/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentIndexReader;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentProcessor;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class PolicySetAttachmentInstallTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    protected String className = ((Object)((Object)this)).getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private RepositoryContext _deployContext = null;
    private EARFile _localear = null;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicySetAttachmentInstallTask.performTask()");
        }
        boolean trDebug = tc.isDebugEnabled();
        try {
            PolicySetAttachment attachmentInEar;
            PolicySetAttachmentHelper attachmentHelper;
            String filename;
            this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            if (trDebug) {
                List fileList = this._deployContext.getAllList(false);
                WorkSpaceFile wFile = null;
                for (int i = 0; i < fileList.size(); ++i) {
                    wFile = (WorkSpaceFile)fileList.get(i);
                    Tr.debug(tc, "_deploymentContext file " + i + ": " + wFile.getPath());
                }
            }
            PolicySetAttachment attachment = (PolicySetAttachment)this.scheduler.getProperties().get("PolicySetAttachmentTask.PolicySetAttachments");
            PolicySetAttachment clientAttachment = (PolicySetAttachment)this.scheduler.getProperties().get("PolicySetAttachmentTask.ClientPolicySetAttachments");
            if ((attachment == null || attachment.getPolicySetReference().isEmpty()) && (clientAttachment == null || clientAttachment.getPolicySetReference().isEmpty())) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask()-No PolicySet attachment objects so nothing to do");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "PolicySetAttachmentInstallTask.performTask()");
                }
                return true;
            }
            Map serviceIndex = new PolicySetAttachmentIndexReader().readIndexes(this._deployContext, this.getEar());
            if (serviceIndex == null || serviceIndex.isEmpty()) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask()-No Service Index files so nothing to do");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "PolicySetAttachmentInstallTask.performTask()");
                }
                return true;
            }
            if (trDebug) {
                Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask()-call PolicySetAttachmentProcessor to handle attachments/bindings from the old ear before app update.");
            }
            HashMap bindings = (HashMap)this.scheduler.getProperties().get("PolicySetAttachmentTask.PolicySetBindings");
            if (trDebug) {
                Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask()- bindings=" + bindings);
            }
            if (bindings == null) {
                bindings = new HashMap();
            }
            HashMap clientBindings = (HashMap)this.scheduler.getProperties().get("PolicySetAttachmentTask.ClientPolicySetBindings");
            if (trDebug) {
                Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask()- clientBindings=" + bindings);
            }
            if (clientBindings == null) {
                clientBindings = new HashMap();
            }
            PolicySetAttachmentProcessor processor = new PolicySetAttachmentProcessor();
            processor.setBindings(bindings);
            processor.setClientBindings(clientBindings);
            processor.setServiceIndex(serviceIndex);
            String relativePath = "META-INF" + File.separator + "policyAttachments.xml";
            String clientRelativePath = "META-INF" + File.separator + "clientPolicyAttachments.xml";
            if (this._deployContext.isAvailable(relativePath)) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), new ear has file " + relativePath);
                }
                filename = this._deployContext.getPath() + File.separator + relativePath;
                attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(filename);
                attachmentInEar = attachmentHelper.getPolicySetAttachmentObject();
                processor.setPolicySetAttachment(attachmentInEar);
            } else {
                processor.setPolicySetAttachment(attachment);
            }
            if (this._deployContext.isAvailable(clientRelativePath)) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), new ear has file " + clientRelativePath);
                }
                filename = this._deployContext.getPath() + File.separator + clientRelativePath;
                attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(filename);
                attachmentInEar = attachmentHelper.getPolicySetAttachmentObject();
                processor.setPolicySetAttachment(attachmentInEar);
            } else {
                processor.setClientPolicySetAttachment(clientAttachment);
            }
            processor.process();
            if (this._deployContext.isAvailable(relativePath)) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), the new ear has attachment file, so do not recreate the old attachment file.");
                }
            } else if (processor.getPolicySetAttachment() != null && processor.getPolicySetAttachment().getPolicySetReference() != null && !processor.getPolicySetAttachment().getPolicySetReference().isEmpty()) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), the old ear has attachment file");
                }
                filename = this._deployContext.getPath() + File.separator + relativePath;
                attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(filename);
                attachmentHelper.createPolicySetAttachment(processor.getPolicySetAttachment());
                this._deployContext.notifyChanged(this.scheduler instanceof InstallScheduler ? 0 : 1, relativePath);
            } else {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), delete the cached attachment file");
                }
                filename = this._deployContext.getPath() + File.separator + relativePath;
                new File(filename).delete();
                this._deployContext.notifyChanged(2, relativePath);
            }
            if (this._deployContext.isAvailable(clientRelativePath)) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), the new ear has client attachment file, so do not recreate the old attachment file.");
                }
            } else if (processor.getClientPolicySetAttachment() != null && processor.getClientPolicySetAttachment().getPolicySetReference() != null && !processor.getClientPolicySetAttachment().getPolicySetReference().isEmpty()) {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), the old ear has client attachment file");
                }
                filename = this._deployContext.getPath() + File.separator + clientRelativePath;
                attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(filename);
                attachmentHelper.createPolicySetAttachment(processor.getClientPolicySetAttachment());
                this._deployContext.notifyChanged(this.scheduler instanceof InstallScheduler ? 0 : 1, clientRelativePath);
            } else {
                if (trDebug) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask(), delete the cached client attachment file");
                }
                filename = this._deployContext.getPath() + File.separator + clientRelativePath;
                new File(filename).delete();
                this._deployContext.notifyChanged(2, clientRelativePath);
            }
            this.writeBindingFiles(processor.getBindings());
            this.writeBindingFiles(processor.getClientBindings());
            this.deleteBindingFiles(processor.getBindingDeleteList());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PolicySetAttachmentInstallTask.performTask(), after deleteBindingFiles");
            }
            return true;
        }
        catch (Throwable th) {
            Tr.processException(th, this.className, FFDC_ID_1);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }

    private void writeBindingFiles(Map _bindings) throws FileNotFoundException, IOException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBindingFiles, _bindings=" + _bindings);
        }
        if (_bindings == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeBindingFiles");
            }
            return;
        }
        for (Map bindingFiles : _bindings.values()) {
            for (String fileName : bindingFiles.keySet()) {
                boolean isNew;
                byte[] bytes = (byte[])bindingFiles.get(fileName);
                String bindingRelativePath = "META-INF" + File.separator + fileName;
                boolean bl = isNew = !this._deployContext.isAvailable(bindingRelativePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.writeBindingFile, relativePath=" + bindingRelativePath + ", file=" + fileName + ", isNew=" + isNew);
                }
                if (!isNew) continue;
                OutputStream os = this._deployContext.getOutputStream(bindingRelativePath);
                os.write(bytes);
                this._deployContext.notifyChanged(0, fileName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBindingFiles, _bindings=" + _bindings);
        }
    }

    private void deleteBindingFiles(List _bindings) throws FileNotFoundException, IOException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBindingFiles, _bindings=" + _bindings);
        }
        if (_bindings == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteBindingFiles, _bindings=" + _bindings);
            }
            return;
        }
        for (String fileName : _bindings) {
            this._deployContext.delete(fileName);
            this._deployContext.notifyChanged(2, fileName);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "deleteBindingFiles, fileName=" + fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingFiles, _bindings=" + _bindings);
        }
    }

    private EARFile getEar() throws Exception {
        if (this._localear != null) {
            return this._localear;
        }
        EARFile ear = null;
        if (this.scheduler instanceof InstallScheduler) {
            ear = this._localear = ((InstallScheduler)this.scheduler).getEarFile(false, true);
        } else if (this.scheduler instanceof UpdateScheduler) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc).isZeroBinaryCopy()) {
                this._localear = ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)rc, (WorkSpace)this.scheduler.getWorkSpace(), (ResourceBundle)this.getResourceBundle(), (boolean)true);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "zero bin copy so get ear from source");
                }
                this._localear = (EARFile)((UpdateSchedulerImpl)this.scheduler).getContentAsArchive(false, true);
            }
            ear = this._localear;
        } else if (this.scheduler instanceof EditSchedulerImpl) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            ear = this._localear = ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)this.scheduler.getWorkSpace(), (RepositoryContext)rc);
        }
        return ear;
    }
}

