/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentInstallTask;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class PolicySetAttachmentIndexReader {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private RepositoryContext _deployContext = null;

    public Map readIndexes(RepositoryContext deployContext, EARFile earFile) throws Exception {
        this._deployContext = deployContext;
        return this.readIndexFile(earFile);
    }

    private ServiceIndexHelper readIndexFile(ModuleFile mf) throws Exception {
        String filename = mf.getName() + File.separator + this.getMetaDirectory(mf) + File.separator + "servicesIndex.xml";
        ServiceIndexHelper helper = null;
        File fileobj = new File(this._deployContext.getPath() + File.separator + filename);
        if (fileobj.exists()) {
            InputStream is = this._deployContext.getInputStream(filename);
            helper = ServiceIndexHelperFactory.createHelper(is);
            helper.listWebServices(true);
        }
        return helper;
    }

    private String getMetaDirectory(ModuleFile mf) {
        return mf.isWARFile() ? "WEB-INF" : "META-INF";
    }

    private Map readIndexFile(EARFile earFile) throws Exception {
        Hashtable<String, ServiceIndexHelper> moduleServices = new Hashtable<String, ServiceIndexHelper>();
        List moduleFiles = earFile.getModuleFiles();
        for (ModuleFile mf : moduleFiles) {
            ServiceIndexHelper helper = this.readIndexFile(mf);
            if (helper == null || helper.listWebServices(true).isEmpty() && helper.listWebServices(false).isEmpty()) continue;
            moduleServices.put(mf.getName(), helper);
        }
        return moduleServices;
    }
}

