/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;

public class PolicyResource {
    public static final int NONE = 0;
    public static final int APPLICATION = 1;
    public static final int SERVICE = 2;
    public static final int ENDPOINT = 3;
    public static final int OPERATION = 4;
    private Resource _resource = null;
    private String _type = null;
    private String _moduleName = null;
    private String _serviceName = null;
    private String _endpointName = null;
    private String _operationName = null;

    public PolicyResource(Resource resource) {
        this._resource = resource;
        if (this._resource == null) {
            return;
        }
        this.parsePattern(resource.getPattern());
    }

    public PolicyResource(String pattern) {
        this._resource = new Resource();
        this._resource.setPattern(pattern);
        this.parsePattern(pattern);
    }

    private void parsePattern(String pattern) {
        StringBuffer[] patternParts = new StringBuffer[4];
        for (int i = 0; i < patternParts.length; ++i) {
            patternParts[i] = new StringBuffer();
        }
        int colonNdx = pattern.indexOf(":");
        int slashNdx = pattern.indexOf("/");
        if (colonNdx != -1 && slashNdx != -1 && colonNdx < slashNdx) {
            this._type = pattern.substring(0, colonNdx);
            pattern = pattern.substring(colonNdx + 1);
        }
        boolean inNameSpace = false;
        int nPart = 0;
        if (pattern.charAt(0) == '/') {
            pattern = pattern.substring(1);
        }
        for (int i = 0; i < pattern.length() && nPart < patternParts.length; ++i) {
            char ch = pattern.charAt(i);
            if (inNameSpace) {
                patternParts[nPart].append(ch);
                if (ch != '}') continue;
                inNameSpace = false;
                continue;
            }
            if (ch == '{') {
                patternParts[nPart].append(ch);
                inNameSpace = true;
                continue;
            }
            if (ch == '/') {
                ++nPart;
                continue;
            }
            patternParts[nPart].append(ch);
        }
        this._serviceName = patternParts[0].length() == 0 ? null : patternParts[0].toString();
        this._endpointName = patternParts[1].length() == 0 ? null : patternParts[1].toString();
        this._operationName = patternParts[2].length() == 0 ? null : patternParts[2].toString();
        this._moduleName = null;
        if (this._serviceName != null) {
            int ndx = this._serviceName.indexOf(":");
            int ndx2 = this._serviceName.indexOf("{");
            if (ndx != -1 && (ndx2 == -1 || ndx < ndx2)) {
                this._moduleName = this._serviceName.substring(0, ndx);
                this._serviceName = this._serviceName.substring(ndx + 1);
            }
        }
    }

    public String toString() {
        return "/" + this._moduleName + ":" + this._serviceName + "/" + this._endpointName + "/" + this._operationName;
    }

    public boolean isValid() {
        return this._resource != null;
    }

    public String getType() {
        return this._type;
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public String getEndpointName() {
        return this._endpointName;
    }

    public String getOperationName() {
        return this._operationName;
    }
}

