/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOABindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyTypeWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicyTypeWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());

    public static List<String> listPolicyTypes(Session session, String policySet) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypes, policySet=" + policySet);
        }
        if (policySet == null) {
            return PolicyTypeWorkSpaceHelper.listDefaultPolicyTypes(session);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        List fileList = repContext.getAllList(false);
        String psFileNamePrefix = CommonWorkSpaceHelper.getPolicySetFilePrefix(policySet, false);
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.endsWith("policy.xml") || !fileName.startsWith(psFileNamePrefix)) continue;
            retList.add(CommonWorkSpaceHelper.getLastDirName(fileName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypes, retList=" + retList);
        }
        return retList;
    }

    private static List<String> retrievePolicyTypes(RepositoryContext repContext, String startPath, String endPath) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrievePolicyTypes, startPath=" + startPath + ", endPath=" + endPath);
        }
        List fileList = repContext.getAllList(false);
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retievePolicyTypes, fileName=" + fileName);
            }
            if (!fileName.endsWith(endPath) || !fileName.startsWith(startPath)) continue;
            retList.add(CommonWorkSpaceHelper.getLastDirName(fileName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrievePolicyTypes, retList=" + retList);
        }
        return retList;
    }

    public static List listPolicyTypesForCellBindingFile(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForCellBindingFile");
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String startPath = "PolicyTypes" + File.separator;
        String endPath = File.separator + "bindings.xml";
        ArrayList retList = new ArrayList();
        retList = (ArrayList)PolicyTypeWorkSpaceHelper.retrievePolicyTypes(repContext, startPath, endPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForCellBindingFile, retList=" + retList);
        }
        return retList;
    }

    public static List listPolicyTypesForServerBindingFile(Session session, String node, String server) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForServerBindingFile, node=" + node + ", server=" + server);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getServerRepositoryContext(session, node, server);
        String startPath = "PolicyTypes" + File.separator;
        String endPath = File.separator + "bindings.xml";
        ArrayList retList = new ArrayList();
        retList = (ArrayList)PolicyTypeWorkSpaceHelper.retrievePolicyTypes(repContext, startPath, endPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForServerBindingFile, retList=" + retList);
        }
        return retList;
    }

    public static List listPolicyTypesForTrustBindingFile(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForTrustBindingFile, bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String startPath = "sts" + File.separator + "policy" + File.separator + bindingName + File.separator + "PolicyTypes" + File.separator;
        String endPath = File.separator + "bindings.xml";
        ArrayList retList = new ArrayList();
        retList = (ArrayList)PolicyTypeWorkSpaceHelper.retrievePolicyTypes(repContext, startPath, endPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForTrustBindingFile, retList=" + retList);
        }
        return retList;
    }

    public static List listPolicyTypesForApplicationBindingFile(Session session, String appName, String bindingName) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForApplicationBindingFile, appName=" + appName + ", bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String startPath = "META-INF" + File.separator + bindingName + File.separator + "PolicyTypes" + File.separator;
        String endPath = File.separator + "bindings.xml";
        ArrayList retList = new ArrayList();
        retList = (ArrayList)PolicyTypeWorkSpaceHelper.retrievePolicyTypes(repContext, startPath, endPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForApplicationBindingFile, retList=" + retList);
        }
        return retList;
    }

    public static List listPolicyTypesForWSNClientBindingFile(Session session, String busName, String serviceName, String bindingName) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForWSNClientBindingFile, busName=" + busName + ", serviceName=" + serviceName + ", bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        String startPath = "META-INF" + File.separator + bindingName + File.separator + "PolicyTypes" + File.separator;
        String endPath = File.separator + "bindings.xml";
        ArrayList retList = new ArrayList();
        retList = (ArrayList)PolicyTypeWorkSpaceHelper.retrievePolicyTypes(wsnContext, startPath, endPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForWSNClientBindingFile, retList=" + retList);
        }
        return retList;
    }

    public static List listPolicyTypesForCUBindingFile(Session session, String cuName, String bindingName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForCUBindingFile, cuName=" + cuName + ", bindingName=" + bindingName);
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String startPath = "meta" + File.separator + bindingName + File.separator + "PolicyTypes" + File.separator;
        String endPath = File.separator + "bindings.xml";
        ArrayList retList = new ArrayList();
        retList = (ArrayList)PolicyTypeWorkSpaceHelper.retrievePolicyTypes(cuSubContext, startPath, endPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForCUBindingFile, retList=" + retList);
        }
        return retList;
    }

    public static List listPolicyTypesForNamedBindingFile(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForNamedBindingFile, bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String startPath = "bindings" + File.separator + bindingName + File.separator + "PolicyTypes" + File.separator;
        String endPath = File.separator + "bindings.xml";
        ArrayList retList = new ArrayList();
        retList = (ArrayList)PolicyTypeWorkSpaceHelper.retrievePolicyTypes(repContext, startPath, endPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForNamedBindingFile, retList=" + retList);
        }
        return retList;
    }

    public static List<String> listDefaultPolicyTypes(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listDefaultPolicyTypes");
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        List fileList = repContext.getAllList(false);
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.endsWith("policy.xml") || !fileName.startsWith("PolicyTypes")) continue;
            retList.add(CommonWorkSpaceHelper.getLastDirName(fileName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listDefaultPolicyTypes, retList=" + retList);
        }
        return retList;
    }

    public static String getPolicyTypeFile(Session session, String policySet, String policyType, boolean fromDefaultRepository) throws WorkSpaceException, NoItemFoundException {
        String fileName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyTypeFile, policySet=" + policySet + ", policyType=" + policyType + ", fromDefaultRepository=" + fromDefaultRepository);
        }
        if (policySet == null) {
            return PolicyTypeWorkSpaceHelper.getDefaultPolicyTypeFile(session, policyType);
        }
        RepositoryContext repContext = null;
        repContext = fromDefaultRepository ? CommonWorkSpaceHelper.getTemplatesRepositoryContext(session) : CommonWorkSpaceHelper.getCellRepositoryContext(session);
        if (!repContext.isExtracted(fileName = PolicyTypeWorkSpaceHelper.getPolicyTypeFileURI(repContext, policySet, policyType))) {
            repContext.extract(fileName, false);
        }
        String fullPath = CommonWorkSpaceHelper.getFullPath(repContext, fileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyTypeFile, fullPath=" + fullPath);
        }
        return fullPath;
    }

    public static boolean updatePolicyTypeFile(Session session, String policySet, String policyType) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePolicyTypeFile, policySet=" + policySet + ", policyType=" + policyType);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String fileName = PolicyTypeWorkSpaceHelper.getPolicyTypeFileURI(repContext, policySet, policyType);
        repContext.notifyChanged(1, fileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePolicyTypeFile");
        }
        return true;
    }

    public static String getDefaultPolicyTypeFile(Session session, String policyType) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultPolicyTypeFile, policyType=" + policyType);
        }
        if ((repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session)).isAvailable(expectedFileName = PolicyTypeWorkSpaceHelper.getDefaultPolicyTypeFileName(policyType))) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            String fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultPolicyTypeFile, policyType=" + policyType + ", fullPath=" + fullPath);
            }
            return fullPath;
        }
        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0057E", new Object[]{policyType}, "Default policy type is not found: {0}"));
    }

    public static boolean addPolicyType(Session session, String policySet, String policyType) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPolicyType, policySet=" + policySet + ", policyType=" + policyType);
        }
        String defaultTypeFileName = PolicyTypeWorkSpaceHelper.getDefaultPolicyTypeFile(session, policyType);
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicyTypeWorkSpaceHelper.getPolicyTypeFileName(policySet, policyType);
        String psFileName = CommonWorkSpaceHelper.getPolicySetFileName(policySet);
        if (!repContext.isAvailable(psFileName)) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
        }
        if (repContext.isAvailable(expectedFileName)) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0059E", new Object[]{policyType}, "Duplicate policy type is found: {0}"));
        }
        repContext.getOutputStream(expectedFileName);
        String fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        CommonWorkSpaceHelper.copyFile(defaultTypeFileName, fullPath);
        repContext.notifyChanged(0, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPolicyType, policySet=" + policySet + ", policyType=" + policyType);
        }
        return true;
    }

    public static boolean deletePolicyType(Session session, String policySet, String policyType) throws WorkSpaceException, NoItemFoundException {
        String fileName;
        RepositoryContext repContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePolicyType, policySet=" + policySet + ", policyType=" + policyType);
        }
        if (!(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session)).isExtracted(fileName = PolicyTypeWorkSpaceHelper.getPolicyTypeFileURI(repContext, policySet, policyType))) {
            repContext.extract(fileName, false);
        }
        repContext.notifyChanged(2, fileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deletePolicyType, policySet=" + policySet + ", policyType=" + policyType);
        }
        return true;
    }

    private static String getPolicyTypeFileURI(RepositoryContext repContext, String policySet, String policyType) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyTypeFileURI, policySet=" + policySet + ", policyType=" + policyType);
        }
        if (repContext.isAvailable(expectedFileName = PolicyTypeWorkSpaceHelper.getPolicyTypeFileName(policySet, policyType))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicyTypeFileURI, expectedFileName=" + expectedFileName);
            }
            return expectedFileName;
        }
        String psFileName = CommonWorkSpaceHelper.getPolicySetFileName(policySet);
        if (repContext.isAvailable(psFileName)) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0056E", new Object[]{policyType}, "Policy type is not found: {0}"));
        }
        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
    }

    private static String getPolicyTypeFileName(String policySet, String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("PolicySets").append(File.separator).append(policySet).append(File.separator).append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("policy.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicyTypeFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getDefaultPolicyTypeFileName(String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("policy.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDefaultPolicyTypeFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }
}

