/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.wsspi.management.bla.model.CompositionUnitFactory;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetSOABindingWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetSOABindingWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());

    public static List<String> listBindingsForCU(Session session, String cuName, String attachmentType) throws WorkSpaceException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listBindingsForCU, cuName=" + cuName);
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String startPath = "meta" + File.separator;
        String endPath = File.separator + "bindings.xml";
        List<String> retList = PolicySetSOABindingWorkSpaceHelper.retrieveBindingNames(session, cuSubContext, startPath, endPath, attachmentType, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listBindingsForCU, retList=" + retList);
        }
        return retList;
    }

    private static List<String> retrieveBindingNames(Session session, RepositoryContext repContext, String startPath, String endPath, String attachmentType, boolean namedBinding) throws WorkSpaceException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveBindingNames, startPath=" + startPath + ", endPath=" + endPath);
        }
        List fileList = repContext.getAllList(false);
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            String bindingDir;
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieveBindingNames, fileName=" + fileName);
            }
            if (!fileName.endsWith(endPath) || !fileName.startsWith(startPath) || retList.contains(bindingDir = PolicySetSOABindingWorkSpaceHelper.getBindingDirName(fileName))) continue;
            if (!namedBinding) {
                String indicatorFileName = PolicySetSOABindingWorkSpaceHelper.getProviderBindingIndicatorFileName(bindingDir);
                if ((repContext.isAvailable(indicatorFileName) || !attachmentType.equals("client")) && (!repContext.isAvailable(indicatorFileName) || !attachmentType.equals("application"))) continue;
                retList.add(bindingDir);
                continue;
            }
            String pathname = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingDir);
            BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathname);
            bindingHelper.setLocale(CommonUtil.getLocale());
            String bindingType = bindingHelper.getBindingType();
            if ((!bindingType.equals("provider") || !attachmentType.equals("application")) && (!bindingType.equals("client") || !attachmentType.equals("client"))) continue;
            retList.add(bindingDir);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveBindingNames, retList=" + retList);
        }
        return retList;
    }

    public static String getCUBindingFile(Session session, String cuName, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "getCUBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCUBindingFile, cuName=" + cuName + ", bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingFileName(bindingName, policyType);
        String fullPath = PolicySetSOABindingWorkSpaceHelper.getBindingFile(cuSubContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCUBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String createCUBindingFile(Session session, String cuName, String bindingName, String policyType, String attachmentType) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException, OpExecutionException {
        String indicatorFileName;
        String expectedFileName;
        String cuEdition;
        RepositoryContext cuRepContext;
        RepositoryContext cuSubContext;
        String fullPath;
        String methodName = "createCUBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCUBindingFile, cuName=" + cuName + ", bindingName=" + bindingName + ", policyType=" + policyType + ", attachmentType=" + attachmentType);
        }
        if ((fullPath = PolicySetSOABindingWorkSpaceHelper.createBindingFile(cuSubContext = (RepositoryContext)(cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName)).findContext("cver", cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName)).iterator().next(), expectedFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingFileName(bindingName, policyType))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{cuName}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (attachmentType.equals("application") && !cuSubContext.isAvailable(indicatorFileName = PolicySetSOABindingWorkSpaceHelper.getProviderBindingIndicatorFileName(bindingName))) {
            cuSubContext.getOutputStream(indicatorFileName);
            String indicatorPath = CommonWorkSpaceHelper.getFullPath(cuSubContext, indicatorFileName);
            CommonWorkSpaceHelper.writeFile(indicatorPath);
            cuSubContext.notifyChanged(0, indicatorFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCUBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateCUBindingFile(Session session, String cuName, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCUBindingFile, cuName=" + cuName + ", bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingFileName(bindingName, policyType);
        cuSubContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static boolean deleteCUBindingFile(Session session, String cuName, String bindingName, String policyType, String attachmentType) throws WorkSpaceException, NoItemFoundException, IOException, OpExecutionException {
        String expectedFileName;
        String cuEdition;
        RepositoryContext cuRepContext;
        RepositoryContext cuSubContext;
        boolean delete;
        String methodName = "deleteCUBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCUBindingFile, cuName=" + cuName + ", bindingName=" + bindingName + ", policyType=" + policyType + ", attachmentType=" + attachmentType);
        }
        if (!(delete = PolicySetSOABindingWorkSpaceHelper.deleteBindingFile(cuSubContext = (RepositoryContext)(cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName)).findContext("cver", cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName)).iterator().next(), expectedFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingFileName(bindingName, policyType)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (attachmentType.equals("application")) {
            String indicatorFileName = PolicySetSOABindingWorkSpaceHelper.getProviderBindingIndicatorFileName(bindingName);
            PolicySetSOABindingWorkSpaceHelper.deleteBindingFile(cuSubContext, indicatorFileName);
        } else if (PolicySetBindingWorkSpaceHelper.getNamedBindingDir(session, bindingName, true) == null) {
            String definitionFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFileName(bindingName);
            PolicySetSOABindingWorkSpaceHelper.deleteBindingFile(cuSubContext, definitionFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCUBindingFile", delete);
        }
        return delete;
    }

    public static boolean deleteCUBinding(Session session, String cuName, String bindingName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String psFileNamePrefix;
        String cuEdition;
        RepositoryContext cuRepContext;
        RepositoryContext cuSubContext;
        boolean deleted;
        String methodName = "deleteCUBinding";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCUBinding, cuName=" + cuName + ", bindingName=" + bindingName);
        }
        if (!(deleted = PolicySetSOABindingWorkSpaceHelper.deleteBinding(cuSubContext = (RepositoryContext)(cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName)).findContext("cver", cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName)).iterator().next(), psFileNamePrefix = PolicySetSOABindingWorkSpaceHelper.getBindingDirPrefix(bindingName)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCUBinding", deleted);
        }
        return deleted;
    }

    public static String getCUBindingDir(Session session, String cuName, String bindingName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "getCUBindingDir";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCUBindingDir, cuName=" + cuName + ", bindingName=" + bindingName);
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String bindingFileNamePrefix = PolicySetSOABindingWorkSpaceHelper.getBindingDirPrefix(bindingName);
        String bindingDir = PolicySetSOABindingWorkSpaceHelper.getBindingDir(cuSubContext, bindingFileNamePrefix);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCUBindingDir", bindingDir);
        }
        return bindingDir;
    }

    public static String getCUBindingDefinitionFile(Session session, String cuName, String bindingName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "getCUBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCUBindingFile, cuName=" + cuName + ", bindingName=" + bindingName);
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFileName(bindingName);
        String fullPath = PolicySetSOABindingWorkSpaceHelper.getBindingFile(cuSubContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCUBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String createCUBindingDefinitionFile(Session session, String cuName, String bindingName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, OpExecutionException {
        String expectedFileName;
        String cuEdition;
        RepositoryContext cuRepContext;
        RepositoryContext cuSubContext;
        String fullPath;
        String methodName = "createNamedBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNamedBindingFile, bindingName=" + bindingName);
        }
        if ((fullPath = PolicySetSOABindingWorkSpaceHelper.createBindingFile(cuSubContext = (RepositoryContext)(cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName)).findContext("cver", cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName)).iterator().next(), expectedFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFileName(bindingName))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{bindingName}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNamedBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateCUBindingDefinitionFile(Session session, String cuName, String bindingName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNamedBindingFile, bindingName=" + bindingName);
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOABindingWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFileName(bindingName);
        cuSubContext.notifyChanged(1, expectedFileName);
        return true;
    }

    private static String getBindingFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingFile", new Object[]{repContext, expectedFileName});
        }
        String fullPath = null;
        if (repContext.isAvailable(expectedFileName)) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingFile", fullPath);
        }
        return fullPath;
    }

    private static String getBindingDir(RepositoryContext repContext, String bindingFileNamePrefix) {
        String methodName = "getBindingDir";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingDir", new Object[]{repContext, bindingFileNamePrefix});
        }
        String bindingDir = null;
        List fileList = repContext.getAllList(false);
        boolean bindingFound = false;
        String fileName = null;
        for (int k = 0; k < fileList.size() && !bindingFound; ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.startsWith(bindingFileNamePrefix)) continue;
            bindingFound = true;
        }
        if (bindingFound) {
            bindingDir = bindingFileNamePrefix;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingDir", bindingDir);
        }
        return bindingDir;
    }

    private static String createBindingFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException {
        String methodName = "createBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBindingFile", new Object[]{repContext, expectedFileName});
        }
        String fullPath = null;
        if (repContext.isAvailable(expectedFileName)) {
            fullPath = null;
        } else {
            repContext.getOutputStream(expectedFileName);
            repContext.notifyChanged(0, expectedFileName);
            fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBindingFile", fullPath);
        }
        return fullPath;
    }

    private static boolean deleteBindingFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException {
        String methodName = "deleteBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBindingFile", new Object[]{repContext, expectedFileName});
        }
        boolean delete = false;
        if (repContext.isAvailable(expectedFileName)) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            repContext.notifyChanged(2, expectedFileName);
            delete = true;
        } else {
            delete = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingFile", delete);
        }
        return delete;
    }

    private static boolean deleteBinding(RepositoryContext repContext, String bindingFileNamePrefix) throws NoItemFoundException, WorkSpaceException {
        String methodName = "deleteBinding";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBinding", new Object[]{repContext, bindingFileNamePrefix});
        }
        boolean deleted = false;
        List fileList = repContext.getAllList(false);
        ArrayList<String> deletedFiles = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.startsWith(bindingFileNamePrefix)) continue;
            if (!repContext.isExtracted(fileName)) {
                repContext.extract(fileName, false);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding file to delete list: " + fileName);
            }
            deletedFiles.add(fileName);
        }
        if (!deletedFiles.isEmpty()) {
            repContext.notifyChanged(2, deletedFiles);
            deleted = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBinding", deleted);
        }
        return deleted;
    }

    private static String getCUBindingFileName(String bindingName, String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("meta").append(File.separator).append(bindingName).append(File.separator).append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCUBindingFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getCUBindingDefinitionFileName(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("meta").append(File.separator).append(bindingName).append(File.separator).append("bindingDefinition.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCUBindingDefinitionFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getProviderBindingIndicatorFileName(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("meta").append(File.separator).append(bindingName).append(File.separator).append("provider.txt");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getProviderBindingIndicatorFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getBindingDirPrefix(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("meta").append(File.separator).append(bindingName).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingDirPrefix, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getBindingDirName(String filePath) {
        int index = filePath.lastIndexOf("PolicyTypes");
        String str1 = filePath.substring(0, index - 1);
        index = str1.lastIndexOf(File.separatorChar);
        String dirName = str1.substring(index + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastDirName, filePath=" + filePath + ", str1=" + str1 + ", dirName=" + dirName);
        }
        return dirName;
    }

    public static String getCUEdition(Session session, String cuName) throws OpExecutionException, NoItemFoundException {
        String methodName = "getCUEdition";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCUEdition", new Object[]{session, cuName});
        }
        String sessionId = session.getUserName();
        List cuSpecs = CompositionUnitFactory.getSingleton().listCompositionUnitSpecs(cuName, sessionId);
        if (cuSpecs.isEmpty()) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0164E", new Object[]{cuName}, "The {0} composition unit is not found"));
        }
        CompositionUnitSpec cuSpec = (CompositionUnitSpec)cuSpecs.get(0);
        String cuVersion = cuSpec.getCUVersion();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCUEdition", cuVersion);
        }
        return cuVersion;
    }
}

