/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.management.bla.model.CompositionUnitFactory;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetSOAAttachmentWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetSOAAttachmentWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());

    public static String getPolicySetAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "getPolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "policyAttachments.xml";
        String fullPath = PolicySetSOAAttachmentWorkSpaceHelper.getAttachmentFile(cuSubContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static String createPolicySetAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, OpExecutionException {
        String methodName = "createPolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicySetAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "policyAttachments.xml";
        String fullPath = PolicySetSOAAttachmentWorkSpaceHelper.createAttachmentFile(cuSubContext, expectedFileName, "application", new Object[]{cuName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicySetAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updatePolicySetAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "updatePolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePolicySetAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "policyAttachments.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean update = PolicySetSOAAttachmentWorkSpaceHelper.updateAttachmentFile(cuSubContext, expectedFileName, "application", new Object[]{cuName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePolicySetAttachmentFile", update);
        }
        return update;
    }

    public static boolean deletePolicySetAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "deletePolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePolicySetAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "policyAttachments.xml";
        boolean delete = PolicySetSOAAttachmentWorkSpaceHelper.deleteAttachmentFile(cuSubContext, expectedFileName, "application", new Object[]{cuName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deletePolicySetAttachmentFile", delete);
        }
        return delete;
    }

    public static String getClientAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "getClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "clientPolicyAttachments.xml";
        String fullPath = PolicySetSOAAttachmentWorkSpaceHelper.getAttachmentFile(cuSubContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static String createClientAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, OpExecutionException {
        String methodName = "createClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "clientPolicyAttachments.xml";
        String fullPath = PolicySetSOAAttachmentWorkSpaceHelper.createAttachmentFile(cuSubContext, expectedFileName, "client", new Object[]{cuName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateClientAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "updateClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateClientAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "clientPolicyAttachments.xml";
        boolean update = PolicySetSOAAttachmentWorkSpaceHelper.updateAttachmentFile(cuSubContext, expectedFileName, "client", new Object[]{cuName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateClientAttachmentFile", update);
        }
        return update;
    }

    public static boolean deleteClientAttachmentFile(Session session, String cuName) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        String methodName = "deleteClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteClientAttachmentFile", new Object[]{session, cuName});
        }
        RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
        String cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
        RepositoryContext cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next();
        String expectedFileName = "meta" + File.separator + "clientPolicyAttachments.xml";
        boolean delete = PolicySetSOAAttachmentWorkSpaceHelper.deleteAttachmentFile(cuSubContext, expectedFileName, "client", new Object[]{cuName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteClientAttachmentFile", delete);
        }
        return delete;
    }

    public static List<String> listPolicySetAttachmentFiles(Session session, String attachmentType) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        Properties p = new Properties();
        p.setProperty("application", "*");
        return PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, attachmentType, p);
    }

    public static List<String> listPolicySetAttachmentFiles(Session session, String attachmentType, Properties searchPattern) throws WorkSpaceException, NoItemFoundException, OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicySetAttachmentFiles, attachmentType=" + attachmentType + ", searchPattern=" + searchPattern);
        }
        ArrayList<String> retList = new ArrayList<String>();
        if (attachmentType.equals("application") || attachmentType.equals("client")) {
            String attachmentFileType = "policyAttachments.xml";
            if (attachmentType.equals("client")) {
                attachmentFileType = "clientPolicyAttachments.xml";
            }
            String cuName = searchPattern.getProperty("cuName");
            String cuEdition = searchPattern.getProperty("cuEdition");
            if (cuName != null) {
                String expectedFileName;
                RepositoryContext cuSubContext;
                String fullPath;
                RepositoryContext cuRepContext = CommonWorkSpaceHelper.getCusRepositoryContext(session, cuName);
                if (cuEdition == null) {
                    cuEdition = PolicySetSOAAttachmentWorkSpaceHelper.getCUEdition(session, cuName);
                }
                if ((fullPath = PolicySetSOAAttachmentWorkSpaceHelper.getAttachmentFile(cuSubContext = (RepositoryContext)cuRepContext.findContext("cver", cuEdition).iterator().next(), expectedFileName = "meta" + File.separator + attachmentFileType)) != null) {
                    fullPath = fullPath.replace(File.separatorChar, '/');
                    retList.add(fullPath);
                }
            } else {
                RepositoryContext cellRepContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
                RepositoryContextType cusRepContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cus");
                List cusRepositoryContexts = cellRepContext.getChildren(cusRepContextType);
                for (RepositoryContext cusRepContext : cusRepositoryContexts) {
                    RepositoryContextType cuSubContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cver");
                    List cuSubRepositoryContexts = cusRepContext.getChildren(cuSubContextType);
                    for (RepositoryContext cuSubRepContext : cuSubRepositoryContexts) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cuSubRepContext: " + cuSubRepContext);
                        }
                        Set files = cuSubRepContext.getFiles();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "files: " + files);
                        }
                        for (String file : files) {
                            String fullPath;
                            if (!file.endsWith(attachmentFileType)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "File matched: " + file);
                            }
                            if ((fullPath = PolicySetSOAAttachmentWorkSpaceHelper.getAttachmentFile(cuSubRepContext, file)) == null || !PolicySetSOAAttachmentWorkSpaceHelper.doesFileExist(fullPath)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "File really exists");
                            }
                            fullPath = fullPath.replace(File.separatorChar, '/');
                            retList.add(fullPath);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicySetAttachmentFiles, retList=" + retList + ", retList.size()=" + retList.size());
        }
        return retList;
    }

    private static boolean doesFileExist(String fullPath) {
        String methodName = "doesFileExist";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesFileExist", new Object[]{fullPath});
        }
        boolean fileExists = false;
        fullPath = fullPath.replace(File.separatorChar, '/');
        try {
            File javaFile = new File(fullPath);
            if (javaFile.exists()) {
                fileExists = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesFileExist", fileExists);
        }
        return fileExists;
    }

    private static String getAttachmentFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachmentFile", new Object[]{repContext, expectedFileName});
        }
        String fileName = null;
        if (repContext.isAvailable(expectedFileName)) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            fileName = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null, cannot find file: " + expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachmentFile", fileName);
        }
        return fileName;
    }

    private static String createAttachmentFile(RepositoryContext repContext, String expectedFileName, String attachmentType, Object[] exceptionArgs) throws WorkSpaceException, DuplicateItemFoundException {
        String methodName = "createAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAttachmentFile", new Object[]{repContext, expectedFileName, attachmentType, exceptionArgs});
        }
        String fileName = null;
        if (repContext.isAvailable(expectedFileName)) {
            if (attachmentType.equals("application")) {
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0060E", exceptionArgs, "Duplicate policyAttachments.xml is found: {0}"));
            }
            if (attachmentType.equals("client")) {
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0061E", exceptionArgs, "Duplicate clientPolicyAttachments.xml is found: {0}"));
            }
        } else {
            repContext.getOutputStream(expectedFileName);
            repContext.notifyChanged(0, expectedFileName);
            fileName = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAttachmentFile", fileName);
        }
        return fileName;
    }

    private static boolean updateAttachmentFile(RepositoryContext repContext, String expectedFileName, String attachmentType, Object[] exceptionArgs) throws WorkSpaceException, NoItemFoundException {
        String methodName = "updateAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAttachmentFile", new Object[]{repContext, expectedFileName, attachmentType, exceptionArgs});
        }
        boolean update = false;
        if (repContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            repContext.notifyChanged(1, expectedFileName);
            update = true;
        } else {
            if (attachmentType.equals("application")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0168E", exceptionArgs, "Policy attachment file is not found: {0}"));
            }
            if (attachmentType.equals("client")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0168E", exceptionArgs, "Client policy attachment file is not found: {0}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAttachmentFile", update);
        }
        return update;
    }

    private static boolean deleteAttachmentFile(RepositoryContext repContext, String expectedFileName, String attachmentType, Object[] exceptionArgs) throws WorkSpaceException, NoItemFoundException {
        String methodName = "deleteAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAttachmentFile", new Object[]{repContext, expectedFileName, attachmentType, exceptionArgs});
        }
        boolean delete = false;
        if (repContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            repContext.notifyChanged(2, expectedFileName);
            delete = true;
        } else {
            if (attachmentType.equals("application")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0168E", exceptionArgs, "Policy attachment file is not found: {0}"));
            }
            if (attachmentType.equals("client")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0168E", exceptionArgs, "Client policy attachment file is not found: {0}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAttachmentFile", delete);
        }
        return delete;
    }

    public static String getCUEdition(Session session, String cuName) throws OpExecutionException, NoItemFoundException {
        String methodName = "getCUEdition";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCUEdition", new Object[]{session, cuName});
        }
        String sessionId = session.getUserName();
        List cuSpecs = CompositionUnitFactory.getSingleton().listCompositionUnitSpecs(cuName, sessionId);
        if (cuSpecs.isEmpty()) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0164E", new Object[]{cuName}, "The {0} composition unit is not found"));
        }
        CompositionUnitSpec cuSpec = (CompositionUnitSpec)cuSpecs.get(0);
        String cuVersion = cuSpec.getCUVersion();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCUEdition", cuVersion);
        }
        return cuVersion;
    }
}

