/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.DefaultBindingsHelper;
import com.ibm.ws.policyset.admin.DefaultBindingsHelperFactory;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOABindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.webservices.admin.utils.AppMgmtUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetBindingCommandUtil
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetBindingCommandUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());
    private static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    private static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    private static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    private static final String WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "The client policy attachment file is not found for bus: {0} WSN service: {1}";
    private static final String BINDING_FILE = "bindingFile";
    private static final String BINDING_REF = "bindingRef";
    private static final String CREATED_FILE = "createdFile";
    private static final String UPDATED_BINDING_REF = "updatedBindingRef";
    private static final String UPDATED_BINDING_DEFINITION = "updatedBindingDefinition";
    private static final String NAMED_BINDING = "namedBinding";
    private static final String BINDING_DOMAIN = "bindingDomain";
    private static final String BINDING_VERSION = "bindingVersion";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";

    public static boolean setBinding(Session session, String policyTypeName, Properties bindingLocation, Properties requestedValues, String attachmentType, boolean replace, boolean remove, String bindingName, String bindingScope) throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBinding, policyTypeName=" + policyTypeName + ", bindingLocation=" + bindingLocation + ", requestedValues=" + requestedValues + ", attachmentType=" + attachmentType + ", replace=" + replace + ", remove=" + remove + ", bindingName=" + bindingName + ", bindingScope=" + bindingScope);
        }
        Properties bindingProps = null;
        boolean policyTypeSuccess = true;
        String description = null;
        String domain = null;
        String version = null;
        int bindingLevel = PolicySetBindingCommandUtil.getBindingLevel(bindingLocation, attachmentType);
        boolean writeAccess = false;
        if (policyTypeName != null || requestedValues != null) {
            writeAccess = true;
        }
        if (remove) {
            if (bindingLevel == 3) {
                String attachID = bindingLocation.getProperty("attachmentId");
                if (attachID != null && attachID.equals("*") && bindingName != null) {
                    writeAccess = true;
                }
            } else if (bindingLevel == 2) {
                writeAccess = true;
            }
        }
        CommonWorkSpaceHelper.validateBindingAuthorization(writeAccess, bindingLevel, attachmentType, bindingLocation);
        if (remove) {
            if (bindingLevel == 1) {
                if (bindingName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0049E", new Object[0], "Removal of cell-level binding not allowed"));
                }
                PolicySetBindingCommandUtil.deleteBinding(session, policyTypeName, bindingLocation, attachmentType, bindingLevel, bindingName, bindingScope);
            } else {
                if (bindingLevel == 2 && policyTypeName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0050E", new Object[0], "Policy type name is required to remove the server level binding"));
                }
                PolicySetBindingCommandUtil.deleteBinding(session, policyTypeName, bindingLocation, attachmentType, bindingLevel, bindingName, bindingScope);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setBinding, bindingLevel = " + bindingLevel);
                Tr.debug(tc, "setBinding, policyTypeName = " + policyTypeName);
            }
            if (policyTypeName == null && (bindingLevel == 2 || bindingLevel == 1 && bindingName == null)) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{"policyType"}, "The {0} input parameter is missing or not valid"));
            }
            if (requestedValues != null && !requestedValues.isEmpty()) {
                if (requestedValues.containsKey("type")) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0151E", new Object[]{"type"}, "The {0} attribute cannot be modified"));
                }
                if (requestedValues.containsKey("description")) {
                    description = requestedValues.getProperty("description");
                    requestedValues.remove("description");
                }
                if (requestedValues.containsKey("domain")) {
                    domain = requestedValues.getProperty("domain");
                    List domainList = PolicySetBindingCommandUtil.getValidDomains(session);
                    if (!domainList.contains(domain)) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0152E", new Object[]{domain}, "The {0} domain name is not valid"));
                    }
                    requestedValues.remove("domain");
                }
                if (requestedValues.containsKey("version")) {
                    version = requestedValues.getProperty("version");
                    requestedValues.remove("version");
                }
            }
            bindingProps = PolicySetBindingCommandUtil.getBindingFile(session, policyTypeName, bindingLocation, attachmentType, bindingLevel, bindingName, requestedValues, bindingScope, description, domain, version);
            String bindingFile = bindingProps.getProperty(BINDING_FILE);
            String bindingRef = bindingProps.getProperty(BINDING_REF);
            boolean createdFile = Boolean.valueOf(bindingProps.getProperty(CREATED_FILE));
            boolean updateBinding = Boolean.valueOf(bindingProps.getProperty(UPDATED_BINDING_REF));
            boolean updateBindingDefinition = Boolean.valueOf(bindingProps.getProperty(UPDATED_BINDING_DEFINITION));
            boolean isNamedBindingFile = Boolean.valueOf(bindingProps.getProperty(NAMED_BINDING));
            String domainName = bindingProps.getProperty(BINDING_DOMAIN);
            String bindingVersion = bindingProps.getProperty(BINDING_VERSION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setBinding, domainName = " + domainName);
                Tr.debug(tc, "setBinding, bindingVersion = " + bindingVersion);
            }
            if (bindingFile != null) {
                String appName;
                if (requestedValues != null && !requestedValues.isEmpty()) {
                    PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyTypeName);
                    if (policyTypeProvider != null) {
                        HashMap<String, String> context = new HashMap<String, String>();
                        if (domainName != null && domainName.equals("global")) {
                            domainName = null;
                        }
                        context.put("domain", domainName);
                        context.put("version", bindingVersion);
                        policyTypeSuccess = policyTypeProvider.setBinding(bindingFile, requestedValues, replace, context);
                        if (!policyTypeSuccess) {
                            if (createdFile) {
                                PolicySetBindingCommandUtil.deleteBindingFile(session, policyTypeName, bindingLocation, bindingRef, attachmentType, isNamedBindingFile);
                            }
                            throw new Exception(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0052E", new Object[]{policyTypeName}, "Error in setting binding attributes for Policy type: {0}"));
                        }
                        if (!createdFile) {
                            PolicySetBindingCommandUtil.updateBindingFile(session, policyTypeName, bindingLocation, bindingRef, attachmentType, bindingName, isNamedBindingFile);
                        }
                    } else {
                        if (createdFile) {
                            PolicySetBindingCommandUtil.deleteBindingFile(session, policyTypeName, bindingLocation, bindingRef, attachmentType, isNamedBindingFile);
                        }
                        throw new ClassNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0042E", new Object[]{policyTypeName}, "PolicyTypeProvider class not found for Policy type: {0}"));
                    }
                }
                String cuName = bindingLocation.getProperty("cuName");
                if (updateBinding && bindingLevel == 3) {
                    appName = bindingLocation.getProperty("application");
                    if (cuName != null && !cuName.equals("")) {
                        if (attachmentType.equals("application")) {
                            PolicySetSOAAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, cuName);
                        } else if (attachmentType.equals("client")) {
                            PolicySetSOAAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, cuName);
                        }
                    } else if (attachmentType.equals("application")) {
                        PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, appName);
                    } else if (attachmentType.equals("system/trust")) {
                        PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(session);
                    } else if (attachmentType.equals("client")) {
                        PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, appName);
                    } else if (attachmentType.equals("WSNClient")) {
                        String busName = bindingLocation.getProperty("bus");
                        String serviceName = bindingLocation.getProperty("WSNService");
                        PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(session, busName, serviceName);
                    }
                }
                if (updateBindingDefinition) {
                    if (isNamedBindingFile) {
                        if (bindingName != null) {
                            PolicySetBindingWorkSpaceHelper.updateNamedBindingDefinitionFile(session, bindingName);
                        } else {
                            PolicySetBindingWorkSpaceHelper.updateNamedBindingDefinitionFile(session, bindingRef);
                        }
                    } else if (cuName != null && !cuName.equals("")) {
                        PolicySetSOABindingWorkSpaceHelper.updateCUBindingDefinitionFile(session, cuName, bindingRef);
                    } else {
                        appName = bindingLocation.getProperty("application");
                        PolicySetBindingWorkSpaceHelper.updateApplicationBindingDefinitionFile(session, appName, bindingRef);
                    }
                }
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0046E", new Object[]{policyTypeName}, "Unable to update bindings for policy type: {0}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBinding, policyTypeSuccess=" + policyTypeSuccess);
        }
        return policyTypeSuccess;
    }

    public static Properties getDefaultBindingNames(Session session, String domainName, String node, String server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultBindingNames, domainName=" + domainName + ", node=" + node + ", server=" + server);
        }
        Properties props = new Properties();
        String bindingsFile = PolicySetBindingWorkSpaceHelper.getDefaultBindingsFile(session);
        if (bindingsFile != null) {
            DefaultBindingsHelper helper = DefaultBindingsHelperFactory.createHelper(bindingsFile);
            helper.setLocale(CommonUtil.getLocale());
            props = domainName != null ? helper.getDomainDefaults(domainName) : helper.getServerDefaults(server, node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultBindingNames");
        }
        return props;
    }

    public static void isProviderNamedBinding(Session session, String bindingName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProviderNamedBinding");
        }
        PolicySetBindingCommandUtil.isNamedBinding(session, bindingName, "provider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProviderNamedBinding");
        }
    }

    public static void isClientNamedBinding(Session session, String bindingName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isClientNamedBinding");
        }
        PolicySetBindingCommandUtil.isNamedBinding(session, bindingName, "client");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClientNamedBinding");
        }
    }

    public static List getValidDomains(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidDomains");
        }
        List<String> retList = new ArrayList<String>();
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        if (cmdMgr != null) {
            AdminCommand cmd = cmdMgr.createCommand("listSecurityDomains");
            cmd.setConfigSession(session);
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            retList = (List)res.getResult();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getValidDomains, CommandMgr is null");
        }
        if (retList != null) {
            retList.add("global");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValidDomains, retList=" + retList);
        }
        return retList;
    }

    public static String getRequiredBindingVersion(Session session, Properties assetProps) throws Exception {
        String bindingVersion;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequiredBindingVersion, assetProps = " + assetProps);
        }
        String version = "7.0.0.0";
        String application = null;
        if (assetProps.containsKey("application")) {
            application = assetProps.getProperty("application");
        }
        if ((version = PolicySetBindingCommandUtil.getServerVersion(session, application)) != null && version.startsWith("7") && (bindingVersion = PolicySetBindingCommandUtil.getAssetBindingVersion(session, assetProps)) != null) {
            version = bindingVersion;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequiredBindingVersion, version = " + version);
        }
        return version;
    }

    public static String getServerVersion(Session session, String application) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerVersion, application = " + application);
        }
        String version = "7.0.0.0";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerVersion, getting ready to invoke getMinNodeVersionForApp with appName = " + application);
        }
        if (PolicySetBindingCommandUtil.isLocalMode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerVersion, is local mode");
            }
            version = AppMgmtUtils.getMinNodeVersionForApp(session, application, true);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerVersion, is server mode");
            }
            version = AppMgmtUtils.getMinNodeVersionForApp(session, application, false);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerVersion, version from getMinNodeVersionForApp = " + version);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerVersion, version = " + version);
        }
        return version;
    }

    public static String getAssetBindingVersion(Session session, Properties assetProps) throws Exception {
        List<String> bindingList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAssetBindingVersion, assetProps = " + assetProps);
        }
        String version = null;
        String application = null;
        if (assetProps.containsKey("application")) {
            application = assetProps.getProperty("application");
        }
        if ((bindingList = PolicySetBindingWorkSpaceHelper.listBindingsForApplication(session, application, "application")) == null || bindingList.isEmpty()) {
            bindingList = PolicySetBindingWorkSpaceHelper.listBindingsForApplication(session, application, "client");
        }
        if (bindingList != null && !bindingList.isEmpty()) {
            String binding = bindingList.get(0);
            String bindingDefinitionFile = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, application, binding);
            if (bindingDefinitionFile != null) {
                BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefinitionFile);
                bindingHelper.setLocale(CommonUtil.getLocale());
                version = bindingHelper.getVersion();
            } else {
                version = "6.1.0.0";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAssetBindingVersion, version = " + version);
        }
        return version;
    }

    public static String getAssetBindingVersion(EARFile ear) throws Exception {
        String version = "6.1.0.0";
        String pattern = "META-INF/.*/bindingDefinition.xml";
        boolean found = false;
        InputStream istream = null;
        try {
            Iterator files = ear.getFiles().iterator();
            while (files.hasNext() && !found) {
                File file = (File)files.next();
                if (file instanceof Container || file.isSetDirectoryEntry() && file.isDirectoryEntry()) continue;
                String fName = file.getURI();
                if (!(fName = fName.replace('\\', '/')).matches(pattern)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fName " + fName);
                }
                found = true;
                istream = file.getInputStream();
                BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(istream);
                bindingHelper.setLocale(CommonUtil.getLocale());
                version = bindingHelper.getVersion();
                istream.close();
            }
        }
        catch (Exception ex) {
            if (istream != null) {
                istream.close();
            }
            throw ex;
        }
        return version;
    }

    public static String getBindingVersion(Session session, String bindingName, String application) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingVersion, bindingName = " + bindingName + ", application = " + application);
        }
        String version = "7.0.0.0";
        String bindingDefinitionFile = null;
        boolean isApplicationBinding = false;
        if (application != null) {
            bindingDefinitionFile = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, application, bindingName);
            isApplicationBinding = true;
        } else {
            bindingDefinitionFile = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName);
        }
        if (bindingDefinitionFile != null) {
            BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefinitionFile);
            bindingHelper.setLocale(CommonUtil.getLocale());
            version = bindingHelper.getVersion();
        } else if (isApplicationBinding) {
            version = "6.1.0.0";
        } else {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingVersion, version = " + version);
        }
        return version;
    }

    private static Properties getDomainsForModules(Session session, String applicationName, List serviceList, String cuName) throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainsForModules, applicationName=" + applicationName + ", serviceList=" + serviceList);
        }
        ArrayList<String> moduleList = new ArrayList<String>();
        Properties moduleProps = new Properties();
        if (serviceList != null && !serviceList.isEmpty()) {
            for (Properties props : serviceList) {
                Enumeration<?> e;
                String service;
                String module = props.getProperty(service = (String)(e = props.propertyNames()).nextElement());
                if (module == null || moduleList.contains(module)) continue;
                moduleList.add(module);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getDomainsForModules, module in service = " + module);
            }
            for (String module : moduleList) {
                ArrayList<String> domainList = new ArrayList<String>();
                String domain = null;
                List<String> serverList = PolicySetBindingCommandUtil.getServersForModule(session, applicationName, module, cuName);
                if (!serverList.isEmpty()) {
                    for (ObjectName objectName : serverList) {
                        String resourceDomain;
                        String strEntry = objectName.toString();
                        String server = strEntry.substring(10);
                        server = server.replace(",", ":");
                        server = server.replace("cell=", "Cell=");
                        server = server.replace("node=", "Node=");
                        server = server.replace("server=", "Server=");
                        if ((server = server.replace("cluster=", "ServerCluster=")).contains("ServerCluster=")) {
                            int clusterIndex = server.indexOf("ServerCluster=");
                            int clusterEndIndex = server.indexOf(":", clusterIndex);
                            server = server.substring(0, clusterIndex) + server.substring(clusterEndIndex + 1);
                        }
                        int nodeIndex = server.indexOf("Node=");
                        int serverIndex = server.indexOf("Server=");
                        if (nodeIndex != 0 && serverIndex != 0 && serverIndex < nodeIndex) {
                            String tempStr;
                            int serverEndIndex = server.indexOf(":", serverIndex);
                            server = tempStr = server.substring(0, serverIndex) + server.substring(serverEndIndex + 1) + server.substring(serverIndex - 1, serverEndIndex);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainsForModules, server = " + server);
                        }
                        if ((resourceDomain = PolicySetBindingCommandUtil.getDomainForResource(session, server)) == null || domainList.contains(resourceDomain)) continue;
                        domainList.add(resourceDomain);
                    }
                }
                domain = domainList.isEmpty() || domainList.size() > 1 ? "global" : (String)domainList.get(0);
                moduleProps.put(module, domain);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getDomainsForModules, module = " + module + ", domain = " + domain);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainsForModules");
        }
        return moduleProps;
    }

    private static List<String> getServersForModule(Session session, String applicationName, String module, String cuName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule, module=" + module);
        }
        ArrayList<String> serverList = new ArrayList<String>();
        if (module != null) {
            Properties props = new Properties();
            props.setProperty("application", applicationName);
            props.setProperty("module", module);
            List<Object> tempList = new ArrayList();
            tempList = PolicySetBindingCommandUtil.isLocalMode() ? AppMgmtUtils.getModuleTargetsLocalMode(props, session) : AppMgmtUtils.getModuleTargetsServerMode(props, session);
            serverList.addAll(tempList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModule, serverList = " + serverList);
        }
        return serverList;
    }

    private static List<String> getDomainsForServers(Session session, String cuName, List<String> serverList) throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainsForServers, cuName=" + cuName);
        }
        ArrayList<String> domainList = new ArrayList<String>();
        if (!serverList.isEmpty()) {
            for (ObjectName objectName : serverList) {
                String resourceDomain;
                String strEntry = objectName.toString();
                String server = strEntry.substring(10);
                if ((server = server.replace(",", ":")).contains("cell=")) {
                    server = server.replace("cell=", "Cell=");
                }
                server = server.replace("node=", "Node=");
                server = server.replace("server=", "Server=");
                if ((server = server.replace("cluster=", "ServerCluster=")).contains("ServerCluster=")) {
                    int clusterIndex = server.indexOf("ServerCluster=");
                    int clusterEndIndex = server.indexOf(":", clusterIndex);
                    server = server.substring(0, clusterIndex) + server.substring(clusterEndIndex + 1);
                }
                int nodeIndex = server.indexOf("Node=");
                int serverIndex = server.indexOf("Server=");
                if (nodeIndex != 0 && serverIndex != 0 && serverIndex < nodeIndex) {
                    String tempStr;
                    int serverEndIndex = server.indexOf(":", serverIndex);
                    server = tempStr = server.substring(0, serverIndex) + server.substring(serverEndIndex + 1) + server.substring(serverIndex - 1, serverEndIndex);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDomainsForServers, server = " + server);
                }
                if ((resourceDomain = PolicySetBindingCommandUtil.getDomainForResource(session, server)) == null || domainList.contains(resourceDomain)) continue;
                domainList.add(resourceDomain);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainsForServers, domainList = " + domainList);
        }
        return domainList;
    }

    private static List<String> getServersForCU(Session session, String cuName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForCU, cuName=" + cuName);
        }
        ArrayList<String> serverList = new ArrayList<String>();
        Properties props = new Properties();
        props.setProperty("cuName", cuName);
        List<Object> tempList = new ArrayList();
        tempList = PolicySetBindingCommandUtil.isLocalMode() ? AppMgmtUtils.getModuleTargetsLocalMode(props, session) : AppMgmtUtils.getModuleTargetsServerMode(props, session);
        serverList.addAll(tempList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForCU, serverList = " + serverList);
        }
        return serverList;
    }

    private static String getDomainForNamedBinding(Session session, String bindingName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainForNamedBinding, bindingName = " + bindingName);
        }
        String domain = null;
        String pathName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName);
        if (pathName == null) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingName}, "The {0} binding was not found"));
        }
        BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathName);
        bindingHelper.setLocale(CommonUtil.getLocale());
        domain = bindingHelper.getDomain();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainForNamedBinding, domain = " + domain);
        }
        return domain;
    }

    private static String getDomainForApplicationBinding(Session session, String bindingName, String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainForApplicationBinding, bindingName = " + bindingName);
        }
        String domain = null;
        String pathName = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingName);
        if (pathName == null) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingName}, "The {0} binding was not found"));
        }
        BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathName);
        bindingHelper.setLocale(CommonUtil.getLocale());
        domain = bindingHelper.getDomain();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainForApplicationBinding, domain = " + domain);
        }
        return domain;
    }

    private static String getDomainForAssetBinding(Session session, String bindingName, Properties assetProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainForAssetBinding, bindingName = " + bindingName + ", assetProps = " + assetProps);
        }
        String domain = null;
        String pathName = null;
        if (assetProps.containsKey("cuName")) {
            String cuName = assetProps.getProperty("cuName");
            pathName = PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFile(session, cuName, bindingName);
        } else if (assetProps.containsKey("applicationName")) {
            String appName = assetProps.getProperty("applicationName");
            pathName = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingName);
        }
        if (pathName == null) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingName}, "The {0} binding was not found"));
        }
        BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathName);
        bindingHelper.setLocale(CommonUtil.getLocale());
        domain = bindingHelper.getDomain();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainForAssetBinding, domain = " + domain);
        }
        return domain;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getDomainForResource(Session session, String resource) throws Exception, Throwable {
        String domain;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDomainForResource, resource = " + resource);
            }
            domain = null;
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            if (cmdMgr != null) {
                AdminCommand cmd = cmdMgr.createCommand("getSecurityDomainForResource");
                cmd.setConfigSession(session);
                cmd.setParameter("resourceName", resource);
                cmd.execute();
                CommandResult res = cmd.getCommandResult();
                if (res.isSuccessful()) {
                    domain = (String)res.getResult();
                    break block7;
                } else {
                    Throwable e = res.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDomainForResource, Exception thrown in getSecurityDomainForResource");
                    }
                    throw e;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDomainForResource, CommandMgr is null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainForResource, domain=" + domain);
        }
        return domain;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static List getServiceList(Session session, String applicationName, String attachmentType, String cuName) throws Exception {
        if (PolicySetBindingCommandUtil.tc.isEntryEnabled()) {
            Tr.entry(PolicySetBindingCommandUtil.tc, "getServiceMap, applicationName = " + applicationName + ", attachmentType = " + attachmentType + ", cuName = " + cuName);
        }
        services /* !! */  = new ArrayList<E>();
        serviceList = new ArrayList<Properties>();
        cmdMgr = CommandMgr.getCommandMgr();
        if (cmdMgr != null) {
            try {
                cmd = cmdMgr.createCommand("listServices");
                cmd.setConfigSession(session);
                props = new Properties();
                if (cuName != null) {
                    props.setProperty("cuname", cuName);
                } else {
                    props.setProperty("application", applicationName);
                }
                if (attachmentType.equals("client")) {
                    props.setProperty("client", "true");
                }
                cmd.setParameter("queryProps", props);
                if (PolicySetBindingCommandUtil.tc.isDebugEnabled()) {
                    Tr.debug(PolicySetBindingCommandUtil.tc, "getServiceMap, getting ready to execute listServices command");
                }
                cmd.execute();
                res = cmd.getCommandResult();
                services /* !! */  = (List)res.getResult();
                if (!PolicySetBindingCommandUtil.tc.isDebugEnabled()) ** GOTO lbl34
                Tr.debug(PolicySetBindingCommandUtil.tc, "getServiceMap, retrieved list of services");
            }
            catch (Exception e) {
                Tr.error(PolicySetBindingCommandUtil.tc, "Exception: " + e.getMessage());
                throw e;
            }
        } else if (PolicySetBindingCommandUtil.tc.isDebugEnabled()) {
            Tr.debug(PolicySetBindingCommandUtil.tc, "getServiceMap, CommandMgr is null");
        }
lbl34:
        // 5 sources

        if (services /* !! */  != null && !services /* !! */ .isEmpty()) {
            for (Properties props : services /* !! */ ) {
                service = props.getProperty("service");
                module = props.getProperty("module");
                if (module == null) continue;
                serviceProps = new Properties();
                serviceProps.put(service, module);
                serviceList.add(serviceProps);
            }
        }
        if (PolicySetBindingCommandUtil.tc.isEntryEnabled()) {
            Tr.exit(PolicySetBindingCommandUtil.tc, "getServiceMap, serviceList = " + serviceList);
        }
        return serviceList;
    }

    private static void isNamedBinding(Session session, String bindingName, String bindingType) throws Exception {
        String pathName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNamedBinding");
        }
        if ((pathName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName)) == null) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingName}, "The {0} binding was not found"));
        }
        BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathName);
        bindingHelper.setLocale(CommonUtil.getLocale());
        String type = bindingHelper.getBindingType();
        if (!bindingType.equals(type)) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0124E", new Object[]{bindingName}, "The {0} binding is not valid for the specified type"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNamedBinding");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getBindingLevel(Properties bindingLocation, String attachmentType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingLevel, bindingLocation=" + bindingLocation + ", attachmentType=" + attachmentType);
        }
        int bindingLevel = 1;
        if (bindingLocation != null && !bindingLocation.isEmpty()) {
            if (bindingLocation.containsKey("node") && bindingLocation.containsKey("server")) {
                bindingLevel = 2;
            } else {
                if (!bindingLocation.containsKey("attachmentId")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0047E", new Object[0], "Required property not found for bindingLocation"));
                bindingLevel = 3;
                if (!attachmentType.equals("system/trust") && !bindingLocation.containsKey("cuName")) {
                    if (attachmentType.equals("application") || attachmentType.equals("client")) {
                        if (!bindingLocation.containsKey("application")) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0048E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the binding does not reference a WSN service client or system attachment."));
                        }
                    } else {
                        if (!attachmentType.equals("WSNClient")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                        if (!bindingLocation.containsKey("bus") || !bindingLocation.containsKey("WSNService")) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0111E", new Object[]{"bus", "WSNService"}, "The {0} and {1} must be specified when attachment type is WSNClient."));
                        }
                    }
                }
            }
        } else {
            bindingLevel = 1;
        }
        if (!tc.isEntryEnabled()) return bindingLevel;
        Tr.exit(tc, "getBindingLevel, bindingLevel=" + bindingLevel);
        return bindingLevel;
    }

    private static String getPolicyAttachmentFile(Session session, String attachmentType, String appName, String busName, String serviceName, String cuName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyAttachmentFile, attachmentType=" + attachmentType + ", appName=" + appName + ", busName=" + busName + ", serviceName=" + serviceName + ", cuName=" + cuName);
        }
        String policyAttachmentFile = null;
        if (cuName != null && !cuName.equals("")) {
            if (attachmentType.equals("application")) {
                policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, cuName);
            } else if (attachmentType.equals("client")) {
                policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(session, cuName);
            }
        } else if (attachmentType.equals("application")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
        } else if (attachmentType.equals("system/trust")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
        } else if (attachmentType.equals("client")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName);
        } else if (attachmentType.equals("WSNClient")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(session, busName, serviceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyAttachmentFile, policyAttachmentFile=" + policyAttachmentFile);
        }
        return policyAttachmentFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void deleteBinding(Session session, String policyTypeName, Properties bindingLocation, String attachmentType, int bindingLevel, String bindingName, String bindingScope) throws Exception {
        block29: {
            PolicySetAttachmentHelper psHelper;
            String cuName;
            String serviceName;
            String busName;
            String appName;
            block32: {
                block33: {
                    String attachmentId;
                    block34: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        String bindingRef;
                                        block31: {
                                            block30: {
                                                if (tc.isEntryEnabled()) {
                                                    Tr.entry(tc, "deleteBinding, policyTypeName=" + policyTypeName + ", bindingLocation=" + bindingLocation + ", attachmentType=" + attachmentType + ", bindingLevel=" + bindingLevel, ", bindingName=" + bindingName);
                                                }
                                                bindingRef = "";
                                                if (bindingLevel != 1) break block30;
                                                if (policyTypeName != null) {
                                                    PolicySetBindingCommandUtil.removePolicyTypeFromNamedBinding(session, bindingName, policyTypeName, attachmentType);
                                                    break block29;
                                                } else {
                                                    PolicySetBindingCommandUtil.deleteNamedBindingIfNotUsed(session, bindingName, attachmentType, true);
                                                }
                                                break block29;
                                            }
                                            if (bindingLevel != 2) break block31;
                                            String node = bindingLocation.getProperty("node");
                                            String server = bindingLocation.getProperty("server");
                                            PolicySetBindingWorkSpaceHelper.deleteServerDefaultBindingFile(session, policyTypeName, node, server);
                                            break block29;
                                        }
                                        appName = bindingLocation.getProperty("application");
                                        busName = bindingLocation.getProperty("bus");
                                        serviceName = bindingLocation.getProperty("WSNService");
                                        attachmentId = bindingLocation.getProperty("attachmentId");
                                        cuName = bindingLocation.getProperty("cuName");
                                        psHelper = null;
                                        String policyAttachmentFile = PolicySetBindingCommandUtil.getPolicyAttachmentFile(session, attachmentType, appName, busName, serviceName, cuName);
                                        if (policyAttachmentFile != null) {
                                            psHelper = PolicySetAttachmentHelperFactory.createHelper(policyAttachmentFile);
                                            psHelper.setLocale(CommonUtil.getLocale());
                                        }
                                        if (attachmentId.equals("*")) break block32;
                                        if (policyAttachmentFile == null) break block33;
                                        Properties bindingProps = psHelper.getBindingReference(attachmentId);
                                        bindingRef = bindingProps.getProperty("name");
                                        String scope = bindingProps.getProperty("scope");
                                        if (bindingRef == null || bindingRef.equals("")) break block34;
                                        if (policyTypeName == null) break block35;
                                        if (scope != null && scope.equals("domain")) {
                                            PolicySetBindingCommandUtil.removePolicyTypeFromNamedBinding(session, bindingRef, policyTypeName, attachmentType);
                                            break block29;
                                        } else {
                                            PolicySetBindingCommandUtil.removePolicyTypeFromBinding(session, psHelper, appName, bindingRef, policyTypeName, attachmentType, busName, serviceName, cuName);
                                        }
                                        break block29;
                                    }
                                    psHelper.setBindingReference(attachmentId, null, null);
                                    if (cuName == null || cuName.equals("")) break block36;
                                    if (attachmentType.equals("application")) {
                                        PolicySetSOAAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, cuName);
                                        break block29;
                                    } else if (attachmentType.equals("client")) {
                                        PolicySetSOAAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, cuName);
                                    }
                                    break block29;
                                }
                                if (!attachmentType.equals("application")) break block37;
                                PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, appName);
                                break block29;
                            }
                            if (!attachmentType.equals("system/trust")) break block38;
                            PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(session);
                            break block29;
                        }
                        if (attachmentType.equals("client")) {
                            PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, appName);
                            break block29;
                        } else if (attachmentType.equals("WSNClient")) {
                            PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(session, busName, serviceName);
                        }
                        break block29;
                    }
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0051E", new Object[]{attachmentId}, "Binding not found for attachment: {0}"));
                }
                String errorMsg = null;
                String messageCode = null;
                String resourceName = appName;
                if (cuName != null && !cuName.equals("")) {
                    if (attachmentType.equals("application")) {
                        errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                        messageCode = "CWPST0168E";
                    } else if (attachmentType.equals("client")) {
                        errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                        messageCode = "CWPST0168E";
                    }
                    resourceName = cuName;
                } else if (attachmentType.equals("application")) {
                    errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0031E";
                } else if (attachmentType.equals("system/trust")) {
                    errorMsg = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0033E";
                } else if (attachmentType.equals("client")) {
                    errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0032E";
                } else if (attachmentType.equals("WSNClient")) {
                    errorMsg = WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0108E";
                }
                if (attachmentType.equals("WSNClient")) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, messageCode, new Object[]{busName, serviceName}, errorMsg));
                }
                throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, messageCode, new Object[]{resourceName}, errorMsg));
            }
            if (bindingName == null) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0106E", new Object[0], "The bindingName and remove parameters are required when you specify the attachment ID as an asterisk (*)"));
            }
            if (policyTypeName != null) {
                PolicySetBindingCommandUtil.removePolicyTypeFromBinding(session, psHelper, appName, bindingName, policyTypeName, attachmentType, busName, serviceName, cuName);
            } else {
                PolicySetBindingCommandUtil.deleteBindingIfNotUsed(session, psHelper, appName, bindingName, attachmentType, true, busName, serviceName, cuName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBinding");
        }
    }

    private static void removePolicyTypeFromBinding(Session session, PolicySetAttachmentHelper psHelper, String appName, String bindingName, String policyTypeName, String attachmentType, String busName, String serviceName, String cuName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicyTypeFromBinding, appName=" + appName + ", bindingName=" + bindingName + ", policyTypeName=" + policyTypeName + ", attachmentType=" + attachmentType + ", busName=" + busName + ", serviceName=" + serviceName);
        }
        if (attachmentType.equals("system/trust")) {
            PolicySetBindingWorkSpaceHelper.deleteTrustBindingFile(session, bindingName, policyTypeName);
            if (PolicySetBindingWorkSpaceHelper.getTrustBindingDir(session, bindingName) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removePolicyTypeFromBinding, trust binding " + bindingName + " is deleted. So update the attachment file");
                }
                PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper, bindingName, appName, attachmentType, busName, serviceName, cuName, null);
            }
        } else if (attachmentType.equals("WSNClient")) {
            PolicySetBindingWorkSpaceHelper.deleteWSNClientBindingFile(session, bindingName, policyTypeName, busName, serviceName);
            if (PolicySetBindingWorkSpaceHelper.getWSNClientBindingDir(session, bindingName, busName, serviceName) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removePolicyTypeFromBinding, trust binding " + bindingName + " is deleted. So update the attachment file");
                }
                PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper, bindingName, appName, attachmentType, busName, serviceName, cuName, null);
            }
        } else if (cuName != null && !cuName.equals("")) {
            PolicySetSOABindingWorkSpaceHelper.deleteCUBindingFile(session, cuName, bindingName, policyTypeName, attachmentType);
            if (PolicySetSOABindingWorkSpaceHelper.getCUBindingDir(session, cuName, bindingName) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removePolicyTypeFromBinding, cuName " + cuName + " binding " + bindingName + " is deleted. So update the attachment files");
                }
                PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper, bindingName, appName, attachmentType, busName, serviceName, cuName, null);
                String attachmentFile = null;
                String otherAttachmentType = null;
                if (attachmentType.equals("application")) {
                    attachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(session, cuName);
                    otherAttachmentType = "client";
                } else {
                    attachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, cuName);
                    otherAttachmentType = "application";
                }
                if (attachmentFile != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removePolicyTypeFromBinding, another attachmentFile is " + attachmentFile);
                    }
                    PolicySetAttachmentHelper psHelper2 = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                    psHelper2.setLocale(CommonUtil.getLocale());
                    PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper2, bindingName, appName, otherAttachmentType, busName, serviceName, cuName, null);
                }
            }
        } else {
            PolicySetBindingWorkSpaceHelper.deleteApplicationBindingFile(session, appName, bindingName, policyTypeName, attachmentType);
            if (PolicySetBindingWorkSpaceHelper.getApplicationBindingDir(session, appName, bindingName) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removePolicyTypeFromBinding, application " + appName + " binding " + bindingName + " is deleted. So update the attachment files");
                }
                PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper, bindingName, appName, attachmentType, busName, serviceName, cuName, null);
                String attachmentFile = null;
                String otherAttachmentType = null;
                if (attachmentType.equals("application")) {
                    attachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName);
                    otherAttachmentType = "client";
                } else {
                    attachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
                    otherAttachmentType = "application";
                }
                if (attachmentFile != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removePolicyTypeFromBinding, another attachmentFile is " + attachmentFile);
                    }
                    PolicySetAttachmentHelper psHelper2 = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                    psHelper2.setLocale(CommonUtil.getLocale());
                    PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper2, bindingName, appName, otherAttachmentType, busName, serviceName, cuName, null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicyTypeFromBinding");
        }
    }

    private static void removePolicyTypeFromNamedBinding(Session session, String bindingName, String policyTypeName, String attachmentType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicyTypeFromBinding, bindingName=" + bindingName + ", policyTypeName=" + policyTypeName + ", attachmentType=" + attachmentType);
        }
        String bindingType = null;
        bindingType = attachmentType.equals("application") || attachmentType.equals("system/trust") ? "provider" : "client";
        String bindingDefFile = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName);
        if (bindingDefFile != null) {
            BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
            bindingHelper.setLocale(CommonUtil.getLocale());
            bindingType = bindingHelper.getBindingType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removePolicyTypeFromNamedBinding, bindingType = " + bindingType);
                Tr.debug(tc, "removePolicyTypeFromNamedBinding, attachmentType = " + attachmentType);
            }
        }
        if (bindingType.equals("provider") && !attachmentType.equals("application") && !attachmentType.equals("system/trust") || bindingType.equals("client") && !attachmentType.equals("client") && !attachmentType.equals("WSNClient")) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0124E", new Object[]{bindingName}, "The {0} binding is not valid for the specified attachment type"));
        }
        List policyTypes = PolicyTypeWorkSpaceHelper.listPolicyTypesForNamedBindingFile(session, bindingName);
        if (policyTypes != null && policyTypes.size() == 1 && policyTypeName.equals(policyTypes.get(0))) {
            PolicySetBindingCommandUtil.verifyBindingNotDefault(session, bindingName, bindingType);
        }
        PolicySetBindingWorkSpaceHelper.deleteNamedBindingFile(session, bindingName, policyTypeName);
        if (PolicySetBindingWorkSpaceHelper.getNamedBindingDir(session, bindingName, false) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removePolicyTypeFromBinding, trust binding " + bindingName + " is deleted. So update the attachment file");
            }
            PolicySetBindingCommandUtil.removeNamedBindingRefFromAttachments(session, bindingName, attachmentType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicyTypeFromNamedBinding");
        }
    }

    private static void removeBindingRefFromAttachments(Session session, PolicySetAttachmentHelper psHelper, String bindingName, String appName, String attachmentType, String busName, String serviceName, String cuName, String bindingScope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeBindingRefFromAttachments bindingName=" + bindingName + ", appName=" + appName + ", attachmentType=" + attachmentType + ", busName=" + busName + ", serviceName=" + serviceName + ", cuName=" + cuName + ", bindingScope=" + bindingScope);
        }
        List<String> idList = psHelper.getAttachmentIdsForBinding(bindingName, bindingScope);
        for (int i = 0; i < idList.size(); ++i) {
            psHelper.setBindingReference(idList.get(i), null, null);
        }
        if (!idList.isEmpty()) {
            if (cuName != null && !cuName.equals("")) {
                if (attachmentType.equals("application")) {
                    PolicySetSOAAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, cuName);
                } else if (attachmentType.equals("client")) {
                    PolicySetSOAAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, cuName);
                }
            } else if (attachmentType.equals("system/trust")) {
                PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(session);
            } else if (attachmentType.equals("application")) {
                PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, appName);
            } else if (attachmentType.equals("client")) {
                PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, appName);
            } else if (attachmentType.equals("WSNClient")) {
                PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(session, busName, serviceName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeBindingRefFromAttachments");
        }
    }

    private static void removeNamedBindingRefFromAttachments(Session session, String bindingName, String attachmentType) throws Exception {
        String policyAttachmentFile;
        PolicySetAttachmentHelper psHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNamedBindingRefFromAttachments bindingName=" + bindingName + ", attachmentType=" + attachmentType);
        }
        List<Object> wsnClientList = new ArrayList();
        List<Object> attachmentList = new ArrayList();
        List<Object> cuAttachmentList = new ArrayList();
        String busName = null;
        String serviceName = null;
        String cuName = null;
        attachmentList = PolicySetBindingCommandUtil.listAttachmentsForNamedBinding(session, bindingName, attachmentType);
        if (attachmentList != null && !attachmentList.isEmpty()) {
            for (int i = 0; i < attachmentList.size(); ++i) {
                String string = (String)attachmentList.get(i);
                psHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                psHelper.setLocale(CommonUtil.getLocale());
                String appName = PolicySetAttachmentCommandUtil.getApplicationName(string, "deployments", "META-INF");
                PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper, bindingName, appName, attachmentType, busName, serviceName, cuName, "domain");
            }
        }
        if ((attachmentType.equals("application") || attachmentType.equals("system/trust")) && (policyAttachmentFile = PolicySetBindingCommandUtil.getPolicyAttachmentFile(session, "system/trust", null, null, null, null)) != null) {
            PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(policyAttachmentFile);
            policySetAttachmentHelper.setLocale(CommonUtil.getLocale());
            PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, policySetAttachmentHelper, bindingName, null, "system/trust", null, null, null, "domain");
        }
        if (attachmentType.equals("client")) {
            wsnClientList = PolicySetBindingCommandUtil.listAttachmentsForNamedBinding(session, bindingName, "WSNClient");
        }
        if (wsnClientList != null && !wsnClientList.isEmpty()) {
            for (String string : wsnClientList) {
                psHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                psHelper.setLocale(CommonUtil.getLocale());
                Properties wsnClient = PolicySetAttachmentCommandUtil.getWSNClientBusServiceName(string);
                if (wsnClient != null && !wsnClient.isEmpty()) {
                    busName = wsnClient.getProperty("bus");
                    serviceName = wsnClient.getProperty("WSNService");
                }
                PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper, bindingName, null, "WSNClient", busName, serviceName, null, "domain");
            }
        }
        if ((cuAttachmentList = PolicySetBindingCommandUtil.listCUAttachmentsForNamedBinding(session, bindingName, attachmentType)) != null && !cuAttachmentList.isEmpty()) {
            for (String string : cuAttachmentList) {
                psHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                psHelper.setLocale(CommonUtil.getLocale());
                cuName = PolicySetAttachmentCommandUtil.getCUNameFromAttachmentPath(string);
                PolicySetBindingCommandUtil.removeBindingRefFromAttachments(session, psHelper, bindingName, null, attachmentType, null, null, cuName, "domain");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNamedBindingRefFromAttachments");
        }
    }

    protected static void deleteBindingIfNotUsed(Session session, PolicySetAttachmentHelper psHelper, String appName, String bindingName, String attachmentType, boolean validateBinding, String busName, String serviceName, String cuName) throws Exception {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteBindingIfNotUsed, appName=" + appName + ", bindingName=" + bindingName + ", attachmentType=" + attachmentType + ", validateBinding=" + validateBinding + ", busName=" + busName + ", serviceName=" + serviceName);
            }
            if (bindingName == null || bindingName.equals("")) {
                return;
            }
            List<Object> attachmentList = new ArrayList(0);
            if (psHelper != null) {
                if (!psHelper.isAttachmentListEmpty()) {
                    attachmentList = psHelper.getAttachmentIdsForBinding(bindingName, null);
                }
                if (!attachmentList.isEmpty()) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0107E", new Object[]{bindingName}, "The {0} binding cannot be deleted because it is still referenced by an attachment"));
                }
            }
            try {
                if (attachmentType.equals("system/trust")) {
                    PolicySetBindingWorkSpaceHelper.deleteTrustBinding(session, bindingName);
                    break block21;
                }
                if (attachmentType.equals("WSNClient")) {
                    PolicySetBindingWorkSpaceHelper.deleteWSNClientBinding(session, bindingName, busName, serviceName);
                    break block21;
                }
                if (cuName != null && !cuName.equals("")) {
                    PolicySetAttachmentHelper psHelper2 = null;
                    String otherAttachmentFile = null;
                    otherAttachmentFile = attachmentType.equals("application") ? PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(session, cuName) : PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, cuName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleteBindingIfNotUsed, otherAttachmentFile=" + otherAttachmentFile);
                    }
                    if (otherAttachmentFile != null) {
                        psHelper2 = PolicySetAttachmentHelperFactory.createHelper(otherAttachmentFile);
                        psHelper2.setLocale(CommonUtil.getLocale());
                        if (!psHelper2.isAttachmentListEmpty()) {
                            attachmentList = psHelper2.getAttachmentIdsForBinding(bindingName, null);
                        }
                    }
                    if (otherAttachmentFile == null || attachmentList.isEmpty()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "deleteBindingIfNotUsed, no attachment refers to this binding, so delete the binding");
                        }
                        PolicySetSOABindingWorkSpaceHelper.deleteCUBinding(session, cuName, bindingName);
                        break block21;
                    }
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0107E", new Object[]{bindingName}, "The {0} binding cannot be deleted because it is still referenced by an attachment"));
                }
                PolicySetAttachmentHelper psHelper2 = null;
                String otherAttachmentFile = null;
                otherAttachmentFile = attachmentType.equals("application") ? PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName) : PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteBindingIfNotUsed, otherAttachmentFile=" + otherAttachmentFile);
                }
                if (otherAttachmentFile != null) {
                    psHelper2 = PolicySetAttachmentHelperFactory.createHelper(otherAttachmentFile);
                    psHelper2.setLocale(CommonUtil.getLocale());
                    if (!psHelper2.isAttachmentListEmpty()) {
                        attachmentList = psHelper2.getAttachmentIdsForBinding(bindingName, null);
                    }
                }
                if (otherAttachmentFile == null || attachmentList.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleteBindingIfNotUsed, no attachment refers to this binding, so delete the binding");
                    }
                    PolicySetBindingWorkSpaceHelper.deleteApplicationBinding(session, appName, bindingName);
                    break block21;
                }
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0107E", new Object[]{bindingName}, "The {0} binding cannot be deleted because it is still referenced by an attachment"));
            }
            catch (NoItemFoundException e) {
                Tr.processException(e, "PolicySetCommandUtil.deleteBindingIfNotUsed", FFDC_ID_1);
                Tr.error(tc, "CWPST0084E", new Object[]{e.toString()});
                if (!validateBinding) break block21;
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0054E", new Object[]{bindingName}, "Binding reference removed from attachment but binding file not found: {0}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingIfNotUsed");
        }
    }

    protected static void deleteNamedBindingIfNotUsed(Session session, String bindingName, String attachmentType, boolean validateBinding) throws Exception {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteBindingIfNotUsed, bindingName=" + bindingName + ", attachmentType=" + attachmentType + ", validateBinding=" + validateBinding);
            }
            if (bindingName == null || bindingName.equals("")) {
                return;
            }
            String bindingType = null;
            bindingType = attachmentType.equals("application") || attachmentType.equals("system/trust") ? "provider" : "client";
            String bindingDefFile = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName);
            if (bindingDefFile != null) {
                BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
                bindingHelper.setLocale(CommonUtil.getLocale());
                bindingType = bindingHelper.getBindingType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteNamedBindingIfNotUsed, bindingType = " + bindingType);
                    Tr.debug(tc, "deleteNamedBindingIfNotUsed, attachmentType = " + attachmentType);
                }
            }
            if (bindingType.equals("provider") && !attachmentType.equals("application") && !attachmentType.equals("system/trust") || bindingType.equals("client") && !attachmentType.equals("client") && !attachmentType.equals("WSNClient")) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0124E", new Object[]{bindingName}, "The {0} binding is not valid for the specified attachment type"));
            }
            List<String> attachmentList = PolicySetBindingCommandUtil.listAttachmentsForNamedBinding(session, bindingName, attachmentType);
            if (!attachmentList.isEmpty()) {
                StringBuffer applicationBuf = PolicySetBindingCommandUtil.convertListToStringBuffer(attachmentList, true);
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0133E", new Object[]{bindingName, applicationBuf}, "The {0} binding cannot be deleted because it is still referenced by attachments for the following applications: {1}"));
            }
            if (attachmentType.equals("client")) {
                attachmentList = PolicySetBindingCommandUtil.listAttachmentsForNamedBinding(session, bindingName, "WSNClient");
                if (!attachmentList.isEmpty()) {
                    StringBuffer applicationBuf = PolicySetBindingCommandUtil.convertListToStringBuffer(attachmentList, true);
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0133E", new Object[]{bindingName, applicationBuf}, "The {0} binding cannot be deleted because it is still referenced by attachments for the following applications: {1}"));
                }
            } else {
                String policyAttachmentFile = PolicySetBindingCommandUtil.getPolicyAttachmentFile(session, "system/trust", null, null, null, null);
                if (policyAttachmentFile != null) {
                    PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(policyAttachmentFile);
                    psHelper.setLocale(CommonUtil.getLocale());
                    attachmentList = psHelper.getAttachmentIdsForBinding(bindingName, "domain");
                    if (!attachmentList.isEmpty()) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0107E", new Object[]{bindingName}, "The {0} binding cannot be deleted because it is still referenced by an attachment"));
                    }
                }
            }
            PolicySetBindingCommandUtil.verifyBindingNotDefault(session, bindingName, bindingType);
            try {
                PolicySetBindingWorkSpaceHelper.deleteNamedBinding(session, bindingName);
            }
            catch (NoItemFoundException e) {
                Tr.processException(e, "PolicySetCommandUtil.deleteNamedBindingIfNotUsed", FFDC_ID_2);
                Tr.error(tc, "CWPST0084E", new Object[]{e.toString()});
                if (!validateBinding) break block14;
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0054E", new Object[]{bindingName}, "Binding reference removed from attachment but binding file not found: {0}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingIfNotUsed");
        }
    }

    private static List<String> listAttachmentsForNamedBinding(Session session, String bindingName, String attachmentType) throws Exception {
        List<String> attachmentList;
        PolicySetAttachmentHelper psHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAttachmentsForNamedBinding bindingName=" + bindingName + ", attachmentType=" + attachmentType);
        }
        List<Object> applicationList = new ArrayList();
        List<Object> wsnClientList = new ArrayList();
        ArrayList<String> attachedReferenceList = new ArrayList<String>();
        if (attachmentType.equals("application")) {
            applicationList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
        }
        if (attachmentType.equals("client")) {
            applicationList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
        }
        if (applicationList != null && !applicationList.isEmpty()) {
            for (int i = 0; i < applicationList.size(); ++i) {
                String string = (String)applicationList.get(i);
                psHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                psHelper.setLocale(CommonUtil.getLocale());
                attachmentList = psHelper.getAttachmentIdsForBinding(bindingName, "domain");
                if (attachmentList.isEmpty()) continue;
                attachedReferenceList.add(string);
            }
        }
        if (attachmentType.equals("WSNClient")) {
            wsnClientList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "WSNClient");
        }
        if (wsnClientList != null && !wsnClientList.isEmpty()) {
            for (String string : wsnClientList) {
                psHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                psHelper.setLocale(CommonUtil.getLocale());
                attachmentList = psHelper.getAttachmentIdsForBinding(bindingName, "domain");
                if (attachmentList.isEmpty()) continue;
                attachedReferenceList.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAttachmentsForNamedBinding");
        }
        return attachedReferenceList;
    }

    private static List<String> listCUAttachmentsForNamedBinding(Session session, String bindingName, String attachmentType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCUAttachmentsForNamedBinding bindingName=" + bindingName + ", attachmentType=" + attachmentType);
        }
        List<Object> cuList = new ArrayList();
        ArrayList<String> attachedReferenceList = new ArrayList<String>();
        if (attachmentType.equals("application")) {
            cuList = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
        }
        if (attachmentType.equals("client")) {
            cuList = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
        }
        if (cuList != null && !cuList.isEmpty()) {
            for (int i = 0; i < cuList.size(); ++i) {
                String cuFilePath = (String)cuList.get(i);
                PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(cuFilePath);
                psHelper.setLocale(CommonUtil.getLocale());
                List<String> attachmentList = psHelper.getAttachmentIdsForBinding(bindingName, "domain");
                if (attachmentList.isEmpty()) continue;
                attachedReferenceList.add(cuFilePath);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCUAttachmentsForNamedBinding");
        }
        return attachedReferenceList;
    }

    private static StringBuffer convertListToStringBuffer(List<String> resourceList, boolean convertApplicationNames) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertListToStringBuffer, resourceList=" + resourceList);
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < resourceList.size(); ++i) {
            String resource = resourceList.get(i);
            try {
                if (convertApplicationNames) {
                    resource = PolicySetAttachmentCommandUtil.getApplicationName(resource, "deployments", "META-INF");
                }
                if (strBuf.length() > 0) {
                    strBuf.append(", ");
                }
                strBuf.append(resource);
                continue;
            }
            catch (CommandValidationException e) {
                Tr.processException(e, "PolicySetCommandUtil.convertListToStringBuffer", FFDC_ID_3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addURLResourceToList");
        }
        return strBuf;
    }

    private static void verifyBindingNotDefault(Session session, String bindingName, String bindingType) throws Exception {
        String bindingsFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyBindingNotDefault, bindingName=" + bindingName);
        }
        if ((bindingsFile = PolicySetBindingWorkSpaceHelper.getDefaultBindingsFile(session)) != null) {
            DefaultBindingsHelper helper = DefaultBindingsHelperFactory.createHelper(bindingsFile);
            helper.setLocale(CommonUtil.getLocale());
            List<String> resourceList = helper.getDomainsDefaultedToBinding(bindingName, bindingType);
            if (!resourceList.isEmpty()) {
                StringBuffer strBuf = PolicySetBindingCommandUtil.convertListToStringBuffer(resourceList, false);
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0134E", new Object[]{bindingName, strBuf}, "The {0} binding cannot be deleted because it is the default binding for the following domains: {1}"));
            }
            resourceList = helper.getServersDefaultedToBinding(bindingName, bindingType);
            if (!resourceList.isEmpty()) {
                StringBuffer strBuf = PolicySetBindingCommandUtil.convertListToStringBuffer(resourceList, false);
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0135E", new Object[]{bindingName, strBuf}, "The {0} binding cannot be deleted because it is the default binding for the following servers: {1}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyBindingNotDefault");
        }
    }

    private static Properties getBindingFile(Session session, String policyTypeName, Properties bindingLocation, String attachmentType, int bindingLevel, String bindingName, Properties requestedValues, String bindingScope, String description, String domain, String version) throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingFile, policyTypeName=" + policyTypeName + ", bindingLocation=" + bindingLocation + ", attachmentType=" + attachmentType + ", bindingLevel=" + bindingLevel + ", requestedValues=" + requestedValues + ", bindingScope=" + bindingScope + ", description=" + description + ", domain=" + domain + ", version=" + version);
        }
        String bindingFile = null;
        String bindingRef = "";
        boolean createdFile = false;
        boolean updateBinding = false;
        boolean updateBindingDefinition = false;
        Properties bindingProps = new Properties();
        String bindingDefFile = null;
        boolean isNamedBindingFile = false;
        String domainName = "global";
        String appDomain = null;
        List serviceList = new ArrayList();
        String bindingVersion = "7.0.0.0";
        if (bindingLevel == 1) {
            if (bindingName != null) {
                isNamedBindingFile = true;
                if (requestedValues == null || requestedValues.isEmpty()) {
                    bindingFile = PolicySetBindingWorkSpaceHelper.getNamedBindingDir(session, bindingName, false);
                    if (bindingFile == null) {
                        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingName}, "Binding not found: {0}"));
                    }
                    updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingName, attachmentType, description, domain, null, null);
                } else {
                    bindingFile = PolicySetBindingWorkSpaceHelper.getNamedBindingFile(session, bindingName, policyTypeName);
                    if (bindingFile == null) {
                        bindingFile = PolicySetBindingWorkSpaceHelper.createNamedBindingFile(session, bindingName, policyTypeName);
                        createdFile = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getBindingFile, created named binding");
                        }
                        if (PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName) == null) {
                            bindingDefFile = PolicySetBindingWorkSpaceHelper.createNamedBindingDefinitionFile(session, bindingName);
                            BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
                            bindingHelper.setLocale(CommonUtil.getLocale());
                            String bindingType = "provider";
                            if (attachmentType.equals("client")) {
                                bindingType = "client";
                            }
                            if (description == null) {
                                description = "";
                            }
                            if (domain == null) {
                                domain = "global";
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getBindingFile, description = " + description);
                            }
                            bindingHelper.createBindingDefinition(description, bindingType, domain, "7.0.0.0");
                        } else {
                            updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingName, attachmentType, description, domain, null, null);
                        }
                    } else {
                        updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingName, attachmentType, description, domain, null, null);
                    }
                }
                domainName = PolicySetBindingCommandUtil.getDomainForNamedBinding(session, bindingName);
                bindingRef = bindingName;
            } else {
                bindingFile = PolicySetBindingWorkSpaceHelper.getCellDefaultBindingFile(session, policyTypeName);
                domainName = "global";
                bindingVersion = "6.1.0.0";
            }
        } else if (bindingLevel == 2) {
            String server;
            String node = bindingLocation.getProperty("node");
            bindingFile = PolicySetBindingWorkSpaceHelper.getServerDefaultBindingFile(session, policyTypeName, node, server = bindingLocation.getProperty("server"));
            if (bindingFile == null) {
                bindingFile = PolicySetBindingWorkSpaceHelper.createServerDefaultBindingFile(session, policyTypeName, node, server);
                createdFile = true;
            }
            domainName = "global";
            bindingVersion = "6.1.0.0";
        } else {
            String appName = bindingLocation.getProperty("application");
            String busName = bindingLocation.getProperty("bus");
            String serviceName = bindingLocation.getProperty("WSNService");
            String attachmentId = bindingLocation.getProperty("attachmentId");
            String cuName = bindingLocation.getProperty("cuName");
            String policyAttachmentFile = null;
            String errorMsg = null;
            String messageCode = null;
            PolicySetAttachmentHelper psHelper = null;
            ArrayList<String> domainList = new ArrayList<String>();
            Properties moduleProps = new Properties();
            if (cuName != null && !cuName.equals("")) {
                if (attachmentType.equals("application")) {
                    policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, cuName);
                    errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0168E";
                } else if (attachmentType.equals("client")) {
                    policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(session, cuName);
                    errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0168E";
                }
            } else if (attachmentType.equals("application")) {
                policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
                errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0031E";
            } else if (attachmentType.equals("system/trust")) {
                policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
                errorMsg = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0033E";
            } else if (attachmentType.equals("client")) {
                policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName);
                errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0032E";
            } else if (attachmentType.equals("WSNClient")) {
                policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(session, busName, serviceName);
                errorMsg = WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0108E";
            }
            if (policyAttachmentFile != null) {
                String bindingType;
                BindingDefinitionHelper bindingHelper;
                String policySetName;
                psHelper = PolicySetAttachmentHelperFactory.createHelper(policyAttachmentFile);
                psHelper.setLocale(CommonUtil.getLocale());
                Properties props = psHelper.getBindingReference(attachmentId);
                bindingRef = props.getProperty("name");
                String scope = props.getProperty("scope");
                String generatedBindingName = policySetName = psHelper.getPolicySetForAttachment(attachmentId);
                if (generatedBindingName == null || generatedBindingName.equals("")) {
                    generatedBindingName = "providerPolicySet";
                }
                if (bindingRef == null || bindingRef.equals("")) {
                    updateBinding = true;
                    bindingRef = bindingName != null ? bindingName : generatedBindingName + " " + attachmentId + " " + "binding";
                } else if (bindingName != null && (!bindingName.equals(bindingRef) || bindingScope != null && !bindingScope.equals(scope) || scope != null && !scope.equals(bindingScope))) {
                    updateBinding = true;
                    bindingRef = bindingName;
                }
                if (attachmentType.equals("application") || attachmentType.equals("client")) {
                    List validDomains = PolicySetBindingCommandUtil.getValidDomains(session);
                    if (validDomains.size() == 1) {
                        domainName = "global";
                    } else if (cuName != null && !cuName.equals("")) {
                        List<String> serverList = PolicySetBindingCommandUtil.getServersForCU(session, cuName);
                        if (serverList != null) {
                            List<String> cuDomainList = PolicySetBindingCommandUtil.getDomainsForServers(session, cuName, serverList);
                            domainName = cuDomainList.isEmpty() || cuDomainList.size() > 1 ? "global" : cuDomainList.get(0);
                        }
                    } else {
                        serviceList = PolicySetBindingCommandUtil.getServiceList(session, appName, attachmentType, cuName);
                        if (serviceList != null) {
                            moduleProps = PolicySetBindingCommandUtil.getDomainsForModules(session, appName, serviceList, cuName);
                            ArrayList<String> appDomains = new ArrayList<String>();
                            Collection<Object> moduleDomains = moduleProps.values();
                            for (String string : moduleDomains) {
                                if (string.equals("global") || appDomains.contains(string)) continue;
                                appDomains.add(string);
                            }
                            appDomain = appDomains.isEmpty() || appDomains.size() > 1 ? "global" : (String)appDomains.get(0);
                        }
                        List<String> resources = psHelper.getPolicySetResources(attachmentId, "id");
                        Iterator<String> resourcesIt = resources.iterator();
                        boolean appLevelResource = false;
                        while (resourcesIt.hasNext() && !appLevelResource) {
                            String string = resourcesIt.next();
                            if (string.equals("WebService:/")) {
                                domainName = appDomain;
                                appLevelResource = true;
                                continue;
                            }
                            PolicyResource policyResource = new PolicyResource(string);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "policyResource: " + policyResource);
                            }
                            String moduleName = policyResource.getModuleName();
                            String service = policyResource.getServiceName();
                            if (moduleName == null) {
                                for (Properties serviceProps : serviceList) {
                                    Enumeration<?> e = serviceProps.propertyNames();
                                    String serv = (String)e.nextElement();
                                    if (!serv.equals(service)) continue;
                                    moduleName = serviceProps.getProperty(service);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "moduleName from serviceList = " + moduleName);
                                }
                            }
                            if (moduleName == null) continue;
                            String modDomain = moduleProps.getProperty(moduleName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "moduleName = " + moduleName + ", modDomain = " + modDomain);
                            }
                            if (domainList.contains(modDomain)) continue;
                            domainList.add(modDomain);
                        }
                        if (!appLevelResource) {
                            domainName = domainList.size() > 1 ? "global" : (String)domainList.get(0);
                        }
                    }
                    if (cuName == null) {
                        Properties assetProps = new Properties();
                        assetProps.setProperty("application", appName);
                        bindingVersion = PolicySetBindingCommandUtil.getRequiredBindingVersion(session, assetProps);
                    }
                    if (version != null && !version.equals(bindingVersion)) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0156E", new Object[]{version}, "The {0} version is not valid for the specified application"));
                    }
                }
                if (bindingScope != null && bindingScope.equals("domain") || !updateBinding && scope != null && scope.equals("domain")) {
                    isNamedBindingFile = true;
                    if (updateBinding && (attachmentType.equals("application") || attachmentType.equals("client")) && bindingVersion.equals("6.1.0.0")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0157E", new Object[]{bindingVersion}, "A general binding cannot be assigned to an application with version {0}"));
                    }
                    if (requestedValues == null || requestedValues.isEmpty() || policyTypeName == null) {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getNamedBindingDir(session, bindingRef, false);
                        if (bindingFile == null) {
                            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingRef}, "Binding not found: {0}"));
                        }
                        updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, null, null);
                    } else {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getNamedBindingFile(session, bindingRef, policyTypeName);
                        if (bindingFile == null) {
                            bindingFile = PolicySetBindingWorkSpaceHelper.createNamedBindingFile(session, bindingRef, policyTypeName);
                            createdFile = true;
                            if (PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingRef) == null) {
                                bindingDefFile = PolicySetBindingWorkSpaceHelper.createNamedBindingDefinitionFile(session, bindingRef);
                                bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
                                bindingHelper.setLocale(CommonUtil.getLocale());
                                bindingType = "provider";
                                if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                                    bindingType = "client";
                                }
                                if (description == null) {
                                    description = "";
                                }
                                if (domain == null) {
                                    domain = "global";
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getBindingFile, description = " + description);
                                }
                                bindingHelper.createBindingDefinition(description, bindingType, domain, "7.0.0.0");
                            } else {
                                updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, null, null);
                            }
                        } else {
                            updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, null, null);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getBindingFile, getting ready to get domain of named binding");
                    }
                    String namedBindingDomainName = PolicySetBindingCommandUtil.getDomainForNamedBinding(session, bindingRef);
                    if (attachmentType.equals("application") || attachmentType.equals("client")) {
                        if (!namedBindingDomainName.equals("global") && !namedBindingDomainName.equals(domainName)) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0154E", new Object[0], "The security domain of the selected binding does not match the security domain of the attachment resource"));
                        }
                        domainName = namedBindingDomainName;
                    } else {
                        domainName = namedBindingDomainName;
                    }
                } else if (attachmentType.equals("system/trust")) {
                    if (requestedValues == null || requestedValues.isEmpty()) {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getTrustBindingDir(session, bindingRef);
                        if (bindingFile == null) {
                            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingRef}, "Binding not found: {0}"));
                        }
                    } else {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getTrustBindingFile(session, bindingRef, policyTypeName);
                        if (bindingFile == null) {
                            bindingFile = PolicySetBindingWorkSpaceHelper.createTrustBindingFile(session, bindingRef, policyTypeName);
                            createdFile = true;
                        }
                    }
                    domainName = "global";
                } else if (attachmentType.equals("WSNClient")) {
                    if (requestedValues == null || requestedValues.isEmpty()) {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getWSNClientBindingDir(session, bindingRef, busName, serviceName);
                        if (bindingFile == null) {
                            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingRef}, "Binding not found: {0}"));
                        }
                    } else {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getWSNClientBindingFile(session, bindingRef, policyTypeName, busName, serviceName);
                        if (bindingFile == null) {
                            bindingFile = PolicySetBindingWorkSpaceHelper.createWSNClientBindingFile(session, bindingRef, policyTypeName, busName, serviceName);
                            createdFile = true;
                        }
                    }
                    domainName = "global";
                } else if (cuName != null && !cuName.equals("")) {
                    if (requestedValues == null || requestedValues.isEmpty()) {
                        bindingFile = PolicySetSOABindingWorkSpaceHelper.getCUBindingDir(session, cuName, bindingRef);
                        if (bindingFile == null) {
                            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingRef}, "Binding not found: {0}"));
                        }
                        if (PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFile(session, cuName, bindingRef) != null) {
                            updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, null, cuName);
                        }
                    } else {
                        bindingFile = PolicySetSOABindingWorkSpaceHelper.getCUBindingFile(session, cuName, bindingRef, policyTypeName);
                        if (bindingFile == null) {
                            bindingFile = PolicySetSOABindingWorkSpaceHelper.createCUBindingFile(session, cuName, bindingRef, policyTypeName, attachmentType);
                            createdFile = true;
                            if (PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFile(session, cuName, bindingRef) == null) {
                                bindingDefFile = PolicySetSOABindingWorkSpaceHelper.createCUBindingDefinitionFile(session, cuName, bindingRef);
                                bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
                                bindingHelper.setLocale(CommonUtil.getLocale());
                                bindingType = "provider";
                                if (attachmentType.equals("client")) {
                                    bindingType = "client";
                                }
                                if (description == null) {
                                    description = "";
                                }
                                if (domain == null) {
                                    domain = "global";
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getBindingFile, description = " + description);
                                }
                                bindingHelper.createBindingDefinition(description, bindingType, domain, bindingVersion);
                            } else {
                                updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, null, cuName);
                            }
                        } else if (PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFile(session, cuName, bindingRef) != null) {
                            updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, null, cuName);
                        }
                    }
                    if (PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFile(session, cuName, bindingRef) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getBindingFile, getting ready to get domain of CU binding");
                        }
                        Properties assetProps = new Properties();
                        assetProps.setProperty("cuName", cuName);
                        String bindingDomainName = PolicySetBindingCommandUtil.getDomainForAssetBinding(session, bindingRef, assetProps);
                        if (!bindingDomainName.equals("global") && !bindingDomainName.equals(domainName)) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0162E", new Object[]{bindingDomainName}, "The {0} domain name is not valid for the attachment resource"));
                        }
                    }
                } else {
                    if (requestedValues == null || requestedValues.isEmpty()) {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getApplicationBindingDir(session, appName, bindingRef);
                        if (bindingFile == null) {
                            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{bindingRef}, "Binding not found: {0}"));
                        }
                        if (PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingRef) != null) {
                            updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, appName, null);
                        }
                    } else {
                        bindingFile = PolicySetBindingWorkSpaceHelper.getApplicationBindingFile(session, appName, bindingRef, policyTypeName);
                        if (bindingFile == null) {
                            bindingFile = PolicySetBindingWorkSpaceHelper.createApplicationBindingFile(session, appName, bindingRef, policyTypeName, attachmentType);
                            createdFile = true;
                            if (PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingRef) == null) {
                                bindingDefFile = PolicySetBindingWorkSpaceHelper.createApplicationBindingDefinitionFile(session, appName, bindingRef);
                                bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
                                bindingHelper.setLocale(CommonUtil.getLocale());
                                bindingType = "provider";
                                if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                                    bindingType = "client";
                                }
                                if (description == null) {
                                    description = "";
                                }
                                if (domain == null) {
                                    domain = "global";
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getBindingFile, description = " + description);
                                }
                                bindingHelper.createBindingDefinition(description, bindingType, domain, bindingVersion);
                            } else {
                                updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, appName, null);
                            }
                        } else if (PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingRef) != null) {
                            updateBindingDefinition = PolicySetBindingCommandUtil.verifyBindingDefinition(session, bindingRef, attachmentType, description, domain, appName, null);
                        }
                    }
                    if (PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingRef) != null) {
                        String bindingDomainName;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getBindingFile, getting ready to get domain of application binding");
                        }
                        if (!(bindingDomainName = PolicySetBindingCommandUtil.getDomainForApplicationBinding(session, bindingRef, appName)).equals("global") && !bindingDomainName.equals(domainName)) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0162E", new Object[]{bindingDomainName}, "The {0} domain name is not valid for the attachment resource"));
                        }
                    }
                }
            } else {
                if (attachmentType.equals("WSNClient")) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, messageCode, new Object[]{busName, serviceName}, errorMsg));
                }
                throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, messageCode, new Object[]{appName}, errorMsg));
            }
            if (updateBinding) {
                psHelper.setBindingReference(attachmentId, null, null);
                int rc = psHelper.setBindingReference(attachmentId, bindingRef, bindingScope);
                if (rc != 0) {
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0045E", new Object[]{attachmentId}, "Unable to create binding reference for attachment: {0}"));
                }
            }
        }
        if (bindingFile != null) {
            bindingProps.setProperty(BINDING_FILE, bindingFile);
        }
        bindingProps.setProperty(BINDING_REF, bindingRef);
        bindingProps.setProperty(CREATED_FILE, Boolean.toString(createdFile));
        bindingProps.setProperty(UPDATED_BINDING_REF, Boolean.toString(updateBinding));
        bindingProps.setProperty(UPDATED_BINDING_DEFINITION, Boolean.toString(updateBindingDefinition));
        bindingProps.setProperty(NAMED_BINDING, Boolean.toString(isNamedBindingFile));
        bindingProps.setProperty(BINDING_DOMAIN, domainName);
        bindingProps.setProperty(BINDING_VERSION, bindingVersion);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingFile, bindingProps=" + bindingProps);
        }
        return bindingProps;
    }

    private static void updateBindingFile(Session session, String policyTypeName, Properties bindingLocation, String bindingRef, String attachmentType, String bindingName, boolean isNamedBindingFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateBindingFile, policyTypeName=" + policyTypeName + ", bindingLocation=" + bindingLocation + ", bindingRef=" + bindingRef + ", attachmentType=" + attachmentType);
        }
        if (bindingLocation != null && !bindingLocation.isEmpty()) {
            if (bindingLocation.containsKey("node")) {
                String node = bindingLocation.getProperty("node");
                String server = bindingLocation.getProperty("server");
                PolicySetBindingWorkSpaceHelper.updateServerDefaultBindingFile(session, policyTypeName, node, server);
            } else if (isNamedBindingFile) {
                PolicySetBindingWorkSpaceHelper.updateNamedBindingFile(session, bindingRef, policyTypeName);
            } else if (attachmentType.equals("system/trust")) {
                PolicySetBindingWorkSpaceHelper.updateTrustBindingFile(session, bindingRef, policyTypeName);
            } else if (attachmentType.equals("WSNClient")) {
                String busName = bindingLocation.getProperty("bus");
                String serviceName = bindingLocation.getProperty("WSNService");
                PolicySetBindingWorkSpaceHelper.updateWSNClientBindingFile(session, bindingRef, policyTypeName, busName, serviceName);
            } else {
                String cuName = bindingLocation.getProperty("cuName");
                if (cuName != null && !cuName.equals("")) {
                    PolicySetSOABindingWorkSpaceHelper.updateCUBindingFile(session, cuName, bindingRef, policyTypeName);
                } else {
                    String appName = bindingLocation.getProperty("application");
                    PolicySetBindingWorkSpaceHelper.updateApplicationBindingFile(session, appName, bindingRef, policyTypeName);
                }
            }
        } else if (bindingName != null) {
            PolicySetBindingWorkSpaceHelper.updateNamedBindingFile(session, bindingName, policyTypeName);
        } else {
            PolicySetBindingWorkSpaceHelper.updateCellDefaultBindingFile(session, policyTypeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateBindingFile");
        }
    }

    private static void deleteBindingFile(Session session, String policyTypeName, Properties bindingLocation, String bindingRef, String attachmentType, boolean isNamedBindingFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBindingFile, policyTypeName=" + policyTypeName + ", bindingLocation=" + bindingLocation + ", bindingRef=" + bindingRef + ", attachmentType=" + attachmentType + ", isNamedBindingFile=" + isNamedBindingFile);
        }
        if (bindingLocation != null && !bindingLocation.isEmpty()) {
            if (bindingLocation.containsKey("node")) {
                String node = bindingLocation.getProperty("node");
                String server = bindingLocation.getProperty("server");
                PolicySetBindingWorkSpaceHelper.deleteServerDefaultBindingFile(session, policyTypeName, node, server);
            } else if (isNamedBindingFile) {
                PolicySetBindingWorkSpaceHelper.deleteNamedBindingFile(session, bindingRef, policyTypeName);
            } else {
                String cuName = bindingLocation.getProperty("cuName");
                if (attachmentType.equals("system/trust")) {
                    PolicySetBindingWorkSpaceHelper.deleteTrustBindingFile(session, bindingRef, policyTypeName);
                } else if (attachmentType.equals("WSNClient")) {
                    String busName = bindingLocation.getProperty("bus");
                    String serviceName = bindingLocation.getProperty("WSNService");
                    PolicySetBindingWorkSpaceHelper.deleteWSNClientBindingFile(session, bindingRef, policyTypeName, busName, serviceName);
                } else if (cuName != null && !cuName.equals("")) {
                    PolicySetSOABindingWorkSpaceHelper.deleteCUBindingFile(session, cuName, bindingRef, policyTypeName, attachmentType);
                } else {
                    String appName = bindingLocation.getProperty("application");
                    PolicySetBindingWorkSpaceHelper.deleteApplicationBindingFile(session, appName, bindingRef, policyTypeName, attachmentType);
                }
            }
        } else if (isNamedBindingFile) {
            PolicySetBindingWorkSpaceHelper.deleteNamedBindingFile(session, bindingRef, policyTypeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingFile");
        }
    }

    private static boolean verifyBindingDefinition(Session session, String bindingName, String attachmentType, String description, String domain, String appName, String cuName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyBindingDefinition, bindingName=" + bindingName + ", attachmentType=" + attachmentType + ", description=" + description + ", domain=" + domain);
        }
        boolean updateBindingDefinition = false;
        boolean invalid = false;
        String bindingDefFile = null;
        bindingDefFile = cuName != null ? PolicySetSOABindingWorkSpaceHelper.getCUBindingDefinitionFile(session, cuName, bindingName) : (appName == null ? PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName) : PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingName));
        BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
        bindingHelper.setLocale(CommonUtil.getLocale());
        String bindingType = bindingHelper.getBindingType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "verifyBindingDefinition, bindingType = " + bindingType);
            Tr.debug(tc, "verifyBindingDefinition, attachmentType = " + attachmentType);
        }
        if (bindingType.equals("provider") && !attachmentType.equals("system/trust") && !attachmentType.equals("application")) {
            invalid = true;
        }
        if (bindingType.equals("client") && !attachmentType.equals("client") && !attachmentType.equals("WSNClient")) {
            invalid = true;
        }
        if (invalid) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0124E", new Object[]{bindingName}, "The {0} binding is not valid for the specified attachment type"));
        }
        if (description != null) {
            bindingHelper.setDescription(description);
            updateBindingDefinition = true;
        }
        if (domain != null) {
            bindingHelper.setDomain(domain);
            updateBindingDefinition = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyBindingDefinition");
        }
        return updateBindingDefinition;
    }

    private static boolean isLocalMode() {
        boolean localMode = true;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            localMode = false;
        }
        return localMode;
    }
}

