/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.runtime.DefaultResourceEvaluator;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import com.ibm.ws.webservices.admin.serviceindex.WebService;
import com.ibm.ws.webservices.admin.utils.ServiceIndexMgrUtils;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelper;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelperFactory;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import com.ibm.wsspi.management.bla.model.BLASpec;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import com.ibm.wsspi.management.bla.model.CompositionUnitFactory;
import com.ibm.wsspi.management.bla.model.CompositionUnitRef;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetAttachmentCommandUtil
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentCommandUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());
    private static final String DEPLOYMENTS = "deployments";
    private static final String META_INF = "META-INF";

    public static StringBuffer getApplicationsAttachedToPolicySet(Session session, String policySetName) throws WorkSpaceException, NoItemFoundException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, IllegalArgumentException, JAXBException, CommandValidationException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationsAttachedToPolicySet, policySetName=" + policySetName);
        }
        StringBuffer appBuffer = new StringBuffer("");
        String appName = null;
        Object var4_4 = null;
        int appCount = 0;
        List<Object> attachmentFileList = new ArrayList();
        List<Object> clientFilenames = new ArrayList();
        attachmentFileList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
        clientFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
        if (clientFilenames != null) {
            attachmentFileList.addAll(clientFilenames);
        }
        for (String string : attachmentFileList) {
            appName = PolicySetAttachmentCommandUtil.getApplicationName(string, DEPLOYMENTS, META_INF);
            if (string == null) continue;
            PolicySetAttachmentHelper psAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
            psAttachmentHelper.setLocale(CommonUtil.getLocale());
            boolean isAttached = psAttachmentHelper.isAttachedToPolicySet(policySetName);
            if (!isAttached) continue;
            if (appCount > 0) {
                appBuffer.append(",");
            }
            ++appCount;
            appBuffer.append(appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationsAttachedToPolicySet, appBuffer=" + appBuffer);
        }
        return appBuffer;
    }

    public static String getApplicationName(String path, String prefix, String suffix) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationName, path=" + path + ", prefix=" + prefix + ", suffix=" + suffix);
        }
        int index1 = path.lastIndexOf(File.separatorChar + prefix + File.separatorChar);
        int index2 = path.lastIndexOf(File.separatorChar + suffix + File.separatorChar);
        if (index1 < 0) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0017E", new Object[]{path, prefix}, "The pathname of {0} did not contain the string of {1}"));
        }
        if (index2 < 0) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0017E", new Object[]{path, suffix}, "The pathname of {0} did not contain the string of {1}"));
        }
        int startpos = index1 + prefix.length() + 2;
        String appName = path.substring(startpos, index2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationName, appName=" + appName + ", index1=" + index1 + ", index2=" + index2 + ", startpos=" + startpos);
        }
        return appName;
    }

    public static int transferAttachments(Session session, String sourcePolicysetName, String destPolicysetName, String applicationName, String policySetType, Properties attachmentProperties) throws WorkSpaceException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transferAttachments, sourcePolicysetName=" + sourcePolicysetName + ", destPolicysetName=" + destPolicysetName + ", applicationName=" + applicationName + ", policySetType=" + policySetType + ", attachmentProperties=" + attachmentProperties);
        }
        int rc = 0;
        if (policySetType.equals("system/trust") || policySetType.equals("system")) {
            CommonWorkSpaceHelper.validateAttachmentAuthorization("system/trust", null);
            String attachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
            if (attachmentFile != null) {
                PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                helper.setLocale(CommonUtil.getLocale());
                if (helper.isAttachedToPolicySet(sourcePolicysetName)) {
                    rc = helper.transferAttachments(sourcePolicysetName, destPolicysetName);
                    PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(session);
                }
            }
            if (policySetType.equals("system")) {
                PolicySetAttachmentCommandUtil.removePolicySetFromMexAttachments(session, sourcePolicysetName, destPolicysetName, applicationName);
            }
        } else if (policySetType.equals("application")) {
            String resourceName;
            List<Object> serviceAppFilenames = new ArrayList();
            List<Object> clientAppFilenames = new ArrayList();
            List<Object> wsnClientFilenames = new ArrayList();
            List<Object> cuServiceFilenames = new ArrayList();
            List<Object> cuClientFilenames = new ArrayList();
            if (applicationName != null) {
                Properties p = new Properties();
                p.setProperty("application", applicationName);
                serviceAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application", p);
                clientAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client", p);
                if (serviceAppFilenames.isEmpty() && clientAppFilenames.isEmpty()) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0031E", new Object[]{applicationName}, "Policy attachment file is not found: {0}"));
                }
            }
            if (attachmentProperties != null) {
                boolean validValues = false;
                String string = attachmentProperties.getProperty("bus");
                String string2 = attachmentProperties.getProperty("WSNService");
                String cuName = attachmentProperties.getProperty("cuName");
                String cuEdition = attachmentProperties.getProperty("cuEdition");
                String blaName = attachmentProperties.getProperty("blaName");
                String blaEdition = attachmentProperties.getProperty("blaEdition");
                if (string != null && string2 != null) {
                    validValues = true;
                    Properties p = new Properties();
                    p.setProperty("bus", string);
                    p.setProperty("WSNService", string2);
                    wsnClientFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "WSNClient", p);
                    if (wsnClientFilenames.isEmpty()) {
                        throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0108E", new Object[]{string, string2}, "The policy attachment file is not found for bus: {0} WSNService: {1}"));
                    }
                } else {
                    if (blaName == null) {
                        if (blaEdition != null) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0030E", new Object[]{"blaName", "blaEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                        }
                        if (cuName != null) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0030E", new Object[]{"blaName", "cuName"}, "The {0} input argument must also be specified with the {1} input argument."));
                        }
                    }
                    if (cuName == null) {
                        if (cuEdition != null) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0030E", new Object[]{"cuName", "cuEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                        }
                        if (blaName != null) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0030E", new Object[]{"cuName", "blaName"}, "The {0} input argument must also be specified with the {1} input argument."));
                        }
                    } else {
                        if (string != null) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0166E", new Object[]{"cuName", "bus"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                        }
                        boolean validBLAName = PolicySetAttachmentCommandUtil.validateBLAName(session, cuName, blaName);
                        if (!validBLAName) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0147E", new Object[]{"blaName"}, "The {0} property does not contain a valid value"));
                        }
                        validValues = true;
                        Properties p = new Properties();
                        p.setProperty("cuName", cuName);
                        if (cuEdition != null && !cuEdition.equals("")) {
                            p.setProperty("cuEdition", cuEdition);
                        }
                        cuServiceFilenames = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application", p);
                        cuClientFilenames = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client", p);
                        if (cuServiceFilenames.isEmpty() && cuClientFilenames.isEmpty()) {
                            throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0168E", new Object[]{cuName}, "The policy attachment file is not found for the {0} asset"));
                        }
                    }
                }
                if (!validValues) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0114E", new Object[]{"attachmentProperties"}, "The {0} parameter did not contain valid values."));
                }
            }
            if (applicationName == null && attachmentProperties == null) {
                serviceAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
                clientAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
                wsnClientFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "WSNClient");
                cuServiceFilenames = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
                cuClientFilenames = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
            }
            for (String string : serviceAppFilenames) {
                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                policySetAttachmentHelper.setLocale(CommonUtil.getLocale());
                if (!policySetAttachmentHelper.isAttachedToPolicySet(sourcePolicysetName)) continue;
                resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "application");
                CommonWorkSpaceHelper.validateAttachmentAuthorization("application", resourceName);
            }
            for (String string : clientAppFilenames) {
                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                policySetAttachmentHelper.setLocale(CommonUtil.getLocale());
                if (!policySetAttachmentHelper.isAttachedToPolicySet(sourcePolicysetName)) continue;
                resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "client");
                CommonWorkSpaceHelper.validateAttachmentAuthorization("client", resourceName);
            }
            for (String string : wsnClientFilenames) {
                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                policySetAttachmentHelper.setLocale(CommonUtil.getLocale());
                if (!policySetAttachmentHelper.isAttachedToPolicySet(sourcePolicysetName)) continue;
                resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "WSNClient");
                CommonWorkSpaceHelper.validateAttachmentAuthorization("WSNClient", resourceName);
            }
            for (String string : cuServiceFilenames) {
                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                policySetAttachmentHelper.setLocale(CommonUtil.getLocale());
                if (!policySetAttachmentHelper.isAttachedToPolicySet(sourcePolicysetName)) continue;
                resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "SOA");
                CommonWorkSpaceHelper.validateAttachmentAuthorization("SOA", resourceName);
            }
            for (String string : cuClientFilenames) {
                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                policySetAttachmentHelper.setLocale(CommonUtil.getLocale());
                if (!policySetAttachmentHelper.isAttachedToPolicySet(sourcePolicysetName)) continue;
                resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "SOA");
                CommonWorkSpaceHelper.validateAttachmentAuthorization("SOA", resourceName);
            }
            int temprc = 0;
            for (String string : serviceAppFilenames) {
                temprc = PolicySetAttachmentCommandUtil.transferApplicationPolicySet(session, string, "application", sourcePolicysetName, destPolicysetName);
                rc += temprc;
            }
            for (String string : clientAppFilenames) {
                temprc = PolicySetAttachmentCommandUtil.transferApplicationPolicySet(session, string, "client", sourcePolicysetName, destPolicysetName);
                rc += temprc;
            }
            for (String string : wsnClientFilenames) {
                temprc = PolicySetAttachmentCommandUtil.transferApplicationPolicySet(session, string, "WSNClient", sourcePolicysetName, destPolicysetName);
                rc += temprc;
            }
            for (String string : cuServiceFilenames) {
                temprc = PolicySetAttachmentCommandUtil.transferSOAPolicySet(session, string, "application", sourcePolicysetName, destPolicysetName);
                rc += temprc;
            }
            for (String string : cuClientFilenames) {
                temprc = PolicySetAttachmentCommandUtil.transferSOAPolicySet(session, string, "client", sourcePolicysetName, destPolicysetName);
                rc += temprc;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transferAttachments, rc=" + rc);
        }
        return rc;
    }

    private static int transferApplicationPolicySet(Session session, String attachmentFile, String attachmentType, String sourcePolicysetName, String destPolicysetName) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, IllegalArgumentException, WorkSpaceException, JAXBException, IOException, NoItemFoundException {
        String methodName = "transferApplicationPolicySet";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transferApplicationPolicySet", new Object[]{session, attachmentFile, attachmentType, sourcePolicysetName, destPolicysetName});
        }
        int rc = 0;
        PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
        helper.setLocale(CommonUtil.getLocale());
        if (helper.isAttachedToPolicySet(sourcePolicysetName)) {
            rc += helper.transferAttachments(sourcePolicysetName, destPolicysetName);
            if (attachmentType.equals("application") || attachmentType.equals("client")) {
                String dirName = null;
                if (attachmentFile.contains("policyAttachments.xml")) {
                    dirName = attachmentFile.substring(0, attachmentFile.indexOf("policyAttachments.xml") - 1);
                } else if (attachmentFile.contains("clientPolicyAttachments.xml")) {
                    dirName = attachmentFile.substring(0, attachmentFile.indexOf("clientPolicyAttachments.xml") - 1);
                }
                dirName = dirName.substring(0, dirName.lastIndexOf(File.separator));
                String appName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
                if (appName != null) {
                    if (attachmentFile.contains("policyAttachments.xml")) {
                        PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, appName);
                    } else if (attachmentFile.contains("clientPolicyAttachments.xml")) {
                        PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, appName);
                    }
                }
            }
            if (attachmentType.equals("WSNClient")) {
                String busName = null;
                String serviceName = null;
                Properties wsnBusService = PolicySetAttachmentCommandUtil.getWSNClientBusServiceName(attachmentFile);
                if (wsnBusService != null) {
                    busName = wsnBusService.getProperty("bus");
                    serviceName = wsnBusService.getProperty("WSNService");
                }
                PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(session, busName, serviceName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transferApplicationPolicySet, rc=" + rc);
        }
        return rc;
    }

    private static int transferSOAPolicySet(Session session, String attachmentFile, String attachmentType, String sourcePolicysetName, String destPolicysetName) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, IllegalArgumentException, WorkSpaceException, JAXBException, IOException, NoItemFoundException, OpExecutionException {
        String methodName = "transferSOAPolicySet";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transferSOAPolicySet", new Object[]{session, attachmentFile, attachmentType, sourcePolicysetName, destPolicysetName});
        }
        int rc = 0;
        PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
        helper.setLocale(CommonUtil.getLocale());
        if (helper.isAttachedToPolicySet(sourcePolicysetName)) {
            rc += helper.transferAttachments(sourcePolicysetName, destPolicysetName);
            String cuName = PolicySetAttachmentCommandUtil.getCUNameFromAttachmentPath(attachmentFile);
            if (cuName != null) {
                if (attachmentFile.contains("policyAttachments.xml")) {
                    PolicySetSOAAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, cuName);
                } else if (attachmentFile.contains("clientPolicyAttachments.xml")) {
                    PolicySetSOAAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, cuName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transferSOAPolicySet, rc=" + rc);
        }
        return rc;
    }

    public static StringBuffer validateTrustResources(Session session, String[] resources) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTrustResources, resources=" + resources);
        }
        String resource = "";
        String type = null;
        StringBuffer resourcesNotValid = new StringBuffer();
        for (int x = 0; x < resources.length; ++x) {
            resource = resources[x];
            PolicySetAttachmentCommandUtil.checkResourceIsPopulated(resource);
            PolicyResource policyResource = new PolicyResource(resource);
            type = policyResource.getType();
            boolean resourceInvalid = false;
            if (!PolicySetAttachmentCommandUtil.isSupportedOperation(type)) {
                resourceInvalid = true;
            } else {
                int urlBegin = resource.indexOf(":/") + 2;
                int urlEnd = resource.length();
                if (urlBegin <= 0) {
                    resourceInvalid = true;
                } else {
                    String urlStr = resource.substring(urlBegin, urlEnd);
                    if (urlStr.length() != 0) {
                        try {
                            new URL(urlStr);
                        }
                        catch (MalformedURLException e) {
                            resourceInvalid = true;
                        }
                    }
                }
            }
            if (!resourceInvalid) continue;
            if (resourcesNotValid.length() > 0) {
                resourcesNotValid.append(", ");
            }
            resourcesNotValid.append(resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTrustResources, resourcesNotValid=" + resourcesNotValid);
        }
        return resourcesNotValid;
    }

    private static boolean isSupportedOperation(String operation) {
        for (int i = 0; i < PolicyConstants.supportedTrustOperations.length; ++i) {
            if (!PolicyConstants.supportedTrustOperations[i].equals(operation)) continue;
            return true;
        }
        return false;
    }

    public static StringBuffer validateResourcesForApplication(Session session, String applicationName, String[] resources, String attachmentType, String policySet, Properties attachmentProperties) throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateResourcesForApplication, applicationName=" + applicationName + ", resources=" + resources + ", attachmentType=" + attachmentType + ", policySet=" + policySet + ", attachmentProperties=" + attachmentProperties);
        }
        String resource = "";
        String moduleName = null;
        StringBuffer resourcesNotFound = new StringBuffer();
        String service = null;
        String endpoint = null;
        String operation = null;
        String cuName = null;
        String cuEdition = null;
        List indexPropertyList = new ArrayList();
        if (resources.length == 0) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0015E", new Object[0], "A resource was specified as empty or null"));
        }
        if (attachmentProperties != null) {
            cuName = attachmentProperties.getProperty("cuName");
            cuEdition = attachmentProperties.getProperty("cuEdition");
        }
        Properties props = new Properties();
        if (cuName != null && !cuName.equals("")) {
            props.put("cuName", cuName);
            indexPropertyList = ServiceIndexMgrUtils.getServiceIndexManager(props).listServiceIndexFiles(session, props);
        } else if (attachmentType.equals("application") || attachmentType.equals("client")) {
            props.put("application", applicationName);
            indexPropertyList = ServiceIndexHelperFactory.createWorkSpaceHelper("application").listServiceIndexFiles(session, props);
        } else if (attachmentType.equals("WSNClient")) {
            props.put("bus", attachmentProperties.get("bus"));
            props.put("WSNService", attachmentProperties.get("WSNService"));
            indexPropertyList = ServiceIndexHelperFactory.createWorkSpaceHelper("WSNService").listServiceIndexFiles(session, props);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "indexPropertyList size = " + indexPropertyList.size());
        }
        for (int x = 0; x < resources.length; ++x) {
            resource = resources[x];
            PolicySetAttachmentCommandUtil.checkResourceIsPopulated(resource);
            PolicyResource policyResource = new PolicyResource(resource);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "policyResource: " + policyResource);
            }
            moduleName = policyResource.getModuleName();
            service = policyResource.getServiceName();
            endpoint = policyResource.getEndpointName();
            operation = policyResource.getOperationName();
            String fileName = null;
            boolean resourceFound = false;
            boolean resourceFormatValid = true;
            if (resource.equals("WebService:/") || resource.equals("/")) {
                resourceFound = true;
            }
            if (!resource.startsWith("WebService:/")) {
                resourceFormatValid = false;
            }
            if (!resourceFound && resourceFormatValid) {
                if (policySet != null && (endpoint != null || operation != null)) {
                    String policySetFile = PolicySetWorkSpaceHelper.getPolicySetFile(session, policySet, false);
                    PolicySetHelper helper = PolicySetHelperFactory.createHelper(policySetFile);
                    List<String> policyTypes = helper.listEnabledPolicyTypes();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "policyTypes: " + policyTypes);
                    }
                    if (policyTypes != null && policyTypes.contains("WSReliableMessaging")) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0116E", new Object[0], "A policy set that contains WSReliableMessaging can not be attached to an endpoint or operation."));
                    }
                }
                if (attachmentType.equals("WSNClient") && (endpoint != null || operation != null)) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0117E", new Object[0], "WSNClient attachments are not valid at endpoint or operation layer."));
                }
            }
            if (!resourceFound && resourceFormatValid) {
                if (attachmentType.equals("WSNClient") && moduleName != null) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0115E", new Object[0], "The resource can not contain a module name if attachment type is WSNClient."));
                }
                if (cuName != null && !cuName.equals("") && moduleName != null) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0170E", new Object[]{"cuName"}, "The resource cannot contain a module name if the {0} parameter is specified."));
                }
            }
            Iterator indexPropertyListIt = indexPropertyList.iterator();
            while (indexPropertyListIt.hasNext() && !resourceFound && resourceFormatValid) {
                Properties iprop = new Properties();
                iprop = (Properties)indexPropertyListIt.next();
                boolean continueLooking = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "index properties are: " + iprop);
                }
                String modName = null;
                if (cuName != null && !cuName.equals("")) {
                    continueLooking = true;
                } else if (attachmentType.equals("application") || attachmentType.equals("client")) {
                    modName = iprop.getProperty("module");
                    if (attachmentType.equals("application")) {
                        if (moduleName != null && moduleName.equals(modName)) {
                            continueLooking = true;
                        }
                    } else if (attachmentType.equals("client")) {
                        if (moduleName == null) {
                            continueLooking = true;
                        } else if (moduleName.equals(modName)) {
                            continueLooking = true;
                        }
                    }
                } else if (attachmentType.equals("WSNClient")) {
                    continueLooking = true;
                }
                if (!continueLooking) continue;
                fileName = iprop.getProperty("file");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "indexProperty fileName: " + fileName);
                }
                ServiceIndexHelper siHelper = null;
                if (cuName != null && !cuName.equals("")) {
                    if (fileName == null) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0167E", new Object[]{cuName}, "The servicesIndex.xml file could not be located for the {0} asset"));
                    }
                    FileInputStream istream = new FileInputStream(fileName);
                    props = new Properties();
                    props.put("cuName", cuName);
                    siHelper = ServiceIndexHelperFactory.createHelper(props, istream);
                } else if (attachmentType.equals("application") || attachmentType.equals("client")) {
                    String appName = iprop.getProperty("application");
                    if (fileName == null) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0014E", new Object[]{appName + " / " + modName}, "The serviceIndex file could not be located for the application / module of: {0}"));
                    }
                    FileInputStream istream = new FileInputStream(fileName);
                    props = new Properties();
                    props.put("application", appName);
                    props.put("module", modName);
                    siHelper = ServiceIndexHelperFactory.createHelper(props, istream);
                } else if (attachmentType.equals("WSNClient")) {
                    String bus = iprop.getProperty("bus");
                    String wsnService = iprop.getProperty("WSNService");
                    if (fileName == null) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0109E", new Object[]{bus, wsnService}, "The serviceIndex file could not be located for bus: {0} WSNService: {1}."));
                    }
                    FileInputStream istream = new FileInputStream(fileName);
                    props = new Properties();
                    props.put("bus", bus);
                    props.put("WSNService", wsnService);
                    siHelper = ServiceIndexHelperFactory.createHelper(props, istream);
                }
                if (attachmentType.equals("application")) {
                    resourceFound = siHelper.contains(service, endpoint, operation, false);
                    continue;
                }
                if (!attachmentType.equals("client") && !attachmentType.equals("WSNClient")) continue;
                resourceFound = siHelper.contains(service, endpoint, operation, true);
            }
            if (resourceFound && resourceFormatValid) continue;
            if (resourcesNotFound.length() > 0) {
                resourcesNotFound.append(",");
            }
            resourcesNotFound.append(resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateResourcesForApplication, resourceNotFound=" + resourcesNotFound);
        }
        return resourcesNotFound;
    }

    private static void checkResourceIsPopulated(String resource) throws CommandValidationException {
        if (resource.equals("") || resource == null) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0015E", new Object[0], "A resource was specified as empty or null"));
        }
    }

    public static StringBuffer validateResourcesNotAttached(String attachmentType, String attachmentFile, String[] resources, String id, boolean matchToID) throws WorkSpaceException, NoItemFoundException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, JAXBException, CommandValidationException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateResourcesNotAttached, attachmentType=" + attachmentType + ", attachmentFile=" + attachmentFile + ", resources=" + resources + ", id=" + id + ", matchToID=" + matchToID);
        }
        StringBuffer resourcesAttached = new StringBuffer();
        String resource = "";
        String originalResource = "";
        List<Object> attachmentPropertyList = new ArrayList();
        if (attachmentFile != null) {
            ResourceEvaluator resourceEvaluator = null;
            if (attachmentType != null && attachmentType.equals("system/trust")) {
                Class<?> trustResourceEvaluator = Class.forName("com.ibm.ws.wssecurity.trust.server.sts.Util.STSResourceEvaluator");
                Constructor<?> constructor = trustResourceEvaluator.getConstructor(new Class[0]);
                resourceEvaluator = (ResourceEvaluator)constructor.newInstance(new Object[0]);
            } else {
                resourceEvaluator = new DefaultResourceEvaluator();
            }
            PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
            psHelper.setLocale(CommonUtil.getLocale());
            attachmentPropertyList = psHelper.getPolicySetAttachments();
            if (attachmentPropertyList != null) {
                for (int x = 0; x < resources.length; ++x) {
                    boolean attached = false;
                    originalResource = resource = resources[x];
                    if (!resource.endsWith("/")) {
                        resource = resource + "/";
                    }
                    PolicySetAttachmentCommandUtil.checkResourceIsPopulated(resource);
                    Iterator<Object> attachmentPropertyListIt = attachmentPropertyList.iterator();
                    while (attachmentPropertyListIt.hasNext() && !attached) {
                        Properties aprop = new Properties();
                        aprop = (Properties)attachmentPropertyListIt.next();
                        Enumeration<?> propkeys = aprop.propertyNames();
                        String resourcevalue = "";
                        String idvalue = "";
                        idvalue = aprop.getProperty("id");
                        while (propkeys.hasMoreElements() && !attached) {
                            String currkey = (String)propkeys.nextElement();
                            if (!currkey.startsWith("pattern")) continue;
                            resourcevalue = aprop.getProperty(currkey);
                            if (resourcevalue != null && !resourcevalue.endsWith("/")) {
                                resourcevalue = resourcevalue + "/";
                            }
                            if (id == null && resourceEvaluator.getMatchDistance(resourcevalue, resource) == 0) {
                                attached = true;
                            }
                            if (id != null && !matchToID && !id.equals(idvalue) && resourceEvaluator.getMatchDistance(resourcevalue, resource) == 0) {
                                attached = true;
                            }
                            if (id == null || !matchToID || !id.equals(idvalue) || resourceEvaluator.getMatchDistance(resourcevalue, resource) != 0) continue;
                            attached = true;
                        }
                    }
                    if (!attached) continue;
                    if (resourcesAttached.length() > 0) {
                        resourcesAttached.append(",");
                    }
                    resourcesAttached.append(originalResource);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateResourcesNotAttached, resourcesAttached=" + resourcesAttached);
        }
        return resourcesAttached;
    }

    public static List<Properties> getExpandedResources(Session session, String applicationName, String expandResources, List<Properties> attachmentList, String attachmentType, Properties attachmentProperties) throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpandedResources, applicationName=" + applicationName + ", expandResources=" + expandResources + ", attachmentList=" + attachmentList + ", attachmentType=" + attachmentType + ", attachmentProperties=" + attachmentProperties);
        }
        ArrayList<Properties> resourceList = new ArrayList<Properties>();
        String moduleName = null;
        String fileName = null;
        boolean webServiceFound = false;
        boolean higherLevelAttachment = false;
        Properties applicationProperties = null;
        Properties serviceProperties = null;
        Properties inheritedProperties = null;
        String resourceName = applicationName;
        String cuName = null;
        String blaName = null;
        if (attachmentProperties != null) {
            cuName = attachmentProperties.getProperty("cuName");
            blaName = attachmentProperties.getProperty("blaName");
        }
        List indexPropertyList = new ArrayList();
        Properties props = new Properties();
        if (cuName != null && !cuName.equals("")) {
            props.put("cuName", cuName);
            indexPropertyList = ServiceIndexMgrUtils.getServiceIndexManager(props).listServiceIndexFiles(session, props);
        } else if (attachmentType.equals("application") || attachmentType.equals("client")) {
            props.put("application", applicationName);
            indexPropertyList = ServiceIndexHelperFactory.createWorkSpaceHelper("application").listServiceIndexFiles(session, props);
        } else if (attachmentType.equals("WSNClient")) {
            props.put("bus", attachmentProperties.getProperty("bus"));
            props.put("WSNService", attachmentProperties.getProperty("WSNService"));
            indexPropertyList = ServiceIndexHelperFactory.createWorkSpaceHelper("WSNService").listServiceIndexFiles(session, props);
        }
        if (indexPropertyList != null && !indexPropertyList.isEmpty()) {
            if (attachmentList != null) {
                Properties resourceProp = new Properties();
                if (cuName != null && !cuName.equals("")) {
                    resourceProp.setProperty("resource", cuName);
                    if (blaName != null && !blaName.equals("")) {
                        resourceProp.setProperty("blaName", blaName);
                    }
                } else if (attachmentType.equals("application") || attachmentType.equals("client")) {
                    resourceProp.setProperty("resource", applicationName);
                } else if (attachmentType.equals("WSNClient")) {
                    resourceProp.setProperty("resource", attachmentProperties.getProperty("WSNService"));
                }
                if (!(applicationProperties = PolicySetAttachmentCommandUtil.getPropertiesIfAttached(session, applicationName, attachmentList, "WebService:/", attachmentType, cuName)).isEmpty()) {
                    higherLevelAttachment = true;
                    inheritedProperties = applicationProperties;
                    resourceProp.putAll((Map<?, ?>)inheritedProperties);
                    resourceProp.setProperty("directAttachment", "true");
                }
                if (expandResources.equals("*")) {
                    resourceList.add(resourceProp);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "indexPropertyList is either null or empty, nothing to do");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getExpandedResources, resourceList=" + resourceList);
            }
            return resourceList;
        }
        Iterator indexPropertyListIt = indexPropertyList.iterator();
        while (indexPropertyListIt.hasNext()) {
            FileInputStream istream;
            Properties iprop = new Properties();
            iprop = (Properties)indexPropertyListIt.next();
            fileName = iprop.getProperty("file");
            ServiceIndexHelper siHelper = null;
            if (cuName != null && !cuName.equals("")) {
                if (fileName == null) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0167E", new Object[]{cuName}, "The serviceIndex file could not be located for the asset of: {0}"));
                }
                istream = new FileInputStream(fileName);
                props = new Properties();
                props.put("cuName", cuName);
                siHelper = ServiceIndexHelperFactory.createHelper(props, istream);
            } else if (attachmentType.equals("application") || attachmentType.equals("client")) {
                moduleName = iprop.getProperty("module");
                if (fileName == null) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0014E", new Object[]{applicationName + " / " + moduleName}, "The serviceIndex file could not be located for the application / module of: {0}"));
                }
                istream = new FileInputStream(fileName);
                props = new Properties();
                props.put("application", applicationName);
                props.put("module", moduleName);
                siHelper = ServiceIndexHelperFactory.createHelper(props, istream);
            } else if (attachmentType.equals("WSNClient")) {
                String bus = iprop.getProperty("bus");
                String wsnService = iprop.getProperty("WSNService");
                if (fileName == null) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0109E", new Object[]{bus, wsnService}, "The serviceIndex file could not be located for bus: {0} WSNService: {1}."));
                }
                FileInputStream istream2 = new FileInputStream(fileName);
                props = new Properties();
                props.put("bus", bus);
                props.put("WSNService", wsnService);
                siHelper = ServiceIndexHelperFactory.createHelper(props, istream2);
            }
            if (siHelper == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "siHelper is null, skipping this service");
                continue;
            }
            if (!expandResources.equals("*") && !(webServiceFound = attachmentType.equals("application") ? siHelper.contains(expandResources, null, null, false) : siHelper.contains(expandResources, null, null, true))) continue;
            List wsObjects = null;
            wsObjects = attachmentType.equals("application") ? siHelper.listWebServiceObjects(false) : siHelper.listWebServiceObjects(true);
            for (int i = 0; i < wsObjects.size(); ++i) {
                String serviceName;
                WebService webService = (WebService)wsObjects.get(i);
                if (!expandResources.equals("*") && !expandResources.equals(webService.getServiceName())) continue;
                StringBuffer buf = new StringBuffer();
                buf.append("WebService:/");
                if (moduleName != null) {
                    buf.append(moduleName).append(":");
                }
                buf.append(webService.getServiceName());
                resourceName = serviceName = buf.toString();
                Properties resourceProp = new Properties();
                resourceProp.setProperty("resource", resourceName);
                inheritedProperties = applicationProperties;
                Properties propsForAttachment = PolicySetAttachmentCommandUtil.getPropertiesIfAttached(session, applicationName, attachmentList, resourceName, attachmentType, cuName);
                if (!propsForAttachment.isEmpty()) {
                    higherLevelAttachment = true;
                    inheritedProperties = propsForAttachment;
                    resourceProp.putAll((Map<?, ?>)inheritedProperties);
                    resourceProp.setProperty("directAttachment", "true");
                } else if (higherLevelAttachment) {
                    resourceProp.putAll((Map<?, ?>)inheritedProperties);
                    resourceProp.setProperty("directAttachment", "false");
                }
                serviceProperties = inheritedProperties;
                resourceList.add(resourceProp);
                List endpointObjects = webService.listEndpoints();
                for (int j = 0; j < endpointObjects.size(); ++j) {
                    Endpoint endpoint = (Endpoint)endpointObjects.get(j);
                    String endptName = endpoint.getName();
                    StringBuffer buf1 = new StringBuffer();
                    buf1.append(serviceName).append("/").append(endptName);
                    resourceName = buf1.toString();
                    resourceProp = new Properties();
                    resourceProp.setProperty("resource", resourceName);
                    inheritedProperties = serviceProperties;
                    propsForAttachment = PolicySetAttachmentCommandUtil.getPropertiesIfAttached(session, applicationName, attachmentList, resourceName, attachmentType, cuName);
                    if (!propsForAttachment.isEmpty()) {
                        higherLevelAttachment = true;
                        inheritedProperties = propsForAttachment;
                        resourceProp.putAll((Map<?, ?>)inheritedProperties);
                        resourceProp.setProperty("directAttachment", "true");
                    } else if (higherLevelAttachment) {
                        resourceProp.putAll((Map<?, ?>)inheritedProperties);
                        resourceProp.setProperty("directAttachment", "false");
                    }
                    resourceList.add(resourceProp);
                    List operations = endpoint.listOperations();
                    for (int k = 0; k < operations.size(); ++k) {
                        String operation = (String)operations.get(k);
                        StringBuffer buf2 = new StringBuffer();
                        buf2.append(serviceName).append("/").append(endptName).append("/").append(operation);
                        resourceName = buf2.toString();
                        resourceProp = new Properties();
                        resourceProp.setProperty("resource", resourceName);
                        propsForAttachment = PolicySetAttachmentCommandUtil.getPropertiesIfAttached(session, applicationName, attachmentList, resourceName, attachmentType, cuName);
                        if (!propsForAttachment.isEmpty()) {
                            resourceProp.putAll((Map<?, ?>)propsForAttachment);
                            resourceProp.setProperty("directAttachment", "true");
                        } else if (higherLevelAttachment) {
                            resourceProp.putAll((Map<?, ?>)inheritedProperties);
                            resourceProp.setProperty("directAttachment", "false");
                        }
                        resourceList.add(resourceProp);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpandedResources, resourceList=" + resourceList);
        }
        return resourceList;
    }

    public static List<Properties> getExpandedResourcesForTrust(String expandResources, List attachmentList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpandedResourcesForTrust, expandResources=" + expandResources + ", attachmentList=" + attachmentList);
        }
        if (attachmentList == null || attachmentList.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getExpandedResourceForTrust, attachmentList is null");
            }
            return new ArrayList<Properties>(0);
        }
        ArrayList<Properties> resourceList = new ArrayList<Properties>();
        for (Properties aprop : attachmentList) {
            String policySet = aprop.getProperty("name");
            String idValue = aprop.getProperty("id");
            String bindingValue = aprop.getProperty("binding");
            String bindingScope = aprop.getProperty("bindingScope");
            Properties oneResourceProps = null;
            Enumeration<?> propkeys = aprop.propertyNames();
            while (propkeys.hasMoreElements()) {
                String currkey = (String)propkeys.nextElement();
                if (!currkey.startsWith("pattern")) continue;
                oneResourceProps = new Properties();
                oneResourceProps.setProperty("resource", aprop.getProperty(currkey));
                oneResourceProps.setProperty("policySet", policySet);
                oneResourceProps.setProperty("attachmentId", idValue);
                if (bindingValue != null) {
                    oneResourceProps.setProperty("binding", bindingValue);
                }
                if (bindingScope != null) {
                    oneResourceProps.setProperty("bindingScope", bindingScope);
                }
                PolicySetAttachmentCommandUtil.addURLResourceToList(resourceList, oneResourceProps);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpandedResourcesForTrust, resourceList=" + resourceList);
        }
        return resourceList;
    }

    private static void addURLResourceToList(List<Properties> resourceList, Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addURLResourceToList, resourceList=" + resourceList + ", props=" + props);
        }
        String resource = props.getProperty("resource");
        String url = PolicySetAttachmentCommandUtil.getURLFromResource(resource);
        String trustOp = PolicySetAttachmentCommandUtil.getTrustOpFromResource(resource);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addURLResourceToList, url=" + url + ", trustOp=" + trustOp);
        }
        Properties otherProps = null;
        String otherResource = null;
        String otherUrl = null;
        int i = 0;
        for (i = 0; i < resourceList.size(); ++i) {
            otherProps = resourceList.get(i);
            otherResource = otherProps.getProperty("resource");
            otherUrl = PolicySetAttachmentCommandUtil.getURLFromResource(otherResource);
            if (url == null || url.equals(otherUrl)) {
                if (trustOp != null && trustOp.compareTo(PolicySetAttachmentCommandUtil.getTrustOpFromResource(otherResource)) >= 0) continue;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "addURLResourceToList, trustOp=" + trustOp + ", otherTrustOp=" + PolicySetAttachmentCommandUtil.getTrustOpFromResource(otherResource));
                break;
            }
            if (url.compareTo(otherUrl) >= 0) continue;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "addURLResourceToList, url=" + url + ", otherUrl=" + otherUrl);
            break;
        }
        resourceList.add(i, props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addURLResourceToList");
        }
    }

    private static String getURLFromResource(String resource) {
        int index = resource.indexOf(":/");
        if (index > 0) {
            return resource.substring(index + 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getURLFromResource, the resource pattern is not valid.");
        }
        return null;
    }

    private static String getTrustOpFromResource(String resource) {
        int index = resource.indexOf(":/");
        if (index > 0) {
            return resource.substring(0, index);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getURLFromResource, the resource pattern is not valid.");
        }
        return null;
    }

    private static Properties getPropertiesIfAttached(Session session, String applicationName, List<Properties> attachmentList, String resource, String attachmentType, String cuName) throws Exception {
        String controlFile;
        String methodName = "getPropertiesIfAttached";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesIfAttached", new Object[]{session, applicationName, attachmentList, resource, attachmentType});
        }
        Properties attachmentProperties = new Properties();
        boolean attached = false;
        String originalResource = resource;
        String resourceWithoutModule = null;
        if (attachmentList != null) {
            boolean keepSearching = true;
            boolean resourceContainsModule = false;
            if (resource != null && !resource.endsWith("/")) {
                resource = resource + "/";
            }
            if (attachmentType.equals("client") && !resource.equals(resourceWithoutModule = PolicySetAttachmentCommandUtil.removeModuleName(resource))) {
                resourceContainsModule = true;
            }
            while (keepSearching) {
                Iterator<Properties> attachmentListIt = attachmentList.iterator();
                while (attachmentListIt.hasNext() && !attached) {
                    Properties aprop = new Properties();
                    aprop = attachmentListIt.next();
                    Enumeration<?> propkeys = aprop.propertyNames();
                    while (propkeys.hasMoreElements() && !attached) {
                        String idValue;
                        String currkey = (String)propkeys.nextElement();
                        if (!currkey.startsWith("pattern")) continue;
                        String resourceValue = aprop.getProperty(currkey);
                        if (resourceValue != null && !resourceValue.endsWith("/")) {
                            resourceValue = resourceValue + "/";
                        }
                        if (!resourceValue.equals(resource)) continue;
                        attachmentProperties.putAll((Map<?, ?>)aprop);
                        attached = true;
                        String policySet = (String)attachmentProperties.remove("name");
                        if (policySet != null) {
                            attachmentProperties.setProperty("policySet", policySet);
                        }
                        if ((idValue = (String)attachmentProperties.remove("id")) != null) {
                            attachmentProperties.setProperty("attachmentId", idValue);
                        }
                        if (cuName == null) {
                            PolicyResource policyResource;
                            String policySetAttachmentFile;
                            boolean enabled;
                            String controlFile2;
                            if (attachmentType.equals("application")) {
                                controlFile2 = PolicyControlWorkSpaceHelper.getWSPolicyServiceControlFile(session, applicationName);
                                enabled = false;
                                if (controlFile2 != null) {
                                    policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, applicationName);
                                    WSPolicyServiceControlHelper serviceHelper = WSPolicyServiceControlHelperFactory.createHelper(controlFile2, policySetAttachmentFile);
                                    policyResource = new PolicyResource(resource);
                                    if (policyResource.getServiceName() != null && policyResource.getEndpointName() == null) {
                                        if (serviceHelper.getWSPolicyServiceControlReference(resource) != null) {
                                            attachmentProperties.setProperty("policyShared", "enabled");
                                            enabled = true;
                                        }
                                    } else if (serviceHelper.isPolicySharingEnabled(resource)) {
                                        attachmentProperties.setProperty("policyShared", "enabled");
                                        enabled = true;
                                    }
                                }
                                if (!enabled) {
                                    attachmentProperties.setProperty("policyShared", "disabled");
                                }
                            } else if (attachmentType.equals("client")) {
                                controlFile2 = PolicyControlWorkSpaceHelper.getWSPolicyClientControlFile(session, applicationName);
                                enabled = false;
                                if (controlFile2 != null) {
                                    policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, applicationName);
                                    WSPolicyClientControlHelper clientHelper = WSPolicyClientControlHelperFactory.createHelper(controlFile2, policySetAttachmentFile);
                                    enabled = clientHelper.isProviderPolicyEnabled(resource);
                                    if (!enabled && resourceContainsModule) {
                                        enabled = clientHelper.isProviderPolicyEnabled(resourceWithoutModule);
                                    }
                                    if (enabled) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "jvm - is enabled, resource = " + resource);
                                        }
                                        if ((policyResource = new PolicyResource(resource)).getServiceName() != null && policyResource.getEndpointName() == null) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "jvm - is service level");
                                            }
                                            if (clientHelper.getWSPolicyClientControlReference(resource) != null) {
                                                if (policySet != null && !policySet.equals("")) {
                                                    attachmentProperties.setProperty("policyApplied", "clientAndProvider");
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "jvm - service level provider attachment; set to client and provider");
                                                    }
                                                } else {
                                                    attachmentProperties.setProperty("policyApplied", "providerOnly");
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "jvm - service level provider attachment and no client attachment; set to provider");
                                                    }
                                                }
                                            } else {
                                                attachmentProperties.setProperty("policyApplied", "client");
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "jvm - attachment level provider attachment, but no service level provider attachment; set to client");
                                                }
                                            }
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "jvm - not service level");
                                            }
                                            if (policySet != null && !policySet.equals("")) {
                                                attachmentProperties.setProperty("policyApplied", "clientAndProvider");
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "jvm - client attachment; set to client and provider");
                                                }
                                            } else {
                                                attachmentProperties.setProperty("policyApplied", "providerOnly");
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "jvm - no client attachment; set to provider");
                                                }
                                            }
                                        }
                                    }
                                }
                                if (!enabled) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "jvm - not enabled, resource = " + resource);
                                    }
                                    if (policySet != null && !policySet.equals("")) {
                                        attachmentProperties.setProperty("policyApplied", "client");
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "jvm - client policy set is attached");
                                        }
                                    } else {
                                        attachmentProperties.setProperty("policyApplied", "none");
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "jvm - no client policy set attached");
                                        }
                                    }
                                }
                            }
                        }
                        attachmentProperties.remove(currkey);
                    }
                }
                if (attachmentType.equals("client")) {
                    if (!attached && resourceContainsModule) {
                        resourceContainsModule = false;
                        resource = resourceWithoutModule;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "didn't find matching attachment; now checking without moduleName for resource = " + resource);
                        continue;
                    }
                    keepSearching = false;
                    continue;
                }
                keepSearching = false;
            }
        }
        if (!attached && cuName == null && attachmentType.equals("client") && (controlFile = PolicyControlWorkSpaceHelper.getWSPolicyClientControlFile(session, applicationName)) != null) {
            String policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, applicationName);
            WSPolicyClientControlHelper clientHelper = WSPolicyClientControlHelperFactory.createHelper(controlFile, policySetAttachmentFile);
            boolean providerEnabled = false;
            if (clientHelper.getWSPolicyClientControlReference(resource) != null) {
                providerEnabled = true;
            } else if (clientHelper.getWSPolicyClientControlReference(originalResource) != null) {
                providerEnabled = true;
            }
            if (providerEnabled) {
                attachmentProperties.setProperty("policyApplied", "providerOnly");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesIfAttached", "attachmentProperties=" + attachmentProperties);
        }
        return attachmentProperties;
    }

    private static String removeModuleName(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeModuleName", resourceName);
        }
        String updatedResource = resourceName;
        PolicyResource policyResource = new PolicyResource(resourceName);
        String moduleName = policyResource.getModuleName();
        if (moduleName != null) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(resourceName.substring(0, resourceName.indexOf(moduleName)));
            strBuf.append(resourceName.substring(resourceName.indexOf(moduleName) + moduleName.length() + 1));
            updatedResource = strBuf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource contains module name");
                Tr.debug(tc, "Resource without moduleName is: " + updatedResource);
            }
        }
        return updatedResource;
    }

    public static Properties getWSNClientBusServiceName(String attachmentFile) {
        String methodName = "getWSNClientBusServiceName";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientBusServiceName", attachmentFile);
        }
        Properties busServiceName = new Properties();
        String busName = null;
        String serviceName = null;
        if ((attachmentFile = attachmentFile.substring(attachmentFile.indexOf("buses") + "buses".length() + 1, attachmentFile.indexOf(META_INF) - 1)) != null) {
            busName = attachmentFile.substring(0, attachmentFile.indexOf("/"));
            serviceName = attachmentFile.substring(attachmentFile.lastIndexOf("/") + 1, attachmentFile.length());
            if (busName != null && serviceName != null) {
                busServiceName.setProperty("bus", busName);
                busServiceName.setProperty("WSNService", serviceName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientBusServiceName", busServiceName);
        }
        return busServiceName;
    }

    public static String getResourceFromAttachmentFile(String attachmentFile, String attachmentType) {
        String methodName = "getResourceFromAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceFromAttachmentFile", new Object[]{attachmentFile, attachmentType});
        }
        String resourceName = null;
        if (attachmentType.equals("application") || attachmentType.equals("client")) {
            int appStart = attachmentFile.indexOf(DEPLOYMENTS) + DEPLOYMENTS.length() + 1;
            int appEnd = attachmentFile.indexOf(META_INF) - 1;
            resourceName = attachmentFile.substring(appStart, appEnd);
        } else if (attachmentType.equals("WSNClient")) {
            int busStart = attachmentFile.indexOf("buses") + "buses".length() + 1;
            int busEnd = attachmentFile.indexOf("/", busStart);
            resourceName = attachmentFile.substring(busStart, busEnd);
        } else if (attachmentType.equals("SOA")) {
            resourceName = PolicySetAttachmentCommandUtil.getCUNameFromAttachmentPath(attachmentFile);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceFromAttachmentFile", resourceName);
        }
        return resourceName;
    }

    public static List<Properties> getWSNAttachmentsToPolicySet(Session session, String policySetName) throws WorkSpaceException, NoItemFoundException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, IllegalArgumentException, JAXBException, CommandValidationException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNAttachmentsToPolicySet, policySetName=" + policySetName);
        }
        ArrayList<Properties> wsnClientAttached = new ArrayList<Properties>();
        List<Object> wsnClientList = new ArrayList();
        wsnClientList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "WSNClient");
        if (wsnClientList != null && !wsnClientList.isEmpty()) {
            for (String string : wsnClientList) {
                Properties wsnClient;
                PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(string);
                helper.setLocale(CommonUtil.getLocale());
                if (!helper.isAttachedToPolicySet(policySetName) || (wsnClient = PolicySetAttachmentCommandUtil.getWSNClientBusServiceName(string)) == null || wsnClientAttached.contains(wsnClient)) continue;
                wsnClientAttached.add(wsnClient);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSNAttachmentsToPolicySet, wsnClientAttached=" + wsnClientAttached);
        }
        return wsnClientAttached;
    }

    public static List<String> getApplicationsWithMexAttachmentsToPolicySet(Session session, String policySetName) throws Exception {
        String methodName = "getApplicationsWithMexAttachmentsToPolicySet";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationsWithMexAttachmentsToPolicySet", new Object[]{policySetName});
        }
        ArrayList<String> wsMexAttached = new ArrayList<String>();
        List<String> wsMexList = PolicyControlWorkSpaceHelper.listWSPolicyControlFiles(session, PolicyConstants.SERVICE_CONTROL);
        List<String> wsMexClientList = PolicyControlWorkSpaceHelper.listWSPolicyControlFiles(session, PolicyConstants.CLIENT_CONTROL);
        wsMexList.addAll(wsMexClientList);
        if (wsMexList != null && !wsMexList.isEmpty()) {
            for (String wsMexControlFile : wsMexList) {
                String mexPolicySet;
                List<Properties> propertiesList;
                Object helper;
                String policySetAttachmentFile;
                String dirName;
                String appName = null;
                if (wsMexControlFile.contains("wsPolicyServiceControl.xml")) {
                    dirName = wsMexControlFile.substring(0, wsMexControlFile.indexOf("wsPolicyServiceControl.xml") - 1);
                    if (dirName == null || (appName = (dirName = dirName.substring(0, dirName.lastIndexOf(File.separator))).substring(dirName.lastIndexOf(File.separator) + 1)) == null) continue;
                    policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
                    helper = WSPolicyServiceControlHelperFactory.createHelper(wsMexControlFile, policySetAttachmentFile);
                    PolicyControlCommandUtil.setLocale(CommonUtil.getLocale());
                    propertiesList = helper.getWSPolicyServiceControlReferencesProperties();
                    for (Properties controlProps : propertiesList) {
                        mexPolicySet = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                        if (!policySetName.equals(mexPolicySet)) continue;
                        wsMexAttached.add(appName);
                    }
                    continue;
                }
                if (!wsMexControlFile.contains("wsPolicyClientControl.xml") || (dirName = wsMexControlFile.substring(0, wsMexControlFile.indexOf("wsPolicyClientControl.xml") - 1)) == null || (appName = (dirName = dirName.substring(0, dirName.lastIndexOf(File.separator))).substring(dirName.lastIndexOf(File.separator) + 1)) == null) continue;
                policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName);
                helper = WSPolicyClientControlHelperFactory.createHelper(wsMexControlFile, policySetAttachmentFile);
                PolicyControlCommandUtil.setLocale(CommonUtil.getLocale());
                propertiesList = helper.getWSPolicyClientControlReferencesProperties();
                for (Properties controlProps : propertiesList) {
                    mexPolicySet = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                    if (!policySetName.equals(mexPolicySet) || wsMexAttached.contains(appName)) continue;
                    wsMexAttached.add(appName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationsWithMexAttachmentsToPolicySet, wsMexAttached=" + wsMexAttached);
        }
        return wsMexAttached;
    }

    public static void removePolicySetFromMexAttachments(Session session, String policySetName, String newPolicySetName, String applicationName) throws Exception {
        String resource;
        String wsMexPolicySetName;
        List<Properties> propertiesList;
        Object helper;
        String policySetAttachmentFile;
        String mexPolicySet;
        String dirName;
        String appName;
        String methodName = "removePolicySetFromMexAttachments";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicySetFromMexAttachments", new Object[]{policySetName, newPolicySetName});
        }
        ArrayList<String> wsMexAttachedApplications = new ArrayList<String>();
        HashMap<String, String> policyControlMap = new HashMap<String, String>();
        HashMap<String, String> clientControlMap = new HashMap<String, String>();
        List<Object> wsMexList = new ArrayList();
        List<Object> wsMexClientList = new ArrayList();
        ArrayList<String> wsMexProviderAttached = new ArrayList<String>();
        ArrayList<String> wsMexClientAttached = new ArrayList<String>();
        if (applicationName != null) {
            Properties p = new Properties();
            p.setProperty("application", applicationName);
            wsMexList = PolicyControlWorkSpaceHelper.listWSPolicyControlFiles(session, PolicyConstants.SERVICE_CONTROL, p);
            wsMexClientList = PolicyControlWorkSpaceHelper.listWSPolicyControlFiles(session, PolicyConstants.CLIENT_CONTROL, p);
            if (wsMexList.isEmpty() && wsMexClientList.isEmpty()) {
                throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0137E", new Object[]{PolicyConstants.WS_POLICY, applicationName}, "The {0} control file could not be found for application: {1}"));
            }
        } else {
            wsMexList = PolicyControlWorkSpaceHelper.listWSPolicyControlFiles(session, PolicyConstants.SERVICE_CONTROL);
            wsMexClientList = PolicyControlWorkSpaceHelper.listWSPolicyControlFiles(session, PolicyConstants.CLIENT_CONTROL);
        }
        if (wsMexList != null && !wsMexList.isEmpty()) {
            for (String string : wsMexList) {
                appName = null;
                if (!string.contains("wsPolicyServiceControl.xml") || (dirName = string.substring(0, string.indexOf("wsPolicyServiceControl.xml") - 1)) == null || (appName = (dirName = dirName.substring(0, dirName.lastIndexOf(File.separator))).substring(dirName.lastIndexOf(File.separator) + 1)) == null) continue;
                String policySetAttachmentFile2 = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
                WSPolicyServiceControlHelper helper2 = WSPolicyServiceControlHelperFactory.createHelper(string, policySetAttachmentFile2);
                PolicyControlCommandUtil.setLocale(CommonUtil.getLocale());
                List<Properties> propertiesList2 = helper2.getWSPolicyServiceControlReferencesProperties();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Service appName = " + appName);
                }
                for (Properties controlProps : propertiesList2) {
                    mexPolicySet = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                    if (!policySetName.equals(mexPolicySet)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Properties are: " + controlProps);
                    }
                    policyControlMap.put(string, appName);
                    wsMexProviderAttached.add(string);
                    if (wsMexAttachedApplications.contains(appName)) continue;
                    wsMexAttachedApplications.add(appName);
                }
            }
        }
        if (wsMexClientList != null && !wsMexClientList.isEmpty()) {
            for (String string : wsMexClientList) {
                appName = null;
                if (!string.contains("wsPolicyClientControl.xml") || (dirName = string.substring(0, string.indexOf("wsPolicyClientControl.xml") - 1)) == null || (appName = (dirName = dirName.substring(0, dirName.lastIndexOf(File.separator))).substring(dirName.lastIndexOf(File.separator) + 1)) == null) continue;
                String policySetAttachmentFile2 = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName);
                WSPolicyClientControlHelper helper2 = WSPolicyClientControlHelperFactory.createHelper(string, policySetAttachmentFile2);
                PolicyControlCommandUtil.setLocale(CommonUtil.getLocale());
                List<Properties> propertiesList2 = helper2.getWSPolicyClientControlReferencesProperties();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client appName = " + appName);
                }
                for (Properties controlProps : propertiesList2) {
                    mexPolicySet = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                    if (!policySetName.equals(mexPolicySet)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Properties are: " + controlProps);
                    }
                    clientControlMap.put(string, appName);
                    wsMexClientAttached.add(string);
                    if (wsMexAttachedApplications.contains(appName)) continue;
                    wsMexAttachedApplications.add(appName);
                }
            }
        }
        for (String string : wsMexAttachedApplications) {
            CommonWorkSpaceHelper.validateAttachmentAuthorization("application", string);
        }
        if (wsMexProviderAttached != null && !wsMexProviderAttached.isEmpty()) {
            for (String string : wsMexProviderAttached) {
                appName = (String)policyControlMap.get(string);
                if (appName == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In transfer code, service appName = " + appName);
                }
                policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
                helper = WSPolicyServiceControlHelperFactory.createHelper(string, policySetAttachmentFile);
                PolicyControlCommandUtil.setLocale(CommonUtil.getLocale());
                propertiesList = helper.getWSPolicyServiceControlReferencesProperties();
                for (Properties controlProps : propertiesList) {
                    wsMexPolicySetName = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                    if (!policySetName.equals(wsMexPolicySetName)) continue;
                    resource = controlProps.getProperty("resource");
                    String sharePolicyMethods = controlProps.getProperty(PolicyConstants.SHARE_POLICY_METHODS);
                    boolean httpGet = false;
                    boolean wsMex = false;
                    if (sharePolicyMethods != null && sharePolicyMethods.contains(PolicyConstants.HTTP_GET)) {
                        httpGet = true;
                    }
                    if (sharePolicyMethods != null && sharePolicyMethods.contains(PolicyConstants.WSMEX)) {
                        wsMex = true;
                    }
                    String wsMexPolicySetBinding = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING);
                    wsMexPolicySetName = newPolicySetName != null ? newPolicySetName : null;
                    helper.addWSPolicyServiceControlReference(resource, httpGet, wsMex, wsMexPolicySetName, wsMexPolicySetBinding);
                }
                PolicyControlWorkSpaceHelper.updateWSPolicyServiceControlFile(session, appName);
            }
        }
        if (wsMexClientAttached != null && !wsMexClientAttached.isEmpty()) {
            for (String string : wsMexClientAttached) {
                appName = (String)clientControlMap.get(string);
                if (appName == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In transfer code, Client appName = " + appName);
                }
                policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
                helper = WSPolicyClientControlHelperFactory.createHelper(string, policySetAttachmentFile);
                PolicyControlCommandUtil.setLocale(CommonUtil.getLocale());
                propertiesList = helper.getWSPolicyClientControlReferencesProperties();
                for (Properties controlProps : propertiesList) {
                    wsMexPolicySetName = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                    if (!policySetName.equals(wsMexPolicySetName)) continue;
                    resource = controlProps.getProperty("resource");
                    String wsMexPolicySetBinding = controlProps.getProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING);
                    wsMexPolicySetName = newPolicySetName != null ? newPolicySetName : null;
                    helper.addWSPolicyClientControlReferenceWSMex11(resource, wsMexPolicySetName, wsMexPolicySetBinding, true);
                }
                PolicyControlWorkSpaceHelper.updateWSPolicyClientControlFile(session, appName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicySetFromMexAttachments");
        }
    }

    public static StringBuffer getSOAAttachmentsToPolicySet(Session session, String policySetName) throws WorkSpaceException, NoItemFoundException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, IllegalArgumentException, JAXBException, CommandValidationException, IOException, OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSOAAttachmentsToPolicySet, policySetName=" + policySetName);
        }
        StringBuffer cuBuffer = new StringBuffer("");
        String cuName = null;
        Object var4_4 = null;
        int cuCount = 0;
        List<Object> attachmentFileList = new ArrayList();
        List<Object> clientFilenames = new ArrayList();
        attachmentFileList = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
        clientFilenames = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
        if (clientFilenames != null) {
            attachmentFileList.addAll(clientFilenames);
        }
        for (String string : attachmentFileList) {
            if (string == null) continue;
            cuName = PolicySetAttachmentCommandUtil.getCUNameFromAttachmentPath(string);
            PolicySetAttachmentHelper psAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
            psAttachmentHelper.setLocale(CommonUtil.getLocale());
            boolean isAttached = psAttachmentHelper.isAttachedToPolicySet(policySetName);
            if (!isAttached) continue;
            if (cuCount > 0) {
                cuBuffer.append(",");
            }
            ++cuCount;
            cuBuffer.append(cuName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSOAAttachmentsToPolicySet, cuBuffer=" + cuBuffer);
        }
        return cuBuffer;
    }

    public static String getCUNameFromAttachmentPath(String pathname) {
        String cuName = null;
        int cuStart = pathname.indexOf("/cus/") + "cus".length() + 2;
        int cuEnd = pathname.indexOf("/", cuStart);
        cuName = pathname.substring(cuStart, cuEnd);
        return cuName;
    }

    public static boolean validateBLAName(Session session, String cuName, String blaName) throws OpExecutionException, NoItemFoundException {
        String cuSpecString;
        String methodName = "validateBLAName";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateBLAName", new Object[]{session, cuName, blaName});
        }
        boolean blaNameIsValid = false;
        String sessionId = session.getUserName();
        CompositionUnitFactory cuFact = CompositionUnitFactory.getSingleton();
        List cuSpecs = cuFact.listCompositionUnitSpecs(cuSpecString = "WebSphere:cuname=" + cuName, sessionId);
        if (cuSpecs.isEmpty()) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0164E", new Object[]{cuName}, "The {0} composition unit is not found"));
        }
        CompositionUnitSpec cuSpec = (CompositionUnitSpec)cuSpecs.get(0);
        CompositionUnit cu = cuFact.readCompositionUnitFromCompositionUnitSpec(cuSpec, sessionId);
        CompositionUnitRef cuRef = cu.getCURef();
        List parentBLASpecList = cuRef.listParentBLAs();
        for (BLASpec blaSpec : parentBLASpecList) {
            String blaSpecName = blaSpec.getBLAName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateBLAName, blaSpecName = " + blaSpecName);
            }
            if (!blaName.equals(blaSpecName)) continue;
            blaNameIsValid = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateBLAName", blaNameIsValid);
        }
        return blaNameIsValid;
    }

    public static String getBLAName(Session session, String cuName) throws OpExecutionException, NoItemFoundException {
        String cuSpecString;
        String methodName = "getBLAName";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBLAName", new Object[]{session, cuName});
        }
        String blaName = null;
        String sessionId = session.getUserName();
        CompositionUnitFactory cuFact = CompositionUnitFactory.getSingleton();
        List cuSpecs = cuFact.listCompositionUnitSpecs(cuSpecString = "WebSphere:cuname=" + cuName, sessionId);
        if (cuSpecs.isEmpty()) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0164E", new Object[]{cuName}, "The {0} composition unit is not found"));
        }
        CompositionUnitSpec cuSpec = (CompositionUnitSpec)cuSpecs.get(0);
        CompositionUnit cu = cuFact.readCompositionUnitFromCompositionUnitSpec(cuSpec, sessionId);
        CompositionUnitRef cuRef = cu.getCURef();
        List parentBLASpecList = cuRef.listParentBLAs();
        if (!parentBLASpecList.isEmpty()) {
            BLASpec blaSpec = (BLASpec)parentBLASpecList.get(0);
            blaName = blaSpec.getBLAName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBLAName", blaName);
        }
        return blaName;
    }
}

