/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class PolicyControlCommandUtil {
    private static TraceComponent tc = Tr.register(PolicyControlCommandUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());
    private static Locale _locale = null;

    public static void setLocale(Locale locale) {
        _locale = locale;
    }

    public static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    public static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args, String msg) {
        String formattedMsg = null;
        try {
            String result = bundle.getString(key);
            formattedMsg = result == null ? msg : MessageFormat.format(result, args);
        }
        catch (Throwable t) {
            formattedMsg = msg;
        }
        return formattedMsg;
    }

    public static boolean validateResourceForApplication(Session session, String applicationName, String resource, String controlType) throws Exception {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateResourceForApplication", new Object[]{session, applicationName, resource, controlType});
        }
        String moduleName = null;
        boolean resourceFound = false;
        String service = null;
        String endpoint = null;
        String operation = null;
        List indexPropertyList = new ArrayList();
        if (resource == null || resource.equals("")) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0011E", new Object[]{resource}, "The following list of resources are invalid: {0}"));
        }
        Properties props = new Properties();
        props.put("application", applicationName);
        indexPropertyList = ServiceIndexHelperFactory.createWorkSpaceHelper("application").listServiceIndexFiles(session, props);
        PolicyResource policyResource = new PolicyResource(resource);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "policyResource: " + policyResource);
        }
        moduleName = policyResource.getModuleName();
        service = policyResource.getServiceName();
        endpoint = policyResource.getEndpointName();
        operation = policyResource.getOperationName();
        if (resource.equals("WebService:/") || resource.equals("/")) {
            resourceFound = true;
        }
        String fileName = null;
        boolean resourceFormatValid = true;
        if (!resource.startsWith("WebService:/")) {
            resourceFormatValid = false;
        }
        if (endpoint != null) {
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(resourceBundle, "CWPST0139E", new Object[0], "WSPolicy is not valid at endpoint or operation layer."));
        }
        Iterator indexPropertyListIt = indexPropertyList.iterator();
        while (indexPropertyListIt.hasNext() && !resourceFound && resourceFormatValid) {
            Properties iprop = new Properties();
            iprop = (Properties)indexPropertyListIt.next();
            boolean continueLooking = false;
            String modName = null;
            modName = iprop.getProperty("module");
            if (controlType.equals(PolicyConstants.SERVICE_CONTROL)) {
                if (moduleName != null && moduleName.equals(modName)) {
                    continueLooking = true;
                }
            } else if (controlType.equals(PolicyConstants.CLIENT_CONTROL)) {
                if (moduleName == null) {
                    continueLooking = true;
                } else if (moduleName.equals(modName)) {
                    continueLooking = true;
                }
            }
            if (!continueLooking) continue;
            fileName = iprop.getProperty("file");
            ServiceIndexHelper siHelper = null;
            String appName = iprop.getProperty("application");
            if (fileName == null) {
                throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(resourceBundle, "CWPST0014E", new Object[]{appName + " / " + modName}, "The servicesIndex.xml file could not be located for the {0} application and module."));
            }
            FileInputStream istream = new FileInputStream(fileName);
            props = new Properties();
            props.put("application", appName);
            props.put("module", modName);
            siHelper = ServiceIndexHelperFactory.createHelper(props, istream);
            if (controlType.equals(PolicyConstants.SERVICE_CONTROL)) {
                resourceFound = siHelper.contains(service, endpoint, operation, false);
                continue;
            }
            if (!controlType.equals(PolicyConstants.CLIENT_CONTROL)) continue;
            resourceFound = siHelper.contains(service, endpoint, operation, true);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateResourceForApplication", resourceFound);
        }
        return resourceFound;
    }

    public static void validateWSMexPolicySet(Session session, String policySetName) throws Exception {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateWSMexPolicySet", new Object[]{session, policySetName});
        }
        if (!PolicySetWorkSpaceHelper.doesPolicySetExist(session, policySetName)) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySetName}, "The {0} policy set is not found."));
        }
        String policySetFile = PolicySetWorkSpaceHelper.getPolicySetFile(session, policySetName, false);
        PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(policySetFile);
        String type = psHelper.getPolicySetType();
        if (!type.equals("system")) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0076E", new Object[]{type}, "The {0} policy set type is not valid."));
        }
        List<String> policyTypes = psHelper.listEnabledPolicyTypes();
        if (policyTypes != null) {
            for (String policyType : policyTypes) {
                if (policyType.equals("WSSecurity") || policyType.equals("WSAddressing")) continue;
                throw new CommandValidationException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0160E", new Object[]{policyType}, "The {0} policy type is not valid for WSMex."));
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateWSMexPolicySet");
        }
    }
}

