/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class UpgradeBindings
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(UpgradeBindings.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public UpgradeBindings(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public UpgradeBindings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        boolean upgradeBindings = true;
        try {
            super.validate();
            this.session = this.getConfigSession();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            Properties assetProps = (Properties)this.getParameter("assetProps");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{assetProps});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UpgradeBindings, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            String appName = assetProps.getProperty("application");
            if (appName == null) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0048E", new Object[]{"application"}, "The application name is required when attachment type is {0} and the binding does not reference a WSN service client or system attachment."));
            }
            String version = PolicySetBindingCommandUtil.getServerVersion(this.session, appName);
            if (version.startsWith("6.1")) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0163E", new Object[]{version}, "The bindings for the specified application cannot be upgraded because the application is installed on a server at version {0}"));
            }
            List<String> appBindingFiles = PolicySetBindingWorkSpaceHelper.listBindingsForApplication(this.session, appName, "application");
            for (String bindingFile : appBindingFiles) {
                for (String policyType : PolicyConstants.POLICY_TYPE_NAMES) {
                    PolicyTypeProvider policyTypeProvider;
                    String bindingFilePath = PolicySetBindingWorkSpaceHelper.getApplicationBindingFile(this.session, appName, bindingFile, policyType);
                    if (bindingFilePath != null && (upgradeBindings = (policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyType)).upgradeBinding(bindingFilePath, bindingFilePath))) {
                        PolicySetBindingWorkSpaceHelper.updateApplicationBindingFile(this.session, appName, bindingFile, policyType);
                    }
                    if (!upgradeBindings) break;
                }
                if (!upgradeBindings) break;
                if (PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(this.session, appName, bindingFile) == null) {
                    String bindingDefFile = PolicySetBindingWorkSpaceHelper.createApplicationBindingDefinitionFile(this.session, appName, bindingFile);
                    BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
                    bindingHelper.setLocale(CommonUtil.getLocale());
                    bindingHelper.createBindingDefinition("", "provider", "global", "7.0.0.0");
                    continue;
                }
                UpgradeBindings.updateBindingDefinition(this.session, bindingFile, appName);
            }
            if (upgradeBindings) {
                List<String> clientBindingFiles = PolicySetBindingWorkSpaceHelper.listBindingsForApplication(this.session, appName, "client");
                for (String bindingFile : clientBindingFiles) {
                    for (String policyType : PolicyConstants.POLICY_TYPE_NAMES) {
                        PolicyTypeProvider policyTypeProvider;
                        String bindingFilePath = PolicySetBindingWorkSpaceHelper.getApplicationBindingFile(this.session, appName, bindingFile, policyType);
                        if (bindingFilePath != null && (upgradeBindings = (policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyType)).upgradeBinding(bindingFilePath, bindingFilePath))) {
                            PolicySetBindingWorkSpaceHelper.updateApplicationBindingFile(this.session, appName, bindingFile, policyType);
                        }
                        if (!upgradeBindings) break;
                    }
                    if (!upgradeBindings) break;
                    if (PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(this.session, appName, bindingFile) == null) {
                        String bindingDefFile = PolicySetBindingWorkSpaceHelper.createApplicationBindingDefinitionFile(this.session, appName, bindingFile);
                        BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
                        bindingHelper.setLocale(CommonUtil.getLocale());
                        bindingHelper.createBindingDefinition("", "client", "global", "7.0.0.0");
                        continue;
                    }
                    UpgradeBindings.updateBindingDefinition(this.session, bindingFile, appName);
                }
            }
            result.setResult(upgradeBindings);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className + ".execute()", FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }

    private static void updateBindingDefinition(Session session, String bindingName, String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateBindingDefinition, bindingName=" + bindingName + ", appName=" + appName);
        }
        String bindingDefFile = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFile(session, appName, bindingName);
        BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
        bindingHelper.setLocale(CommonUtil.getLocale());
        bindingHelper.setVersion("7.0.0.0");
        PolicySetBindingWorkSpaceHelper.updateApplicationBindingDefinitionFile(session, appName, bindingName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateBindingDefinition");
        }
    }
}

