/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.SetClientDynamicPolicyControl;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class SetProviderPolicySharingInfo
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(SetClientDynamicPolicyControl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private String className = this.getClass().getName();
    private Session session = null;

    public SetProviderPolicySharingInfo(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SetProviderPolicySharingInfo", inMetadata);
        }
    }

    public SetProviderPolicySharingInfo(CommandData inCommandData) throws CommandNotFoundException {
        super(inCommandData);
        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SetProviderPolicySharingInfo", inCommandData);
        }
    }

    public void execute() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{this});
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            boolean resourceFound;
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String applicationName = (String)this.getParameter("applicationName");
            String resource = (String)this.getParameter("resource");
            String[] sharePolicyMethods = (String[])this.getParameter(PolicyConstants.SHARE_POLICY_METHODS);
            Properties wsMexProperties = (Properties)this.getParameter(PolicyConstants.WSMEX_PROPERTIES);
            Boolean removeB = (Boolean)this.getParameter("remove");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, resource, sharePolicyMethods, wsMexProperties, removeB});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetProviderPolicySharingInfo, Locale is " + this.getLocale().getDisplayName());
            }
            PolicyControlCommandUtil.setLocale(this.getLocale());
            this.session = this.getConfigSession();
            PolicyControlWorkSpaceHelper.validateConfiguratorAuthorization(PolicyControlWorkSpaceHelper.getAppRepositoryContext(this.session, applicationName));
            if (resource != null && !(resourceFound = PolicyControlCommandUtil.validateResourceForApplication(this.session, applicationName, resource, PolicyConstants.SERVICE_CONTROL))) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resource}, "The following list of resources are invalid: {0}"));
            }
            String attachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, applicationName);
            StringBuffer resourcesAttached = new StringBuffer("");
            if (attachmentFile != null) {
                String[] resources = new String[]{resource};
                resourcesAttached = PolicySetAttachmentCommandUtil.validateResourcesNotAttached("application", attachmentFile, resources, null, false);
            }
            if (resourcesAttached.length() == 0) {
                throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0140E", new Object[]{resource}, "The following resource must have a policy set attachment before sharing policy: {0}"));
            }
            boolean remove = false;
            if (removeB != null) {
                remove = removeB;
            }
            boolean success = true;
            if (remove) {
                success = this.removeProviderPolicySharingInfo(applicationName, resource);
            } else {
                if (sharePolicyMethods == null) {
                    throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0069E", new Object[]{PolicyConstants.SHARE_POLICY_METHODS}, "The {0} input parameter is missing or not valid."));
                }
                boolean httpGet = false;
                boolean wsMex = false;
                for (int i = 0; i < sharePolicyMethods.length; ++i) {
                    if (sharePolicyMethods[i].equals(PolicyConstants.HTTP_GET)) {
                        httpGet = true;
                    }
                    if (!sharePolicyMethods[i].equals(PolicyConstants.WSMEX)) continue;
                    wsMex = true;
                }
                if (!httpGet && !wsMex) {
                    throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0136E", new Object[0], "Either httpGet or wsMex must be specified."));
                }
                String controlFile = PolicyControlWorkSpaceHelper.getWSPolicyServiceControlFile(this.session, applicationName);
                boolean createdFile = false;
                if (controlFile == null) {
                    controlFile = PolicyControlWorkSpaceHelper.createWSPolicyServiceControlFile(this.session, applicationName);
                    createdFile = true;
                }
                String policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, applicationName);
                WSPolicyServiceControlHelper helper = WSPolicyServiceControlHelperFactory.createHelper(controlFile, policySetAttachmentFile);
                if (createdFile) {
                    helper.createWSPolicyServiceControl();
                }
                String wsMexPolicySetName = null;
                String wsMexPolicySetBinding = null;
                if (wsMexProperties != null) {
                    wsMexPolicySetName = wsMexProperties.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                    if (wsMexPolicySetName != null) {
                        PolicyControlCommandUtil.validateWSMexPolicySet(this.session, wsMexPolicySetName);
                    }
                    if ((wsMexPolicySetBinding = wsMexProperties.getProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING)) != null) {
                        PolicySetBindingCommandUtil.isProviderNamedBinding(this.session, wsMexPolicySetBinding);
                    }
                }
                helper.addWSPolicyServiceControlReference(resource, httpGet, wsMex, wsMexPolicySetName, wsMexPolicySetBinding);
                success = PolicyControlWorkSpaceHelper.updateWSPolicyServiceControlFile(this.session, applicationName);
            }
            result.setResult(success);
        }
        catch (Exception e) {
            Tr.processException(e, this.className + ".execute", "183");
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", e);
            }
            result.setException(e);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private boolean removeProviderPolicySharingInfo(String applicationName, String resource) throws Exception {
        String methodName = "removeProviderPolicySharingInfo";
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProviderPolicySharingInfo", new Object[]{applicationName, resource, this});
        }
        boolean success = false;
        String controlFile = PolicyControlWorkSpaceHelper.getWSPolicyServiceControlFile(this.session, applicationName);
        if (controlFile == null) {
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0137E", new Object[]{"wsPolicyServiceControl.xml", applicationName}, "The {0} control file could not be found for application: {1}"));
        }
        String policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, applicationName);
        WSPolicyServiceControlHelper helper = WSPolicyServiceControlHelperFactory.createHelper(controlFile, policySetAttachmentFile);
        if (helper.getWSPolicyServiceControlReference(resource) == null) {
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0141E", new Object[]{resource}, "The following resource does not contain any WSPolicy settings: {0}"));
        }
        helper.removeWSPolicyServiceControlReference(resource);
        List<Properties> referenceProperties = helper.getWSPolicyServiceControlReferencesProperties();
        success = referenceProperties == null || referenceProperties.size() == 0 ? PolicyControlWorkSpaceHelper.deleteWSPolicyServiceControlFile(this.session, applicationName) : PolicyControlWorkSpaceHelper.updateWSPolicyServiceControlFile(this.session, applicationName);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProviderPolicySharingInfo", success);
        }
        return success;
    }
}

