/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.ValidationManager;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;

public class SetPolicyTypeAttribute
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(SetPolicyTypeAttribute.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public SetPolicyTypeAttribute(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public SetPolicyTypeAttribute(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        String policySetFilePath = null;
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policysetName = (String)this.getParameter("policySet");
            String policyType = (String)this.getParameter("policyType");
            String attributeName = (String)this.getParameter("attributeName");
            String attributeValue = (String)this.getParameter("attributeValue");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policysetName, policyType, attributeName, attributeValue});
            }
            this.session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetPolicyTypeAttribute, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            policySetFilePath = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, policysetName, false);
            if (policySetFilePath != null && policySetFilePath.length() > 0) {
                ValidationManager validationMgr;
                PolicySetHelper helper = PolicySetHelperFactory.createHelper(policySetFilePath);
                helper.setLocale(this.getLocale());
                if (helper.isDefaultPolicySet()) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0004E", new Object[]{policysetName}, "A default policy set cannot be edited: {0}"));
                }
                int rc = helper.setPolicyTypeAttribute(policyType, attributeName, attributeValue);
                boolean policyTypeSuccess = true;
                boolean updatePolicyTypeFile = false;
                boolean updatePolicySetFile = false;
                if (!(attributeName.equals("provides") || attributeName.equals("enabled") || attributeName.equals("type") || attributeName.equals("description"))) {
                    HashMap<String, String> context;
                    Properties tempProp;
                    String version = null;
                    Properties policySetProps = helper.getPolicySet();
                    if (policySetProps != null && policySetProps.contains("version")) {
                        version = policySetProps.getProperty("version");
                    }
                    String typePathName = PolicyTypeWorkSpaceHelper.getPolicyTypeFile(this.session, policysetName, policyType, false);
                    PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyType);
                    if (policyTypeProvider != null) {
                        tempProp = new Properties();
                        tempProp.setProperty(attributeName, attributeValue);
                        context = new HashMap<String, String>();
                        if (version != null) {
                            context.put("version", version);
                        }
                    } else {
                        throw new ClassNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0042E", new Object[]{policyType}, "PolicyTypeProvider class not found for Policy type: {0}"));
                    }
                    policyTypeSuccess = policyTypeProvider.setAttributes(typePathName, tempProp, false, context);
                    updatePolicyTypeFile = true;
                } else {
                    updatePolicySetFile = true;
                }
                if (!policyTypeSuccess) {
                    throw new Exception(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0044E", new Object[]{policyType}, "Error in setting attributes for Policy type: {0}"));
                }
                if (updatePolicySetFile) {
                    PolicySetWorkSpaceHelper.updatePolicySetFile(this.session, policysetName);
                }
                if (updatePolicyTypeFile) {
                    PolicyTypeWorkSpaceHelper.updatePolicyTypeFile(this.session, policysetName, policyType);
                }
                if ((validationMgr = ValidationManager.getManager(this.session)) != null) {
                    validationMgr.markForValidation(policysetName);
                }
                if (rc == 0 && policyTypeSuccess) {
                    result.setResult(Boolean.TRUE);
                } else {
                    result.setResult(Boolean.FALSE);
                }
            }
        }
        catch (Exception cse) {
            Tr.processException(cse, this.className + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

