/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class SetBinding
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(SetBinding.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public SetBinding(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public SetBinding(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            PolicySetAttachmentHelper psAttachmentHelper;
            List<String> resources;
            String policyAttachmentFile;
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policyTypeName = (String)this.getParameter("policyType");
            Properties bindingLocation = (Properties)this.getParameter("bindingLocation");
            Properties requestedValues = (Properties)this.getParameter("attributes");
            String attachmentType = (String)this.getParameter("attachmentType");
            Boolean replaceAttributes = (Boolean)this.getParameter("replace");
            Boolean removeBinding = (Boolean)this.getParameter("remove");
            String bindingName = (String)this.getParameter("bindingName");
            String bindingScope = (String)this.getParameter("bindingScope");
            if (attachmentType == null) {
                attachmentType = "application";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policyTypeName, bindingLocation, requestedValues, attachmentType, replaceAttributes, removeBinding, bindingName});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetBinding, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (requestedValues == null && bindingName == null && removeBinding == null) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0043E", new Object[0], "Attributes required unless removing or switching a binding"));
            }
            if (!bindingLocation.isEmpty() && (bindingLocation.containsKey("node") || bindingLocation.containsKey("server"))) {
                String warningMsg = CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0143W", new Object[0], "The bindingLocation properties of node and server are deprecated");
                result.addWarnings(warningMsg);
            }
            boolean replace = false;
            if (replaceAttributes != null) {
                replace = replaceAttributes;
            }
            boolean remove = false;
            if (removeBinding != null) {
                remove = removeBinding;
            }
            String busName = null;
            String serviceName = null;
            String systemType = null;
            String cuName = null;
            String cuEdition = null;
            String blaName = null;
            String blaEdition = null;
            if (bindingLocation != null && !bindingLocation.isEmpty()) {
                busName = bindingLocation.getProperty("bus");
                serviceName = bindingLocation.getProperty("WSNService");
                if (busName == null && serviceName != null || busName != null && serviceName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (busName != null && serviceName != null) {
                    if (!attachmentType.equals("client")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "bindingLocation"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                    }
                    attachmentType = "WSNClient";
                }
                if ((systemType = bindingLocation.getProperty("systemType")) != null) {
                    if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0146E", new Object[]{"bindingLocation", systemType}, "The application or provider attachment type is required when the systemType property in the {0} parameter is: {1}"));
                    }
                    if (systemType.equals("trustService")) {
                        attachmentType = "system/trust";
                    } else {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"systemType"}, "The {0} property does not contain a valid value"));
                    }
                }
                cuName = bindingLocation.getProperty("cuName");
                cuEdition = bindingLocation.getProperty("cuEdition");
                blaName = bindingLocation.getProperty("blaName");
                blaEdition = bindingLocation.getProperty("blaEdition");
                if (blaName == null) {
                    if (blaEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "blaEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (cuName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "cuName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                }
                if (cuName == null) {
                    if (cuEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "cuEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (blaName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "blaName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                } else {
                    if (busName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "bus"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                    }
                    if (bindingLocation.containsKey("application")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "application"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                    }
                    boolean validBLAName = PolicySetAttachmentCommandUtil.validateBLAName(session, cuName, blaName);
                    if (!validBLAName) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"blaName"}, "The {0} property does not contain a valid value"));
                    }
                }
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            if (attachmentType.equals("client") && bindingLocation != null && bindingLocation.containsKey("application") && bindingLocation.containsKey("attachmentId") && bindingScope == null && !remove && (policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, bindingLocation.getProperty("application"))) != null && (resources = (psAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(policyAttachmentFile)).getPolicySetResources(bindingLocation.getProperty("attachmentId"), "id")).size() > 0 && psAttachmentHelper.getIdForProviderPolicySetAttachment(resources.get(0)) != null) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0155E", new Object[0], "Unable to create or assign application specific bindings when provider policy set is enabled."));
            }
            boolean policyTypeSuccess = PolicySetBindingCommandUtil.setBinding(session, policyTypeName, bindingLocation, requestedValues, attachmentType, replace, remove, bindingName, bindingScope);
            if (policyTypeSuccess) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

