/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class ListPolicyTypes
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ListPolicyTypes.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    public static final String WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "The client policy attachment file is not found for bus: {0} WSN service: {1}";
    protected String SOURCE_FILE = this.getClass().getName();
    private Session session = null;

    public ListPolicyTypes(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public ListPolicyTypes(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        this.session = this.getConfigSession();
        List<String> resultList = null;
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policysetName = (String)this.getParameter("policySet");
            Properties bindingLocation = (Properties)this.getParameter("bindingLocation");
            String attachmentType = (String)this.getParameter("attachmentType");
            String bindingName = (String)this.getParameter("bindingName");
            Boolean fromDefaultRepository = (Boolean)this.getParameter("fromDefaultRepository");
            Boolean enabled = (Boolean)this.getParameter("enabled");
            if (attachmentType == null) {
                attachmentType = "application";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policysetName, bindingLocation, attachmentType, bindingName, fromDefaultRepository, enabled});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListPolicyTypes, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (fromDefaultRepository == null) {
                fromDefaultRepository = false;
            }
            if (enabled == null) {
                enabled = false;
            }
            String busName = null;
            String serviceName = null;
            String cuName = null;
            String cuEdition = null;
            String blaName = null;
            String blaEdition = null;
            if (bindingLocation != null) {
                busName = bindingLocation.getProperty("bus");
                serviceName = bindingLocation.getProperty("WSNService");
                cuName = bindingLocation.getProperty("cuName");
                cuEdition = bindingLocation.getProperty("cuEdition");
                blaName = bindingLocation.getProperty("blaName");
                blaEdition = bindingLocation.getProperty("blaEdition");
            }
            if (busName == null && serviceName != null || busName != null && serviceName == null) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
            }
            if (busName != null && serviceName != null) {
                if (!attachmentType.equals("client")) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "attachmentProperties"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                }
                attachmentType = "WSNClient";
            }
            if (blaName == null) {
                if (blaEdition != null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "blaEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (cuName != null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "cuName"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
            }
            if (cuName == null) {
                if (cuEdition != null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "cuEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (blaName != null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "blaName"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
            } else {
                if (busName != null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "bus"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                }
                if (bindingLocation.containsKey("application")) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "application"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                }
                boolean validBLAName = PolicySetAttachmentCommandUtil.validateBLAName(this.session, cuName, blaName);
                if (!validBLAName) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"blaName"}, "The {0} property does not contain a valid value"));
                }
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            if (policysetName != null && bindingLocation != null) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0029E", new Object[]{"bindingLocation", "policySet"}, "The {1} parameter cannot be used if the {0} parameter is specified"));
            }
            if (bindingLocation != null) {
                if (bindingLocation.containsKey("node") && !bindingLocation.containsKey("server") || bindingLocation.containsKey("server") && !bindingLocation.containsKey("node")) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"node", "server"}, "The input argument {0} must also be specified with {1}"));
                }
                if (bindingLocation.containsKey("node") || bindingLocation.containsKey("server")) {
                    String warningMsg = CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0143W", new Object[0], "The bindingLocation properties of node and server are deprecated");
                    result.addWarnings(warningMsg);
                }
            }
            if (fromDefaultRepository.booleanValue() && policysetName == null) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"policySet", "fromDefaultRepository"}, "The {0} input argument must also be specified with the {1} input argument."));
            }
            if (fromDefaultRepository.booleanValue()) {
                String policySetFile = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, policysetName, true);
                PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(policySetFile);
                resultList = enabled.booleanValue() ? psHelper.listEnabledPolicyTypes() : psHelper.listPolicyTypes();
            } else if (bindingLocation == null) {
                if (policysetName == null || policysetName.equals("")) {
                    resultList = PolicyTypeWorkSpaceHelper.listDefaultPolicyTypes(this.session);
                } else {
                    String policySetFile = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, policysetName, false);
                    PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(policySetFile);
                    resultList = enabled.booleanValue() ? psHelper.listEnabledPolicyTypes() : psHelper.listPolicyTypes();
                }
            } else {
                resultList = this.findPolicyTypesForBindingFiles(this.session, bindingLocation, attachmentType, bindingName, busName, serviceName, cuName);
            }
            result.setResult(resultList);
        }
        catch (Exception cse) {
            Tr.processException(cse, this.SOURCE_FILE + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finally");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List findPolicyTypesForBindingFiles(Session session, Properties bindingLocation, String attachmentType, String bindingName, String busName, String serviceName, String cuName) throws WorkSpaceException, NoItemFoundException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JAXBException, FileNotFoundException, DuplicateItemFoundException, IOException, Exception {
        List policyTypes = null;
        if (bindingLocation.isEmpty()) {
            if (bindingName != null) return PolicyTypeWorkSpaceHelper.listPolicyTypesForNamedBindingFile(session, bindingName);
            return PolicyTypeWorkSpaceHelper.listPolicyTypesForCellBindingFile(session);
        }
        if (bindingLocation.containsKey("node")) {
            String node = bindingLocation.getProperty("node");
            String server = bindingLocation.getProperty("server");
            return PolicyTypeWorkSpaceHelper.listPolicyTypesForServerBindingFile(session, node, server);
        }
        String attachmentId = bindingLocation.getProperty("attachmentId");
        String appName = bindingLocation.getProperty("application");
        if ((attachmentType.equals("application") || attachmentType.equals("client")) && appName == null && cuName == null) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0048E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the binding does not reference a WSN service client or system attachment."));
        }
        String policyAttachmentFile = null;
        String errorMsg = null;
        String messageCode = null;
        String bindingRef = null;
        if (cuName != null && !cuName.equals("")) {
            if (attachmentType.equals("application")) {
                policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, cuName);
                errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0168E";
            } else if (attachmentType.equals("client")) {
                policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(session, cuName);
                errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0168E";
            }
        } else if (attachmentType.equals("application")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
            errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0031E";
        } else if (attachmentType.equals("system/trust")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
            errorMsg = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0033E";
        } else if (attachmentType.equals("client")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName);
            errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0032E";
        } else {
            if (!attachmentType.equals("WSNClient")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(session, busName, serviceName);
            errorMsg = WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0108E";
        }
        if (policyAttachmentFile == null) throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{appName}, errorMsg));
        PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(policyAttachmentFile);
        psHelper.setLocale(this.getLocale());
        Properties bindingProps = psHelper.getBindingReference(attachmentId);
        bindingRef = bindingProps.getProperty("name");
        String bindingScope = bindingProps.getProperty("scope");
        if (bindingRef == null || bindingRef.equals("")) throw new NoItemFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0037E", new Object[]{attachmentId}, "Binding reference not found for attachment: {0}"));
        if (bindingScope != null && bindingScope.equals("domain")) {
            return PolicyTypeWorkSpaceHelper.listPolicyTypesForNamedBindingFile(session, bindingRef);
        }
        if (attachmentType.equals("system/trust")) {
            return PolicyTypeWorkSpaceHelper.listPolicyTypesForTrustBindingFile(session, bindingRef);
        }
        if (cuName != null && !cuName.equals("")) {
            return PolicyTypeWorkSpaceHelper.listPolicyTypesForCUBindingFile(session, cuName, bindingRef);
        }
        if (attachmentType.equals("application")) return PolicyTypeWorkSpaceHelper.listPolicyTypesForApplicationBindingFile(session, appName, bindingRef);
        if (attachmentType.equals("client")) {
            return PolicyTypeWorkSpaceHelper.listPolicyTypesForApplicationBindingFile(session, appName, bindingRef);
        }
        if (!attachmentType.equals("WSNClient")) return policyTypes;
        return PolicyTypeWorkSpaceHelper.listPolicyTypesForWSNClientBindingFile(session, busName, serviceName, bindingRef);
    }
}

