/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class ListAssetsAttachedToPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ListAssetsAttachedToPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public ListAssetsAttachedToPolicySet(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public ListAssetsAttachedToPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        ArrayList<Properties> attachments = new ArrayList<Properties>();
        try {
            super.validate();
            this.session = this.getConfigSession();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policysetName = (String)this.getParameter("policySet");
            String attachmentType = (String)this.getParameter("attachmentType");
            if (attachmentType == null) {
                attachmentType = "all";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policysetName, attachmentType});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListAttachmentsForPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            if (!(attachmentType.equals("application") || attachmentType.equals("client") || attachmentType.equals("WSNClient") || attachmentType.equals("WSMex") || attachmentType.equals("cuProvider") || attachmentType.equals("cuClient") || attachmentType.equals("all"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
            }
            ArrayList allAppsList = new ArrayList();
            if (attachmentType.equals("application") || attachmentType.equals("all")) {
                List<Object> serviceAppsList = new ArrayList();
                serviceAppsList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "application");
                allAppsList.addAll(serviceAppsList);
            }
            if (attachmentType.equals("client") || attachmentType.equals("all")) {
                List<Object> clientAppsList = new ArrayList();
                clientAppsList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "client");
                allAppsList.addAll(clientAppsList);
            }
            ArrayList<String> appsAttached = new ArrayList<String>();
            if (allAppsList != null && !allAppsList.isEmpty()) {
                for (String appFilePath : allAppsList) {
                    String string;
                    String appName;
                    void var10_15;
                    PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(appFilePath);
                    helper.setLocale(this.getLocale());
                    if (!helper.isAttachedToPolicySet(policysetName)) continue;
                    Object var10_12 = null;
                    if (appFilePath.contains("policyAttachments.xml")) {
                        String string2 = appFilePath.substring(0, appFilePath.indexOf("policyAttachments.xml") - 1);
                    } else if (appFilePath.contains("clientPolicyAttachments.xml")) {
                        String string3 = appFilePath.substring(0, appFilePath.indexOf("clientPolicyAttachments.xml") - 1);
                    }
                    if (var10_15 == null || (appName = (string = var10_15.substring(0, var10_15.lastIndexOf(File.separator))).substring(string.lastIndexOf(File.separator) + 1)) == null || appsAttached.contains(appName)) continue;
                    appsAttached.add(appName);
                }
            }
            for (String appName : appsAttached) {
                Properties props = new Properties();
                props.setProperty("assetType", "application");
                props.setProperty("applicationName", appName);
                attachments.add(props);
            }
            List<Object> wsnClientList = new ArrayList();
            if (attachmentType.equals("WSNClient") || attachmentType.equals("all")) {
                wsnClientList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "WSNClient");
            }
            ArrayList<Properties> wsnClientAttached = new ArrayList<Properties>();
            if (wsnClientList != null && !wsnClientList.isEmpty()) {
                for (String string : wsnClientList) {
                    Properties wsnClient;
                    PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(string);
                    helper.setLocale(this.getLocale());
                    if (!helper.isAttachedToPolicySet(policysetName) || (wsnClient = PolicySetAttachmentCommandUtil.getWSNClientBusServiceName(string)) == null || wsnClientAttached.contains(wsnClient)) continue;
                    wsnClientAttached.add(wsnClient);
                }
            }
            for (Properties properties : wsnClientAttached) {
                properties.setProperty("assetType", "WSNClient");
                attachments.add(properties);
            }
            if (attachmentType.equals("WSMex") || attachmentType.equals("all")) {
                List<String> wsMexAttached = PolicySetAttachmentCommandUtil.getApplicationsWithMexAttachmentsToPolicySet(this.session, policysetName);
                for (String appName : wsMexAttached) {
                    Properties props = new Properties();
                    props.setProperty("assetType", "application");
                    props.setProperty("applicationName", appName);
                    attachments.add(props);
                }
            }
            ArrayList<String> allCUsList = new ArrayList<String>();
            if (attachmentType.equals("cuProvider") || attachmentType.equals("all")) {
                ArrayList arrayList = new ArrayList();
                List<String> list = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "application");
                allCUsList.addAll(list);
            }
            if (attachmentType.equals("cuClient") || attachmentType.equals("all")) {
                ArrayList arrayList = new ArrayList();
                List<String> list = PolicySetSOAAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "client");
                allCUsList.addAll(list);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (allCUsList != null && !allCUsList.isEmpty()) {
                for (String cuFilePath : allCUsList) {
                    String cuName;
                    PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(cuFilePath);
                    helper.setLocale(this.getLocale());
                    if (!helper.isAttachedToPolicySet(policysetName) || (cuName = PolicySetAttachmentCommandUtil.getCUNameFromAttachmentPath(cuFilePath)) == null || appsAttached.contains(cuName)) continue;
                    arrayList.add(cuName);
                }
            }
            for (String cuName : arrayList) {
                Properties props = new Properties();
                props.setProperty("assetType", "CU");
                props.setProperty("cuName", cuName);
                String blaName = PolicySetAttachmentCommandUtil.getBLAName(this.session, cuName);
                if (blaName != null) {
                    props.setProperty("blaName", blaName);
                }
                attachments.add(props);
            }
            result.setResult(attachments);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className + ".execute()", FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

