/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class GetProviderPolicySharingInfo
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetProviderPolicySharingInfo.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private String className = this.getClass().getName();
    private Session session = null;

    public GetProviderPolicySharingInfo(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "GetProviderPolicySharingInfo", inMetadata);
        }
    }

    public GetProviderPolicySharingInfo(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "GetProviderPolicySharingInfo", commandData);
        }
    }

    public void execute() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{this});
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            boolean resourceFound;
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String applicationName = (String)this.getParameter("applicationName");
            String resource = (String)this.getParameter("resource");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, resource});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetProviderPolicySharingInfo, Locale is " + this.getLocale().getDisplayName());
            }
            PolicyControlCommandUtil.setLocale(this.getLocale());
            this.session = this.getConfigSession();
            if (resource != null && !(resourceFound = PolicyControlCommandUtil.validateResourceForApplication(this.session, applicationName, resource, PolicyConstants.SERVICE_CONTROL))) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resource}, "The following list of resources are invalid: {0}"));
            }
            String controlFile = PolicyControlWorkSpaceHelper.getWSPolicyServiceControlFile(this.session, applicationName);
            String policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, applicationName);
            List<Object> propertiesList = new ArrayList();
            if (controlFile != null) {
                WSPolicyServiceControlHelper helper = WSPolicyServiceControlHelperFactory.createHelper(controlFile, policySetAttachmentFile);
                propertiesList = helper.getWSPolicyServiceControlReferencesProperties();
                if (resource != null) {
                    propertiesList.clear();
                    Properties properties = helper.getWSPolicyServiceControlReferenceInheritedProperties(resource);
                    propertiesList.add(properties);
                }
            }
            result.setResult(propertiesList);
        }
        catch (Exception e) {
            Tr.processException(e, this.className + ".execute", "148");
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", e);
            }
            result.setException(e);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

