/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;

public class GetPolicyTypeAttribute
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetPolicyTypeAttribute.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public GetPolicyTypeAttribute(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public GetPolicyTypeAttribute(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        String policySetFilePath = null;
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policysetName = (String)this.getParameter("policySet");
            String policyType = (String)this.getParameter("policyType");
            String attributeName = (String)this.getParameter("attributeName");
            Boolean fromDefaultRepository = (Boolean)this.getParameter("fromDefaultRepository");
            String attributeValue = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policysetName, policyType, attributeName, fromDefaultRepository});
            }
            this.session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetPolicyTypeAttribute, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (fromDefaultRepository == null) {
                fromDefaultRepository = false;
            }
            if ((policySetFilePath = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, policysetName, fromDefaultRepository)) != null && policySetFilePath.length() > 0) {
                PolicySetHelper helper = PolicySetHelperFactory.createHelper(policySetFilePath);
                helper.setLocale(this.getLocale());
                attributeValue = helper.getPolicyTypeAttribute(policyType, attributeName);
                if (attributeValue == null) {
                    String version = null;
                    Properties policySetProps = helper.getPolicySet();
                    if (policySetProps != null && policySetProps.contains("version")) {
                        version = policySetProps.getProperty("version");
                    }
                    String typePathName = PolicyTypeWorkSpaceHelper.getPolicyTypeFile(this.session, policysetName, policyType, fromDefaultRepository);
                    Properties policyTypeProps = null;
                    PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyType);
                    if (policyTypeProvider != null) {
                        Properties tempProp = new Properties();
                        tempProp.setProperty(attributeName, "");
                        HashMap<String, String> context = new HashMap<String, String>();
                        if (version != null) {
                            context.put("version", version);
                        }
                        if ((policyTypeProps = policyTypeProvider.getAttributes(typePathName, tempProp, context)) != null) {
                            attributeValue = policyTypeProps.getProperty(attributeName);
                        }
                    } else {
                        throw new ClassNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0042E", new Object[]{policyType}, "PolicyTypeProvider class not found for Policy type: {0}"));
                    }
                }
                result.setResult(attributeValue);
            }
        }
        catch (Exception cse) {
            Tr.processException(cse, this.className + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

