/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class GetPolicyType
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetPolicyType.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public GetPolicyType(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public GetPolicyType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policySetName = (String)this.getParameter("policySet");
            String policyType = (String)this.getParameter("policyType");
            String[] requestedValues = (String[])this.getParameter("attributes");
            Boolean fromDefaultRepository = (Boolean)this.getParameter("fromDefaultRepository");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policySetName, policyType, requestedValues, fromDefaultRepository});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetPolicyType, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (fromDefaultRepository == null) {
                fromDefaultRepository = false;
            }
            Properties attributes = this.convertAttributeList(requestedValues);
            String pathname = PolicySetWorkSpaceHelper.getPolicySetFile(session, policySetName, fromDefaultRepository);
            PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(pathname);
            psHelper.setLocale(this.getLocale());
            Properties props = psHelper.getPolicyType(policyType, requestedValues);
            boolean callPolicyProvider = true;
            if (!attributes.isEmpty()) {
                if (attributes.containsKey("provides")) {
                    attributes.remove("provides");
                }
                if (attributes.containsKey("enabled")) {
                    attributes.remove("enabled");
                }
                if (attributes.containsKey("description")) {
                    attributes.remove("description");
                }
                if (attributes.isEmpty()) {
                    callPolicyProvider = false;
                }
            }
            if (callPolicyProvider) {
                HashMap<String, String> context;
                String version = null;
                Properties policySetProps = psHelper.getPolicySet();
                if (policySetProps != null && policySetProps.contains("version")) {
                    version = policySetProps.getProperty("version");
                }
                String typePathName = PolicyTypeWorkSpaceHelper.getPolicyTypeFile(session, policySetName, policyType, fromDefaultRepository);
                Properties policyTypeProps = null;
                PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyType);
                if (policyTypeProvider != null) {
                    context = new HashMap<String, String>();
                    if (version != null) {
                        context.put("version", version);
                    }
                } else {
                    throw new ClassNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0042E", new Object[]{policyType}, "PolicyTypeProvider class not found for Policy type: {0}"));
                }
                policyTypeProps = policyTypeProvider.getAttributes(typePathName, attributes, context);
                if (policyTypeProps != null && !policyTypeProps.isEmpty()) {
                    props.putAll((Map<?, ?>)policyTypeProps);
                }
            }
            result.setResult(props);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private Properties convertAttributeList(String[] resources) {
        Properties attributeProps = new Properties();
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                attributeProps.setProperty(resources[i], "");
            }
        }
        return attributeProps;
    }
}

