/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class GetPolicySetAttachments
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetPolicySetAttachments.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    protected String className = this.getClass().getName();
    private Session session = null;

    public GetPolicySetAttachments(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public GetPolicySetAttachments(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            void var14_23;
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String applicationName = (String)this.getParameter("applicationName");
            String attachmentType = (String)this.getParameter("attachmentType");
            String expandResources = (String)this.getParameter("expandResources");
            Properties attachmentProperties = (Properties)this.getParameter("attachmentProperties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, attachmentType, expandResources, attachmentProperties});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetPolicySetAttachments, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            this.session = this.getConfigSession();
            if (attachmentType == null) {
                attachmentType = "application";
            }
            String busName = null;
            String serviceName = null;
            String systemType = null;
            String cuName = null;
            String cuEdition = null;
            String blaName = null;
            String blaEdition = null;
            if (attachmentProperties != null) {
                boolean validValues = false;
                busName = attachmentProperties.getProperty("bus");
                serviceName = attachmentProperties.getProperty("WSNService");
                if (busName == null && serviceName != null || busName != null && serviceName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (busName != null && serviceName != null) {
                    if (!attachmentType.equals("client")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "attachmentProperties"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                    }
                    attachmentType = "WSNClient";
                    validValues = true;
                }
                if ((systemType = attachmentProperties.getProperty("systemType")) != null) {
                    if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0146E", new Object[]{"attachmentProperties", systemType}, "The application or provider attachment type is required when the systemType property in the {0} parameter is: {1}"));
                    }
                    if (!systemType.equals("trustService")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"systemType"}, "The {0} property does not contain a valid value"));
                    }
                    attachmentType = "system/trust";
                    validValues = true;
                }
                cuName = attachmentProperties.getProperty("cuName");
                cuEdition = attachmentProperties.getProperty("cuEdition");
                blaName = attachmentProperties.getProperty("blaName");
                blaEdition = attachmentProperties.getProperty("blaEdition");
                if (blaName == null) {
                    if (blaEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "blaEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (cuName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "cuName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                }
                if (cuName == null) {
                    if (cuEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "cuEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (blaName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "blaName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                } else {
                    if (busName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "bus"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                    }
                    boolean bl = PolicySetAttachmentCommandUtil.validateBLAName(this.session, cuName, blaName);
                    if (!bl) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"blaName"}, "The {0} property does not contain a valid value"));
                    }
                    validValues = true;
                }
                if (!validValues) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0114E", new Object[]{"attachmentProperties"}, "The {0} parameter did not contain valid values."));
                }
            } else if (applicationName == null && (attachmentType.equals("application") || attachmentType.equals("client") || attachmentType.equals("provider"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0034E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the attachmentProperties parameter is not specified"));
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            String attachmentFile = null;
            if (cuName != null && !cuName.equals("")) {
                if (attachmentType.equals("application")) {
                    attachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, cuName);
                } else {
                    if (!attachmentType.equals("client")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                    attachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, cuName);
                }
            } else if (attachmentType.equals("application")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, applicationName);
            } else if (attachmentType.equals("system/trust")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(this.session);
            } else if (attachmentType.equals("client")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, applicationName);
            } else {
                if (!attachmentType.equals("WSNClient")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(this.session, busName, serviceName);
            }
            ArrayList arrayList = new ArrayList();
            if (attachmentFile != null) {
                PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                helper.setLocale(this.getLocale());
                List<Properties> list = helper.getPolicySetAttachments();
            }
            if (expandResources != null) {
                void var14_20;
                if (attachmentType.equals("system/trust")) {
                    List<Properties> list = PolicySetAttachmentCommandUtil.getExpandedResourcesForTrust(expandResources, (List)var14_20);
                } else {
                    List<Properties> list = PolicySetAttachmentCommandUtil.getExpandedResources(this.session, applicationName, expandResources, (List<Properties>)var14_20, attachmentType, attachmentProperties);
                }
            }
            result.setResult(var14_23);
        }
        catch (Exception cse) {
            Tr.processException(cse, this.className + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className + ".execute", FFDC_ID_2);
            Tr.error(tc, "CWPST0007E", new Object[]{t.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + t);
            }
            result.setException(t);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "execute end");
    }
}

