/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOABindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class GetBinding
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetBinding.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    public static final String WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "The client policy attachment file is not found for bus: {0} WSN service: {1}";
    private boolean getBindingList = false;
    private boolean getNamedBindingAttributes = false;
    String bindingVersion = "7.0.0.0";

    public GetBinding(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public GetBinding(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policyTypeName = (String)this.getParameter("policyType");
            Properties bindingLocation = (Properties)this.getParameter("bindingLocation");
            String[] requestedValues = (String[])this.getParameter("attributes");
            String attachmentType = (String)this.getParameter("attachmentType");
            String bindingName = (String)this.getParameter("bindingName");
            if (attachmentType == null) {
                attachmentType = "application";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policyTypeName, bindingLocation, requestedValues, attachmentType});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetBinding, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            Properties attributes = this.convertAttributeList(requestedValues);
            if (policyTypeName == null && !bindingLocation.isEmpty() && !"*".equals(bindingLocation.getProperty("attachmentId"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0069E", new Object[]{"policyType"}, "The {0} input parameter is not valid"));
            }
            if (!bindingLocation.isEmpty() && (bindingLocation.containsKey("node") || bindingLocation.containsKey("server"))) {
                String warningMsg = CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0143W", new Object[0], "The bindingLocation properties of node and server are deprecated");
                result.addWarnings(warningMsg);
            }
            String busName = null;
            String serviceName = null;
            String systemType = null;
            String cuName = null;
            String cuEdition = null;
            String blaName = null;
            String blaEdition = null;
            if (bindingLocation != null && !bindingLocation.isEmpty()) {
                busName = bindingLocation.getProperty("bus");
                serviceName = bindingLocation.getProperty("WSNService");
                if (busName == null && serviceName != null || busName != null && serviceName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (busName != null && serviceName != null) {
                    if (!attachmentType.equals("client")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "bindingLocation"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                    }
                    attachmentType = "WSNClient";
                }
                if ((systemType = bindingLocation.getProperty("systemType")) != null) {
                    if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0146E", new Object[]{"bindingLocation", systemType}, "The application or provider attachment type is required when the systemType property in the {0} parameter is: {1}"));
                    }
                    if (!systemType.equals("trustService")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"systemType"}, "The {0} property does not contain a valid value"));
                    attachmentType = "system/trust";
                }
                cuName = bindingLocation.getProperty("cuName");
                cuEdition = bindingLocation.getProperty("cuEdition");
                blaName = bindingLocation.getProperty("blaName");
                blaEdition = bindingLocation.getProperty("blaEdition");
                if (blaName == null) {
                    if (blaEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "blaEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (cuName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "cuName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                }
                if (cuName == null) {
                    if (cuEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "cuEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (blaName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "blaName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                } else {
                    if (busName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "bus"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                    }
                    if (bindingLocation.containsKey("application")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "application"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                    }
                    boolean validBLAName = PolicySetAttachmentCommandUtil.validateBLAName(session, cuName, blaName);
                    if (!validBLAName) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"blaName"}, "The {0} property does not contain a valid value"));
                    }
                }
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            Properties bindingProps = new Properties();
            String bindingFile = this.getBindingFile(session, policyTypeName, bindingLocation, attachmentType, bindingName);
            if (bindingFile != null) {
                PolicyTypeProvider policyTypeProvider;
                boolean returnVersion = false;
                if (attributes.containsKey("version")) {
                    attributes.remove("version");
                    returnVersion = true;
                }
                if ((policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyTypeName)) == null) throw new ClassNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0042E", new Object[]{policyTypeName}, "PolicyTypeProvider class not found for Policy type: {0}"));
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("version", this.bindingVersion);
                bindingProps = policyTypeProvider.getBinding(bindingFile, attributes, context);
                if (returnVersion) {
                    if (bindingProps == null) {
                        bindingProps = new Properties();
                    }
                    bindingProps.put("version", this.bindingVersion);
                }
            } else if (this.getBindingList) {
                List<String> bindingList = null;
                if (attachmentType.equals("system/trust")) {
                    bindingList = PolicySetBindingWorkSpaceHelper.listBindingsForTrust(session);
                } else if (attachmentType.equals("WSNClient")) {
                    bindingList = PolicySetBindingWorkSpaceHelper.listBindingsForWSNClient(session, busName, serviceName);
                } else if (!bindingLocation.isEmpty()) {
                    if (cuName != null && !cuName.equals("")) {
                        bindingList = PolicySetSOABindingWorkSpaceHelper.listBindingsForCU(session, cuName, attachmentType);
                    } else {
                        String appName = bindingLocation.getProperty("application");
                        bindingList = PolicySetBindingWorkSpaceHelper.listBindingsForApplication(session, appName, attachmentType);
                    }
                } else {
                    bindingList = PolicySetBindingWorkSpaceHelper.listNamedBindings(session, attachmentType);
                }
                if (bindingList != null) {
                    for (int i = 0; i < bindingList.size(); ++i) {
                        bindingProps.setProperty("bindingName." + i, bindingList.get(i));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "binding list size = " + bindingList.size());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bindingList is null");
                }
            } else if (this.getNamedBindingAttributes) {
                String pathname = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName);
                BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathname);
                bindingHelper.setLocale(CommonUtil.getLocale());
                bindingProps = bindingHelper.getBindingAttributes(requestedValues);
            }
            result.setResult(bindingProps);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "execute");
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getBindingFile(Session session, String policyTypeName, Properties bindingLocation, String attachmentType, String bindingName) throws WorkSpaceException, NoItemFoundException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JAXBException, FileNotFoundException, DuplicateItemFoundException, IOException, Exception {
        String bindingFile = null;
        if (bindingLocation.isEmpty()) {
            if (bindingName == null) {
                if (policyTypeName != null) {
                    return PolicySetBindingWorkSpaceHelper.getCellDefaultBindingFile(session, policyTypeName);
                }
                this.getBindingList = true;
                return bindingFile;
            }
            if (policyTypeName == null) {
                this.getNamedBindingAttributes = true;
                return bindingFile;
            }
            bindingFile = PolicySetBindingWorkSpaceHelper.getNamedBindingFile(session, bindingName, policyTypeName);
            String bindingDefFile = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName);
            BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(bindingDefFile);
            bindingHelper.setLocale(CommonUtil.getLocale());
            String bindingType = bindingHelper.getBindingType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getBindingFile, bindingType = " + bindingType);
                Tr.debug(tc, "getBindingFile, attachmentType = " + attachmentType);
            }
            if (!bindingType.equals("provider") || attachmentType.equals("application")) {
                if (!bindingType.equals("client")) return bindingFile;
                if (attachmentType.equals("client")) return bindingFile;
                if (attachmentType.equals("WSNClient")) return bindingFile;
            }
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0124E", new Object[]{bindingName}, "The {0} binding is not valid for the specified attachment type"));
        }
        if (bindingLocation.containsKey("node")) {
            String node = bindingLocation.getProperty("node");
            String server = bindingLocation.getProperty("server");
            return PolicySetBindingWorkSpaceHelper.getServerDefaultBindingFile(session, policyTypeName, node, server);
        }
        String attachmentId = bindingLocation.getProperty("attachmentId");
        if (attachmentId == null) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0069E", new Object[]{"attachmentId"}, "Input parameter is invalid: {0}"));
        }
        String appName = bindingLocation.getProperty("application");
        String busName = bindingLocation.getProperty("bus");
        String serviceName = bindingLocation.getProperty("WSNService");
        String cuName = bindingLocation.getProperty("cuName");
        String cuEdition = bindingLocation.getProperty("cuEdition");
        if (appName == null && cuName == null && (attachmentType.equals("application") || attachmentType.equals("client"))) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0048E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the binding does not reference a WSN service client or system attachment."));
        }
        if (attachmentId.equals("*")) {
            this.getBindingList = true;
            return bindingFile;
        }
        String policyAttachmentFile = null;
        String errorMsg = null;
        String messageCode = null;
        String bindingRef = null;
        if (cuName != null && !cuName.equals("")) {
            if (attachmentType.equals("application")) {
                policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, cuName);
                errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0168E";
            } else {
                if (!attachmentType.equals("client")) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                }
                policyAttachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(session, cuName);
                errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0168E";
            }
        } else if (attachmentType.equals("application")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, appName);
            errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0031E";
        } else if (attachmentType.equals("system/trust")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
            errorMsg = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0033E";
        } else if (attachmentType.equals("client")) {
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, appName);
            errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0032E";
        } else {
            if (!attachmentType.equals("WSNClient")) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
            }
            policyAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(session, busName, serviceName);
            errorMsg = WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            messageCode = "CWPST0108E";
        }
        if (policyAttachmentFile != null) {
            PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(policyAttachmentFile);
            psHelper.setLocale(this.getLocale());
            Properties bindingProps = psHelper.getBindingReference(attachmentId);
            bindingRef = bindingProps.getProperty("name");
            String bindingScope = bindingProps.getProperty("scope");
            if (bindingRef != null && !bindingRef.equals("")) {
                if (bindingScope != null && bindingScope.equals("domain")) {
                    return PolicySetBindingWorkSpaceHelper.getNamedBindingFile(session, bindingRef, policyTypeName);
                }
                if (attachmentType.equals("system/trust")) {
                    return PolicySetBindingWorkSpaceHelper.getTrustBindingFile(session, bindingRef, policyTypeName);
                }
                if (attachmentType.equals("WSNClient")) {
                    return PolicySetBindingWorkSpaceHelper.getWSNClientBindingFile(session, bindingRef, policyTypeName, busName, serviceName);
                }
                if (cuName != null && !cuName.equals("")) {
                    return PolicySetSOABindingWorkSpaceHelper.getCUBindingFile(session, cuName, bindingRef, policyTypeName);
                }
                bindingFile = PolicySetBindingWorkSpaceHelper.getApplicationBindingFile(session, appName, bindingRef, policyTypeName);
                this.bindingVersion = PolicySetBindingCommandUtil.getBindingVersion(session, bindingRef, appName);
                return bindingFile;
            }
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0037E", new Object[]{attachmentId}, "Binding reference not found for attachment: {0}"));
        }
        if (attachmentType.equals("WSNClient")) {
            throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{busName, serviceName}, errorMsg));
        }
        if (cuName != null && !cuName.equals("")) {
            throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{cuName}, errorMsg));
        }
        throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{appName}, errorMsg));
    }

    private Properties convertAttributeList(String[] resources) {
        Properties attributeProps = new Properties();
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                attributeProps.setProperty(resources[i], "");
            }
        }
        return attributeProps;
    }
}

