/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExportBinding
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ExportBinding.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private String className = this.getClass().getName();

    public ExportBinding(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ExportBinding(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List validate(Session session, String bindingName, String pathName) throws CommandValidationException, WorkSpaceException, NoItemFoundException, Exception {
        File dirPath;
        int lastSlash2;
        int lastSlash1;
        List<String> fileList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if ((fileList = PolicySetBindingWorkSpaceHelper.getBindingDirectoryFiles(session, bindingName)).size() < 1) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0125E", new Object[]{bindingName}, "The following binding directory does not contain any files: {0}"));
        }
        String osname = System.getProperty("os.name");
        int lastSlash = 0;
        lastSlash = osname.startsWith("Window") ? ((lastSlash1 = pathName.lastIndexOf("\\")) > (lastSlash2 = pathName.lastIndexOf("/")) ? lastSlash1 : lastSlash2) : pathName.lastIndexOf("/");
        if (lastSlash == -1) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0024E", new Object[]{pathName}, "The following output file name does not contain any file separator slashes: {0}"));
        }
        String baseDirPath = pathName.substring(0, lastSlash);
        if (baseDirPath == null || baseDirPath.equals("")) {
            baseDirPath = "/";
        }
        if ((dirPath = new File(baseDirPath)).exists()) {
            if (!dirPath.isDirectory()) throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0019E", new Object[]{baseDirPath}, "The following directory path is not a directory: {0}"));
            if (!dirPath.canWrite()) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0016E", new Object[]{baseDirPath}, "The following directory path is not writeable: {0}"));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Export baseDirPath is: " + baseDirPath);
            }
            if (dirPath != null) {
                dirPath.mkdirs();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Export directories being created");
                }
            }
            String absolutePath = dirPath.getAbsolutePath();
            File newD = new File(absolutePath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Export absolutePath is: " + absolutePath);
            }
            if (!newD.getParentFile().canWrite()) {
                String parent = newD.getParent();
                if (!tc.isDebugEnabled()) throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0016E", new Object[]{parent}, "The following directory path is not writeable: {0}"));
                Tr.debug(tc, "Export directory is readonly: " + parent);
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0016E", new Object[]{parent}, "The following directory path is not writeable: {0}"));
            }
        }
        File fullPath = new File(pathName);
        if (fullPath.exists()) {
            if (fullPath.isFile()) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0022E", new Object[]{pathName}, "The following output file name already exists: {0}"));
            }
            if (fullPath.isDirectory()) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0023E", new Object[]{pathName}, "The following output file name is a directory: {0}"));
            }
        }
        if (!tc.isEntryEnabled()) return fileList;
        Tr.exit(tc, "validate");
        return fileList;
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String bindingName = (String)this.getParameter("bindingName");
            String pathName = (String)this.getParameter("pathName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{bindingName, pathName});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ExportBinding, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            List fileList = this.validate(session, bindingName, pathName);
            boolean exportStatus = this.exportFiles(fileList, pathName);
            result.setResult(exportStatus);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private boolean exportFiles(List fileList, String outputFile) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportFiles");
        }
        boolean exportStatus = false;
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream ostream = new ZipOutputStream(new FileOutputStream(outputFile));
            for (String fileName : fileList) {
                int len;
                FileInputStream istream = new FileInputStream(fileName);
                fileName = fileName.substring(fileName.indexOf("bindings"));
                fileName = fileName.replace('\\', '/').replaceAll("//", "/");
                ostream.putNextEntry(new ZipEntry(fileName));
                while ((len = istream.read(buf)) > 0) {
                    ostream.write(buf, 0, len);
                }
                ostream.closeEntry();
                istream.close();
            }
            ostream.close();
            exportStatus = true;
        }
        catch (IOException e) {
            Tr.processException(e, this.className, FFDC_ID_2);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportFiles");
        }
        return exportStatus;
    }
}

