/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.ValidationManager;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.ResourceBundle;

public class DeletePolicyType
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeletePolicyType.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String SOURCE_FILE = this.getClass().getName();
    private Session session = null;

    public DeletePolicyType(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public DeletePolicyType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policysetName = (String)this.getParameter("policySet");
            String policytypeName = (String)this.getParameter("policyType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policysetName, policytypeName});
            }
            this.session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeletePolicyType, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            String pathname = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, policysetName, false);
            PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(pathname);
            psHelper.setLocale(this.getLocale());
            if (psHelper.isDefaultPolicySet()) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0004E", new Object[]{policysetName}, "A default policy set cannot be edited: {0}"));
            }
            PolicyTypeWorkSpaceHelper.deletePolicyType(this.session, policysetName, policytypeName);
            int rc = psHelper.deletePolicyType(policytypeName);
            boolean updated = PolicySetWorkSpaceHelper.updatePolicySetFile(this.session, policysetName);
            ValidationManager validationMgr = ValidationManager.getManager(this.session);
            if (validationMgr != null) {
                validationMgr.markForValidation(policysetName);
            }
            if (rc == 0 && updated) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Exception cse) {
            Tr.processException(cse, this.SOURCE_FILE + ".execute", FFDC_ID_1);
            Tr.error(tc, "WSPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finally");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

