/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class DeletePolicySetAttachment
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeletePolicySetAttachment.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    public static final String WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "The client policy attachment file is not found for bus: {0} WSN service: {1}";
    private String className = this.getClass().getName();

    public DeletePolicySetAttachment(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public DeletePolicySetAttachment(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            int rc;
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String applicationName = (String)this.getParameter("applicationName");
            String attachmentID = (String)this.getParameter("attachmentId");
            String attachmentType = (String)this.getParameter("attachmentType");
            Properties attachmentProperties = (Properties)this.getParameter("attachmentProperties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, attachmentID, attachmentType, attachmentProperties});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeletePolicySetAttachment, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (attachmentType == null) {
                attachmentType = "application";
            }
            String busName = null;
            String serviceName = null;
            String systemType = null;
            String cuName = null;
            String cuEdition = null;
            String blaName = null;
            String blaEdition = null;
            if (attachmentProperties != null) {
                boolean validValues = false;
                busName = attachmentProperties.getProperty("bus");
                serviceName = attachmentProperties.getProperty("WSNService");
                if (busName == null && serviceName != null || busName != null && serviceName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (busName != null && serviceName != null) {
                    if (!attachmentType.equals("client")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "attachmentProperties"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                    }
                    attachmentType = "WSNClient";
                    validValues = true;
                }
                if ((systemType = attachmentProperties.getProperty("systemType")) != null) {
                    if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0146E", new Object[]{"attachmentProperties", systemType}, "The application or provider attachment type is required when the systemType property in the {0} parameter is: {1}"));
                    }
                    if (!systemType.equals("trustService")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"systemType"}, "The {0} property does not contain a valid value"));
                    }
                    attachmentType = "system/trust";
                    validValues = true;
                }
                cuName = attachmentProperties.getProperty("cuName");
                cuEdition = attachmentProperties.getProperty("cuEdition");
                blaName = attachmentProperties.getProperty("blaName");
                blaEdition = attachmentProperties.getProperty("blaEdition");
                if (blaName == null) {
                    if (blaEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "blaEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (cuName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "cuName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                }
                if (cuName == null) {
                    if (cuEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "cuEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (blaName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "blaName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                } else {
                    if (busName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "bus"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                    }
                    boolean validBLAName = PolicySetAttachmentCommandUtil.validateBLAName(session, cuName, blaName);
                    if (!validBLAName) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"blaName"}, "The {0} property does not contain a valid value"));
                    }
                    validValues = true;
                }
                if (!validValues) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0114E", new Object[]{"attachmentProperties"}, "The {0} parameter did not contain valid values."));
                }
            } else if (applicationName == null && (attachmentType.equals("application") || attachmentType.equals("client") || attachmentType.equals("provider"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0034E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the attachmentProperties parameter is not specified"));
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            String resourceName = applicationName;
            if (attachmentType.equals("WSNClient")) {
                resourceName = busName;
            } else if (cuName != null && !cuName.equals("")) {
                resourceName = cuName;
            }
            CommonWorkSpaceHelper.validateAttachmentAuthorization(attachmentType, resourceName);
            String pathname = null;
            String errorMsg = null;
            String messageCode = null;
            if (cuName != null && !cuName.equals("")) {
                if (attachmentType.equals("application")) {
                    pathname = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, cuName);
                    errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0168E";
                } else {
                    if (!attachmentType.equals("client")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                    pathname = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(session, cuName);
                    errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0168E";
                }
            } else if (attachmentType.equals("application")) {
                pathname = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, applicationName);
                errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0031E";
            } else if (attachmentType.equals("system/trust")) {
                pathname = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
                errorMsg = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0033E";
            } else if (attachmentType.equals("client")) {
                pathname = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, applicationName);
                errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0032E";
            } else {
                if (!attachmentType.equals("WSNClient")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                pathname = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(session, busName, serviceName);
                errorMsg = WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0108E";
            }
            if (pathname != null) {
                PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(pathname);
                psHelper.setLocale(this.getLocale());
                if (cuName == null && attachmentType.equals("application")) {
                    List<String> resources = psHelper.getPolicySetResources(attachmentID, "id");
                    PolicySetAttachmentWorkSpaceHelper.removeWSPolicy(session, applicationName, resources);
                }
                if (attachmentType.equals("client")) {
                    boolean providerPolicySetEnabled = false;
                    List<String> resources = psHelper.getPolicySetResources(attachmentID, "id");
                    for (String resource : resources) {
                        if (psHelper.getIdForProviderPolicySetAttachment(resource) == null) continue;
                        providerPolicySetEnabled = true;
                        break;
                    }
                    rc = providerPolicySetEnabled ? psHelper.removePolicySetFromAttachment(attachmentID) : psHelper.deleteAttachment(attachmentID);
                } else {
                    rc = psHelper.deleteAttachment(attachmentID);
                }
                boolean attachmentEmpty = psHelper.isAttachmentListEmpty();
                if (cuName != null && !cuName.equals("")) {
                    if (attachmentType.equals("application")) {
                        if (attachmentEmpty) {
                            PolicySetSOAAttachmentWorkSpaceHelper.deletePolicySetAttachmentFile(session, cuName);
                        } else {
                            PolicySetSOAAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, cuName);
                        }
                    } else if (attachmentType.equals("client")) {
                        if (attachmentEmpty) {
                            PolicySetSOAAttachmentWorkSpaceHelper.deleteClientAttachmentFile(session, cuName);
                        } else {
                            PolicySetSOAAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, cuName);
                        }
                    }
                } else if (attachmentType.equals("application")) {
                    if (attachmentEmpty) {
                        PolicySetAttachmentWorkSpaceHelper.deletePolicySetAttachmentFile(session, applicationName);
                    } else {
                        PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, applicationName);
                    }
                } else if (attachmentType.equals("system/trust")) {
                    if (attachmentEmpty) {
                        PolicySetAttachmentWorkSpaceHelper.deleteTrustAttachmentFile(session);
                    } else {
                        PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(session);
                    }
                } else if (attachmentType.equals("client")) {
                    if (attachmentEmpty) {
                        PolicySetAttachmentWorkSpaceHelper.deleteClientAttachmentFile(session, applicationName);
                    } else {
                        PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, applicationName);
                    }
                } else if (attachmentType.equals("WSNClient")) {
                    if (attachmentEmpty) {
                        PolicySetAttachmentWorkSpaceHelper.deleteWSNClientAttachmentFile(session, busName, serviceName);
                    } else {
                        PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(session, busName, serviceName);
                    }
                }
            } else {
                if (attachmentType.equals("WSNClient")) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{busName, serviceName}, errorMsg));
                }
                if (cuName == null || cuName.equals("")) throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{applicationName}, errorMsg));
                throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{cuName}, errorMsg));
            }
            if (rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable t) {
            Tr.processException(t, this.className + ".execute()", FFDC_ID_1);
            result.setException(t);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "execute");
    }
}

