/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class DeletePolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeletePolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String className = this.getClass().getName();

    public DeletePolicySet(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public DeletePolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private void validate(Session session, String policySetName) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String pathname = PolicySetWorkSpaceHelper.getPolicySetFile(session, policySetName, false);
            PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(pathname);
            psHelper.setLocale(this.getLocale());
            String policySetType = psHelper.getPolicySetType();
            if (policySetType.equals("system/trust") || policySetType.equals("system")) {
                List<String> wsMexAttached;
                String attachmentPath = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
                if (attachmentPath != null) {
                    PolicySetAttachmentHelper attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(attachmentPath);
                    attachmentHelper.setLocale(this.getLocale());
                    boolean isAttached = attachmentHelper.isAttachedToPolicySet(policySetName);
                    if (isAttached) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0018E", new Object[]{policySetName}, "Policy set {0} cannot be deleted because it is still attached"));
                    }
                }
                if ((wsMexAttached = PolicySetAttachmentCommandUtil.getApplicationsWithMexAttachmentsToPolicySet(session, policySetName)) != null && !wsMexAttached.isEmpty()) {
                    StringBuffer appBuffer = new StringBuffer("");
                    int appCount = 0;
                    for (String appName : wsMexAttached) {
                        if (appCount > 0) {
                            appBuffer.append(",");
                        }
                        ++appCount;
                        appBuffer.append(appName);
                    }
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0005E", new Object[]{policySetName, appBuffer.toString()}, "Policy set {0} cannot be deleted. It is still attached to the following applications: {1}"));
                }
            } else {
                StringBuffer appBuffer = new StringBuffer("");
                appBuffer = PolicySetAttachmentCommandUtil.getApplicationsAttachedToPolicySet(session, policySetName);
                if (appBuffer.length() > 0) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0005E", new Object[]{policySetName, appBuffer.toString()}, "Policy set {0} cannot be deleted. It is still attached to the following applications: {1}"));
                }
                List<Properties> wsnClientAttached = PolicySetAttachmentCommandUtil.getWSNAttachmentsToPolicySet(session, policySetName);
                if (wsnClientAttached != null && !wsnClientAttached.isEmpty()) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0018E", new Object[]{policySetName, appBuffer.toString()}, "Policy set {0} cannot be deleted because it is still attached"));
                }
                StringBuffer cuBuffer = PolicySetAttachmentCommandUtil.getSOAAttachmentsToPolicySet(session, policySetName);
                if (cuBuffer.length() > 0) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0018E", new Object[]{policySetName, appBuffer.toString()}, "Policy set {0} cannot be deleted because it is still attached"));
                }
            }
        }
        catch (CommandValidationException e) {
            Tr.processException(e, this.className, FFDC_ID_1);
            throw e;
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_2);
            throw new CommandValidationException(t, CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0006E", null, "Unexpected exception during command validation."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policySetName = (String)this.getParameter("policySet");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policySetName});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeletePolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            this.validate(session, policySetName);
            PolicySetWorkSpaceHelper.deletePolicySet(session, policySetName);
            result.setResult(Boolean.TRUE);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_3);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

