/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;

public class CreatePolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(CreatePolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private String className = this.getClass().getName();

    public CreatePolicySet(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public CreatePolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        String policySetName = null;
        try {
            super.validate();
            policySetName = (String)this.getParameter("policySet");
            String policySetDescription = (String)this.getParameter("description");
            String policySetType = (String)this.getParameter("policySetType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policySetName, policySetDescription, policySetType});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            PolicySetCommandUtil.validatePolicySetName(policySetName);
            String pathname = PolicySetWorkSpaceHelper.createPolicySet(session, policySetName);
            PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(pathname);
            psHelper.createPolicySet(policySetDescription, policySetType);
            result.setResult(Boolean.TRUE);
        }
        catch (DuplicateItemFoundException e) {
            Tr.processException(e, this.className, FFDC_ID_1);
            result.setException(e);
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_2);
            try {
                PolicySetWorkSpaceHelper.deletePolicySet(session, policySetName);
            }
            catch (Throwable th) {
                // empty catch block
            }
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

