/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class CopyBinding
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(CopyBinding.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public CopyBinding(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public CopyBinding(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private List validate(Session session, String sourceBindingName, String newBindingName) throws CommandValidationException, WorkSpaceException, NoItemFoundException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        PolicySetCommandUtil.validatePolicySetName(newBindingName);
        List<String> fileList = PolicySetBindingWorkSpaceHelper.getBindingDirectoryFiles(session, sourceBindingName);
        if (fileList.size() < 1) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0125E", new Object[]{sourceBindingName}, "The following binding directory does not contain any files: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return fileList;
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            List domainList;
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            int rc = 0;
            String sourceBinding = (String)this.getParameter("sourceBinding");
            String newBinding = (String)this.getParameter("newBinding");
            String bindingDescription = (String)this.getParameter("newDescription");
            String domainName = (String)this.getParameter("domainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{sourceBinding, newBinding, bindingDescription, domainName});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CopyBinding, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            List fileList = this.validate(session, sourceBinding, newBinding);
            if (domainName != null && !(domainList = PolicySetBindingCommandUtil.getValidDomains(session)).contains(domainName)) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0152E", new Object[]{domainName}, "The {0} domain name is not valid"));
            }
            String filePath = CommonWorkSpaceHelper.getCellRepositoryPath(session);
            String newBindingFilePath = PolicySetBindingWorkSpaceHelper.createNamedBindingDefinitionFile(session, newBinding);
            boolean copyStatus = PolicySetBindingWorkSpaceHelper.copyNamedBindingFiles(session, fileList, filePath, sourceBinding, newBinding);
            if (bindingDescription != null || domainName != null) {
                Properties updatedValues = new Properties();
                if (bindingDescription != null) {
                    updatedValues.setProperty("description", bindingDescription);
                }
                if (domainName != null) {
                    updatedValues.setProperty("domain", domainName);
                }
                BindingDefinitionHelper helper = BindingDefinitionHelperFactory.createHelper(newBindingFilePath);
                helper.setLocale(this.getLocale());
                rc = helper.updateBindingDefinition(updatedValues);
                PolicySetBindingWorkSpaceHelper.updateNamedBindingDefinitionFile(session, newBinding);
            }
            if (copyStatus && rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

