/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetSOAAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.ResourceBundle;

public class AddToPolicySetAttachment
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(AddToPolicySetAttachment.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    public static final String WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "The client policy attachment file is not found for bus: {0} WSN service: {1}";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    protected String className = this.getClass().getName();
    private Session session = null;

    public AddToPolicySetAttachment(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public AddToPolicySetAttachment(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    private void validate(Session session, String applicationName, String attachmentId, String[] resources, String attachmentType, String attachmentFile, boolean dynamicClient, Properties attachmentProperties) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            if (!dynamicClient) {
                if (attachmentType.equals("system/trust")) {
                    StringBuffer resourcesInvalid = new StringBuffer("");
                    resourcesInvalid = PolicySetAttachmentCommandUtil.validateTrustResources(session, resources);
                    if (resourcesInvalid.length() > 0) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resourcesInvalid.toString()}, "The following list of resources are invalid: {0}"));
                    }
                } else {
                    PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                    helper.setLocale(this.getLocale());
                    String policySet = helper.getPolicySetForAttachment(attachmentId);
                    StringBuffer resourcesNotFound = new StringBuffer("");
                    resourcesNotFound = PolicySetAttachmentCommandUtil.validateResourcesForApplication(session, applicationName, resources, attachmentType, policySet, attachmentProperties);
                    if (resourcesNotFound.length() > 0) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resourcesNotFound.toString()}, "The following list of resources are invalid: {0}"));
                    }
                }
                String cuName = null;
                if (attachmentProperties != null) {
                    cuName = attachmentProperties.getProperty("cuName");
                }
                StringBuffer resourcesAttached = new StringBuffer("");
                resourcesAttached = PolicySetAttachmentCommandUtil.validateResourcesNotAttached(attachmentType, attachmentFile, resources, null, false);
                if (resourcesAttached.length() > 0) {
                    if (cuName != null && !cuName.equals("")) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0165E", new Object[]{resourcesAttached.toString()}, "The following resources are already attached to the asset: {0}"));
                    }
                    if (attachmentType.equals("WSNClient")) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0112E", new Object[]{resourcesAttached.toString()}, "The following list of resources are already attached to the WSN service: {0}"));
                    }
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0013E", new Object[]{resourcesAttached.toString()}, "The following list of resources are already attached to the application: {0}"));
                }
            }
        }
        catch (CommandValidationException e) {
            Tr.processException(e, this.className, FFDC_ID_1);
            throw e;
        }
        catch (Throwable t) {
            Tr.processException(t, this.className, FFDC_ID_2);
            throw new CommandValidationException(t, CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0006E", null, "Unexpected exception during command validation."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String applicationName = (String)this.getParameter("applicationName");
            String attachmentId = (String)this.getParameter("attachmentId");
            String[] resources = (String[])this.getParameter("resources");
            String attachmentType = (String)this.getParameter("attachmentType");
            Boolean isDynamicClient = (Boolean)this.getParameter("dynamicClient");
            Properties attachmentProperties = (Properties)this.getParameter("attachmentProperties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, attachmentId, resources, attachmentType, isDynamicClient, attachmentProperties});
            }
            this.session = this.getConfigSession();
            int rc = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddToPolicySetAttachment, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (attachmentType == null) {
                attachmentType = "application";
            }
            boolean dynamicClient = false;
            if (isDynamicClient != null && (dynamicClient = isDynamicClient.booleanValue()) && !attachmentType.equals("client")) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0036E", new Object[0], "Dynamic client only allowed when attachment type is client"));
            }
            String busName = null;
            String serviceName = null;
            String systemType = null;
            String cuName = null;
            String cuEdition = null;
            String blaName = null;
            String blaEdition = null;
            if (attachmentProperties != null) {
                boolean validValues = false;
                busName = attachmentProperties.getProperty("bus");
                serviceName = attachmentProperties.getProperty("WSNService");
                if (busName == null && serviceName != null || busName != null && serviceName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (busName != null && serviceName != null) {
                    if (!attachmentType.equals("client")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "attachmentProperties"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                    }
                    attachmentType = "WSNClient";
                    validValues = true;
                }
                if ((systemType = attachmentProperties.getProperty("systemType")) != null) {
                    if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0146E", new Object[]{"attachmentProperties", systemType}, "The application or provider attachment type is required when the systemType property in the {0} parameter is: {1}"));
                    }
                    if (!systemType.equals("trustService")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"systemType"}, "The {0} property does not contain a valid value"));
                    }
                    attachmentType = "system/trust";
                    validValues = true;
                }
                cuName = attachmentProperties.getProperty("cuName");
                cuEdition = attachmentProperties.getProperty("cuEdition");
                blaName = attachmentProperties.getProperty("blaName");
                blaEdition = attachmentProperties.getProperty("blaEdition");
                if (blaName == null) {
                    if (blaEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "blaEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (cuName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"blaName", "cuName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                }
                if (cuName == null) {
                    if (cuEdition != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "cuEdition"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                    if (blaName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"cuName", "blaName"}, "The {0} input argument must also be specified with the {1} input argument."));
                    }
                } else {
                    if (busName != null) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0166E", new Object[]{"cuName", "bus"}, "The {1} parameter cannot be used if the {0} parameter is specified."));
                    }
                    boolean validBLAName = PolicySetAttachmentCommandUtil.validateBLAName(this.session, cuName, blaName);
                    if (!validBLAName) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"blaName"}, "The {0} property does not contain a valid value"));
                    }
                    validValues = true;
                }
                if (!validValues) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0114E", new Object[]{"attachmentProperties"}, "The {0} parameter did not contain valid values."));
                }
            } else if (applicationName == null && (attachmentType.equals("application") || attachmentType.equals("client") || attachmentType.equals("provider"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0034E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the attachmentProperties parameter is not specified"));
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            String resourceName = applicationName;
            if (attachmentType.equals("WSNClient")) {
                resourceName = busName;
            } else if (cuName != null && !cuName.equals("")) {
                resourceName = cuName;
            }
            CommonWorkSpaceHelper.validateAttachmentAuthorization(attachmentType, resourceName);
            String attachmentFile = null;
            String errorMsg = null;
            String messageCode = null;
            if (cuName != null && !cuName.equals("")) {
                if (attachmentType.equals("application")) {
                    attachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, cuName);
                    errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0168E";
                } else {
                    if (!attachmentType.equals("client")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                    attachmentFile = PolicySetSOAAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, cuName);
                    errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    messageCode = "CWPST0168E";
                }
            } else if (attachmentType.equals("application")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, applicationName);
                errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0031E";
            } else if (attachmentType.equals("system/trust")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(this.session);
                errorMsg = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0033E";
            } else if (attachmentType.equals("client")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, applicationName);
                errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0032E";
            } else {
                if (!attachmentType.equals("WSNClient")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(this.session, busName, serviceName);
                errorMsg = WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0108E";
            }
            if (attachmentFile == null) {
                if (attachmentType.equals("WSNClient")) {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{busName, serviceName}, errorMsg));
                }
                if (cuName == null || cuName.equals("")) throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{applicationName}, errorMsg));
                throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{cuName}, errorMsg));
            }
            this.validate(this.session, applicationName, attachmentId, resources, attachmentType, attachmentFile, dynamicClient, attachmentProperties);
            PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
            helper.setLocale(this.getLocale());
            rc = helper.updatePolicySetAttachment(attachmentId, resources, 2);
            if (cuName != null && !cuName.equals("")) {
                if (attachmentType.equals("application")) {
                    PolicySetSOAAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(this.session, cuName);
                } else if (attachmentType.equals("client")) {
                    PolicySetSOAAttachmentWorkSpaceHelper.updateClientAttachmentFile(this.session, cuName);
                }
            } else if (attachmentType.equals("application")) {
                PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(this.session, applicationName);
            } else if (attachmentType.equals("system/trust")) {
                PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(this.session);
            } else if (attachmentType.equals("client")) {
                PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(this.session, applicationName);
            } else if (attachmentType.equals("WSNClient")) {
                PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(this.session, busName, serviceName);
            }
            if (rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Exception cse) {
            Tr.processException(cse, this.className + ".execute", FFDC_ID_3);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "execute end");
    }
}

