/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin;

import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class PolicyTypeClassLoader {
    private static TraceComponent tc = Tr.register(PolicyTypeClassLoader.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static String className = "com.ibm.ws.policyset.admin.impl.PolicyTypeClassLoader";
    private static Map policyTypeClassMap = new HashMap();
    private static List extensions = null;

    public static synchronized PolicyTypeProvider getPolicyTypeProvider(String policyType) {
        PolicyTypeProvider policyTypeProvider;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyTypeProvider", policyType);
        }
        if ((policyTypeProvider = (PolicyTypeProvider)policyTypeClassMap.get(policyType)) == null) {
            try {
                List extensions = PolicyTypeClassLoader.getExtensions();
                for (PolicyTypeProvider provider : extensions) {
                    try {
                        String type = provider.getType();
                        policyTypeClassMap.put(type, provider);
                    }
                    catch (Throwable t) {
                        Tr.processException(t, className, FFDC_ID_1);
                    }
                }
                policyTypeProvider = (PolicyTypeProvider)policyTypeClassMap.get(policyType);
            }
            catch (Throwable t) {
                Tr.processException(t, className, FFDC_ID_2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyTypeProvider", policyType);
        }
        return policyTypeProvider;
    }

    private static List getExtensions() throws Throwable {
        if (extensions == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading policy type admin class extensions");
            }
            extensions = new ArrayList();
            try {
                String extensionPointId = "com.ibm.wsfp.main.ibmaxis2-qos-admin-policytypeloader";
                IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
                IConfigurationElement[] elements = registry.getConfigurationElementsFor(extensionPointId);
                for (int i = 0; i < elements.length; ++i) {
                    try {
                        String classname = elements[i].getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found " + classname);
                        }
                        Class<?> loaderClass = Class.forName(classname);
                        Constructor<?> constructor = loaderClass.getConstructor(new Class[0]);
                        PolicyTypeProvider policyTypeClass = (PolicyTypeProvider)constructor.newInstance(new Object[0]);
                        extensions.add(policyTypeClass);
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.processException(t, className, FFDC_ID_3);
                        Tr.warning(tc, "CWPST0094E", new Object[]{elements[i].getValue()});
                    }
                }
            }
            catch (Throwable t) {
                Tr.processException(t, className, FFDC_ID_4);
                throw t;
            }
        }
        return extensions;
    }
}

