/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class StatsConfigHelper
implements PmiConstants {
    private static HashMap rawConfigMap = new HashMap();
    private static HashMap localeMap = new HashMap();
    private static HashMap nlsMap = new HashMap();
    private static boolean debug = false;
    private static final String PMI_RESOURCE_BUNDLE = "com.ibm.ws.pmi.properties.PMIText";
    private static final String PMI_RESOURCE_BUNDLE_PREFIX_50 = "com.ibm.websphere.pmi.property.";
    private static final TraceComponent tc = Tr.register(StatsConfigHelper.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public static void setDebug(boolean dbg) {
        debug = dbg;
    }

    private static final String getNlsKey(String resourceBundle, Locale locale) {
        return new StringBuffer(resourceBundle).append("#").append(locale.toString()).toString();
    }

    private static HashMap getConfigMap(Locale l) {
        HashMap aConfigMap;
        if (l == null) {
            l = Locale.getDefault();
        }
        if ((aConfigMap = (HashMap)localeMap.get(l.toString())) == null) {
            aConfigMap = new HashMap();
            localeMap.put(l.toString(), aConfigMap);
        }
        return aConfigMap;
    }

    private static PmiModuleConfig getConfig(Locale l, String statsType) {
        PmiModuleConfig acfg = (PmiModuleConfig)StatsConfigHelper.getConfigMap(l).get(statsType);
        if (debug && acfg != null) {
            System.out.println("[StatsConfigHelper] getConfig cache hit for: " + statsType);
        }
        return acfg;
    }

    private static NLS getNLS(Locale l, String resourceBundle, String statsType) {
        boolean bDefaultLocale = false;
        if (l == null || l == Locale.getDefault()) {
            bDefaultLocale = true;
            l = Locale.getDefault();
        }
        NLS aNLS = null;
        if (resourceBundle == null) {
            int trial = 1;
            do {
                if (trial == 1) {
                    resourceBundle = PMI_RESOURCE_BUNDLE_PREFIX_50 + statsType;
                } else if (trial == 2) {
                    resourceBundle = PMI_RESOURCE_BUNDLE;
                }
                aNLS = (NLS)nlsMap.get(StatsConfigHelper.getNlsKey(resourceBundle, l));
                if (aNLS == null) continue;
                return aNLS;
            } while (!(aNLS = new NLS(resourceBundle, l, true, false)).isResourceLoaded() && ++trial <= 2);
        } else {
            aNLS = (NLS)nlsMap.get(StatsConfigHelper.getNlsKey(resourceBundle, l));
            if (aNLS != null) {
                return aNLS;
            }
            aNLS = new NLS(resourceBundle, l, true, false);
            if (!aNLS.isResourceLoaded()) {
                block14: {
                    final String _rbName = resourceBundle;
                    final Locale _locale = l;
                    try {
                        aNLS = (NLS)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new NLS(_rbName, _locale, Thread.currentThread().getContextClassLoader());
                            }
                        });
                    }
                    catch (Exception e1) {
                        Tr.warning(tc, "PMI0030W", resourceBundle);
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Error loading custom resource bundle using context classloader: " + e1.getMessage());
                    }
                }
                if (aNLS == null || !aNLS.isResourceLoaded()) {
                    aNLS = null;
                }
            }
        }
        if (aNLS != null && aNLS.isResourceLoaded()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caching resource bundle: " + resourceBundle + " locale: " + l);
            }
            nlsMap.put(StatsConfigHelper.getNlsKey(resourceBundle, l), aNLS);
        }
        return aNLS;
    }

    public static String getTranslatedStatsName(String statsName, String statsType, Locale locale) {
        String[] _stats = StatsConfigHelper.parseStatsType(statsType);
        for (int i = 0; i < _stats.length; ++i) {
            String trName;
            NLS aNLS;
            PmiModuleConfig cfg = StatsConfigHelper.getTranslatedStatsConfig(_stats[i], locale);
            if (cfg == null || (aNLS = StatsConfigHelper.getNLS(locale, cfg.getResourceBundle(), statsType)) == null) continue;
            try {
                trName = aNLS.getString(statsName);
            }
            catch (MissingResourceException mre) {
                trName = statsName;
            }
            if (trName == null) continue;
            return trName;
        }
        return statsName;
    }

    public static String getTranslatedStatsName(String statsName, String statsType) {
        return StatsConfigHelper.getTranslatedStatsName(statsName, statsType, Locale.getDefault());
    }

    public static PmiModuleConfig getStatsConfig(String statsType) {
        PmiModuleConfig cfg = (PmiModuleConfig)rawConfigMap.get(statsType);
        if (cfg == null) {
            cfg = StatsConfigHelper._getStatsConfig(statsType, false, null);
        }
        return cfg;
    }

    public static PmiModuleConfig getTranslatedStatsConfig(String statsType) {
        return StatsConfigHelper.getTranslatedStatsConfig(statsType, Locale.getDefault());
    }

    public static PmiModuleConfig getTranslatedStatsConfig(String statsType, Locale locale) {
        PmiModuleConfig aCfg = StatsConfigHelper.getConfig(locale, statsType);
        if (aCfg == null) {
            aCfg = StatsConfigHelper._getStatsConfig(statsType, true, locale);
        }
        return aCfg;
    }

    private static PmiModuleConfig _getStatsConfig(String statsType, boolean bXlate, Locale locale) {
        String[] _statsType;
        if (statsType == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getStatsConfig for {statType, locale}:  " + statsType + ", " + locale.getLanguage());
        }
        String preCustomSubModule = null;
        boolean bPreCustomSubModule = false;
        boolean bPreCustomCategory = false;
        int hashPos = statsType.indexOf(35);
        if (hashPos > 0) {
            _statsType = new String[]{statsType.substring(0, hashPos)};
            if (hashPos + 1 < statsType.length()) {
                preCustomSubModule = statsType.substring(hashPos + 1, statsType.length());
            }
            if (preCustomSubModule == null) {
                bPreCustomSubModule = true;
            } else if (preCustomSubModule.startsWith("ejb.")) {
                bPreCustomCategory = true;
            } else {
                bPreCustomSubModule = true;
            }
        } else {
            _statsType = StatsConfigHelper.parseStatsType(statsType);
        }
        if (_statsType == null || _statsType.length == 0) {
            return null;
        }
        PmiModuleConfig[] config2 = new PmiModuleConfig[_statsType.length];
        for (int i = 0; i < _statsType.length; ++i) {
            int hasDot;
            PmiModuleConfig cfg;
            if (bXlate) {
                cfg = StatsConfigHelper.getConfig(locale, _statsType[i]);
                if (cfg != null) {
                    config2[i] = cfg;
                    continue;
                }
            } else {
                cfg = (PmiModuleConfig)rawConfigMap.get(_statsType[i]);
                if (cfg != null) {
                    config2[i] = cfg;
                    continue;
                }
            }
            if ((hasDot = _statsType[i].indexOf(46)) == -1) {
                String preDefinedMod = "/com/ibm/websphere/pmi/xml/" + _statsType[i] + ".xml";
                config2[i] = PerfModules.getConfigFromXMLFile(preDefinedMod, false, false);
            }
            if (config2[i] == null) {
                config2[i] = PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(_statsType[i]), false, true);
            }
            if (config2[i] == null || !bXlate) continue;
            StatsConfigHelper.translate(config2[i], locale);
        }
        PmiModuleConfig oneConfig = new PmiModuleConfig(statsType);
        if (_statsType.length >= 1 && config2[0] != null) {
            oneConfig.setResourceBundle(config2[0].getResourceBundle());
            oneConfig.setDescription(config2[0].getDescription());
        }
        if (bPreCustomSubModule) {
            if (config2[0] != null) {
                PmiDataInfo[] data = config2[0].listData(null);
                for (int k = 0; k < data.length; ++k) {
                    if (data[k].getType() == 15) continue;
                    if (data[k].getSubmoduleName() == null) {
                        if (preCustomSubModule != null) continue;
                        oneConfig.addData(data[k]);
                        continue;
                    }
                    if (!data[k].getSubmoduleName().equals(preCustomSubModule)) continue;
                    oneConfig.addData(data[k]);
                }
            }
        } else if (bPreCustomCategory) {
            if (config2[0] != null) {
                PmiDataInfo[] data = config2[0].listData(preCustomSubModule);
                for (int k = 0; k < data.length; ++k) {
                    if (data[k].getSubmoduleName() != null) continue;
                    oneConfig.addData(data[k]);
                }
            }
        } else {
            for (int i = 0; i < _statsType.length; ++i) {
                if (config2[i] == null) continue;
                if (debug) {
                    System.out.println("[StatsConfigHelper] adding config for: " + config2[i].getUID());
                }
                PmiDataInfo[] data = config2[i].listData(null);
                for (int k = 0; k < data.length; ++k) {
                    if (i != 0) {
                        if (!data[k].isAggregatable() || data[k].getType() == 15) continue;
                        oneConfig.addData(data[k]);
                        continue;
                    }
                    if (data[k].getType() == 15) continue;
                    oneConfig.addData(data[k]);
                }
            }
        }
        if (bXlate) {
            StatsConfigHelper.getConfigMap(locale).put(oneConfig.getUID(), oneConfig);
        } else {
            rawConfigMap.put(oneConfig.getUID(), oneConfig);
        }
        return oneConfig;
    }

    private static String _getStringFromRB(ResourceBundle rb, String key) {
        try {
            return rb.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    private static PmiModuleConfig translate(PmiModuleConfig cfg, Locale locale) {
        NLS nls = StatsConfigHelper.getNLS(locale, cfg.getResourceBundle(), cfg.getUID());
        if (nls != null) {
            try {
                cfg.setDescription(nls.getString(cfg.getDescription()));
            }
            catch (MissingResourceException mre) {
                cfg.setDescription(cfg.getDescription());
            }
            PmiDataInfo[] counterInfo = cfg.listAllData();
            for (int i = 0; i < counterInfo.length; ++i) {
                try {
                    counterInfo[i].setName(nls.getString(counterInfo[i].getName(), counterInfo[i].getName()));
                }
                catch (MissingResourceException mre) {
                    counterInfo[i].setName(counterInfo[i].getName());
                }
                try {
                    counterInfo[i].setDescription(nls.getString(counterInfo[i].getDescription(), counterInfo[i].getDescription()));
                }
                catch (MissingResourceException mre) {
                    counterInfo[i].setDescription(counterInfo[i].getDescription());
                }
                try {
                    counterInfo[i].setUnit(nls.getString(counterInfo[i].getUnit()));
                    continue;
                }
                catch (MissingResourceException mre) {
                    counterInfo[i].setUnit(counterInfo[i].getUnit());
                }
            }
        }
        return cfg;
    }

    public static void translateAndCache(PmiModuleConfig cfg, Locale l) {
        PmiModuleConfig aCfg = StatsConfigHelper.getConfig(l, cfg.getUID());
        if (aCfg == null) {
            aCfg = cfg.copy();
            if (aCfg != null) {
                PmiDataInfo[] data = aCfg.listData(null);
                for (int k = data.length - 1; k >= 0; --k) {
                    if (data[k].getType() != 15) continue;
                    aCfg.removeData(data[k]);
                }
            }
            aCfg = StatsConfigHelper.translate(aCfg, l);
            StatsConfigHelper.getConfigMap(l).put(aCfg.getUID(), aCfg);
        }
    }

    public static PmiModuleConfig[] getAllConfigs(Locale l) {
        HashMap aMap = StatsConfigHelper.getConfigMap(l);
        Iterator i = aMap.values().iterator();
        PmiModuleConfig[] cfg = new PmiModuleConfig[aMap.size()];
        int k = 0;
        while (i.hasNext()) {
            cfg[k++] = (PmiModuleConfig)i.next();
        }
        return cfg;
    }

    public static void initConfig(PmiModuleConfig[] cfg, Locale l) {
        if (cfg == null) {
            return;
        }
        HashMap aMap = StatsConfigHelper.getConfigMap(l);
        for (int i = 0; i < cfg.length; ++i) {
            aMap.put(cfg[i].getUID(), cfg[i]);
        }
    }

    private static String[] parseStatsType(String type) {
        StringTokenizer parser = new StringTokenizer(type, ",");
        String[] statTypes = new String[parser.countTokens()];
        int i = 0;
        while (parser.hasMoreTokens()) {
            statTypes[i++] = parser.nextToken();
        }
        return statTypes;
    }

    public static String getStatsType(int type) {
        switch (type) {
            case 2: {
                return "CountStatistic";
            }
            case 3: {
                return "DoubleStatistic";
            }
            case 4: {
                return "TimeStatistic";
            }
            case 5: {
                return "BoundedRangeStatistic";
            }
            case 6: {
                return "AverageStatistic";
            }
            case 7: {
                return "RangeStatistic";
            }
        }
        return "undefined";
    }

    public static String getLevelString(int level) {
        switch (level) {
            case 0: {
                return "none";
            }
            case 1: {
                return "low";
            }
            case 3: {
                return "medium";
            }
            case 7: {
                return "high";
            }
            case 15: {
                return "maximum";
            }
        }
        return "undefined";
    }

    public static void main(String[] args) {
        System.out.println(StatsConfigHelper.getTranslatedStatsName("root.MyStats", "com.ibm.websphere.fvt.pmi.custom.CustomStats1,com.ibm.websphere.fvt.pmi.custom.EmptyStats"));
        if (args == null || args.length < 2) {
            System.out.println("Usage: StatsConfigHelper <statsType> <r, e, t>");
            return;
        }
        debug = true;
        PmiModuleConfig c = null;
        if (args[1].equals("r")) {
            c = StatsConfigHelper.getStatsConfig(args[0]);
        } else if (args[1].equals("e")) {
            c = StatsConfigHelper.getTranslatedStatsConfig(args[0], null);
        } else if (args[1].equals("t")) {
            c = StatsConfigHelper.getTranslatedStatsConfig(args[0], new Locale(args[2]));
        }
        if (c != null) {
            System.out.println(c.toString());
        } else {
            System.out.println("Config is null");
        }
        if (args[1].equals("r")) {
            c = StatsConfigHelper.getStatsConfig(args[0]);
        } else if (args[1].equals("e")) {
            c = StatsConfigHelper.getTranslatedStatsConfig(args[0], null);
        } else if (args[1].equals("t")) {
            c = StatsConfigHelper.getTranslatedStatsConfig(args[0], new Locale(args[2]));
        }
        if (c != null) {
            System.out.println(c.toString());
        } else {
            System.out.println("Config is null");
        }
    }
}

