/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WLMPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class WLMModule
extends PmiAbstractModule
implements WLMPerf {
    private static final long serialVersionUID = -7113935544494127417L;
    private static TraceComponent tc = Tr.register(WLMModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "wlmModule";
    public static final int defaultLevel = 0;
    private int localConcurrentRequests = 0;
    private String moduleName = null;
    private Set clientSet = Collections.synchronizedSet(new HashSet());
    private static ThreadLocal serverStartTime = new ThreadLocal();
    private static ThreadLocal clientStartTime = new ThreadLocal();
    public static final int NUM_INCOMING_REQUESTS = 11;
    public static final int NUM_STRONG_AFFINITY_REQUESTS = 12;
    public static final int NUM_WEAK_AFFINITY_REQUESTS = 13;
    public static final int NUM_NON_AFFINITY_REQUESTS = 14;
    public static final int NUM_NON_WLM_OBJECT_REQUESTS = 15;
    public static final int NUM_SERVER_CLUSTER_UPDATES = 16;
    public static final int NUM_CLIENTS_SERVICED = 17;
    public static final int NUM_CONCURRENT_REQUESTS = 18;
    public static final int SERVER_RESPONSE_TIME = 19;
    public static final int NUM_OUTGOING_REQUESTS = 51;
    public static final int NUM_CLIENT_CLUSTER_UPDATES = 52;
    public static final int CLIENT_RESPONSE_TIME = 53;
    public static final byte STRONG_AFFINITY = 2;
    public static final byte WEAK_AFFINITY = 1;
    public static final byte NO_AFFINITY = 0;
    SPICountStatistic numIncomingRequests = null;
    SPICountStatistic numIncomingStrongAffinityRequests = null;
    SPICountStatistic numIncomingWeakAffinityRequests = null;
    SPICountStatistic numIncomingNonAffinityRequests = null;
    SPICountStatistic numIncomingNonWLMObjectRequests = null;
    SPICountStatistic numServerClusterUpdates = null;
    SPICountStatistic numClientsServiced = null;
    SPIRangeStatistic numConcurrentRequests = null;
    SPITimeStatistic serverResponseTime = null;
    SPICountStatistic numOutgoingRequests = null;
    SPICountStatistic numClientClusterUpdates = null;
    SPITimeStatistic clientResponseTime = null;

    public WLMModule(String moduleName) {
        super(moduleID, moduleName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CTOR:submoduleName=" + moduleName);
        }
        this.submoduleName = moduleName;
        this.type = 15;
        this.registerModule(this);
    }

    public String[] getPath() {
        return new String[]{moduleID, this.submoduleName};
    }

    public void onIncomingWLMRequest(ServerRequestInfo sri, int clientId, int affinityType) {
        if (this.numConcurrentRequests != null) {
            this.numConcurrentRequests.increment();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onIncomingWLMRequest:currentLevel=" + this.currentLevel);
        }
        if (this.serverResponseTime != null) {
            serverStartTime.set(new Long(System.currentTimeMillis()));
        }
        if (this.numIncomingRequests != null) {
            this.numIncomingRequests.increment();
        }
        if (clientId == -1) {
            if (this.numIncomingNonWLMObjectRequests != null) {
                this.numIncomingNonWLMObjectRequests.increment();
            }
            if (this.numIncomingNonAffinityRequests != null) {
                this.numIncomingNonAffinityRequests.increment();
            }
        } else {
            Integer intObj;
            if (affinityType == 2) {
                if (this.numIncomingStrongAffinityRequests != null) {
                    this.numIncomingStrongAffinityRequests.increment();
                }
            } else if (affinityType == 1) {
                if (this.numIncomingWeakAffinityRequests != null) {
                    this.numIncomingWeakAffinityRequests.increment();
                }
            } else if (affinityType == 0 && this.numIncomingNonAffinityRequests != null) {
                this.numIncomingNonAffinityRequests.increment();
            }
            if (!this.clientSet.contains(intObj = new Integer(clientId))) {
                this.clientSet.add(intObj);
                if (this.numClientsServiced != null) {
                    this.numClientsServiced.setCount(this.clientSet.size());
                }
            }
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "onIncomingWLMRequest:method=" + sri.operation() + ":requestId=" + sri.request_id() + ":clientId=" + clientId + ":affinityType=" + affinityType);
        }
    }

    public void onOutgoingWLMReply(ServerRequestInfo sri) {
        Long beginObj;
        if (this.numConcurrentRequests != null) {
            this.numConcurrentRequests.decrement();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onOutgoingWLMReply:currentLevel=" + this.currentLevel);
        }
        if (sri.reply_status() == 1) {
            return;
        }
        long delta = 0L;
        if (this.serverResponseTime != null && (beginObj = (Long)serverStartTime.get()) != null) {
            long begin = beginObj;
            delta = System.currentTimeMillis() - begin;
            this.serverResponseTime.add(delta * 1L);
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "onOutgoingWLMReply:method=" + sri.operation() + ":requestId=" + sri.request_id() + ":numServiced=" + this.clientSet.size() + ":responseTm=" + delta);
        }
    }

    public void onOutgoingWLMRequest(ClientRequestInfo cri) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onOutgoingWLMRequest:currentLevel=" + this.currentLevel);
        }
        if (this.numOutgoingRequests != null) {
            this.numOutgoingRequests.increment();
        }
        if (this.clientResponseTime != null) {
            clientStartTime.set(new Long(System.currentTimeMillis()));
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "onOutgoingWLMRequest:method=" + cri.operation() + ":requestId=" + cri.request_id());
        }
    }

    public void onIncomingWLMReply(ClientRequestInfo cri) {
        Long beginObj;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onIncomingWLMReply:currentLevel=" + this.currentLevel);
        }
        long delta = 0L;
        if (this.clientResponseTime != null && (beginObj = (Long)clientStartTime.get()) != null) {
            long begin = beginObj;
            delta = System.currentTimeMillis() - begin;
            this.clientResponseTime.add(delta);
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "onIncomingWLMReply:method=" + cri.operation() + ":requestId=" + cri.request_id() + ":responseTm=" + delta);
        }
    }

    public void onServerClusterUpdate() {
        if (this.numServerClusterUpdates != null) {
            this.numServerClusterUpdates.increment();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "onServerClusterUpdate:numServerClusterUpdates=" + this.numServerClusterUpdates.getCount());
            }
        }
    }

    public void onClientClusterUpdate() {
        if (this.numClientClusterUpdates != null) {
            this.numClientClusterUpdates.increment();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "onClientClusterUpdate:numClientClusterUpdates=" + this.numClientClusterUpdates.getCount());
            }
        }
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 11: {
                this.numIncomingRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 12: {
                this.numIncomingStrongAffinityRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 13: {
                this.numIncomingWeakAffinityRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 14: {
                this.numIncomingNonAffinityRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 15: {
                this.numIncomingNonWLMObjectRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 16: {
                this.numServerClusterUpdates = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 17: {
                this.numClientsServiced = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 51: {
                this.numOutgoingRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 52: {
                this.numClientClusterUpdates = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        switch (data.getId()) {
            case 18: {
                this.numConcurrentRequests = (SPIRangeStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 19: {
                this.serverResponseTime = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 53: {
                this.clientResponseTime = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    protected void initializeMe(int newLevel) {
        if (this.currentLevel >= 7 || newLevel < 7) {
            return;
        }
        long numRequests = 0L;
        if (this.numConcurrentRequests != null) {
            numRequests = this.numConcurrentRequests.getCurrent();
        }
        if (numRequests < 0L) {
            this.numConcurrentRequests.setLastValue(0L);
        }
        this.clientSet.clear();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "initializeMe:concurrentRequests=" + this.numConcurrentRequests.getCurrent());
        }
    }
}

