/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleAggregate;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdGroup;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.stat.JCAStatsImpl;
import com.ibm.ws.pmi.stat.JDBCStatsImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.util.ArrayList;
import javax.management.ObjectName;

public class ResourcePmiModule
extends PmiAbstractModule
implements PmiModuleAggregate {
    private static final long serialVersionUID = -2305064548251234563L;
    private String moduleID = null;
    private final int defaultLevel = 0;
    private ObjectName providerOName = null;
    private static final TraceComponent tc = Tr.register(ResourcePmiModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public ResourcePmiModule(String moduleName, String name, ObjectName providerOName) {
        super(moduleName, name);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ResourcePmiModule, moduleID=" + moduleName + ", name=" + name);
        }
        this.moduleID = moduleName;
        this.providerOName = providerOName;
        this.mbeanName = providerOName;
        this.aggregateModule = true;
        this.registerModule(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ResourcePmiModule");
        }
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public synchronized void add(PmiModule instance) {
        if (instance == null) {
            return;
        }
        this.add(instance.listData());
    }

    public synchronized void remove(PmiModule instance) {
        if (instance == null) {
            return;
        }
        this.remove(instance.listData());
    }

    public synchronized void add(SpdData[] dataList) {
        if (dataList == null || this.moduleConfig == null) {
            return;
        }
        for (int i = 0; i < dataList.length; ++i) {
            int dataId = dataList[i].getId();
            PmiDataInfo info = this.moduleConfig.getDataInfo(dataId);
            if (info == null || !info.isAggregatable()) continue;
            SpdGroup aggregateData = (SpdGroup)this.dataTable.get(new Integer(dataId));
            if (aggregateData == null) {
                aggregateData = (SpdGroup)this.createAggregateData(info);
                if (aggregateData != null) {
                    this.putToTable(aggregateData);
                }
                if (info.getLevel() > this.currentLevel) {
                    aggregateData.disable();
                }
            }
            aggregateData.add(dataList[i]);
        }
    }

    public synchronized void remove(SpdData[] dataList) {
        if (dataList == null) {
            return;
        }
        for (int i = 0; i < dataList.length; ++i) {
            SpdGroup aggregateData = (SpdGroup)this.dataTable.get(new Integer(dataList[i].getId()));
            if (aggregateData == null) continue;
            aggregateData.remove(dataList[i]);
        }
    }

    public synchronized boolean remove(SpdData data) {
        if (data == null) {
            return false;
        }
        SpdGroup aggregateData = (SpdGroup)this.dataTable.get(new Integer(data.getId()));
        if (aggregateData == null) {
            return false;
        }
        return aggregateData.remove(data);
    }

    public StatsImpl getJSR77Stats(ModuleItem mItem) {
        ModuleItem[] items = mItem.children();
        ArrayList<StatsImpl> colMembers = null;
        if (items != null) {
            colMembers = new ArrayList<StatsImpl>(items.length);
            for (int i = 0; i < items.length; ++i) {
                colMembers.add(items[i].getInstance().getJSR77Stats(null));
            }
        }
        if (this.moduleID.equals("j2cModule")) {
            return new JCAStatsImpl(this.name, this.type, this.currentLevel, null, colMembers);
        }
        if (this.moduleID.equals("connectionPoolModule")) {
            return new JDBCStatsImpl(this.name, this.type, this.currentLevel, null, colMembers);
        }
        return null;
    }
}

