/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;

public class StatsHelper {
    public static String statsToTclAttrString(StatsImpl stats, DataDescriptor dd, String nodeName, String serverName) {
        return StatsHelper.statsToTclAttrString(null, stats, dd, nodeName, serverName);
    }

    public static String statsToTclAttrString(String desc, StatsImpl stats, DataDescriptor dd, String nodeName, String serverName) {
        StatsImpl[] substats;
        if (stats == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer(256);
        String childdesc = desc;
        String modName = stats.getStatsType();
        if (modName == null) {
            modName = dd.getModuleName();
        }
        if (modName == null) {
            modName = "pmi";
        }
        if (desc == null) {
            if (modName.equals("pmi")) {
                desc = "PMI data for server";
                childdesc = null;
            } else {
                PmiModuleConfig config2 = PmiRegistry.getConfig(modName);
                childdesc = desc = config2.getDescription();
            }
        }
        rv.append("{Description ").append(desc).append("} ");
        rv.append("{Descriptor ").append(StatsHelper.safeString(StatsHelper.pmiDescriptorToTclAttrString(modName, dd, nodeName, serverName))).append("} ");
        rv.append("{Level ").append(stats.getLevel()).append("}");
        DataDescriptor mydd = null;
        StatisticImpl[] dataMembers = (StatisticImpl[])stats.listStatistics();
        if (dataMembers != null && dataMembers.length > 0) {
            rv.append(" {Data {");
            for (int i = 0; i < dataMembers.length; ++i) {
                mydd = new DataDescriptor(dd, dataMembers[i].getId());
                rv.append("{").append(StatsHelper.statisticToTclAttrString(dataMembers[i], stats.getTime(), modName, mydd, nodeName, serverName)).append("}");
                if (i >= dataMembers.length - 1) continue;
                rv.append(" ");
            }
            rv.append("}}");
        }
        if ((substats = (StatsImpl[])stats.listSubStats()) != null && substats.length > 0) {
            rv.append(" {SubCollections {");
            for (int i = 0; i < substats.length; ++i) {
                mydd = new DataDescriptor(dd, substats[i].getName());
                rv.append("{").append(StatsHelper.statsToTclAttrString(childdesc, substats[i], mydd, nodeName, serverName)).append("}");
                if (i >= substats.length - 1) continue;
                rv.append(" ");
            }
            rv.append("}}");
        }
        return rv.toString();
    }

    public static String statisticToTclAttrString(StatisticImpl stats, long time, String modName, DataDescriptor dd, String nodeName, String serverName) {
        if (stats == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer(256);
        rv.append("{Id ").append(stats.getId()).append("} ");
        rv.append("{Descriptor ").append(StatsHelper.safeString(StatsHelper.pmiDescriptorToTclAttrString(modName, dd, nodeName, serverName))).append("} ");
        rv.append("{PmiDataInfo ").append(StatsHelper.safeString(StatsHelper.pmiDataInfoToTclAttrString(stats.getDataInfo()))).append("} ");
        rv.append("{Time ").append(time).append("} ");
        rv.append("{Value ").append(StatsHelper.statisticToValue(stats)).append("}");
        return rv.toString();
    }

    private static String statisticToValue(StatisticImpl statData) {
        if (statData == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer();
        if (statData instanceof CountStatisticImpl) {
            CountStatisticImpl tmp = (CountStatisticImpl)statData;
            rv.append("{Count ").append(tmp.getCount()).append("} ");
        } else if (statData instanceof TimeStatisticImpl) {
            TimeStatisticImpl tmp = (TimeStatisticImpl)statData;
            rv.append("{Total ").append(tmp.getTotal()).append("} ");
            rv.append("{Count ").append(tmp.getCount()).append("} ");
            rv.append("{Mean ").append(tmp.getMean()).append("} ");
        } else if (statData instanceof RangeStatisticImpl) {
            RangeStatisticImpl tmp = (RangeStatisticImpl)statData;
            rv.append("{Current ").append(tmp.getCurrent()).append("} ");
            rv.append("{LowWaterMark ").append(tmp.getLowWaterMark()).append("} ");
            rv.append("{HighWaterMark ").append(tmp.getHighWaterMark()).append("} ");
            rv.append("{MBean ").append(tmp.getMean()).append("} ");
        }
        return rv.toString();
    }

    public static String pmiDataInfoToTclAttrString(PmiDataInfo pmi) {
        if (pmi == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer();
        rv.append("{Name ").append(StatsHelper.safeString(pmi.getName())).append("} ");
        rv.append("{Id ").append(pmi.getId()).append("} ");
        rv.append("{Description ").append(StatsHelper.safeString(pmi.getDescription())).append("} ");
        rv.append("{Level ").append(pmi.getLevel()).append("} ");
        rv.append("{Comment ").append(StatsHelper.safeString(pmi.getComment())).append("} ");
        rv.append("{SubmoduleName ").append(StatsHelper.safeString(pmi.getSubmoduleName())).append("} ");
        rv.append("{Type ").append(pmi.getType()).append("} ");
        rv.append("{Unit ").append(pmi.getUnit()).append("} ");
        rv.append("{Resettable ").append(pmi.isResettable()).append("}");
        return rv.toString();
    }

    public static String pmiDescriptorToTclAttrString(String modName, DataDescriptor dd, String nodeName, String serverName) {
        StringBuffer rv = new StringBuffer();
        rv.append("{Node ").append(StatsHelper.safeString(nodeName)).append("} ");
        rv.append("{Server ").append(StatsHelper.safeString(serverName)).append("} ");
        if (dd.getType() != 12) {
            rv.append("{Module ").append(StatsHelper.safeString(modName)).append("} ");
            rv.append("{Name ").append(StatsHelper.safeString(dd.getName())).append("} ");
        }
        rv.append("{Type ").append(StatsHelper.pdTypeToString(dd.getType())).append("}");
        return rv.toString();
    }

    public static String pdTypeToString(int i) {
        switch (i) {
            case 10: {
                return "ROOT";
            }
            case 11: {
                return "NODE";
            }
            case 12: {
                return "SERVER";
            }
            case 13: {
                return "MODULE";
            }
            case 14: {
                return "INSTANCE";
            }
            case 15: {
                return "SUBMODULE";
            }
            case 16: {
                return "SUBINSTANCE";
            }
            case 17: {
                return "COLLECTION";
            }
            case 18: {
                return "DATA";
            }
            case 24: {
                return "MODULEROOT";
            }
        }
        return "UNKNOWN";
    }

    private static String safeString(String in) {
        if (null == in) {
            return in;
        }
        if (-1 != in.indexOf(" ")) {
            return "{" + in + "}";
        }
        return in;
    }
}

