/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.client.PerfLevelSpec;

public class PerfLevelDescriptor
implements PerfLevelSpec,
PmiConstants {
    private static final long serialVersionUID = -5934872678821227124L;
    static final int MODULE_INDEX = 1;
    static final int SUBMODULE_INDEX = 3;
    String[] path;
    int level;
    static final String pmiroot = "pmi";
    private String moduleID;

    public PerfLevelDescriptor(String[] path, int level, String modID) {
        this(path, level);
        this.moduleID = modID;
    }

    public PerfLevelDescriptor(String[] path, int level) {
        if (level == 2) {
            level = 0;
        }
        this.level = level;
        if (path == null) {
            this.path = new String[]{pmiroot};
        } else if (path[0].equals(pmiroot)) {
            this.path = path;
        } else {
            String[] newPath = new String[path.length + 1];
            newPath[0] = pmiroot;
            System.arraycopy(path, 0, newPath, 1, path.length);
            this.path = newPath;
        }
        if (this.path.length > 3) {
            if (this.path[3].equals("methods")) {
                this.path[3] = "beanModule.methods";
            } else if (this.path[3].equals("servlets")) {
                this.path[3] = "webAppModule.servlets";
            }
        }
    }

    public String[] getPath() {
        return this.path;
    }

    public String[] getShortPath() {
        if (this.path == null || this.path.length == 0) {
            return null;
        }
        int index = 0;
        if (this.path[0].equals(pmiroot)) {
            index = 1;
        }
        if (index == 0) {
            return this.path;
        }
        String[] ret = new String[this.path.length - index];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.path[i + index];
        }
        return ret;
    }

    public int comparePath(PerfLevelSpec otherDesc) {
        return this.comparePath(otherDesc.getPath());
    }

    public int comparePath(String[] otherPath) {
        if (this.path == null) {
            return -1;
        }
        if (otherPath == null) {
            return 1;
        }
        int minLen = this.path.length < otherPath.length ? this.path.length : otherPath.length;
        for (int i = 0; i < minLen; ++i) {
            int result = this.path[i].compareTo(otherPath[i]);
            if (result == 0) continue;
            return result;
        }
        return this.path.length - otherPath.length;
    }

    public boolean isSubPath(PerfLevelSpec otherDesc) {
        return this.isSubPath(otherDesc.getPath());
    }

    public boolean isSubPath(String[] otherPath) {
        if (this.path == null || otherPath == null) {
            return false;
        }
        if (this.path.length >= otherPath.length) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            int result = this.path[i].compareTo(otherPath[i]);
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public String getModuleName() {
        if (this.moduleID != null) {
            return this.moduleID;
        }
        if (this.path != null && this.path.length > 1) {
            return this.path[1];
        }
        return null;
    }

    public String getSubmoduleName() {
        if (this.path != null && this.path.length > 3) {
            return this.path[3];
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String toString() {
        if (this.path == null || this.path.length == 0) {
            return "null=" + this.level;
        }
        StringBuffer retStr = new StringBuffer();
        for (int i = 0; i < this.path.length; ++i) {
            retStr.append(this.path[i]).append(",");
        }
        retStr.append("=").append(this.level);
        return retStr.toString();
    }

    public String getWCCMType() {
        if (this.path == null) {
            return "";
        }
        String m = this.getModuleName();
        if (m == null) {
            return "";
        }
        if (m.equals("beanModule")) {
            if (this.path.length > 5) {
                return m + "#" + "beanModule.methods";
            }
            return m + "#";
        }
        if (m.equals("jvmRuntimeModule")) {
            if (this.path.length > 2) {
                return this.path[1] + "#" + this.path[2];
            }
            return this.path[1] + "#";
        }
        if (this.path.length == 2) {
            return m;
        }
        if (this.path.length > 3) {
            return m + "#" + this.getSubmoduleName();
        }
        return m + "#";
    }
}

