/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.util.HashMap;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class PerfPrivateLocal {
    private static TraceComponent tc = Tr.register(PerfPrivateLocal.class, "PMI", null);
    private static PerfPrivateLocal proxy = null;
    private static boolean perfPrivateMBeanReady = true;
    private AdminService as = null;
    private ObjectName perfMBean = null;
    private HashMap dd2mbsd = null;

    private PerfPrivateLocal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.as = AdminServiceFactory.getAdminService();
        this.perfMBean = this.getPrivatePerfMBean();
        if (this.perfMBean == null) {
            perfPrivateMBeanReady = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : failed to find PerfPrivate MBean - PMI must NOT be enabled!");
            }
        }
        this.dd2mbsd = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    private Object invoke(String operation, Object[] params, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{operation, params, signature});
        }
        Object retVal = null;
        try {
            retVal = this.as.invoke(this.perfMBean, operation, params, signature);
        }
        catch (JMException e) {
            Tr.event(tc, "invoke", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", retVal);
        }
        return retVal;
    }

    private ObjectName getPrivatePerfMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivatePerfMBean");
        }
        ObjectName oName = null;
        try {
            ObjectName query = new ObjectName("WebSphere:type=PerfPrivate,*");
            Set results = this.as.queryNames(query, null);
            if (results != null && results.size() == 1) {
                oName = (ObjectName)results.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getPrivatePerfMBean", oName);
                }
            } else {
                Tr.event(tc, "getPrivatePerfMBean", results);
            }
        }
        catch (MalformedObjectNameException e) {
            Tr.event(tc, "getPrivatePerfMBean", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivatePerfMBean", oName);
        }
        return oName;
    }

    public DataDescriptor getDataDescriptor(MBeanStatDescriptor mbsd) {
        DataDescriptor dd;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataDescriptor", mbsd);
        }
        if ((dd = (DataDescriptor)this.dd2mbsd.get(mbsd.toString())) == null) {
            String[] signature = new String[]{"com.ibm.websphere.pmi.stat.MBeanStatDescriptor"};
            Object[] params = new Object[]{mbsd};
            dd = (DataDescriptor)this.invoke("getDataDescriptor", params, signature);
            this.dd2mbsd.put(mbsd.toString(), dd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataDescriptor", dd);
        }
        return dd;
    }

    public DataDescriptor getDataDescriptor(ObjectName oName) {
        return this.getDataDescriptor(new MBeanStatDescriptor(oName, null));
    }

    public StatsImpl getServerStats() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerStats");
        }
        StatsImpl s = (StatsImpl)this.invoke("getServerStats", null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerStats", s);
        }
        return s;
    }

    public PMIServiceState getPMIServiceState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPMIServiceState");
        }
        PMIServiceState s = (PMIServiceState)((Object)this.invoke("getPMIServiceState", null, null));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPMIServiceState", (Object)s);
        }
        return s;
    }

    public static PerfPrivateLocal get() {
        if (proxy == null) {
            proxy = new PerfPrivateLocal();
        }
        return proxy;
    }

    public static boolean exists() {
        if (proxy == null) {
            PerfPrivateLocal.get();
        }
        return perfPrivateMBeanReady;
    }
}

