/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orb.transport.WSSSLClientSocketFactory;
import com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.ConnectionKey;
import com.ibm.ws.orbimpl.transport.WSTCPTransportConnection;
import com.ibm.ws.orbimpl.transport.WSTransport;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import com.ibm.ws.security.util.AccessController;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLSocket;

public class WSSSLTransportConnection
extends WSTCPTransportConnection {
    ConnectionInformation connectionInformation = null;

    public WSSSLTransportConnection(ConnectionTable table, Socket socket, ReaderPool readerPool, ORBForTransports orbForTransports, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor) {
        super(table, socket, readerPool, orbForTransports, connectionData, connectionInterceptor, true);
        String methodName = "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "the socket for this connection is: " + socket);
        }
        SSLSocket castedSocket = (SSLSocket)socket;
        final ConnectionData fconnectionData = connectionData;
        final SSLSocket fcastedSocket = castedSocket;
        final Socket fsocket = socket;
        this.connectionInformation = (ConnectionInformationImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ConnectionInformationImpl(fconnectionData, WSTransport.getWSSSLServerSocketFactory(WSSSLTransportConnection.this.getORBForTransports()).getPeerCertificateChain(fcastedSocket), System.currentTimeMillis(), fsocket.getInetAddress().getHostName(), fsocket.getPort());
            }
        });
        this.activateServer();
    }

    public WSSSLTransportConnection(ORBForTransports orbForTransports, ConnectionTable table, ConnectionKey key, ORBConnection conn, ReaderPool readerPool, Profile profile, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor) {
        super(orbForTransports, table, key, conn, readerPool, profile, connectionData, connectionInterceptor);
        String methodName = "<init>(ORBForTransports, ConnectionTable, ConnectionKey, ORBConnection, ReaderPool, Profile, ConnectionData, ConnectionInterceptor";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ORBForTransports, ConnectionTable, ConnectionKey, ORBConnection, ReaderPool, Profile, ConnectionData, ConnectionInterceptor", "the connection key for this connection is: " + key);
        }
        this.connectionInformation = new ConnectionInformationImpl(connectionData, null, System.currentTimeMillis(), null, -1);
    }

    public Socket createSocket(String host, int port) throws Exception {
        String methodName = "createSocket(host, port)";
        Socket socket = null;
        try {
            String lHost = this.getORBForTransports().getProperty("com.ibm.CORBA.LocalHost");
            boolean uselHost = lHost != null;
            String BindAddr = this.getORBForTransports().getProperty("com.ibm.ws.orb.transport.useMultiHome");
            boolean useBindAddr = BindAddr != null && BindAddr.equalsIgnoreCase("false");
            SSLConnectionData extendedSSLcd = (SSLConnectionData)this.connectionData;
            this.connectionData.setLocalHost(lHost);
            extendedSSLcd.setUseSingleNIC(uselHost && useBindAddr);
            if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket()", "Connection Type=SSL Client Side Socket, LocalHost=" + lHost + ", Bind Client Socket To Multiple NIC cards=" + (!uselHost || !useBindAddr));
            }
            WSSSLClientSocketFactory factory = WSTransport.getWSSSLClientSocketFactory(this.getORBForTransports());
            int connectTimeout = this.getConnectTimeout();
            socket = factory.createSSLSocket(this.connectionData, connectTimeout);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host, port)", "The socket being returned is " + socket);
            }
            return socket;
        }
        catch (Exception ex) {
            if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                Manager.Ffdc.log(ex, (Object)this, "com.ibm.ws.orbimpl.transport.WSSSLTransportConnection.createSocket", "270", new Object[]{this});
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4112L, (Object)this, "createSocket(host, port)", ex);
            }
            throw ex;
        }
    }

    public Socket createSocket(InetSocketAddress server, InetSocketAddress client) throws Exception {
        String methodName = "createSocket(server,client)";
        int connectTimeout = this.getConnectTimeout();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "connecting client=" + client + " to server=" + server + ", ConnectTimeout=" + connectTimeout);
        }
        return this.createSocket(server.getHostName(), server.getPort());
    }

    public Object getConnectionData() {
        String methodName = "getConnectionData()";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnectionData()", "About to return connectionInformation=" + this.connectionInformation);
        }
        return this.connectionInformation;
    }
}

