/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.services.lsd;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.ws.orb.services.lsd.UserKey;
import java.lang.reflect.Method;
import org.omg.CORBA.OBJ_ADAPTER;

public class UserKeyImpl
implements UserKey {
    private static final int JMBI_USERKEYMAGIC_OFFSET = 0;
    private static final int JMBI_REFDATA_OFFSET_OFFSET = 4;
    private static final int JMBI_REFDATA_LENGTH_OFFSET = 6;
    private static final int JMBI_ADAPTERNAME_OFFSET_OFFSET = 8;
    private static final int JMBI_ADAPTERNAME_LENGTH_OFFSET = 10;
    private byte[] userKey = null;
    private byte[] objectKey = null;
    private byte[] adapterName = null;
    private byte[] refData = null;
    private ObjectKey objectKeyObject = null;

    private UserKeyImpl() {
    }

    public UserKeyImpl(byte[] objectKey) {
        this.objectKey = objectKey;
        this.objectKeyObject = new ObjectKey(objectKey);
        this.userKey = this.objectKeyObject.getUserKey();
    }

    public byte[] getAdapterName() {
        if (null == this.adapterName) {
            if (this.isWsUserKey()) {
                this.adapterName = this.getObjectAdapterName(this.userKey);
            } else if (this.isJMBIEBroker()) {
                short adapterNameLength = ORB.bytesToShort((byte[])this.userKey, (int)10);
                this.adapterName = new byte[adapterNameLength];
                System.arraycopy(this.userKey, ORB.bytesToShort((byte[])this.userKey, (int)8), this.adapterName, 0, adapterNameLength);
            }
        }
        return this.adapterName;
    }

    public byte[] getReferenceData() {
        if (null == this.refData) {
            if (this.isJMBIEBroker()) {
                short refDataLength = ORB.bytesToShort((byte[])this.userKey, (int)6);
                this.refData = new byte[refDataLength];
                System.arraycopy(this.userKey, ORB.bytesToShort((byte[])this.userKey, (int)4), this.refData, 0, refDataLength);
            } else {
                this.refData = new byte[0];
            }
        }
        return this.refData;
    }

    private boolean isJMBIEBroker() {
        return this.objectKeyObject.getSCID() == 19;
    }

    private boolean isWsUserKey() {
        return this.objectKeyObject.getSCID() == 18;
    }

    private byte[] getObjectAdapterName(byte[] userKey) {
        byte[] result = null;
        String clzName = "com.ibm.ejs.oa.UserKey";
        String mName = "getOAName";
        try {
            Class<?> keyClass = Class.forName("com.ibm.ejs.oa.UserKey");
            Method method = keyClass.getMethod("getOAName", null);
            Object key = keyClass.getConstructor(byte[].class).newInstance(new Object[]{userKey});
            Object name = method.invoke(key, (Object[])null);
            if (!(name instanceof String)) {
                throw new OBJ_ADAPTER("The value returned by com.ibm.ejs.oa.UserKey.getOAName() is not a String.");
            }
            result = ((String)name).getBytes();
        }
        catch (Exception e) {
            throw new OBJ_ADAPTER("An unexpected exception ocurred when invoking com.ibm.ejs.oa.UserKey.getOAName(): " + e);
        }
        return result;
    }
}

