/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import com.ibm.ws.management.wsdm.capability.IClusterManagement;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.capability.IStateManageable;
import com.ibm.ws.management.wsdm.common.WSDMConstants;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import com.ibm.ws.management.wsdm.common.WSDMUtilities;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;

public class WebSphereCluster
extends WSDMResource
implements IJ2EEManagedObject,
IStateManageable,
IClusterManagement {
    private static final TraceComponent tc = Tr.register(WebSphereCluster.class, null, null);

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{containmentPath, this});
        }
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = "WebSphere:*,type=Cluster";
        }
        List result = super.getMbeanResourceInstances(containmentPath, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", result);
        }
        return result;
    }

    protected void resolveMbeanIDFromConfigID(HashMap refProps, String configID) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveMbeanIDFromConfigID", new Object[]{refProps, configID, this});
        }
        String serverName = this.getName();
        ObjectName j2eeAppMbean = (ObjectName)WSDMUtilities.getMbeanByQueryString((String)("WebSphere:*,type=Cluster,name=" + serverName)).iterator().next();
        String mbeanIdentifier = j2eeAppMbean.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mbean resolved is" + mbeanIdentifier);
        }
        refProps.put(WSDMConstants.WAS_WSDM_Resource_MbeanIdentifier, mbeanIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveMbeanIDFromConfigID");
        }
    }

    protected Set getResourceMbeans(String mbeanQueryString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceMbeans", new Object[]{mbeanQueryString, this});
        }
        Set resMbeans = this.isManagedProcess() ? WSDMUtilities.getMbeanByQueryString((String)mbeanQueryString, (boolean)true) : super.getResourceMbeans(mbeanQueryString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceMbeans", resMbeans);
        }
        return resMbeans;
    }

    public Object getMbeanAttribute(String attribute) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanAttribute", attribute);
        }
        Object result = this.isManagedProcess() ? WSDMUtilities.getMbeanAttribute((ObjectName)this.mbeanObject, (String)attribute, (boolean)true) : super.getMbeanAttribute(attribute);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanAttribute", result);
        }
        return result;
    }

    public void setMbeanAttribute(String attribute, Object attributeValue) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMbeanAttribute", new Object[]{attribute, attributeValue});
        }
        if (this.isManagedProcess()) {
            WSDMUtilities.setMbeanAttribute((ObjectName)this.mbeanObject, (String)attribute, (Object)attributeValue, (boolean)true);
        } else {
            super.setMbeanAttribute(attribute, attributeValue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMbeanAttribute");
        }
    }

    public Object mbeanInvoke(String operationName, Object[] params, String[] sigs) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvoke", new Object[]{operationName, params, sigs});
        }
        Object result = this.isManagedProcess() ? WSDMUtilities.mbeanInvoke((ObjectName)this.mbeanObject, (String)operationName, (Object[])params, (String[])sigs, (boolean)true) : super.mbeanInvoke(operationName, params, sigs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvoke", result);
        }
        return result;
    }

    public String getResourceType() {
        return "webspherecluster";
    }

    public void getConfigProperty(String propertyName) {
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public String getBackupBootstrapHost() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBackupBootstrapHost", this);
        }
        String backupBootstrapHost = (String)this.getMbeanAttribute("backupBootstrapHost");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBackupBootstrapHost " + backupBootstrapHost);
        }
        return backupBootstrapHost;
    }

    public String getBackupBootstrapPort() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBackupBootstrapPort", this);
        }
        String backupBootstrapPort = (String)this.getMbeanAttribute("backupBootstrapPort");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBackupBootstrapPort " + backupBootstrapPort);
        }
        return backupBootstrapPort;
    }

    public String getBackupName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBackupName", this);
        }
        String backupName = (String)this.getMbeanAttribute("backupName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBackupName " + backupName);
        }
        return backupName;
    }

    public String getClusterName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterName", this);
        }
        String clusterName = (String)this.getMbeanAttribute("clusterName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterName " + clusterName);
        }
        return clusterName;
    }

    public String getWlcId() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWlcId", this);
        }
        String wlcID = (String)this.getMbeanAttribute("wlcID");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWlcId " + wlcID);
        }
        return wlcID;
    }

    public boolean isPreferLocal() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPreferLocal", this);
        }
        boolean preferLocal = (Boolean)this.getMbeanAttribute("preferLocal");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPreferLocal " + preferLocal);
        }
        return preferLocal;
    }

    public void setPreferLocal(boolean preferLocal) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPreferLocal", new Boolean(preferLocal));
        }
        this.setMbeanAttribute("preferLocal", new Boolean(preferLocal));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPreferLocal");
        }
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = (Boolean)this.getMbeanAttribute("eventProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = this.getMbeanAttribute("objectName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean isStateManageable = (Boolean)this.getMbeanAttribute("stateManageable");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", isStateManageable);
        }
        return isStateManageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean isStatisticsProvider = (Boolean)this.getMbeanAttribute("statisticsProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", isStatisticsProvider);
        }
        return isStatisticsProvider;
    }

    public int getState() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getState", this);
        }
        int state = (Integer)this.getMbeanAttribute("state");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getState " + state);
        }
        return state;
    }

    public void start() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", this);
        }
        this.mbeanInvoke("start", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void rippleStart() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rippleStart", this);
        }
        this.mbeanInvoke("rippleStart", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rippleStart");
        }
    }

    public void stop() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", this);
        }
        this.mbeanInvoke("stop", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public String dumpClusterInfo() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpClusterInfo", this);
        }
        String result = (String)this.mbeanInvoke("dumpClusterInfo", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dumpClusterInfo", result);
        }
        return result;
    }

    public String exportRouteTable() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportRouteTable", this);
        }
        String result = (String)this.mbeanInvoke("exportRouteTable", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportRouteTable", result);
        }
        return result;
    }

    public boolean getAvailable(String memberName, String nodeName) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailable", this);
        }
        Boolean result = (Boolean)this.mbeanInvoke("getAvailable", new Object[]{memberName, nodeName}, new String[]{"java.lang.String", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailable", result);
        }
        return result;
    }

    public void setAvailable(String memberName, String nodeName) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailable", this);
        }
        this.mbeanInvoke("setAvailable", new Object[]{memberName, nodeName}, new String[]{"java.lang.String", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAvailable");
        }
    }

    public void setUnavailable(String memberName, String nodeName) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUnavailable", this);
        }
        this.mbeanInvoke("setUnavailable", new Object[]{memberName, nodeName}, new String[]{"java.lang.String", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUnavailable");
        }
    }

    public void stopImmediate() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopImmediate", this);
        }
        this.mbeanInvoke("stopImmediate", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopImmediate");
        }
    }

    public Date getStartTime() throws WASResourceOperationException {
        return new Date();
    }

    public void startRecursive() throws WASResourceOperationException {
    }
}

