/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.InvalidResourceMetricsDataException;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.capability.IMOWSMetric;
import com.ibm.ws.management.wsdm.capability.IWebService;
import com.ibm.ws.management.wsdm.common.MOWSServiceEvent;
import com.ibm.ws.management.wsdm.common.MOWSServiceListener;
import com.ibm.ws.management.wsdm.common.WSDMConstants;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class WebServices
extends WSDMResource
implements IJ2EEManagedObject,
IWebService,
IMOWSMetric,
MOWSServiceListener {
    private static final TraceComponent tc = Tr.register(WebServices.class, null, null);
    List appWSEnabledModuleList = new ArrayList();
    List wsAppNameList = new ArrayList();

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        try {
            Session session = this.getSession();
            RepositoryContext cellContext = this.getCellRepositoryContext(session);
            String appContextName = this.getAppContextNameFromDeployment(this.mbeanObject.getKeyProperty("mbeanIdentifier"));
            if (appContextName != null && !appContextName.equals("")) {
                this.appWSEnabledModuleList = this.getEnabledWebservicesAppList(cellContext, appContextName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking for Jaxws...");
            }
            String appName = this.mbeanObject.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application name to check is " + appName);
            }
            List jaxwsAppsInfo = this.getJaxwsAppInfo(appName);
            for (int i = 0; i < jaxwsAppsInfo.size(); ++i) {
                AttributeList appAttrList = (AttributeList)jaxwsAppsInfo.get(i);
                String name = (String)ConfigServiceHelper.getAttributeValue(appAttrList, "application");
                String moduleName = (String)ConfigServiceHelper.getAttributeValue(appAttrList, "module");
                String mockAppFileContextName = "deployments/" + name + "/" + moduleName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mockAppFileContextNameis " + mockAppFileContextName);
                }
                if (this.appWSEnabledModuleList.contains(mockAppFileContextName)) continue;
                this.appWSEnabledModuleList.add(mockAppFileContextName);
            }
            this.getConfigService().discard(session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appModuleWSEnabledList is " + this.appWSEnabledModuleList);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WebServices.initialize", "45", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught while initializing", e);
            }
            throw new WASResourceInitializeException((Throwable)e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    public String getResourceType() {
        return "webservices";
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        List result;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResourceInstances", new Object[]{containmentPath, this});
            }
            if (containmentPath == null || containmentPath.equals("")) {
                containmentPath = "WebSphere:*,type=J2EEApplication";
            }
            result = super.getMbeanResourceInstances(containmentPath, false);
            try {
                this.addJaxwsWebServicesApps(result, this.wsAppNameList);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WebServices.getResourceInstances", "86", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Cannot find Jaxws apps", e);
            }
        }
        this.convertResourceTypeToWebService(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", result);
        }
        return result;
    }

    protected Set filterResources(Set unfilteredResources) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterResources", new Object[]{unfilteredResources, this});
        }
        HashSet<ObjectName> filteredResources = new HashSet<ObjectName>();
        Session session = new Session();
        RepositoryContext cellContext = this.getCellRepositoryContext(session);
        for (ObjectName resourceToFilter : unfilteredResources) {
            String applicationName = this.getAppContextNameFromDeployment(resourceToFilter.getKeyProperty("mbeanIdentifier"));
            if (applicationName == null || applicationName.equals("") || this.getEnabledWebservicesAppList(cellContext, applicationName).size() <= 0) continue;
            filteredResources.add(resourceToFilter);
            this.wsAppNameList.add(resourceToFilter.getKeyProperty("name"));
        }
        this.getConfigService().discard(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterResources", filteredResources);
        }
        return filteredResources;
    }

    private void convertResourceTypeToWebService(List appEPRList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertResourceTypeToWebService", new Object[]{appEPRList, this});
        }
        for (int i = 0; i < appEPRList.size(); ++i) {
            WASResourceReferenceParameters appEPR = (WASResourceReferenceParameters)appEPRList.get(i);
            HashMap refProps = appEPR.getReferenceProperties();
            refProps.put(WSDMConstants.WAS_WSDM_Resource_Type, "webservices");
            String mrid = (String)refProps.get(WSDMConstants.WAS_WSDM_Resource_MRID);
            String newMrid = mrid.substring(mrid.indexOf(":") + 1);
            refProps.put(WSDMConstants.WAS_WSDM_Resource_MRID, newMrid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertResourceTypeToWebService", appEPRList);
        }
    }

    private RepositoryContext getCellRepositoryContext(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryContext", this);
        }
        String sessionId = session.getSessionId();
        String userID = session.getUserName();
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(userID, sessionId);
        RepositoryContext rootContext = workSpace.getRootContext();
        RepositoryContext cellContext = rootContext.findContext("cell");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryContext", cellContext);
        }
        return cellContext;
    }

    private String getAppContextNameFromDeployment(String mbeanID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppContextNameFromDeployment", new Object[]{mbeanID, this});
        }
        String appName = null;
        StringTokenizer tokenizer = new StringTokenizer(mbeanID, "/");
        String previousToken = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("deployments") && tokenizer.hasMoreTokens()) {
                appName = previousToken;
                break;
            }
            previousToken = token;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppContextNameFromDeployment", appName);
        }
        return appName;
    }

    private String[] getAppWSEnabledModuleName(String contextPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppWSEnabledModuleName", new Object[]{contextPath, this});
        }
        String[] names = new String[2];
        StringTokenizer tokenizer = new StringTokenizer(contextPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals("deployments") || !tokenizer.hasMoreTokens()) continue;
            names[0] = tokenizer.nextToken();
            names[1] = tokenizer.nextToken();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppWSEnabledModuleName", names);
        }
        return names;
    }

    private List getEnabledWebservicesAppList(RepositoryContext cellContext, String applicationName) {
        ArrayList<String> webServicesEnabledModuleList;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEnabledWebservicesAppList", new Object[]{cellContext, applicationName, this});
            }
            String modifiedApplicationName = applicationName.replaceAll("%20", " ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Modified String", modifiedApplicationName);
            }
            webServicesEnabledModuleList = new ArrayList<String>();
            try {
                RepositoryContext applicationContext = (RepositoryContext)cellContext.findContext("applications", modifiedApplicationName).iterator().next();
                List appFiles = applicationContext.getAllList(true);
                for (int i = 0; i < appFiles.size(); ++i) {
                    String appFile = appFiles.get(i).toString();
                    if (appFile.indexOf("webservices.xml") == -1) continue;
                    webServicesEnabledModuleList.add(appFile);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WebServices.getEnabledWebservicesAppList", "236", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Error while trying to getEnabledWebservicesAppList.  Log exception and continue", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnabledWebservicesAppList", webServicesEnabledModuleList);
        }
        return webServicesEnabledModuleList;
    }

    private void addJaxwsWebServicesApps(List existingApp, List wsAppNameList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addJaxwsWebServicesApps", new Object[]{existingApp, wsAppNameList, this});
        }
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand listWS = cmdMgr.createCommand("listWebServices");
        listWS.setConfigSession(this.getSession());
        listWS.execute();
        CommandResult listWSResult = listWS.getCommandResult();
        List webServicesAppLists = (List)listWSResult.getResult();
        for (AttributeList attrList : webServicesAppLists) {
            String appName = (String)ConfigServiceHelper.getAttributeValue(attrList, "application");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App name is " + appName);
            }
            if (!this.isNewJaxwsApp(wsAppNameList, appName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding new Jax-ws app " + appName);
            }
            String queryString = "WebSphere:*,type=J2EEApplication,name=" + appName;
            List jaxwsAppList = super.getMbeanResourceInstances(queryString, false, false);
            existingApp.addAll(jaxwsAppList);
            wsAppNameList.add(appName);
        }
        this.discardSession();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addJaxwsWebServicesApps", existingApp);
        }
    }

    private List getJaxwsAppInfo(String appName) {
        List appInfo;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getJaxwsAppInfo", new Object[]{appName, this});
            }
            appInfo = null;
            try {
                CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                AdminCommand listWS = cmdMgr.createCommand("listWebServices");
                listWS.setConfigSession(this.getSession());
                listWS.setParameter("application", appName);
                listWS.execute();
                CommandResult listWSResult = listWS.getCommandResult();
                if (listWSResult.isSuccessful()) {
                    appInfo = (List)listWSResult.getResult();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WebServices.getJaxwsAppInfo", "224", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Error while trying to query listWebService command", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJaxwsAppInfo", appInfo);
        }
        return appInfo;
    }

    private boolean isNewJaxwsApp(List appList, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNewJaxwsApp", new Object[]{appList, appName, this});
        }
        boolean result = true;
        Iterator iter = appList.iterator();
        while (iter.hasNext()) {
            String existingAppName = iter.next().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ExistingApp is " + existingAppName + " appname is " + appName);
            }
            if (!existingAppName.equals(appName)) continue;
            result = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNewJaxwsApp", new Boolean(result));
        }
        return result;
    }

    public void getConfigProperty(String propertyName) throws InvalidResourcePropertyException, WASResourceException {
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = (Boolean)this.getMbeanAttribute("eventProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = this.getMbeanAttribute("objectName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean isStateManageable = (Boolean)this.getMbeanAttribute("stateManageable");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", isStateManageable);
        }
        return isStateManageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean isStatisticsProvider = (Boolean)this.getMbeanAttribute("statisticsProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", isStatisticsProvider);
        }
        return isStatisticsProvider;
    }

    public long getLastResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastResponseTime", this);
        }
        int result = this.getMetricStatistics(15);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastResponseTime", new Integer(result));
        }
        return result;
    }

    public long getMaxResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxResponseTime", this);
        }
        int result = this.getMetricStatistics(101);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxResponseTime", new Integer(result));
        }
        return result;
    }

    public int getNumberOfFailedRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfFailedRequests", this);
        }
        int numberOfRequest = this.getMetricStatistics(12);
        int numberOfSuccessfulRequest = this.getMetricStatistics(13);
        int result = numberOfRequest - numberOfSuccessfulRequest;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumberOfFailedRequests", new Integer(result));
        }
        return result;
    }

    public int getNumberOfRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfRequests", this);
        }
        int result = this.getMetricStatistics(11);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumberOfRequests", new Integer(result));
        }
        return result;
    }

    public int getNumberOfSuccessfulRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfSuccessfulRequests", this);
        }
        int result = this.getMetricStatistics(13);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumberOfSuccessfulRequests", new Integer(result));
        }
        return result;
    }

    public long getServiceTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceTime", this);
        }
        int result = this.getMetricStatistics(14);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceTime", new Integer(result));
        }
        return result;
    }

    public int getDispatchedRequestCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDispatchedRequestCount", this);
        }
        int result = this.getMetricStatistics(12);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDispatchedRequestCount", new Integer(result));
        }
        return result;
    }

    public long getDispatchResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDispatchResponseTime", this);
        }
        int result = this.getMetricStatistics(16);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDispatchResponseTime", new Integer(result));
        }
        return result;
    }

    public int getLoadedWebServiceCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoadedWebServiceCount", this);
        }
        int result = this.getMetricStatistics(1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoadedWebServiceCount", new Integer(result));
        }
        return result;
    }

    public int getPayloadSize() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPayloadSize", this);
        }
        int result = this.getMetricStatistics(18);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPayloadSize", new Integer(result));
        }
        return result;
    }

    public int getProcessedRequestCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedRequestCount", this);
        }
        int result = this.getMetricStatistics(13);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedRequestCount", new Integer(result));
        }
        return result;
    }

    public int getReceivedRequestCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReceivedRequestCount", this);
        }
        int result = this.getMetricStatistics(11);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReceivedRequestCount", new Integer(result));
        }
        return result;
    }

    public int getReplyPayloadSize() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReplyPayloadSize", this);
        }
        int result = this.getMetricStatistics(20);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReplyPayloadSize", new Integer(result));
        }
        return result;
    }

    public long getReplyResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReplyResponseTime", this);
        }
        int result = this.getMetricStatistics(17);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReplyResponseTime", new Integer(result));
        }
        return result;
    }

    public int getRequestPayloadSize() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestPayloadSize", this);
        }
        int result = this.getMetricStatistics(19);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestPayloadSize", new Integer(result));
        }
        return result;
    }

    public long getRequestResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestResponseTime", this);
        }
        int result = this.getMetricStatistics(15);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestResponseTime", new Integer(result));
        }
        return result;
    }

    public long getResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseTime", this);
        }
        int result = this.getMetricStatistics(14);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseTime", new Integer(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMetricStatistics(int statType) throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetricStatics", new Object[]{new Integer(statType), this});
        }
        int totalStatValue = 0;
        try {
            for (int i = 0; i < this.appWSEnabledModuleList.size(); ++i) {
                int statValue = 0;
                String appContext = (String)this.appWSEnabledModuleList.get(i);
                String[] name = this.getAppWSEnabledModuleName(appContext);
                String appmodule = name[0] + "." + name[1];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Metric module name to check is " + appmodule);
                }
                String[] signature = new String[]{"[Lcom.ibm.websphere.pmi.stat.StatDescriptor;", "java.lang.Boolean"};
                StatDescriptor webServiceSD = new StatDescriptor(new String[]{"webServicesModule", appmodule});
                Object[] params = new Object[]{new StatDescriptor[]{webServiceSD}, new Boolean(true)};
                WSStats[] wsStats = (WSStats[])this.getAdminService().invoke(this.getPerfMbean(this.mbeanObject), "getStatsArray", params, signature);
                WSStats wsServiceStat = wsStats[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebServices stat: " + wsServiceStat);
                }
                WSStats[] wsSubStats = wsServiceStat.getSubStats();
                WSStats wsServiceSubStat = wsSubStats[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebServices sub stat: " + wsServiceSubStat);
                }
                switch (statType) {
                    case 1: {
                        WSCountStatistic wsCountMetricStatistic = (WSCountStatistic)wsServiceStat.getStatistic(statType);
                        statValue = (int)wsCountMetricStatistic.getCount();
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        WSCountStatistic webServicesCountMetricStatistic = (WSCountStatistic)wsServiceSubStat.getStatistic(statType);
                        statValue = (int)webServicesCountMetricStatistic.getCount();
                        break;
                    }
                    case 18: 
                    case 19: 
                    case 20: {
                        WSAverageStatistic webServicesAverageMetricStatistic = (WSAverageStatistic)wsServiceSubStat.getStatistic(statType);
                        if (statType == 101) {
                            statValue = (int)webServicesAverageMetricStatistic.getMax();
                            break;
                        }
                        statValue = (int)webServicesAverageMetricStatistic.getMean();
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        WSTimeStatistic webServicesTimeMetricStatistic = (WSTimeStatistic)wsServiceSubStat.getStatistic(statType);
                        statValue = (int)webServicesTimeMetricStatistic.getMean();
                        break;
                    }
                    case 101: {
                        WSTimeStatistic webServicesMaxTimeMetricStatistic = (WSTimeStatistic)wsServiceSubStat.getStatistic(14);
                        statValue = (int)webServicesMaxTimeMetricStatistic.getMaxTime();
                    }
                }
                totalStatValue += statValue;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.Servlet.getTotalRequests", "158", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while getting performance data", e);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetricStatics", new Integer(totalStatValue));
            }
        }
        return totalStatValue;
    }

    public void stateChanged(MOWSServiceEvent event) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged", event);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }
}

