/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.InvalidResourceMetricsDataException;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.capability.IMowsIdentification;
import com.ibm.ws.management.wsdm.capability.IMowsOperationOperationalStatus;
import com.ibm.ws.management.wsdm.capability.IMowsOperationalState;
import com.ibm.ws.management.wsdm.capability.IMowsOperationalStatus;
import com.ibm.ws.management.wsdm.capability.IMowsPMIMetrics;
import com.ibm.ws.management.wsdm.capability.IMowsRequestProcessingState;
import com.ibm.ws.management.wsdm.capability.IStateManageable;
import com.ibm.ws.management.wsdm.common.WSDMConstants;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import com.ibm.ws.management.wsdm.common.WSDMUtilities;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.w3c.dom.Element;

public class JaxwsWebServices
extends WSDMResource
implements IJ2EEManagedObject,
IStateManageable,
IMowsPMIMetrics,
IMowsIdentification,
IMowsOperationalStatus,
IMowsOperationalState,
IMowsOperationOperationalStatus,
IMowsRequestProcessingState {
    private static final TraceComponent tc = Tr.register(JaxwsWebServices.class, null, null);
    String _serviceName;
    String _endpointName;
    private Integer[] _transitionState = new Integer[2];
    private Integer _stateType = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        try {
            this._serviceName = (String)eprRefProps.get(WSDMConstants.WAS_WSDM_Resource_ServiceName);
            this._endpointName = (String)eprRefProps.get(WSDMConstants.WAS_WSDM_Resource_Endpoint);
            this._stateType = this.getCurrentOperationalState();
            if (this._transitionState[0] == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_transitionState[0] is null");
                }
                this._transitionState[0] = this._stateType;
            }
            if (this._transitionState[1] == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_transitionState[1] is null");
                }
                this._transitionState[1] = this._stateType;
            }
            if (!tc.isEntryEnabled()) return;
        }
        catch (Exception e) {
            try {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.JaxwsWebServices.initialize", "80", this);
                if (!tc.isDebugEnabled()) throw new WASResourceInitializeException((Throwable)e);
                Tr.debug(tc, "Exception caught while initializing", e);
                throw new WASResourceInitializeException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "initialize", new Object[]{this._transitionState[0], this._transitionState[1], this});
                throw throwable;
            }
        }
        Tr.exit(tc, "initialize", new Object[]{this._transitionState[0], this._transitionState[1], this});
        return;
    }

    public String getResourceType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceType", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceType", this);
        }
        return "jaxwswebservices";
    }

    public List getResourceInstances(Session session, ObjectName scope, String queryString) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{queryString, this});
        }
        List result = new ArrayList();
        if (queryString == null || queryString.equals("")) {
            queryString = "WebSphere:*,type=EndpointManager";
        }
        result = super.getMbeanResourceInstances(queryString, false);
        this.formatResource(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", new Object[]{result, this});
        }
        return result;
    }

    protected List getMbeanResourceInstances(String mbeanQueryString, boolean resolveConfigID, boolean filterResources) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanResourceInstances", new Object[]{mbeanQueryString, resolveConfigID, filterResources, this});
        }
        ArrayList<WASResourceReferenceParameters> result = new ArrayList<WASResourceReferenceParameters>();
        try {
            Set resourceMbans = this.getResourceMbeans(mbeanQueryString);
            final AdminService adminService = AdminServiceFactory.getAdminService();
            for (final ObjectName resourceMbean : resourceMbans) {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                List serviceList = (List)contextManager.runAsSystem(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return adminService.invoke(resourceMbean, "getServiceNames", null, null);
                    }
                });
                for (final Object serviceName : serviceList) {
                    List endpointNames = (List)contextManager.runAsSystem(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return adminService.invoke(resourceMbean, "getEndpointNames", new String[]{(String)serviceName}, new String[]{"java.lang.String"});
                        }
                    });
                    for (final Object endpoint : endpointNames) {
                        String endpoint_type = (String)contextManager.runAsSystem(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return adminService.invoke(resourceMbean, "getEndpointType", new String[]{(String)serviceName, (String)endpoint}, new String[]{"java.lang.String", "java.lang.String"});
                            }
                        });
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "JAXWS, serviceName = " + serviceName + "; endpoint = " + endpoint + "; endpoint_type = " + endpoint_type);
                        }
                        if (!endpoint_type.equalsIgnoreCase("webservices.type.jaxws")) continue;
                        WASResourceReferenceParameters resourceEpr = WSDMUtilities.getWASReferenceParametersFromMbean(resourceMbean);
                        HashMap refprops = resourceEpr.getReferenceProperties();
                        refprops.put(WSDMConstants.WAS_WSDM_Resource_ServiceName, serviceName);
                        refprops.put(WSDMConstants.WAS_WSDM_Resource_Endpoint, endpoint);
                        if (resolveConfigID) {
                            this.resolveConfigIDFromMbeanID(resourceEpr.getReferenceProperties(), this.mbeanIdentifier);
                        }
                        result.add(resourceEpr);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.JaxwsWebServices.getMbeanResourceInstances", "42", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getMbeanResourceInstances", e);
            }
            throw new WASResourceException((Throwable)e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMbeanResourceInstances", result);
            }
        }
        return result;
    }

    private void formatResource(List appEPRList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatResource", new Object[]{appEPRList, this});
        }
        for (int i = 0; i < appEPRList.size(); ++i) {
            WASResourceReferenceParameters appEPR = (WASResourceReferenceParameters)appEPRList.get(i);
            HashMap refProps = appEPR.getReferenceProperties();
            refProps.put(WSDMConstants.WAS_WSDM_Resource_Type, "jaxwswebservices");
            String mrid = (String)refProps.get(WSDMConstants.WAS_WSDM_Resource_MRID);
            String newMrid = mrid.substring(mrid.indexOf(":") + 1);
            refProps.put(WSDMConstants.WAS_WSDM_Resource_MRID, newMrid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatResource", appEPRList);
        }
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = this.getMbeanAttribute("objectName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean manageable = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", manageable);
        }
        return manageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean provider = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", provider);
        }
        return provider;
    }

    public void getConfigProperty(String propertyName) throws InvalidResourcePropertyException, WASResourceException {
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public Element getManageabilityReferences() throws Exception {
        return null;
    }

    public WASResourceReferenceParameters getEndpointReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointReference", this);
        }
        WASResourceReferenceParameters resourceEpr = WSDMUtilities.getWASReferenceParametersFromMbean(this.mbeanObject, "EndpointManager_JAXWS", this._serviceName, this._endpointName);
        WSDMUtilities.formatResourceEPR(resourceEpr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointReference", new Object[]{resourceEpr, this._serviceName, this._endpointName, this});
        }
        return resourceEpr;
    }

    public String getEndpointDescriptions() {
        String result;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEndpointDescriptions", this);
            }
            result = null;
            try {
                String url = (String)this.mbeanInvoke("getEndpointPartialURL", new Object[]{this._serviceName, this._endpointName}, new String[]{"java.lang.String", "java.lang.String"});
                result = url + "?wsdl";
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.JaxwsWebServices.getEndpointDescriptions", "235", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error while trying getEndpoinDescription.  Log exception and continue", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointDescription", new Object[]{result, this._serviceName, this._endpointName, this});
        }
        return result;
    }

    public Integer getCurrentOperationalState() {
        Integer result;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCurrentOperationalState", this);
            }
            result = null;
            try {
                result = (Integer)this.mbeanInvoke("getEndpointState", new Object[]{this._serviceName, this._endpointName}, new String[]{"java.lang.String", "java.lang.String"});
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.JaxwsWebServices.getCurrentOperationalState", "253", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error while trying getCurrentOperationalState.  Log exception and continue", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentOperationalState", new Object[]{result, this._serviceName, this._endpointName, this});
        }
        return result;
    }

    public Integer[] getLastOperationalStateTransition() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastOperationalState", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastOperationalState", new Object[]{this._transitionState[0], this._transitionState[1], this._serviceName, this._endpointName, this});
        }
        return this._transitionState;
    }

    public void setCurrentOperationalState(Integer updateState) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCurrentOperationalState", new Object[]{updateState, this});
        }
        Integer previous = this._stateType;
        this._stateType = updateState;
        this._transitionState[0] = previous;
        this._transitionState[1] = this._stateType;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCurrentOperationalState", new Object[]{this._transitionState[0], this._transitionState[1], this._serviceName, this._endpointName, this});
        }
    }

    public String getOperationalStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOperationalStatus", this);
        }
        String _status = null;
        int _state = this.getCurrentOperationalState();
        _status = _state == 3 || _state == 6 || _state == 7 ? "Unavailable" : (_state == 2 || _state == 4 ? "Available" : "PartiallyAvailable");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOperationalStatus", new Object[]{_status, this._serviceName, this._endpointName, this});
        }
        return _status;
    }

    public String getOperationOperationalStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOperationOperationalStatus", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOperationOperationalStatus", new Object[]{this._serviceName, this._endpointName, this});
        }
        return this.getOperationalStatus();
    }

    public long getServiceTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceTime", this);
        }
        long result = 0L;
        try {
            result = System.currentTimeMillis() - this.getStartTime().getTime();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.JaxwsWebServices.getServiceTime", "480", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while getting service time", e);
            }
            new InvalidResourceMetricsDataException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getserviceTime", new Long(result));
        }
        return result;
    }

    public long getNumberOfRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfRequests", this);
        }
        long result = this.getJaxwsPMIMetrics(30);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumberOfRequests", new Long(result));
        }
        return result;
    }

    public long getNumberOfSuccessfulRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfSuccessfulRequests", this);
        }
        long result = this.getJaxwsPMIMetrics(31);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumberOfSuccessfulRequests", new Long(result));
        }
        return result;
    }

    public long getNumberOfFailedRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfFailedRequests", this);
        }
        long result = this.getJaxwsPMIMetrics(32);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumberOfFailedRequests", new Long(result));
        }
        return result;
    }

    public long getMaxRequestSize() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxRequestSize", this);
        }
        long result = this.getJaxwsPMIMetrics(37);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxRequestSize", new Long(result));
        }
        return result;
    }

    public long getMaxResponseSize() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxResponseSize", this);
        }
        long result = this.getJaxwsPMIMetrics(40);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxResponseSize", new Long(result));
        }
        return result;
    }

    public long getLastRequestSize() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastRequestSize", this);
        }
        long result = this.getJaxwsPMIMetrics(38);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastRequestSize", new Long(result));
        }
        return result;
    }

    public long getLastResponseSize() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastResponseSize", this);
        }
        long result = this.getJaxwsPMIMetrics(41);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastResponseSize", new Long(result));
        }
        return result;
    }

    public long getMaxResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxResponseTime", this);
        }
        long result = this.getJaxwsPMIMetrics(34);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxResponseTime", new Long(result));
        }
        return result;
    }

    public long getLastResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastResponseTime", this);
        }
        long result = this.getJaxwsPMIMetrics(35);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastResponseTime", new Long(result));
        }
        return result;
    }

    private long getJaxwsPMIMetrics(int statType) throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJaxwsPMIMetrics", this);
        }
        long statValue = 0L;
        try {
            WSStats[] wsStatServicesTemplates;
            WSStats wsStatModule;
            String aName = this.mbeanObject.getKeyProperty("name");
            int indx1 = aName.indexOf("_");
            int indx2 = aName.indexOf("#");
            String appName = aName.substring(indx1 + 1, indx2);
            String moduleName = aName.substring(indx2 + 1);
            String appModuleName = appName + "." + moduleName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jaxws, appModuleName is " + appModuleName);
            }
            StatDescriptor sd = new StatDescriptor(new String[]{"pmiWebServiceModule", appModuleName});
            Object[] params = new Object[]{new StatDescriptor[]{sd}, new Boolean(true)};
            String[] signature = new String[]{"[Lcom.ibm.websphere.pmi.stat.StatDescriptor;", "java.lang.Boolean"};
            WSStats[] wsStats = (WSStats[])this.getAdminService().invoke(this.getPerfMbean(this.mbeanObject), "getStatsArray", params, signature);
            if (wsStats != null && (wsStatModule = wsStats[0]) != null && (wsStatServicesTemplates = wsStatModule.getSubStats()) != null) {
                WSStats wsStatServiceTemplate = wsStatServicesTemplates[0];
                WSStats[] wsStatServices = wsStatServiceTemplate.getSubStats();
                boolean found = false;
                for (int s_item = 0; s_item < wsStatServices.length && !found; ++s_item) {
                    WSStats[] wsStatEndpointTemplates;
                    WSStats wsStatService = wsStatServices[s_item];
                    if (wsStatService == null) continue;
                    String serviceName = wsStatService.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "jaxws, wsStatService is" + serviceName + "; this._serviceName is " + this._serviceName);
                    }
                    if (serviceName == null || !serviceName.equals(this._serviceName) || (wsStatEndpointTemplates = wsStatService.getSubStats()) == null) continue;
                    WSStats wsStatEndpointTemplate = wsStatEndpointTemplates[0];
                    WSStats[] wsStatEndpoints = wsStatEndpointTemplate.getSubStats();
                    block13: for (int e_item = 0; e_item < wsStatEndpoints.length && !found; ++e_item) {
                        WSStats wsStatEndpoint = wsStatEndpoints[e_item];
                        if (wsStatEndpoint == null) continue;
                        String endpointName = wsStatEndpoint.getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "jaxws, wsStatEndpoint is" + endpointName + "; this._endpointName is " + this._endpointName);
                        }
                        if (endpointName == null || !endpointName.equals(this._endpointName)) continue;
                        found = true;
                        switch (statType) {
                            case 30: 
                            case 31: 
                            case 32: 
                            case 36: 
                            case 38: 
                            case 39: 
                            case 41: {
                                WSCountStatistic countMetricStatistic = (WSCountStatistic)wsStatEndpoint.getStatistic(statType);
                                statValue = countMetricStatistic.getCount();
                                continue block13;
                            }
                            case 33: 
                            case 37: 
                            case 40: {
                                WSAverageStatistic avgResponseTime = (WSAverageStatistic)wsStatEndpoint.getStatistic(statType);
                                statValue = (int)avgResponseTime.getMean();
                                continue block13;
                            }
                            case 35: {
                                WSTimeStatistic responseTime = (WSTimeStatistic)wsStatEndpoint.getStatistic(statType);
                                statValue = (int)responseTime.getMean();
                                continue block13;
                            }
                            case 34: {
                                WSTimeStatistic responseMaxTime = (WSTimeStatistic)wsStatEndpoint.getStatistic(statType);
                                statValue = (int)responseMaxTime.getMaxTime();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.JaxwsWebServices.getJaxwsPMIMetrics", "687", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while getting performance data", e);
            }
            throw new InvalidResourceMetricsDataException((Throwable)e);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.management.wsdm.resource.JaxwsWebServices.getJaxwsPMIMetrics", "694", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while getting performance data", t);
            }
            throw new InvalidResourceMetricsDataException(t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getJaxwsPMIMetrics", new Long(statValue));
            }
        }
        return statValue;
    }

    public void start() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", this);
        }
        Object result = this.mbeanInvoke("startEndpointListener", new Object[]{this._serviceName.toString(), this._endpointName}, new String[]{"java.lang.String", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public Date getStartTime() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStartTime", this);
        }
        Long result = (Long)this.mbeanInvoke("getEndpointStartTime", new Object[]{this._serviceName.toString(), this._endpointName}, new String[]{"java.lang.String", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStartTime", this);
        }
        return new Date(result);
    }

    public void startRecursive() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startRecursive", this);
        }
        this.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startRecursive", this);
        }
    }

    public void stop() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", this);
        }
        this.mbeanInvoke("stopEndpointListener", new Object[]{this._serviceName.toString(), this._endpointName}, new String[]{"java.lang.String", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop", this);
        }
    }
}

