/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.InvalidResourceMetricsDataException;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wsdm.capability.IEJB;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public class EJB
extends WSDMResource
implements IJ2EEManagedObject,
IEJB {
    private static final TraceComponent tc = Tr.register(EJB.class, null, null);

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{containmentPath, this});
        }
        List resultEJBs = new ArrayList();
        if (containmentPath == null || containmentPath.equals("")) {
            String statefulSessionlessBeanContainmentPath = "WebSphere:*,type=StatefulSessionBean";
            resultEJBs.addAll(super.getMbeanResourceInstances(statefulSessionlessBeanContainmentPath, false));
            String entityBeanContainmentPath = "WebSphere:*,type=EntityBean";
            resultEJBs.addAll(super.getMbeanResourceInstances(entityBeanContainmentPath, false));
            String statelessSessionBeanContainmentPath = "WebSphere:*,type=StatelessSessionBean";
            resultEJBs.addAll(super.getMbeanResourceInstances(statelessSessionBeanContainmentPath, false));
            String messageDrivenBeanContainmentPath = "WebSphere:*,type=MessageDrivenBean";
            resultEJBs.addAll(super.getMbeanResourceInstances(messageDrivenBeanContainmentPath, false));
        } else {
            resultEJBs = super.getMbeanResourceInstances(containmentPath, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", resultEJBs);
        }
        return resultEJBs;
    }

    public String getResourceType() {
        return "ejb";
    }

    public void getConfigProperty(String propertyName) {
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = (Boolean)this.getMbeanAttribute("eventProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = this.getMbeanAttribute("objectName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean isStateManageable = (Boolean)this.getMbeanAttribute("stateManageable");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", isStateManageable);
        }
        return isStateManageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean isStatisticsProvider = (Boolean)this.getMbeanAttribute("statisticsProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", isStatisticsProvider);
        }
        return isStatisticsProvider;
    }

    public int getCreateCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateCount", this);
        }
        int result = this.getMetricStatistics(1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateCount", new Integer(result));
        }
        return result;
    }

    public int getLiveCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLiveCount", this);
        }
        int result = this.getMetricStatistics(10);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLiveCount", new Integer(result));
        }
        return result;
    }

    public int getLoadCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoadCount", this);
        }
        int result = this.getMetricStatistics(7);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoadCount", new Integer(result));
        }
        return result;
    }

    public int getPooledCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPooledCount", this);
        }
        int result = this.getMetricStatistics(25);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPooledCount", new Integer(result));
        }
        return result;
    }

    public int getReadyCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReadyCount", this);
        }
        int result = this.getMetricStatistics(9);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReadyCount", new Integer(result));
        }
        return result;
    }

    public int getStoreCount() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStoreCount", this);
        }
        int result = this.getMetricStatistics(8);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStoreCount", new Integer(result));
        }
        return result;
    }

    public long getWaitTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWaitTime", this);
        }
        int result = this.getMetricStatistics(28);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWaitTime", new Integer(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMetricStatistics(int statType) throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetricStatics", new Object[]{new Integer(statType), this});
        }
        int statValue = 0;
        try {
            String[] signature = new String[]{"javax.management.ObjectName", "java.lang.Boolean"};
            Object[] params = new Object[]{this.mbeanObject, new Boolean(false)};
            WSStats ejbStats = (WSStats)this.getAdminService().invoke(this.getPerfMbean(this.mbeanObject), "getStatsObject", params, signature);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EJB stats:  " + ejbStats);
            }
            if (ejbStats == null) return statValue;
            switch (statType) {
                case 1: 
                case 7: 
                case 8: {
                    WSCountStatistic ejbCountMetricStatistic = (WSCountStatistic)ejbStats.getStatistic(statType);
                    statValue = (int)ejbCountMetricStatistic.getCount();
                    return statValue;
                }
                case 9: 
                case 10: 
                case 25: {
                    WSRangeStatistic ejbRangeMetricStatistic = (WSRangeStatistic)ejbStats.getStatistic(statType);
                    statValue = (int)ejbRangeMetricStatistic.getCurrent();
                    return statValue;
                }
                case 28: {
                    WSTimeStatistic ejbRequestTimeMetricStatistic = (WSTimeStatistic)ejbStats.getStatistic(statType);
                    if (ejbRequestTimeMetricStatistic == null) return statValue;
                    statValue = (int)ejbRequestTimeMetricStatistic.getMean();
                    return statValue;
                }
            }
            return statValue;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.EJB.getMetricStatistics", "209", this);
            if (!tc.isDebugEnabled()) return statValue;
            Tr.debug(tc, "Error while getting performance data", e);
            return statValue;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetricStatics", new Integer(statValue));
            }
        }
    }
}

