/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wsdm.common.MOWSService;
import com.ibm.ws.management.wsdm.common.MOWSServiceEvent;
import com.ibm.ws.management.wsdm.common.WSDMUtilities;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;

public class HandlersUtilities {
    private static final TraceComponent tc = Tr.register(HandlersUtilities.class, null, null);
    private static MOWSService mows = null;
    private static final String _attachMent1 = "multipart/related";
    private static final String _attachMent2 = "application/xop+xml";

    public static boolean hasAttachment(MessageContext msgContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasAttachment", HandlersUtilities.class);
        }
        boolean hasAttachment = false;
        String multipart_related = _attachMent1;
        String MTOM2 = _attachMent2;
        String contentType = (String)msgContext.getProperty("ContentType");
        if (contentType != null && !contentType.equals("") && (contentType.startsWith(multipart_related) || contentType.startsWith(MTOM2))) {
            hasAttachment = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasAttachment", new Object[]{hasAttachment, HandlersUtilities.class});
        }
        return hasAttachment;
    }

    public static void publishNotification(QName state_type, MessageContext msgContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishNotification", HandlersUtilities.class);
        }
        if (WSDMUtilities.isServiceEnabled()) {
            try {
                if (mows == null) {
                    try {
                        mows = (MOWSService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return WsServiceRegistry.getService(WsServiceRegistry.class, MOWSService.class);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.websphere.management.wsdm.custom.impl.HandlerUtilities.publishNotification", "76", HandlersUtilities.class);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception caught during publishNotification doPrivileged", e);
                        }
                        throw e.getException();
                    }
                }
                if (mows != null) {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    String cellName = adminService.getCellName();
                    String nodeName = adminService.getNodeName();
                    String processName = adminService.getProcessName();
                    int runtimeHash = Runtime.getRuntime().hashCode();
                    AxisConfiguration axisConfiguration = msgContext.getConfigurationContext().getAxisConfiguration();
                    String moduleName = Axis2Utils.getModuleName(axisConfiguration);
                    String appName = Axis2Utils.getApplicationName(axisConfiguration);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "appName = " + appName + ", moduleName = " + moduleName);
                    }
                    EndpointReference SC_EPR = msgContext.getServiceContext().getMyEPR();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServiceContext's EPR is " + SC_EPR.toString());
                    }
                    AxisService axisService = msgContext.getAxisService();
                    QName serviceQName = Axis2Utils.getServiceQName(axisService);
                    String portName_from_msgctx = Axis2Utils.getPortName(axisService);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serviceName is " + serviceQName.toString() + " and endpointName is " + portName_from_msgctx);
                        Tr.debug(tc, "Caller subject is " + WSSubject.getCallerSubject() + "; RunAs subject is " + WSSubject.getRunAsSubject());
                    }
                    final MOWSServiceEvent mowsEvent = new MOWSServiceEvent(state_type, SC_EPR, cellName, nodeName, processName, runtimeHash, serviceQName, portName_from_msgctx, appName, moduleName);
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    contextManager.runAsSystem(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            mows.publishMOWSNotification(mowsEvent);
                            return null;
                        }
                    });
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.websphere.management.wsdm.custom.impl.HandlerUtilities.publishNotification", "95", HandlersUtilities.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during publishNotification", e);
                }
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "publishNotification for " + state_type.toString());
                }
            }
        }
    }
}

