/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformClusterConfigHelper;
import com.ibm.ws.management.util.PlatformClusterMemberConfigHelper;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.util.ImplFactory;

public class ConfigHelperFactory {
    private static TraceComponent tc = Tr.register(ConfigHelperFactory.class, "Admin", null);
    private static ManagedObjectMetadataAccessor metadataAccessor = null;
    private static ManagedObjectMetadataHelper metadataHelper = null;

    public static PlatformServerConfigHelper getPlatformServerConfigHelper(Node node) {
        PlatformServerConfigHelper helper = null;
        String impl = null;
        String platform = ConfigHelperFactory.normalizePlatform(node);
        impl = platform != null && platform.length() > 0 ? "com.ibm.ws.management.util." + platform + ".PlatformServerConfigHelperImpl" : "com.ibm.ws.management.util.PlatformServerConfigHelperImpl";
        helper = (PlatformServerConfigHelper)ConfigHelperFactory.getImplFromClass(impl);
        if (helper == null) {
            helper = (PlatformServerConfigHelper)ConfigHelperFactory.getImplFromImplFactory(impl);
        }
        if (helper == null) {
            helper = (PlatformServerConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformServerConfigHelperImpl");
        }
        return helper;
    }

    public static PlatformClusterConfigHelper getPlatformClusterConfigHelper(Node node) {
        PlatformClusterConfigHelper helper = null;
        String impl = null;
        String platform = ConfigHelperFactory.normalizePlatform(node);
        impl = platform != null && platform.length() > 0 ? "com.ibm.ws.management.util." + platform + ".PlatformClusterConfigHelperImpl" : "com.ibm.ws.management.util.PlatformClusterConfigHelperImpl";
        helper = (PlatformClusterConfigHelper)ConfigHelperFactory.getImplFromClass(impl);
        if (helper == null) {
            helper = (PlatformClusterConfigHelper)ConfigHelperFactory.getImplFromImplFactory(impl);
        }
        if (helper == null) {
            helper = (PlatformClusterConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformClusterConfigHelperImpl");
        }
        return helper;
    }

    public static PlatformClusterMemberConfigHelper getPlatformClusterMemberConfigHelper(Node node) {
        PlatformClusterMemberConfigHelper helper = null;
        String impl = null;
        String platform = ConfigHelperFactory.normalizePlatform(node);
        impl = platform != null && platform.length() > 0 ? "com.ibm.ws.management.util." + platform + ".PlatformClusterMemberHelperImpl" : "com.ibm.ws.management.util.PlatformClusterMemberHelperImpl";
        helper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getImplFromClass(impl);
        if (helper == null) {
            helper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getImplFromImplFactory(impl);
        }
        if (helper == null) {
            helper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformClusterMemberHelperImpl");
        }
        return helper;
    }

    private static String normalizePlatform(Node node) {
        String plat;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizePlatform()", node);
        }
        boolean zOSNode = false;
        String nodeName = null;
        try {
            nodeName = node.getName();
            ManagedObjectMetadataHelper metadataHelper = ConfigHelperFactory.getMetadataHelper();
            if (metadataHelper.isNodeZOS(nodeName)) {
                zOSNode = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isNodeZOS", new Boolean(zOSNode));
                }
            }
        }
        catch (Exception ex) {
            Tr.error(tc, "Error during initializing ManagedObjectMetadataHelper", ex);
        }
        if (AdminHelper.getPlatformHelper().isZOS() || zOSNode) {
            return "zos";
        }
        if (node != null && (plat = null) != null && plat.length() > 0) {
            if (plat.startsWith("win")) {
                return "win";
            }
            if (plat.startsWith("sun")) {
                return "sun";
            }
            if (plat.startsWith("os400")) {
                return "os400";
            }
            if (plat.startsWith("hp")) {
                return "hp";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizePlatform()");
        }
        return null;
    }

    private static Object getImplFromImplFactory(String impl) {
        Object o = null;
        try {
            o = ImplFactory.loadImplFromKey(impl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    private static Object getImplFromClass(String impl) {
        Object o = null;
        try {
            Class<?> clazz = Class.forName(impl);
            o = clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    private static Object getDefaultHelper(String helperType) {
        Object o = null;
        o = ConfigHelperFactory.getImplFromClass("com.ibm.ws.management.util." + helperType);
        return o;
    }

    private static synchronized ManagedObjectMetadataHelper getMetadataHelper() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataHelper");
        }
        if (metadataAccessor == null) {
            metadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            metadataHelper = new ManagedObjectMetadataHelper(metadataAccessor);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataHelper");
        }
        return metadataHelper;
    }
}

