/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.repository.RepositoryLock;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.lang.reflect.Method;

public class RepositoryLockFactory {
    private static RepositoryLock repositoryLock = null;
    private static boolean initialized = false;
    private static TraceComponent tc = Tr.register(RepositoryLockFactory.class, "RepositoryLock", "com.ibm.ws.management.resources.repository");

    public static synchronized RepositoryLock createRepositoryLock() throws AdminException {
        String uuid = AdminContext.peek();
        if (uuid != null) {
            return RepositoryLockFactory.createRepositoryLock(uuid);
        }
        if (initialized) {
            throw new AdminException("RepositoryLock is already created.");
        }
        repositoryLock = RepositoryLockFactory.initialize();
        initialized = true;
        return repositoryLock;
    }

    private static synchronized RepositoryLock createRepositoryLock(String profileKey) throws AdminException {
        RepositoryLock remoteRepositoryLock;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRepositoryLock with profile key " + profileKey);
        }
        if ((remoteRepositoryLock = (RepositoryLock)AdminSubsystemServiceRegistry.getService((String)RepositoryLockFactory.class.getName())) != null) {
            throw new AdminException("The RepositoryLock for native managed endpoint" + profileKey + " is already created");
        }
        remoteRepositoryLock = RepositoryLockFactory.initialize();
        AdminSubsystemServiceRegistry.addService((String)RepositoryLockFactory.class.getName(), (Object)remoteRepositoryLock);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRepositoryLock ");
        }
        return remoteRepositoryLock;
    }

    private static RepositoryLock initialize() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        RepositoryLock ret = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Load XDRepositoryLock");
        }
        try {
            Class<?> repositoryImpl = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.management.repository.XDRepositoryLock");
            Method getRepositoryLock = repositoryImpl.getMethod("getRepositoryLock", null);
            ret = (RepositoryLock)getRepositoryLock.invoke(null, null);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Load DefaultRepositoryLock");
            }
            try {
                Class<?> repositoryImpl = Class.forName("com.ibm.ws.management.repository.DefaultRepositoryLock");
                Method getRepositoryLock = repositoryImpl.getMethod("getRepositoryLock", null);
                ret = (RepositoryLock)getRepositoryLock.invoke(null, null);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, RepositoryLockFactory.class, "com.ibm.ws.management.repository.RepositoryLockFactory.initialize", "2");
                throw new AdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return ret;
    }

    public static RepositoryLock getRepositoryLock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRepositoryLock");
        }
        String profileKey = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Profile key ", profileKey);
        }
        if (profileKey != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRepositoryLock", profileKey);
            }
            return (RepositoryLock)AdminSubsystemServiceRegistry.getService((String)RepositoryLockFactory.class.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRepositoryLock");
        }
        return repositoryLock;
    }
}

