/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.profileregistry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import java.util.Map;
import java.util.UUID;

public class ProfileRegistryGenerator {
    private static TraceComponent tc = Tr.register(ProfileRegistryGenerator.class, "ProfileRegistry", "com.ibm.ws.management.resources.adminagent");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateProfileKey(Map parms) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateProfileKey", parms);
        }
        String profileType = (String)parms.get("profile.registry.profile.type");
        String profilePath = (String)parms.get("profile.registry.profile.root");
        String cellName = (String)parms.get("profile.registry.cell.name");
        String profileKey = null;
        AdminCommand cmd = null;
        Session session = new Session();
        try {
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            cmd = cmdMgr.createCommand("getProfileKey");
            cmd.setParameter("profilePath", profilePath);
            cmd.setConfigSession(session);
            cmd.execute();
            CommandResult result = cmd.getCommandResult();
            if (!result.isSuccessful()) {
            } else {
                profileKey = (String)result.getResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ConfigServiceFactory.getConfigService().discard(session);
        }
        if (profileKey == null) {
            UUID uuid = UUID.randomUUID();
            String UUIDString = uuid.toString();
            StringBuffer keyBuffer = new StringBuffer();
            keyBuffer.append(cellName);
            keyBuffer.append("-");
            keyBuffer.append(profileType);
            keyBuffer.append("-");
            keyBuffer.append(UUIDString);
            profileKey = keyBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateProfileKey", profileKey);
        }
        return profileKey;
    }
}

