/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.profileregistry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.profileregistry.ProfileRegistry;
import com.ibm.ws.management.profileregistry.ProfileRegistryGenerator;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class FileBasedProfileRegistry
implements ProfileRegistry,
ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register(FileBasedProfileRegistry.class, "FileBasedProfileRegistry", "com.ibm.ws.management.resources.adminagent");
    private static final String LOCAL_REGISTRY = "profile.local";
    private Map registryCache = Collections.synchronizedMap(new HashMap());
    private List remoteProfileKeys = Collections.synchronizedList(new ArrayList());
    private String managedNode = null;
    private boolean alreadyRead = false;
    private boolean AAListenerAdded = false;
    private ConfigRepository repository = null;

    protected FileBasedProfileRegistry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "FileBasedProfileRegistry");
        }
        this.initializeRegistry();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "FileBasedProfileRegistry");
        }
    }

    private void initializeRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeRegistry");
        }
        try {
            if (!this.alreadyRead) {
                HashMap propsMap = this.getAllManagedNodeProperties(null);
                Set propSet = propsMap.keySet();
                for (String mnName : propSet) {
                    Properties props = (Properties)propsMap.get(mnName);
                    String profileKey = props.getProperty("profile.registry.profile.key");
                    String adminAgentName = props.getProperty("profile.registry.adminagent.name");
                    this.registryCache.put(profileKey, props);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "profile key is " + profileKey);
                        Tr.debug(tc, "properties " + props.toString());
                        Tr.debug(tc, "registryCache is " + this.registryCache.toString());
                    }
                    if (this.remoteProfileKeys.contains(profileKey)) continue;
                    this.remoteProfileKeys.add(profileKey);
                }
            } else if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Already initialized so do nothing here.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.profileregistry.initializeRegistry", "109", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeRegistry");
        }
    }

    public String register(Map parms) throws Exception {
        String profileKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register", parms);
        }
        if ((profileKey = (String)parms.get("profile.registry.profile.key")) == null) {
            profileKey = ProfileRegistryGenerator.generateProfileKey(parms);
        }
        parms.put("profile.registry.profile.key", profileKey);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)parms);
        this.registryCache.put(profileKey, props);
        if (!this.remoteProfileKeys.contains(profileKey)) {
            this.remoteProfileKeys.add(profileKey);
        }
        String profilePath = (String)parms.get("profile.registry.profile.root");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register", profileKey);
        }
        return profileKey;
    }

    public Map lookupProfile(String profileKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup for profile " + profileKey);
        }
        this.initializeRegistry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registryCache is " + this.registryCache.toString());
        }
        Map result = (Map)this.registryCache.get(profileKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup for profile " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupProfile(Map profileMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup for profile " + profileMap);
        }
        String pKey = null;
        String profilePath = (String)profileMap.get("profile.registry.profile.root");
        this.initializeRegistry();
        try {
            FileBasedProfileRegistry fileBasedProfileRegistry = this;
            synchronized (fileBasedProfileRegistry) {
                Set propSet = this.registryCache.keySet();
                for (String profileKey : propSet) {
                    File profilePathFile;
                    File pRootFile;
                    Properties props = (Properties)this.registryCache.get(profileKey);
                    String pRoot = props.getProperty("profile.registry.profile.root");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "profile key is " + profileKey);
                        Tr.debug(tc, "properties " + props.toString());
                        Tr.debug(tc, "registryCache is " + this.registryCache.toString());
                    }
                    if ((pRootFile = new File(pRoot)).compareTo(profilePathFile = new File(profilePath)) != 0) continue;
                    pKey = profileKey;
                    break;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.profileregistry.lookupProfile", "190", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup for profile " + pKey);
        }
        return pKey;
    }

    public Map lookupLocalProfile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupLocalProfile");
        }
        this.initializeRegistry();
        return this.lookupProfile(LOCAL_REGISTRY);
    }

    public List getRemoteProfileKeys() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteProfileKeys");
        }
        this.initializeRegistry();
        return this.remoteProfileKeys;
    }

    public void removeUnregisterProfileKey(String pKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUnregisterProfile", pKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUnregisterProfile", pKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getAllManagedNodeProperties(final String name) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllManagedNodeProperties entry");
        }
        boolean pushed = false;
        HashMap ret = null;
        try {
            if (AdminContext.peek() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAllManagedNodeProperties: pushing null AdminContext");
                }
                pushed = AdminContext.push(null);
            }
            ret = (HashMap)ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return FileBasedProfileRegistry.this.getAllManagedNodePropertiesPrivate(name);
                }
            });
        }
        finally {
            if (pushed) {
                AdminContext.pop();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllManagedNodeProperties exit: " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getAllManagedNodePropertiesPrivate(String mnName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllManagedNodePropertiesPrivate");
        }
        HashMap<String, Properties> propMap = new HashMap<String, Properties>();
        Session session = new Session();
        if (!this.AAListenerAdded) {
            this.setupAARepositoryListener();
        }
        this.AAListenerAdded = true;
        ConfigService cs = ConfigServiceFactory.getConfigService();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigService is ", cs);
        }
        if (cs != null) {
            try {
                ObjectName mnON = ConfigServiceHelper.createObjectName(null, "ManagedNode");
                ObjectName[] managedNodeArray = cs.queryConfigObjects(session, null, mnON, null);
                for (int i = 0; i < managedNodeArray.length; ++i) {
                    Properties mnProperties = new Properties();
                    ObjectName mn = managedNodeArray[i];
                    String managedNodeName = (String)cs.getAttribute(session, mn, "name");
                    if (mnName == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Read all managednode properties");
                        }
                        mnProperties = this.getManagedNodeProperties(session, cs, mn);
                        propMap.put(managedNodeName, mnProperties);
                        continue;
                    }
                    if (!managedNodeName.equals(mnName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Read one managednode properties");
                    }
                    mnProperties = this.getManagedNodeProperties(session, cs, mn);
                    propMap.put(managedNodeName, mnProperties);
                }
                this.alreadyRead = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.profileregistry.getAllManagedNodePropertiesPrivate", "304", this);
            }
            finally {
                cs.discard(session);
            }
        } else {
            Tr.debug(tc, "ManagedNodes properties already read");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllManagedNodePropertiesPrivate");
        }
        return propMap;
    }

    private Properties getManagedNodeProperties(Session session, ConfigService cs, ObjectName mn) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagedNodeProperties " + mn);
        }
        Properties mnProperties = new Properties();
        try {
            String managedNodeName = (String)cs.getAttribute(session, mn, "name");
            ObjectName propON = ConfigServiceHelper.createObjectName(null, "Property");
            ObjectName[] propertyArray = cs.queryConfigObjects(session, mn, propON, null);
            mnProperties = new Properties();
            for (int j = 0; j < propertyArray.length; ++j) {
                ObjectName prop = propertyArray[j];
                String name = (String)cs.getAttribute(session, prop, "name");
                String value = (String)cs.getAttribute(session, prop, "value");
                mnProperties.put(name, value);
            }
            mnProperties.put("profile.registry.managed.node.name", managedNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managed node name ", managedNodeName);
                Tr.debug(tc, "properties ", mnProperties.toString());
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.profileregistry.getAllManagedNodePropertiesPrivate", "338", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeProperties");
        }
        return mnProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map lookupManagedNode(String managedNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupManagedNode " + managedNode);
        }
        Properties result = null;
        this.initializeRegistry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registryCache is " + this.registryCache.toString());
        }
        FileBasedProfileRegistry fileBasedProfileRegistry = this;
        synchronized (fileBasedProfileRegistry) {
            Set registeredNodeSet = this.registryCache.keySet();
            for (String profileKey : registeredNodeSet) {
                Properties props = (Properties)this.registryCache.get(profileKey);
                String managedNodeNm = props.getProperty("profile.registry.managed.node.name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "managedNode from registry " + managedNodeNm);
                }
                if (!managedNode.equals(managedNodeNm)) continue;
                result = props;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupManagedNode " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAARepositoryListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupAARepositoryListener");
        }
        boolean pushed = false;
        try {
            pushed = AdminContext.push(null);
            this.repository = ConfigRepositoryFactory.getConfigRepository();
            this.repository.addListener(this);
            this.AAListenerAdded = true;
        }
        finally {
            if (pushed) {
                AdminContext.pop();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupAARepositoryListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeCompletion(ConfigRepositoryEvent event) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeCompletion");
        }
        boolean isAdded = false;
        boolean isDeleted = false;
        boolean isModified = false;
        String pKey = null;
        Properties mnProperties = new Properties();
        ConfigChangeNotifier[] changes = event.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "changes length is " + changes.length);
                Tr.debug(tc, "changes are " + changes.toString());
            }
            String docURI = changes[i].getUri();
            int changeType = changes[i].getChangeType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Document URI is " + docURI);
                Tr.debug(tc, "Change type is " + changeType);
            }
            if (!docURI.contains("managednode.xml")) continue;
            String[] subString1 = docURI.split("managednodes");
            String newString = subString1[1];
            String[] subString2 = newString.split("/");
            String managedNode = subString2[1];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managed node name " + managedNode);
            }
            HashMap propsMap = new HashMap();
            try {
                Object propSet;
                if (changeType == 0) {
                    isAdded = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "added is true");
                    }
                } else if (changeType == 1) {
                    isDeleted = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleted is true");
                    }
                } else if (changeType == 2) {
                    isModified = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "modified is true");
                    }
                }
                if (isAdded || isModified) {
                    propsMap = this.getAllManagedNodeProperties(managedNode);
                    propSet = propsMap.keySet();
                    Iterator it = propSet.iterator();
                    while (it.hasNext()) {
                        String mnName = (String)it.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "mnName \t  " + mnName);
                            Tr.debug(tc, "managedNode " + managedNode);
                        }
                        if (!mnName.equals(managedNode)) continue;
                        mnProperties = (Properties)propsMap.get(managedNode);
                    }
                    if (mnProperties != null) {
                        pKey = mnProperties.getProperty("profile.registry.profile.key");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "managed node hashmap are " + propsMap.toString());
                            Tr.debug(tc, "managed node properties are " + mnProperties.toString());
                        }
                    }
                    this.registryCache.put(pKey, mnProperties);
                    if (!this.remoteProfileKeys.contains(pKey)) {
                        this.remoteProfileKeys.add(pKey);
                    }
                } else if (isDeleted) {
                    propSet = this;
                    synchronized (propSet) {
                        Set registeredNodeSet = this.registryCache.keySet();
                        Iterator it = registeredNodeSet.iterator();
                        String deletedPKey = null;
                        while (it.hasNext()) {
                            String profileKey = (String)it.next();
                            Properties props = (Properties)this.registryCache.get(profileKey);
                            String managedNodeNm = props.getProperty("profile.registry.managed.node.name");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "managedNode from registry " + managedNodeNm);
                            }
                            if (!managedNode.equals(managedNodeNm)) continue;
                            deletedPKey = profileKey;
                            break;
                        }
                        if (deletedPKey != null) {
                            this.registryCache.remove(deletedPKey);
                            if (this.remoteProfileKeys.contains(deletedPKey)) {
                                this.remoteProfileKeys.remove(deletedPKey);
                            }
                        }
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "registryCache are " + this.registryCache.toString());
                Tr.debug(tc, "remoteProfileKeys are " + this.remoteProfileKeys.toString());
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.profileregistry.onChangeCompletion", "500", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onChangeCompletion");
        }
    }

    public synchronized void onRepositoryEpochRefresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onRepositoryEpochRefresh");
        }
        HashMap propsMap = new HashMap();
        Map<String, Properties> newCache = Collections.synchronizedMap(new HashMap());
        List<String> newList = Collections.synchronizedList(new ArrayList());
        try {
            propsMap = this.getAllManagedNodeProperties(null);
            Set propSet = propsMap.keySet();
            for (String mnName : propSet) {
                Properties props = (Properties)propsMap.get(mnName);
                String profileKey = props.getProperty("profile.registry.profile.key");
                newCache.put(profileKey, props);
                newList.add(profileKey);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "profile key is " + profileKey);
                Tr.debug(tc, "properties " + props.toString());
                Tr.debug(tc, "Props map are " + newCache.toString());
            }
            this.registryCache = newCache;
            this.remoteProfileKeys = newList;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.profileregistry.onRepositoryEpochRefresh", "534", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onRepositoryEpochRefresh", this.registryCache.toString());
        }
    }

    public void onChangeStart(ConfigRepositoryEvent event) {
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }
}

