/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.exception.SessionTimeoutException;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TaskCommandSessionMgr
implements AlarmListener {
    private static TraceComponent tc = Tr.register(TaskCommandSessionMgr.class, "TaskCommandSessionMgr", "com.ibm.ws.management.resources.cmdframework");
    private HashMap taskSessions = new HashMap();

    public TaskCommandSessionMgr() {
        this.registerAlarm();
    }

    private void registerAlarm() {
        AlarmManager.createDeferrable(600000L, this);
    }

    public synchronized TaskCommandSession createTaskCommandSession(AdminCommand command) {
        TaskCommandSession taskCmdSession = new TaskCommandSession();
        this.taskSessions.put(taskCmdSession, command);
        ((AbstractAdminCommand)command).setCommandSession(taskCmdSession);
        return taskCmdSession;
    }

    public synchronized TaskCommand getTaskCommand(TaskCommandSession session) throws SessionTimeoutException {
        TaskCommand result = (TaskCommand)this.getAdminCommand(session);
        if (result == null) {
            throw new SessionTimeoutException(new Session(Long.toString(session.getSessionId()), true));
        }
        return result;
    }

    public synchronized AdminCommand getAdminCommand(TaskCommandSession session) throws SessionTimeoutException {
        AdminCommand result = (AdminCommand)this.taskSessions.get(session);
        if (result != null) {
            Set keySet = this.taskSessions.keySet();
            for (TaskCommandSession key : keySet) {
                if (!key.equals(session)) continue;
                key.refreshActiveTimeStamp();
            }
        }
        if (result == null) {
            throw new SessionTimeoutException(new Session(Long.toString(session.getSessionId()), true));
        }
        return result;
    }

    public synchronized void removeTaskCommand(TaskCommandSession session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTaskCommand, [" + this.taskSessions.size() + "] removing TaskCommand " + session);
        }
        TaskCommand result = (TaskCommand)this.taskSessions.remove(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTaskCommand, [" + this.taskSessions.size() + "] TaskCommand " + result + " removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void alarm(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        try {
            try {
                Set entrySet = this.taskSessions.entrySet();
                Iterator iter = entrySet.iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    TaskCommandSession key = (TaskCommandSession)entry.getKey();
                    if (!key.isExpired()) continue;
                    iter.remove();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "removed session", key);
                }
                Object var7_7 = null;
                this.registerAlarm();
            }
            catch (Throwable th) {
                th.printStackTrace();
                Manager.Ffdc.log(th, this, "com.ibm.ws.management.cmdframework.TaskCommandSessionMgr", "77", this);
                Object var7_8 = null;
                this.registerAlarm();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.registerAlarm();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }
}

