/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.wsspi.cmdframework.CommandAuditHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class CommandSecurityUtil {
    private static TraceComponent tc = Tr.register(CommandSecurityUtil.class, "CommandSecurityUtil", "com.ibm.ws.management.cmdframework");
    private static CommandSecurityUtil cmdSecUtil = new CommandSecurityUtil();
    public static final String REQUIRED_ROLES = "RequiredRoles";
    public static final String DELEGATION_MODE = "DelegationMode";
    public static final String RESOURCE_IDENTIFIER = "ResourceIdentifier";
    public static final String ROLE_DELIM = ":|";
    public static final String RESID_DELIM = "/";
    public static final String PARAM_DELIM = "|";
    public static final String TARGET_OBJECT = "targetObject";
    private String action = "";

    private CommandSecurityUtil() {
    }

    public static CommandSecurityUtil getInstance() {
        return cmdSecUtil;
    }

    public boolean checkAccess(AdminCommand cmd, String action) {
        this.action = action;
        return this.checkAccess(cmd);
    }

    public boolean checkAccess(AdminCommand cmd) {
        boolean result;
        block22: {
            AdminAuthorizer aa;
            result = true;
            ArrayList<String> requiredRoles = new ArrayList<String>();
            String scope = new String();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkAccess", cmd);
            }
            if ((aa = AdminAuthorizerFactory.getAdminAuthorizer()) == null) {
                block21: {
                    try {
                        CommandAuditHelper.cmdAudit((AdminCommand)cmd, (String)this.action, (boolean)result, requiredRoles);
                    }
                    catch (Throwable e) {
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "audit failed");
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", "No Authorizer (true) ");
                }
                return result;
            }
            CommandMetadata cmdMetadata = cmd.getCommandMetadata();
            EList customProperties = cmdMetadata.getCustom();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " custom = ", customProperties);
            }
            if (customProperties != null && !customProperties.isEmpty()) {
                for (CustomProperties cp : customProperties) {
                    EList resourceIdList;
                    StringTokenizer st;
                    EList roleList;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " custom = ", customProperties);
                    }
                    if (cp.getKey().equals(REQUIRED_ROLES) && (roleList = cp.getValue()) != null && !roleList.isEmpty()) {
                        String roles = (String)roleList.iterator().next();
                        st = new StringTokenizer(roles, ROLE_DELIM);
                        while (st.hasMoreTokens()) {
                            String role = st.nextToken();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " required role = ", role);
                            }
                            requiredRoles.add(role);
                        }
                    }
                    if (!cp.getKey().equals(RESOURCE_IDENTIFIER) || (resourceIdList = cp.getValue()) == null || resourceIdList.isEmpty()) continue;
                    String resIds = (String)resourceIdList.iterator().next();
                    if (resIds.indexOf(RESID_DELIM) < 0) {
                        scope = this.getParamValue(cmd, resIds, true);
                        continue;
                    }
                    st = new StringTokenizer(resIds, RESID_DELIM);
                    boolean firstTime = true;
                    while (st.hasMoreTokens()) {
                        if (!firstTime) {
                            scope = scope + RESID_DELIM;
                        }
                        String resId = st.nextToken();
                        String paramName = st.nextToken();
                        String paramValue = this.getParamValue(cmd, paramName, false);
                        scope = scope + resId + RESID_DELIM + paramValue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " scope = ", scope);
                        }
                        firstTime = false;
                    }
                }
                if (scope == null) {
                    scope = new String();
                }
                Iterator itr = requiredRoles.iterator();
                while (itr.hasNext()) {
                    result = false;
                    String requiredRole = (String)itr.next();
                    result = !requiredRole.startsWith("Any-") ? aa.checkAccess(scope, requiredRole) : true;
                    if (!result) continue;
                    break;
                }
            }
            try {
                CommandAuditHelper.cmdAudit((AdminCommand)cmd, (String)this.action, (boolean)result, requiredRoles);
            }
            catch (Throwable e) {
                if (!tc.isDebugEnabled()) break block22;
                Tr.debug(tc, "audit failed");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(result));
        }
        return result;
    }

    public String getDelegationMode(AdminCommand cmd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDelegationMode", cmd);
        }
        String delegationMode = "CallerIdentity";
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (aa == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDelegationMode", "No Authorizer ");
            }
            return delegationMode;
        }
        CommandMetadata cmdMetadata = cmd.getCommandMetadata();
        EList customProperties = cmdMetadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " custom = ", customProperties);
        }
        if (customProperties != null && !customProperties.isEmpty()) {
            for (CustomProperties cp : customProperties) {
                EList delModeList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " custom = ", customProperties);
                }
                if (!cp.getKey().equals(DELEGATION_MODE) || (delModeList = cp.getValue()) == null || delModeList.isEmpty()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " delegation mode = ", delModeList);
                }
                delegationMode = (String)delModeList.iterator().next();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDelegationMode", delegationMode);
        }
        return delegationMode;
    }

    private String getParamValue(AdminCommand cmd, String paramName, boolean convert) {
        String value;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getParamValue", paramName);
            }
            value = null;
            try {
                StringTokenizer st = new StringTokenizer(paramName, PARAM_DELIM);
                boolean targetObject = false;
                String param = null;
                while (st.hasMoreTokens()) {
                    param = st.nextToken();
                    if (!param.equals(TARGET_OBJECT)) continue;
                    param = null;
                    targetObject = true;
                }
                if (targetObject) {
                    Object obj = cmd.getTargetObject();
                    if (obj instanceof ObjectName) {
                        obj = ObjectName.getInstance((ObjectName)obj);
                        value = !convert ? ConfigServiceHelper.getDisplayName((ObjectName)obj) : ConfigServiceHelper.getConfigDataId((ObjectName)obj).getContextUri();
                    } else {
                        value = convert ? this.convertVal((String)obj) : (String)obj;
                    }
                }
                if (value == null) {
                    value = (String)cmd.getParameter(param);
                    if (convert) {
                        value = this.convertVal(value);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "getParamValue", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParamValue", value);
        }
        return value;
    }

    private String convertVal(String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertVal", val);
        }
        String result = val;
        String value = new String(val);
        StringBuffer scope = new StringBuffer();
        StringTokenizer st = new StringTokenizer(value, "=,");
        while (st.hasMoreTokens()) {
            String type = st.nextToken();
            String context = this.getContext(type);
            if (context == null) {
                scope.setLength(0);
                break;
            }
            if (st.hasMoreTokens()) {
                String v = st.nextToken();
                scope.append(RESID_DELIM).append(context).append(RESID_DELIM).append(v);
                continue;
            }
            scope.setLength(0);
            break;
        }
        if (scope.length() != 0) {
            result = scope.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertVal", result);
        }
        return result;
    }

    private String getContext(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContext", type);
        }
        String context = null;
        try {
            Class<?> implClass = Class.forName("com.ibm.ws.management.authorizer.ResourceInstanceRelations");
            Method m1 = implClass.getMethod("getInstance", new Class[0]);
            Object instance = m1.invoke(null, new Object[0]);
            Method m2 = implClass.getMethod("getUniversalResourceType", String.class);
            context = (String)m2.invoke(instance, type);
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cannot invoke getUniversalResourceType() method ", e);
            }
            context = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContext", context);
        }
        return context;
    }

    private String getCmdStepsAndParams(AdminCommand cmd, String action) throws Exception {
        String ret = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCmdStepsAndParams", new Object[]{cmd, action});
        }
        StringBuffer sb = new StringBuffer();
        sb.append(cmd.getName()).append("(");
        HashMap map = CommandSecurityUtil.getCommandParamters(cmd.getCommandMetadata(), cmd);
        if (map != null && !map.isEmpty()) {
            Set s = map.keySet();
            boolean firstTime = true;
            for (String key : s) {
                Object val = map.get(key);
                if (!firstTime) {
                    sb.append(",");
                }
                sb.append(key).append("=").append(val);
                firstTime = false;
            }
        }
        sb.append(")");
        sb.append("Steps{");
        CommandMetadata cmdMetadata = cmd.getCommandMetadata();
        if (cmdMetadata instanceof TaskCommandMetadata) {
            TaskCommand taskCmd = (TaskCommand)cmd;
            TaskCommandMetadata taskMetadata = (TaskCommandMetadata)cmdMetadata;
            EList steps = taskMetadata.getSteps();
            for (int i = 0; steps != null && i < steps.size(); ++i) {
                String stepName;
                CommandStep cmdStep;
                CommandStepMetadata stepMetadata = (CommandStepMetadata)steps.get(i);
                HashMap smap = CommandSecurityUtil.getCommandStepParamters(stepMetadata, cmdStep = taskCmd.getCommandStep(stepName = stepMetadata.getName()));
                if (smap == null || smap.isEmpty()) continue;
                sb.append(stepName).append("(");
                Set s = smap.keySet();
                boolean firstTime = true;
                for (String key : s) {
                    Object val = map.get(key);
                    if (!firstTime) {
                        sb.append(",");
                    }
                    sb.append(key).append("=").append(val);
                    firstTime = false;
                }
                sb.append(")");
            }
        }
        sb.append("}");
        ret = sb.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCmdStepsAndParams", ret);
        }
        return ret;
    }

    private static HashMap getCommandParamters(CommandMetadata cmdMetadata, AdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandParamters", new Object[]{cmdMetadata, cmd});
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (cmdMetadata.isTargetObjectAllowed() && cmd.getTargetObject() != null) {
            map.put(TARGET_OBJECT, cmd.getTargetObject());
        }
        EList params = cmdMetadata.getParameters();
        for (int i = 0; params != null && i < params.size(); ++i) {
            ParameterMetadata pMetadata = (ParameterMetadata)params.get(i);
            if (cmd.getParameter(pMetadata.getName()) == null) continue;
            String name = pMetadata.getName();
            Object value = cmd.getParameter(name);
            value = value.toString();
            String nameLowerCase = name.toLowerCase();
            if (nameLowerCase.contains("password") || nameLowerCase.contains("passwd")) {
                value = "******";
            }
            map.put(name, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandParamters", map);
        }
        return map;
    }

    private static HashMap getCommandStepParamters(CommandStepMetadata cmdStepMetadata, CommandStep cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandStepParamters", new Object[]{cmdStepMetadata, cmd});
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (cmdStepMetadata.isTargetObjectAllowed() && cmd.getTargetObject() != null) {
            map.put(TARGET_OBJECT, cmd.getTargetObject());
        }
        EList params = cmdStepMetadata.getParameters();
        for (int i = 0; params != null && i < params.size(); ++i) {
            ParameterMetadata pMetadata = (ParameterMetadata)params.get(i);
            if (cmd.getParameter(pMetadata.getName()) == null) continue;
            String name = pMetadata.getName();
            Object value = cmd.getParameter(name);
            String nameLowerCase = name.toLowerCase();
            if (nameLowerCase.contains("password") || nameLowerCase.contains("passwd")) {
                value = "******";
            }
            map.put(name, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandStepParamters", map);
        }
        return map;
    }
}

