/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.async.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class ADTSemaphore {
    public static final String EVENT_CMD_STEPS_DEFINED = "Command step metadata defined";
    public static final String EVENT_USER_INPUT = "User input obtained";
    public static final String EVENT_OP_COMPLETION = "Op execution completed";
    public static final String EVENT_DISCARD = "Op canceled";
    private static TraceComponent tc = Tr.register(ADTSemaphore.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private String _key;
    private boolean _notified = false;
    private boolean _discard = false;

    public ADTSemaphore(String key) {
        this._key = key;
        this._notified = false;
        this._discard = false;
    }

    public synchronized boolean waitForOpEvent(String event) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForOpEvent", new String[]{"key=" + this._key, "event=" + event});
        }
        boolean canceled = false;
        if (!this._notified) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
        }
        this._notified = false;
        if (this._discard) {
            canceled = true;
            this._discard = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForOpEvent", new String[]{"key=" + this._key, "canceled=" + canceled});
        }
        return canceled;
    }

    public synchronized void notifyOfOpEvent(String event) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyOfOpEvent", new String[]{"key=" + this._key, "event=" + event});
        }
        this._notified = true;
        this.notify();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyOfOpEvent", "key=" + this._key);
        }
    }

    public synchronized void discard() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discard", "key=" + this._key);
        }
        this._discard = true;
        this.notifyOfOpEvent(EVENT_DISCARD);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard", "key=" + this._key);
        }
    }

    public String toString() {
        return this._key;
    }
}

