/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CommonAppUtils {
    private static TraceComponent tc = Tr.register(CommonAppUtils.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.adminservice");
    private static final String DIR_NODES = "/nodes";
    private static final String DIR_APPLICATIONS = "/applications";

    public static void waitSyncForAppManagement() throws AdminException {
    }

    public static String getAppSyncMarkerLocation(String uiRoot, String appName) {
        String result;
        String tempRoot;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppSyncMarkerLocation", new Object[]{uiRoot, appName});
            }
            tempRoot = null;
            result = null;
            try {
                Object strObj;
                Field field;
                Class<?> cls = Class.forName("com.ibm.ws.sm.workspace.impl.WorkSpaceConstant");
                if (cls != null && (field = cls.getDeclaredField("WORKSPACE_PATH_NAME")) != null && (strObj = field.get(null)) instanceof String) {
                    String str;
                    tempRoot = str = (String)strObj;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result using reflection", tempRoot);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception recieved", e);
            }
        }
        result = tempRoot != null ? tempRoot + File.separator + "appsync" + File.separator + appName + ".marker" : uiRoot + File.separator + "wstemp" + File.separator + "appsync" + File.separator + appName + ".marker";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppSyncMarkerLocation", new Object[]{result});
        }
        return result;
    }

    public static void waitForAppExpansion(String serverName, String nodeName, String cellName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAppExpansion", serverName + " " + nodeName + " " + cellName);
        }
        ArrayList applicationsList = CommonAppUtils.getAppsOnServer(serverName, nodeName, cellName);
        Object[] appNames = applicationsList.toArray();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "launchProcess: appNames " + appNames + " Length = " + appNames.length);
        }
        boolean someMarkerFileExists = false;
        boolean[] markerFiles = new boolean[appNames.length];
        do {
            for (int i = 0; i < appNames.length; ++i) {
                File markerFile;
                String applicationName = (String)appNames[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess: applicationName => " + applicationName);
                }
                String markerName = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), applicationName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess: markerName " + markerName);
                }
                if ((markerFile = new File(markerName)).exists()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "launchProcess: " + markerName + " exists");
                    }
                    markerFiles[i] = true;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess: " + markerName + " does not exists");
                }
                markerFiles[i] = false;
            }
            someMarkerFileExists = CommonAppUtils.checkifMarkerFileExists(markerFiles);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess: someMarkerFileExists " + someMarkerFileExists);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ioe) {
                // empty catch block
            }
        } while (someMarkerFileExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ArrayList getAppsOnServer(String serverName, String nodeName, String cellName) {
        ArrayList appDeps;
        block30: {
            URI uri;
            Tr.entry(tc, "getAppsOnServer");
            String cellPath = "cells/" + cellName;
            String nodesPath = cellPath + DIR_NODES;
            String myNodePath = nodesPath + "/" + nodeName;
            ConfigRepository repository = ConfigRepositoryFactory.getConfigRepository();
            String serverIndexURI = myNodePath + "/serverindex.xml";
            ServerIndex[] serverIndex = null;
            Resource resource = null;
            appDeps = new ArrayList();
            WASResourceSetImpl resourceSet = null;
            DocumentContentSource dcs = null;
            int serverIndexSize = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess : Before extracting serverIndexURI");
            }
            dcs = repository.extract(serverIndexURI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess : After extracting ..");
            }
            if ((resource = (resourceSet = new WASResourceSetImpl()).createResource(uri = URI.createFileURI(dcs.getDocument().getURI()))) != null) {
                resource.load(dcs.getSource(), new HashMap());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess : serverIndex array size " + resource.getContents().size());
                }
                serverIndexSize = resource.getContents().size();
                serverIndex = new ServerIndex[serverIndexSize];
                for (int j = 0; j < serverIndexSize; ++j) {
                    serverIndex[j] = (ServerIndex)resource.getContents().get(j);
                }
            } else {
                throw new AdminException("Unable to create resource: " + serverIndexURI);
            }
            for (int i = 0; i < serverIndexSize; ++i) {
                serverIndex[i] = (ServerIndex)resource.getContents().get(i);
                if (serverIndex[i] != null) {
                    EList servers = serverIndex[i].getServerEntries();
                    for (int k = 0; k < servers.size(); ++k) {
                        ServerEntry server = (ServerEntry)servers.get(k);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "launchProcess: servername = " + server.getServerName());
                        }
                        if (!server.getServerName().equals(serverName)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "launchProcess: getting the list of apps");
                        }
                        EList serverApps = server.getDeployedApplications();
                        for (int j = 0; j < serverApps.size(); ++j) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "launchProcess: appname = " + serverApps.get(j));
                            }
                            appDeps.add(serverApps.get(j));
                        }
                    }
                    continue;
                }
                throw new AdminException("Unable to load document: " + serverIndexURI);
            }
            Object var22_22 = null;
            try {
                if (dcs != null) {
                    dcs.getSource().close();
                }
                if (serverIndex == null) break block30;
                ResourceSet rs = resource.getResourceSet();
                if (rs != null) {
                    EList el = rs.getResources();
                    if (el != null) {
                        el.remove(resource);
                        break block30;
                    }
                    throw new AdminException("Unable to remove resource: " + serverIndexURI);
                }
                throw new AdminException("Unable to get resources for: " + serverIndexURI);
            }
            catch (Throwable t2) {
                Tr.error(tc, "Exception occurred in getAppsOnServer " + t2.getMessage());
            }
            break block30;
            {
                catch (Throwable t) {
                    Tr.error(tc, "Exception occurred in getAppsOnServer " + t.getMessage());
                    Object var22_23 = null;
                    try {
                        if (dcs != null) {
                            dcs.getSource().close();
                        }
                        if (serverIndex == null) break block30;
                        ResourceSet rs = resource.getResourceSet();
                        if (rs != null) {
                            EList el = rs.getResources();
                            if (el != null) {
                                el.remove(resource);
                                break block30;
                            }
                            throw new AdminException("Unable to remove resource: " + serverIndexURI);
                        }
                        throw new AdminException("Unable to get resources for: " + serverIndexURI);
                    }
                    catch (Throwable t2) {
                        Tr.error(tc, "Exception occurred in getAppsOnServer " + t2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                block31: {
                    Object var22_24 = null;
                    try {
                        if (dcs != null) {
                            dcs.getSource().close();
                        }
                        if (serverIndex == null) break block31;
                        ResourceSet rs = resource.getResourceSet();
                        if (rs != null) {
                            EList el = rs.getResources();
                            if (el != null) {
                                el.remove(resource);
                                break block31;
                            }
                            throw new AdminException("Unable to remove resource: " + serverIndexURI);
                        }
                        throw new AdminException("Unable to get resources for: " + serverIndexURI);
                    }
                    catch (Throwable t2) {
                        Tr.error(tc, "Exception occurred in getAppsOnServer " + t2.getMessage());
                    }
                }
                throw throwable;
            }
        }
        return appDeps;
    }

    private static boolean checkifMarkerFileExists(boolean[] markerFiles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkifMarkerFileExists" + markerFiles);
        }
        boolean exists = false;
        for (int i = 0; i < markerFiles.length; ++i) {
            exists |= markerFiles[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkifMarkerFileExists " + exists);
        }
        return exists;
    }
}

