/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.object;

import com.ibm.ejs.ras.MessageEvent6;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent6;
import com.ibm.ejs.ras.TraceEvent6;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.RecursionCounter;
import com.ibm.ws.logging.WsLogger;
import com.ibm.ws.logging.cbe.EventFactoryHelper;
import com.ibm.ws.logging.cbe.WsNoTemplateContentHandlerImpl;
import com.ibm.ws.logging.object.CBEWsLogRecordAdapter;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordImpl;
import com.ibm.ws.logging.object.WsLoggerRuntimeData;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class WsLogRecordFactory {
    static final int[] LevelTypesForRASEventTypes = new int[]{2, 11, 3, 0, 14, 7, 5, 5, 15, 11, 12, 10, 6, 10, 10, 10};
    private static final int OFFVALUE = Level.OFF.intValue();
    private static final String RECURSION_COUNTER_NAME = WsLogRecordFactory.class.getName();
    private static int RECURSION_COUNTER_MAX = 5;
    private static final String svEmptyString = "";
    private static final String ROOT_LOGGER_NAME_REPLACEMENT = "root";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsLogRecord createWsLogRecord(MessageEvent6 event) {
        WsLogRecord wsLogRecord;
        boolean okToProceed = RecursionCounter.incrementCount(RECURSION_COUNTER_NAME, RECURSION_COUNTER_MAX);
        if (!okToProceed) {
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            return null;
        }
        try {
            LogRecord logRecord;
            WsLogRecord wsLogRecord2 = null;
            CommonBaseEvent cbe = null;
            String loggerName = null;
            String sourceClassName = null;
            String sourceMethodName = null;
            String versionId = null;
            String correlationId = null;
            Level level = WsLevel.LEVELS[LevelConstants.DISTINCT_LEVELS[LevelTypesForRASEventTypes[event.ivType]]];
            cbe = EventFactoryHelper.getPlainEventFactory().createCommonBaseEvent();
            try {
                logRecord = new CommonBaseEventLogRecord(cbe, level);
            }
            catch (Throwable t) {
                logRecord = new WsLogRecordImpl(level, event.ivMsgKey);
            }
            if (event.ivMsgKey != null && !event.ivMsgKey.equals(svEmptyString)) {
                logRecord.setMessage(event.ivMsgKey);
            }
            logRecord.setMillis(event.ivTimeStamp);
            if (event.ivEventSource != null && !event.ivEventSource.equals(svEmptyString)) {
                logRecord.setLoggerName(event.ivEventSource);
                loggerName = event.ivEventSource;
            }
            if (event.ivClassName != null && !event.ivClassName.equals(svEmptyString)) {
                logRecord.setSourceClassName(event.ivClassName);
                sourceClassName = event.ivClassName;
            }
            if (event.ivMethodName != null && !event.ivMethodName.equals(svEmptyString)) {
                logRecord.setSourceMethodName(event.ivMethodName);
                sourceMethodName = event.ivMethodName;
            }
            wsLogRecord2 = logRecord instanceof CommonBaseEventLogRecord ? new CBEWsLogRecordAdapter((CommonBaseEventLogRecord)logRecord) : (WsLogRecord)((Object)logRecord);
            if (event.ivType == 9) {
                wsLogRecord2.addExtension("service_log_only", "true");
            }
            if (event.ivDiagnosticProviderID != null) {
                wsLogRecord2.addExtension("DiagnosticProvider", event.ivDiagnosticProviderID);
            }
            if (event.ivOrganization != null && !event.ivOrganization.equals(svEmptyString)) {
                wsLogRecord2.setOrganization(event.ivOrganization);
            }
            if (event.ivProduct != null && !event.ivProduct.equals(svEmptyString)) {
                wsLogRecord2.setProduct(event.ivProduct);
            }
            if (event.ivComponent != null && !event.ivComponent.equals(svEmptyString)) {
                wsLogRecord2.setComponent(event.ivComponent);
            }
            if (event.ivVersion != null && !event.ivVersion.equals(svEmptyString)) {
                wsLogRecord2.setVersion(event.ivVersion);
                versionId = event.ivVersion;
            }
            if (event.ivProcessId != null && !event.ivProcessId.equals(svEmptyString)) {
                wsLogRecord2.setProcessId(event.ivProcessId);
            }
            if (event.ivUnitOfWork != null && !event.ivUnitOfWork.equals(svEmptyString)) {
                wsLogRecord2.setCorrelationId(event.ivUnitOfWork);
                correlationId = event.ivUnitOfWork;
            }
            if (event.ivExtendedMessage != null && !event.ivExtendedMessage.equals(svEmptyString)) {
                wsLogRecord2.setStackTrace(event.ivExtendedMessage);
            }
            if (event.ivServerName != null && !event.ivServerName.equals(svEmptyString)) {
                wsLogRecord2.setProcessName(event.ivServerName);
            }
            if (event.ivThreadName != null && !event.ivThreadName.equals(svEmptyString)) {
                wsLogRecord2.setSourceThreadName(event.ivThreadName);
            }
            MessageEvent6 messageEvent = event;
            if (messageEvent.tivFormattedMessage != null && !messageEvent.tivFormattedMessage.equals(svEmptyString)) {
                wsLogRecord2.setLocalizable(2);
                wsLogRecord2.setFormattedMessage(messageEvent.tivFormattedMessage);
            } else {
                wsLogRecord2.setLocalizable(1);
                wsLogRecord2.setParameters(messageEvent.ivMsgParms);
                wsLogRecord2.setResourceBundle(messageEvent.ivBundle);
                wsLogRecord2.setResourceBundleName(messageEvent.ivBundleName);
            }
            if (cbe != null) {
                try {
                    WsNoTemplateContentHandlerImpl.completeEvent(cbe, level != null ? level.intValue() : -1, loggerName, sourceClassName, sourceMethodName, versionId, correlationId, null, null, null, null, null, null, null, null, messageEvent.ivBundleName, messageEvent.ivBundle);
                    cbe.complete();
                }
                catch (CompletionException e) {
                    System.err.println("CBE Completion Exception : " + RasHelper.throwableToString(e));
                }
            }
            wsLogRecord = wsLogRecord2;
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            throw throwable;
        }
        RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
        return wsLogRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsLogRecord createWsLogRecord(TraceEvent6 event) {
        WsLogRecordImpl wsLogRecordImpl;
        boolean okToProceed = RecursionCounter.incrementCount(RECURSION_COUNTER_NAME, RECURSION_COUNTER_MAX);
        if (!okToProceed) {
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            return null;
        }
        try {
            int length;
            WsLogRecordImpl wsLogRecord = null;
            Level level = WsLevel.LEVELS[LevelConstants.DISTINCT_LEVELS[LevelTypesForRASEventTypes[event.ivType]]];
            wsLogRecord = new WsLogRecordImpl(level, event.ivMsgKey);
            wsLogRecord.setMillis(event.ivTimeStamp);
            wsLogRecord.setLoggerName(event.ivEventSource);
            wsLogRecord.setSourceClassName(event.ivClassName);
            wsLogRecord.setSourceMethodName(event.ivMethodName);
            if (event.ivOrganization != null && !event.ivOrganization.equals(svEmptyString)) {
                wsLogRecord.setOrganization(event.ivOrganization);
            }
            if (event.ivProduct != null && !event.ivProduct.equals(svEmptyString)) {
                wsLogRecord.setProduct(event.ivProduct);
            }
            if (event.ivComponent != null && !event.ivComponent.equals(svEmptyString)) {
                wsLogRecord.setComponent(event.ivComponent);
            }
            if (event.ivVersion != null && !event.ivVersion.equals(svEmptyString)) {
                wsLogRecord.setVersion(event.ivVersion);
            }
            if (event.ivProcessId != null && !event.ivProcessId.equals(svEmptyString)) {
                wsLogRecord.setProcessId(event.ivProcessId);
            }
            if (event.ivUnitOfWork != null && !event.ivUnitOfWork.equals(svEmptyString)) {
                wsLogRecord.setCorrelationId(event.ivUnitOfWork);
            }
            if (event.ivExtendedMessage != null && !event.ivExtendedMessage.equals(svEmptyString)) {
                wsLogRecord.setStackTrace(event.ivExtendedMessage);
            }
            if (event.ivServerName != null && !event.ivServerName.equals(svEmptyString)) {
                wsLogRecord.setProcessName(event.ivServerName);
            }
            if (event.ivThreadName != null && !event.ivThreadName.equals(svEmptyString)) {
                wsLogRecord.setSourceThreadName(event.ivThreadName);
            }
            TraceEvent6 traceEvent = event;
            wsLogRecord.setLocalizable(2);
            if (traceEvent.ivStrings != null && (length = traceEvent.ivStrings.length) > 1) {
                Object[] params = new String[length - 1];
                System.arraycopy(traceEvent.ivStrings, 1, params, 0, traceEvent.ivStrings.length - 1);
                wsLogRecord.setParameters(params);
            }
            if (event.ivRawData != null) {
                wsLogRecord.setRawData(event.ivRawData);
            }
            wsLogRecordImpl = wsLogRecord;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            throw throwable;
        }
        RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
        return wsLogRecordImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsLogRecord createWsLogRecord(StreamEvent6 event) {
        WsLogRecordImpl wsLogRecordImpl;
        boolean okToProceed = RecursionCounter.incrementCount(RECURSION_COUNTER_NAME, RECURSION_COUNTER_MAX);
        if (!okToProceed) {
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            return null;
        }
        try {
            WsLogRecordImpl wsLogRecord = null;
            Level level = Level.FINE;
            String message = event.convertToString();
            wsLogRecord = new WsLogRecordImpl(level, message);
            wsLogRecord.setMillis(event.ivTimeStamp);
            wsLogRecord.setLoggerName(event.ivEventSource);
            wsLogRecord.setSourceClassName(null);
            wsLogRecord.setSourceMethodName(null);
            if (event.ivOrganization != null && !event.ivOrganization.equals(svEmptyString)) {
                wsLogRecord.setOrganization(event.ivOrganization);
            }
            if (event.ivProduct != null && !event.ivProduct.equals(svEmptyString)) {
                wsLogRecord.setProduct(event.ivProduct);
            }
            if (event.ivComponent != null && !event.ivComponent.equals(svEmptyString)) {
                wsLogRecord.setComponent(event.ivComponent);
            }
            if (event.ivVersion != null && !event.ivVersion.equals(svEmptyString)) {
                wsLogRecord.setVersion(event.ivVersion);
            }
            if (event.ivProcessId != null && !event.ivProcessId.equals(svEmptyString)) {
                wsLogRecord.setProcessId(event.ivProcessId);
            }
            if (event.ivUnitOfWork != null && !event.ivUnitOfWork.equals(svEmptyString)) {
                wsLogRecord.setCorrelationId(event.ivUnitOfWork);
            }
            if (event.ivServerName != null && !event.ivServerName.equals(svEmptyString)) {
                wsLogRecord.setProcessName(event.ivServerName);
            }
            if (event.ivThreadName != null && !event.ivThreadName.equals(svEmptyString)) {
                wsLogRecord.setSourceThreadName(event.ivThreadName);
            }
            wsLogRecord.setLocalizable(2);
            wsLogRecordImpl = wsLogRecord;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            throw throwable;
        }
        RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
        return wsLogRecordImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsLogRecord createWsLogRecord(EventFactory eventFactory, Level level, String msg, Object[] params, String sourceClassName, String sourceMethodName, String resourceBundleName, ResourceBundle resourceBundle, Throwable thrown, String organization, String product2, String component, Map extensions, int minimumLocalizationLevel, String loggerName) {
        WsLogRecord wsLogRecord;
        boolean okToProceed = RecursionCounter.incrementCount(RECURSION_COUNTER_NAME, RECURSION_COUNTER_MAX);
        if (!okToProceed) {
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            return null;
        }
        try {
            String dPidCk;
            WsLogRecord wsLogRecord2;
            LogRecord logRecord;
            boolean isCBE = level.intValue() >= LevelConstants.LOWEST_MESSAGE_LEVEL_INTVALUE;
            boolean isFactorySetHere = false;
            if (isCBE && eventFactory == null) {
                eventFactory = EventFactoryHelper.getPlainEventFactory();
                isFactorySetHere = true;
            }
            int localizable = level.intValue() < minimumLocalizationLevel || minimumLocalizationLevel == OFFVALUE ? 2 : 1;
            CommonBaseEvent cbe = null;
            if (isCBE) {
                cbe = eventFactory.createCommonBaseEvent();
                CommonBaseEventLogRecord cbeLogRecord = new CommonBaseEventLogRecord(cbe, level);
                logRecord = cbeLogRecord;
                wsLogRecord2 = new CBEWsLogRecordAdapter(cbeLogRecord);
                if (msg != null) {
                    logRecord.setMessage(msg);
                }
            } else {
                WsLogRecordImpl wsLogRecordImpl = new WsLogRecordImpl(level, msg);
                wsLogRecord2 = wsLogRecordImpl;
                logRecord = wsLogRecordImpl;
            }
            if (params != null) {
                logRecord.setParameters(params);
                if (params.length > 0 && params[0] != null && Byte.TYPE.equals(params[0].getClass().getComponentType())) {
                    wsLogRecord2.setRawData((byte[])params[0]);
                }
            }
            if (sourceClassName != null) {
                logRecord.setSourceClassName(sourceClassName);
            }
            if (sourceMethodName != null) {
                logRecord.setSourceMethodName(sourceMethodName);
            }
            if (resourceBundleName != null) {
                logRecord.setResourceBundleName(resourceBundleName);
            }
            if (resourceBundle != null) {
                logRecord.setResourceBundle(resourceBundle);
            }
            if (thrown != null) {
                wsLogRecord2.setThrown(thrown);
            }
            wsLogRecord2.setLocalizable(localizable);
            if (loggerName != null) {
                logRecord.setLoggerName(loggerName);
            }
            if (organization != null) {
                wsLogRecord2.setOrganization(organization);
            }
            if (product2 != null) {
                wsLogRecord2.setProduct(product2);
            }
            if (component != null) {
                wsLogRecord2.setComponent(component);
            }
            if (extensions != null) {
                wsLogRecord2.addExtensions(extensions);
            }
            if (params != null && params.length > 0 && params[0] instanceof String && (dPidCk = (String)params[0]) != null && dPidCk.length() > 5 && dPidCk.substring(0, 5).equalsIgnoreCase("DPID:")) {
                wsLogRecord2.addExtension("DiagnosticProvider", dPidCk.substring(5));
            }
            if (!isCBE) {
                WsLoggerRuntimeData.getInstance().populate((WsLogRecordImpl)wsLogRecord2);
            }
            if (isCBE) {
                try {
                    if (isFactorySetHere) {
                        WsNoTemplateContentHandlerImpl.completeEvent(cbe, level != null ? level.intValue() : -1, loggerName, sourceClassName, sourceMethodName, null, null, null, null, null, null, null, null, null, null, resourceBundleName, resourceBundle);
                    }
                    cbe.complete();
                }
                catch (CompletionException e) {
                    System.err.println("CBE Completion Exception : " + RasHelper.throwableToString(e));
                }
            }
            wsLogRecord = wsLogRecord2;
            Object var24_24 = null;
        }
        catch (Throwable throwable) {
            Object var24_25 = null;
            RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            throw throwable;
        }
        RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
        return wsLogRecord;
    }

    public static WsLogRecord getWsLogRecordIfConvertible(LogRecord logRecord) {
        if (logRecord instanceof WsLogRecord) {
            return (WsLogRecord)((Object)logRecord);
        }
        if (logRecord instanceof CommonBaseEventLogRecord && ((CommonBaseEventLogRecord)logRecord).getCommonBaseEvent() != null) {
            return new CBEWsLogRecordAdapter((CommonBaseEventLogRecord)logRecord);
        }
        return null;
    }

    public static CommonBaseEventLogRecord convertToCBELogRecord(LogRecord logRecord) {
        ResourceBundle r;
        String s;
        Logger logger;
        CommonBaseEvent cbe = null;
        if (logRecord instanceof CommonBaseEventLogRecord) {
            cbe = ((CommonBaseEventLogRecord)logRecord).getCommonBaseEvent();
        }
        if (cbe != null) {
            return (CommonBaseEventLogRecord)logRecord;
        }
        EventFactory eventFactory = null;
        String loggerName = logRecord.getLoggerName();
        if (loggerName != null && (logger = Logger.getLogger(loggerName)) != null && logger instanceof WsLogger) {
            eventFactory = ((WsLogger)logger).getEventFactory();
        }
        if (eventFactory == null) {
            eventFactory = EventFactoryHelper.getDefaultEventFactory();
        }
        cbe = eventFactory.createCommonBaseEvent();
        CommonBaseEventLogRecord cbeLR = new CommonBaseEventLogRecord(cbe, logRecord.getLevel());
        CBEWsLogRecordAdapter wcbeLR = new CBEWsLogRecordAdapter(cbeLR);
        String newLoggerName = loggerName;
        if (loggerName != null && loggerName.equals(svEmptyString)) {
            newLoggerName = ROOT_LOGGER_NAME_REPLACEMENT;
        }
        if (newLoggerName != null) {
            wcbeLR.setLoggerName(newLoggerName);
        }
        if ((s = logRecord.getMessage()) != null) {
            wcbeLR.setMessage(s);
        }
        wcbeLR.setMillis(logRecord.getMillis());
        Object[] o = logRecord.getParameters();
        if (o != null) {
            wcbeLR.setParameters(o);
        }
        if ((r = logRecord.getResourceBundle()) != null) {
            wcbeLR.setResourceBundle(r);
        }
        if ((s = logRecord.getResourceBundleName()) != null) {
            wcbeLR.setResourceBundleName(s);
        }
        wcbeLR.setSequenceNumber(logRecord.getSequenceNumber());
        s = logRecord.getSourceClassName();
        if (s != null) {
            wcbeLR.setSourceClassName(s);
        }
        if ((s = logRecord.getSourceMethodName()) != null) {
            wcbeLR.setSourceMethodName(s);
        }
        wcbeLR.setThreadID(logRecord.getThreadID());
        Throwable t = logRecord.getThrown();
        if (t != null) {
            wcbeLR.setThrown(t);
        }
        return cbeLR;
    }

    public static CommonBaseEvent getCommonBaseEvent(LogRecord logRecord) {
        LogRecord logRecord2;
        if (logRecord == null) {
            return null;
        }
        if (logRecord instanceof CommonBaseEventLogRecord) {
            return ((CommonBaseEventLogRecord)logRecord).getCommonBaseEvent();
        }
        if (logRecord instanceof WsLogRecord && (logRecord2 = ((WsLogRecord)((Object)logRecord)).getImpl()) instanceof CommonBaseEventLogRecord) {
            return ((CommonBaseEventLogRecord)logRecord2).getCommonBaseEvent();
        }
        return null;
    }
}

